/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.vh263;

import com.ibm.media.codec.video.VideoCodec;
import com.sun.media.JMFSecurityManager;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class NativeDecoder
extends VideoCodec {
    private int nativeData;
    private int pictureDesc;
    private int PBFrameCap = 1;
    private int bsStart;
    private int nextGOB;
    private int pendingFrame = 0;
    private static int MAX_SEQ = 65535;
    private long prevSeq = -1L;
    private static final boolean debug = false;
    static final int[] widths;
    static final int[] heights;
    private int videoWidth = 176;
    private int videoHeight = 144;
    private boolean FormatSizeInitFlag = false;
    private int payloadLength = 4;

    static {
        int[] nArray = new int[8];
        nArray[1] = 128;
        nArray[2] = 176;
        nArray[3] = 352;
        nArray[4] = 704;
        nArray[5] = 1408;
        widths = nArray;
        int[] nArray2 = new int[8];
        nArray2[1] = 96;
        nArray2[2] = 144;
        nArray2[3] = 288;
        nArray2[4] = 576;
        nArray2[5] = 1152;
        heights = nArray2;
    }

    public NativeDecoder() {
        this.supportedInputFormats = new VideoFormat[]{new VideoFormat("h263"), new VideoFormat("h263/rtp"), new VideoFormat("h263-1998/rtp")};
        this.defaultOutputFormats = new VideoFormat[]{new YUVFormat()};
        this.PLUGIN_NAME = "H.263 Decoder";
    }

    public boolean checkFormat(Format format) {
        if (format.getEncoding().equals("h263/rtp")) {
            return true;
        }
        if (format.getEncoding().equals("h263-1998/rtp")) {
            return true;
        }
        return super.checkFormat(format);
    }

    public void close() {
        this.closeNativeDecoder();
        super.close();
    }

    private native boolean closeNativeDecoder();

    private native boolean decodeFrameNative(Buffer var1, Buffer var2);

    private native boolean decodePacketNative(byte[] var1, int var2, int var3, byte[] var4, byte[] var5, int var6, int var7, int var8);

    public static int get1998PayloadHeaderLength(byte[] byArray, int n2) {
        int n3 = 2 + ((byArray[n2] & 1) << 5) | (byArray[n2 + 1] & 0xF8) >> 3;
        if ((byArray[n2] & 2) != 0) {
            ++n3;
        }
        return n3;
    }

    protected Format[] getMatchingOutputFormats(Format format) {
        VideoFormat videoFormat = (VideoFormat)format;
        Dimension dimension = videoFormat.getSize();
        int n2 = videoFormat.getMaxDataLength();
        if (videoFormat.getEncoding().equals("h263/rtp") || videoFormat.getEncoding().equals("h263-1998/rtp")) {
            int n3;
            if (dimension == null) {
                n3 = this.videoWidth * this.videoHeight;
            } else {
                n3 = dimension.width * dimension.height;
                this.videoWidth = dimension.width;
                this.videoHeight = dimension.height;
            }
            n3 = this.videoWidth * this.videoHeight;
            this.supportedOutputFormats = new VideoFormat[]{new YUVFormat(new Dimension(this.videoWidth, this.videoHeight), n3 + (n3 >> 1), Format.byteArray, videoFormat.getFrameRate(), 2, this.videoWidth, this.videoWidth >> 1, 0, n3, n3 + (n3 >> 2))};
        } else {
            Dimension dimension2 = this.movieSizeTo263Size(dimension);
            int n4 = dimension2.width * dimension2.height;
            this.videoWidth = dimension2.width;
            this.videoHeight = dimension2.height;
            this.supportedOutputFormats = new VideoFormat[]{new YUVFormat(dimension, n4 + (n4 >> 1), Format.byteArray, videoFormat.getFrameRate(), 2, dimension2.width, dimension2.width >> 1, 0, n4, n4 + (n4 >> 2))};
        }
        return this.supportedOutputFormats;
    }

    private int getPayloadHeaderLength(byte[] byArray, int n2) {
        int n3 = 0;
        byte by = byArray[n2];
        n3 = (by & 0x80) != 0 ? ((by & 0x40) != 0 ? 12 : 8) : 4;
        return n3;
    }

    private int getSequenceDiff(long l2, long l3) {
        if (l3 > l2) {
            return (int)(l3 - l2);
        }
        if (l3 == l2) {
            return 0;
        }
        if (l2 > (long)(MAX_SEQ - 100) && l3 < 100L) {
            return (int)((long)MAX_SEQ - l2 + l3 + 1L);
        }
        return (int)(l3 - l2);
    }

    protected void initDecoder() {
        this.closeNativeDecoder();
        this.initNativeDecoder(this.videoWidth, this.videoHeight);
    }

    private native boolean initNativeDecoder(int var1, int var2);

    private static native boolean initNativeDecoderClass();

    private Dimension movieSizeTo263Size(Dimension dimension) {
        int n2 = dimension.width + 15 & 0xFFFFFFF0;
        int n3 = dimension.height + 15 & 0xFFFFFFF0;
        int n4 = n2 * n3 >> 8;
        if (n4 <= 48) {
            return new Dimension(128, 96);
        }
        if (n4 <= 99) {
            return new Dimension(176, 144);
        }
        if (n4 <= 396) {
            return new Dimension(352, 288);
        }
        if (n4 <= 1584) {
            return new Dimension(704, 576);
        }
        if (n4 <= 6336) {
            return new Dimension(1408, 1152);
        }
        return new Dimension(0, 0);
    }

    public void open() throws ResourceUnavailableException {
        try {
            JMFSecurityManager.loadLibrary("jmutil");
            JMFSecurityManager.loadLibrary("jmvh263");
            NativeDecoder.initNativeDecoderClass();
            this.initDecoder();
            super.open();
            return;
        }
        catch (Throwable throwable) {
            throw new ResourceUnavailableException("could not load jmvh263");
        }
    }

    public int process(Buffer buffer, Buffer buffer2) {
        int n2;
        int n3;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Object var6_6 = null;
        int n4 = this.videoWidth;
        int n5 = this.videoHeight;
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        VideoFormat videoFormat = (VideoFormat)buffer.getFormat();
        int n6 = buffer.getLength();
        int n7 = videoFormat.getMaxDataLength();
        int n8 = this.outputFormat.getMaxDataLength();
        int n9 = buffer.getOffset();
        byte[] byArray = (byte[])buffer.getData();
        if (videoFormat.getEncoding().equals("h263/rtp")) {
            bl = true;
            this.payloadLength = this.getPayloadHeaderLength(byArray, n9);
            if (byArray[n9 + this.payloadLength] == 0 && byArray[n9 + this.payloadLength + 1] == 0 && (byArray[n9 + this.payloadLength + 2] & 0xFC) == 128) {
                n3 = byArray[n9 + this.payloadLength + 4] >> 2 & 7;
                n4 = widths[n3];
                n5 = heights[n3];
                this.FormatSizeInitFlag = true;
            }
        } else if (videoFormat.getEncoding().equals("h263-1998/rtp")) {
            bl2 = true;
            n3 = -1;
            n2 = -1;
            if (this.getSequenceDiff(this.prevSeq, buffer.getSequenceNumber()) != 1) {
                boolean bl4;
                boolean bl5 = bl4 = (byArray[n9] & 4) == 0;
                if (bl4) {
                    return 4;
                }
            }
            this.prevSeq = buffer.getSequenceNumber();
            this.payloadLength = NativeDecoder.get1998PayloadHeaderLength(byArray, n9);
            if (this.payloadLength > 5) {
                if ((byArray[n9] & 2) == 2 && (byArray[n9 + 3] & 0xFC) == 128) {
                    n2 = n9 + 3;
                } else if ((byArray[n9 + 2] & 0xFC) == 128) {
                    n2 = n9 + 2;
                }
            } else if ((byArray[n9] & 4) == 4 && (byArray[n9 + this.payloadLength] & 0xFC) == 128) {
                n2 = n9 + this.payloadLength;
            }
            if (n2 >= 0 && (n3 = byArray[n2 + 2] >> 2 & 7) == 7) {
                n3 = (byArray[n2 + 3] >> 1 & 7) == 1 ? byArray[n2 + 3] << 2 & 4 | byArray[n2 + 4] >> 6 & 3 : -1;
            }
            if (n3 >= 0) {
                n4 = widths[n3];
                n5 = heights[n3];
                this.FormatSizeInitFlag = true;
            }
        }
        if (this.videoWidth != n4 || this.videoHeight != n5) {
            this.videoWidth = n4;
            this.videoHeight = n5;
            n3 = this.videoWidth * this.videoHeight;
            this.outputFormat = new YUVFormat(new Dimension(this.videoWidth, this.videoHeight), n3 + (n3 >> 1), Format.byteArray, videoFormat.getFrameRate(), 2, this.videoWidth, this.videoWidth >> 1, 0, n3, n3 + (n3 >> 2));
            n8 = this.outputFormat.getMaxDataLength();
            this.videoResized();
            this.FormatSizeInitFlag = true;
        }
        if ((bl || bl2) && !this.FormatSizeInitFlag) {
            return 1;
        }
        byte[] byArray2 = this.validateByteArraySize(buffer2, n8);
        if (n6 + 8 + n9 > byArray.length) {
            n2 = n6 > n7 ? n6 : n7;
            byte[] byArray3 = new byte[n9 + n2 + 8];
            System.arraycopy(byArray, 0, byArray3, 0, n6 + n9);
            byArray = byArray3;
            buffer.setData(byArray3);
        }
        byArray[n9 + n6] = 0;
        byArray[n9 + n6 + 1] = 0;
        byArray[n9 + n6 + 2] = -4;
        buffer.setLength(n6 += 3);
        if (bl) {
            n6 -= this.payloadLength;
            n2 = 0;
            if ((buffer.getFlags() & 0x800) != 0) {
                n2 = 1;
            }
            bl3 = this.decodePacketNative(byArray, n9 + this.payloadLength, n6, byArray2, byArray, n9, n2, 0);
        } else if (bl2) {
            n6 -= this.payloadLength;
            n2 = 0;
            if ((buffer.getFlags() & 0x800) != 0) {
                n2 = 1;
            } else {
                n6 -= 3;
            }
            bl3 = this.decodePacketNative(byArray, n9 + this.payloadLength, n6, byArray2, byArray, n9, n2, 1);
        } else {
            bl3 = this.decodeFrameNative(buffer, buffer2);
        }
        if (bl3) {
            this.updateOutput(buffer2, this.outputFormat, n8, 0);
            buffer2.setFormat(this.outputFormat);
            return 0;
        }
        return 4;
    }

    public void reset() {
    }

    public Format setInputFormat(Format format) {
        Format format2 = super.setInputFormat(format);
        if (format2 == null) {
            return null;
        }
        if (this.opened) {
            this.close();
            try {
                this.setOutputFormat(this.getMatchingOutputFormats(format)[0]);
                this.open();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return format2;
    }

    protected void videoResized() {
        this.initDecoder();
    }
}

