/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.audio.cdaudio;

import com.sun.media.BasicPlayer;
import com.sun.media.amovie.MCI;
import com.sun.media.protocol.file.DataSource;
import com.sun.media.util.LoopThread;
import java.io.IOException;
import javax.media.GainChangeEvent;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;

public class Handler
extends BasicPlayer {
    private int frames;
    private int minutes;
    private int seconds;
    private int hours;
    private int track;
    private int mins;
    private int secs;
    private int frms;
    private int hrs;
    private MCI mci = new MCI();
    private boolean isPlaying = false;
    private byte[] buffer;
    private long nanos;
    private boolean muted;
    private EomThread eomThread;

    protected boolean audioEnabled() {
        return true;
    }

    public String convertToMsf(int n2, int n3, int n4) {
        if (n2 > 74) {
            n2 %= 75;
            ++n3;
        }
        if (n3 > 59) {
            n3 %= 60;
            ++n4;
        }
        String string = n4 + ":" + n3 + ":" + n2;
        return string;
    }

    public void doClose() {
        super.doClose();
        if (this.eomThread != null) {
            this.eomThread.kill();
        }
    }

    protected boolean doRealize() {
        PullSourceStream pullSourceStream = ((PullDataSource)this.source).getStreams()[0];
        this.buffer = new byte[44];
        int n2 = 0;
        try {
            n2 = pullSourceStream.read(this.buffer, 0, 44);
        }
        catch (IOException iOException) {}
        if (n2 < 0) {
            this.abortRealize();
            return false;
        }
        this.frames = this.buffer[40];
        this.seconds = this.buffer[41];
        this.minutes = this.buffer[42];
        this.hours = this.buffer[43];
        this.track = this.buffer[22] & 0xFF;
        this.nanos = 60 * this.minutes + this.seconds;
        this.nanos *= 75L;
        this.nanos += (long)this.frames;
        this.nanos *= 40L;
        this.nanos *= 333333L;
        this.setMediaLength(this.nanos);
        this.track |= (this.buffer[23] & 0xFF) << 8;
        this.mci.ssendString("open cdaudio shareable wait");
        this.mci.ssendString("stop cdaudio wait");
        this.mci.ssendString("close cdaudio wait");
        if (this.eomThread == null) {
            this.eomThread = new EomThread(this);
            this.eomThread.start();
        } else {
            this.eomThread.start();
        }
        return true;
    }

    public void doSetMediaTime(Time time) {
        long l2 = time.getNanoseconds();
        this.secs = (int)(l2 / 1000000000L);
        this.hrs = this.secs / 3600;
        this.mins = this.secs / 60;
        this.secs %= 60;
        this.frms = (int)((l2 %= 1000000000L) / 13333320L);
    }

    public void doStart() {
        if (this.eomThread != null) {
            this.eomThread.start();
        }
        this.mci.sendString("set cdaudio time format msf wait");
        String string = this.convertToMsf(this.buffer[36] + this.frms, this.secs + this.buffer[37], this.buffer[38] + this.mins);
        String string2 = this.convertToMsf(this.buffer[36] + this.buffer[40], this.buffer[37] + this.buffer[41] - 1, this.buffer[38] + this.buffer[42]);
        this.mci.ssendString("open cdaudio shareable wait");
        String string3 = "play cdaudio from " + string + " to " + string2;
        this.mci.ssendString(string3);
        this.mci.ssendString("close cdaudio wait");
        this.isPlaying = true;
    }

    public void doStop() {
        this.isPlaying = false;
        this.doSetMediaTime(this.getMediaTime());
        this.mci.ssendString("open cdaudio shareable wait");
        this.mci.ssendString("pause cdaudio wait");
        this.mci.ssendString("close cdaudio wait");
        if (this.eomThread != null) {
            this.eomThread.pause();
        }
    }

    public void gainChange(GainChangeEvent gainChangeEvent) {
    }

    public Time getDuration() {
        return new Time(this.nanos);
    }

    public TimeBase getMasterTimeBase() {
        return null;
    }

    public void handleEom() {
        this.setTargetState(500);
        this.processEndOfMedia();
    }

    public void muteChange(boolean bl) {
        if (bl != this.muted) {
            this.muted = bl;
            this.mci.ssendString("open cdaudio shareable wait");
            if (bl) {
                this.mci.ssendString("set cdaudio audio all off wait");
            } else {
                this.mci.ssendString("set cdaudio audio all on wait");
            }
            this.mci.ssendString("close cdaudio wait");
        }
    }

    public void setSource(javax.media.protocol.DataSource dataSource) throws IncompatibleSourceException {
        if (!(dataSource instanceof DataSource)) {
            System.out.println("Unsupported data source: " + dataSource);
            throw new IncompatibleSourceException(String.valueOf(String.valueOf(this)) + ": doesn't support " + dataSource);
        }
        this.source = dataSource;
    }

    public void updateStats() {
    }

    protected boolean videoEnabled() {
        return false;
    }

    class EomThread
    extends LoopThread {
        private Handler handler;

        public EomThread(Handler handler2) {
            this.handler = handler2;
        }

        public boolean process() {
            long l2 = Handler.this.getMediaTime().getNanoseconds();
            if (l2 >= Handler.this.nanos) {
                this.handler.stop();
                this.handler.handleEom();
            } else {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return true;
        }
    }
}

