/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.multiplexer.audio;

import com.sun.media.format.WavAudioFormat;
import com.sun.media.multiplexer.BasicMux;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.FileTypeDescriptor;

public class WAVMux
extends BasicMux {
    private AudioFormat audioFormat;
    private WavAudioFormat wavAudioFormat;
    private int sampleSizeInBits;
    private double sampleRate;
    private int channels;
    private byte[] codecSpecificHeader;
    private short wFormatTag;
    private int blockAlign = 0;
    private int bytesPerSecond = 0;
    private int dataSizeOffset;
    private int numberOfSamplesOffset;
    private int factChunkLength = 0;
    Format signed = new AudioFormat(null, -1.0, -1, -1, 0, 1);
    Format unsigned = new AudioFormat(null, -1.0, -1, -1, 0, 0);

    public WAVMux() {
        this.supportedInputs = new Format[1];
        this.supportedInputs[0] = new AudioFormat(null);
        this.supportedOutputs = new ContentDescriptor[1];
        this.supportedOutputs[0] = new FileTypeDescriptor("audio.x_wav");
    }

    public String getName() {
        return "WAVE Audio Multiplexer";
    }

    public Format setInputFormat(Format format, int n2) {
        Integer n3;
        if (!(format instanceof AudioFormat)) {
            return null;
        }
        AudioFormat audioFormat = (AudioFormat)format;
        this.sampleRate = audioFormat.getSampleRate();
        String string = null;
        this.audioFormat = audioFormat;
        if (audioFormat instanceof WavAudioFormat) {
            this.wavAudioFormat = (WavAudioFormat)audioFormat;
        }
        String string2 = this.audioFormat.getEncoding();
        this.sampleSizeInBits = this.audioFormat.getSampleSizeInBits();
        if (string2.equalsIgnoreCase("LINEAR")) {
            if (this.sampleSizeInBits > 8) {
                if (this.audioFormat.getEndian() == 1) {
                    return null;
                }
                if (this.audioFormat.getSigned() == 0) {
                    return null;
                }
                if (this.audioFormat.getEndian() == -1 || this.audioFormat.getSigned() == -1) {
                    audioFormat = (AudioFormat)this.audioFormat.intersects(this.signed);
                }
            } else {
                if (this.audioFormat.getSigned() == 1) {
                    return null;
                }
                if (this.audioFormat.getEndian() == -1 || this.audioFormat.getSigned() == -1) {
                    audioFormat = (AudioFormat)this.audioFormat.intersects(this.unsigned);
                }
            }
        }
        if ((n3 = (Integer)WavAudioFormat.reverseFormatMapper.get(string2.toLowerCase())) == null) {
            string = "Cannot handle format";
            return null;
        }
        this.wFormatTag = n3.shortValue();
        switch (this.wFormatTag) {
            case 2: 
            case 17: 
            case 49: {
                if (this.wavAudioFormat != null) break;
                string = "A WavAudioFormat is required  to provide encoding specific information for this encoding " + this.wFormatTag;
            }
        }
        if (this.wavAudioFormat != null) {
            this.codecSpecificHeader = this.wavAudioFormat.getCodecSpecificHeader();
            this.bytesPerSecond = this.wavAudioFormat.getAverageBytesPerSecond();
        }
        this.sampleRate = this.audioFormat.getSampleRate();
        this.channels = this.audioFormat.getChannels();
        if (string != null) {
            return null;
        }
        this.inputs[0] = audioFormat;
        return audioFormat;
    }

    public int setNumTracks(int n2) {
        if (n2 != 1) {
            return 1;
        }
        return super.setNumTracks(n2);
    }

    protected void writeFooter() {
        this.seek(4);
        this.bufClear();
        this.bufWriteIntLittleEndian(this.fileSize - 8);
        this.bufFlush();
        this.seek(this.dataSizeOffset);
        this.bufClear();
        int n2 = this.fileSize - (this.dataSizeOffset + 4);
        this.bufWriteIntLittleEndian(n2);
        this.bufFlush();
        if (this.factChunkLength > 0) {
            float f2 = (float)n2 / (float)this.bytesPerSecond;
            int n3 = (int)((double)f2 * this.sampleRate);
            this.seek(this.numberOfSamplesOffset);
            this.bufClear();
            this.bufWriteIntLittleEndian(n3);
            this.bufFlush();
        }
    }

    protected void writeHeader() {
        int n2 = 16;
        this.bufClear();
        this.audioFormat = (AudioFormat)this.inputs[0];
        this.codecSpecificHeader = null;
        if (this.audioFormat instanceof WavAudioFormat) {
            this.codecSpecificHeader = ((WavAudioFormat)this.audioFormat).getCodecSpecificHeader();
        }
        if (this.codecSpecificHeader != null) {
            n2 += 2 + this.codecSpecificHeader.length;
        } else if (this.wFormatTag == 85) {
            n2 += 14;
        }
        this.bufWriteBytes("RIFF");
        this.bufWriteInt(0);
        this.bufWriteBytes("WAVE");
        this.bufWriteBytes("fmt ");
        this.bufWriteIntLittleEndian(n2);
        int n3 = this.audioFormat.getFrameSizeInBits();
        this.blockAlign = n3 > 0 ? n3 / 8 : this.sampleSizeInBits / 8 * this.channels;
        this.bufWriteShortLittleEndian(this.wFormatTag);
        this.bufWriteShortLittleEndian((short)this.channels);
        this.bufWriteIntLittleEndian((int)this.sampleRate);
        int n4 = -1;
        if (this.wFormatTag == 85) {
            this.blockAlign = 1;
            n4 = (int)this.audioFormat.getFrameRate();
            if (n4 != -1) {
                this.bytesPerSecond = n4;
            }
        }
        if (this.bytesPerSecond <= 0) {
            this.bytesPerSecond = this.channels * this.sampleSizeInBits * (int)this.sampleRate / 8;
        }
        this.bufWriteIntLittleEndian(this.bytesPerSecond);
        this.bufWriteShortLittleEndian((short)this.blockAlign);
        if (this.wFormatTag == 85) {
            this.bufWriteShortLittleEndian((short)0);
        } else {
            this.bufWriteShortLittleEndian((short)this.sampleSizeInBits);
        }
        if (this.codecSpecificHeader != null) {
            this.bufWriteShortLittleEndian((short)this.codecSpecificHeader.length);
            this.bufWriteBytes(this.codecSpecificHeader);
        } else if (this.wFormatTag == 85) {
            int n5;
            if (n4 > 0) {
                float f2 = 72.0f * (float)n4 * 8.0f / 8000.0f;
                f2 = (float)((double)f2 * (8000.0 / this.sampleRate));
                n5 = (int)f2;
            } else {
                n5 = 417;
            }
            this.bufWriteShortLittleEndian((short)12);
            this.bufWriteShortLittleEndian((short)1);
            this.bufWriteIntLittleEndian(2);
            this.bufWriteShortLittleEndian((short)n5);
            this.bufWriteShortLittleEndian((short)1);
            this.bufWriteShortLittleEndian((short)1393);
        }
        this.factChunkLength = 0;
        if (this.wFormatTag != 1) {
            this.bufWriteBytes("fact");
            this.bufWriteIntLittleEndian(4);
            this.numberOfSamplesOffset = this.filePointer;
            this.bufWriteInt(0);
            this.factChunkLength = 12;
        }
        this.bufWriteBytes("data");
        this.dataSizeOffset = this.filePointer;
        this.bufWriteInt(0);
        this.bufFlush();
    }
}

