/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.dsound;

import com.sun.media.JMFSecurityManager;
import javax.media.format.AudioFormat;

public class DSound {
    private static boolean opened = false;
    private static AudioFormat format = null;
    private static int bufSize = 2048;
    private static long directSound = 0L;
    private long dsBuffer = 0L;
    static boolean loaded = false;

    static {
        if (!loaded) {
            try {
                JMFSecurityManager.checkCapture();
                JMFSecurityManager.loadLibrary("jmdaudc");
                loaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                loaded = false;
                throw unsatisfiedLinkError;
            }
        }
    }

    public DSound(AudioFormat audioFormat, int n2) {
        format = audioFormat;
        bufSize = n2;
    }

    public synchronized void close() {
        if (this.dsBuffer != 0L) {
            this.nClose(this.dsBuffer);
        }
        this.dsBuffer = 0L;
    }

    public void flush() {
        this.nFlush(this.dsBuffer);
    }

    public int getBufferSize() {
        return bufSize;
    }

    public AudioFormat getFormat() {
        return format;
    }

    public static boolean isFormatSupported(AudioFormat audioFormat, int n2) {
        return true;
    }

    public static boolean isOpen() {
        return opened;
    }

    private synchronized native void nClose(long var1);

    private synchronized native void nFlush(long var1);

    private native long nOpen(int var1, int var2, int var3, int var4);

    private synchronized native int nRead(long var1, byte[] var3, int var4, int var5);

    private synchronized native void nStart(long var1);

    private synchronized native void nStop(long var1);

    public void open() {
        this.dsBuffer = this.nOpen((int)format.getSampleRate(), format.getSampleSizeInBits(), format.getChannels(), bufSize);
        if (this.dsBuffer == 0L) {
            throw new Error("Couldn't create capture buffer");
        }
    }

    public int read(byte[] byArray, int n2, int n3) {
        return this.nRead(this.dsBuffer, byArray, n2, n3);
    }

    public void start() {
        this.nStart(this.dsBuffer);
    }

    public void stop() {
        this.nStop(this.dsBuffer);
    }
}

