/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.vfw;

import com.sun.media.BasicPlugIn;
import com.sun.media.CircularBuffer;
import com.sun.media.ExtBuffer;
import com.sun.media.NBA;
import com.sun.media.protocol.BasicSourceStream;
import com.sun.media.protocol.vfw.VFWDeviceQuery;
import com.sun.media.ui.VideoFormatChooser;
import com.sun.media.vfw.BitMapInfo;
import com.sun.media.vfw.CapDriverCaps;
import com.sun.media.vfw.CapStatus;
import com.sun.media.vfw.CaptureParms;
import com.sun.media.vfw.VFWCapture;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Control;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.Owned;
import javax.media.SystemTimeBase;
import javax.media.control.FormatControl;
import javax.media.control.MonitorControl;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;

public class VFWSourceStream
extends BasicSourceStream
implements PushBufferStream,
Runnable,
ActionListener,
FormatControl,
Owned {
    private MediaLocator locator = null;
    private int capHandle = 0;
    Integer cbHandleLock = new Integer(0);
    private int cbHandle = 0;
    private VideoFormat capFormat = null;
    private float capFrameRate = 0.0f;
    private int capPreviewRate = 33;
    private int capWidth = -1;
    private int capHeight = -1;
    private byte[] data = null;
    private int maxDataSize = 1;
    BufferTransferHandler transferHandler = null;
    private int length = 0;
    private int nativeParentWindow = 0;
    private static String STRING_CF = "Custom Format...";
    private static String STRING_SD = "Video Source...";
    private Integer lockInit = new Integer(1);
    private Integer vfwReqLock = new Integer(2);
    private int vfwRequest = -1;
    private static final int REQ_START = 1;
    private static final int REQ_STOP = 2;
    private static final int REQ_FORMATDIALOG = 3;
    private static final int REQ_SOURCEDIALOG = 4;
    private static final int REQ_DISCONNECT = 5;
    private static final int REQ_UPDATECAPTURESETUP = 6;
    private static final int REQ_MONITOR = 7;
    private boolean started = false;
    private boolean connected = false;
    private boolean connectedOK = false;
    private Frame capFrame = null;
    private static int MAX_CARDS = 10;
    private static boolean DEBUG = false;
    private int cardNo = 0;
    private static boolean[] inUse = new boolean[MAX_CARDS];
    private static Integer VFWLock = new Integer(0);
    Integer readLock = new Integer(1);
    Integer waitForStop = new Integer(2);
    boolean doneReading = false;
    boolean waitingToStop = false;
    long lastTimeStamp = 0L;
    long startTimeStamp = 0L;
    long[] resultTimeStamp = new long[1];
    SystemTimeBase systemTimeBase = new SystemTimeBase();
    private Panel controlPanel = null;
    private Control[] controls = null;
    private static final String DEFAULT_PORT = "default";
    private boolean hasDlgVideoFormat = false;
    private boolean hasDlgVideoSource = false;
    private boolean hasOverlay = false;
    private boolean monitorEnabled = false;
    private float defaultFrameRate = 15.0f;
    private float requestedFrameRate = 15.0f;
    private PushThread pt = null;
    private TransferDataThread tdt = null;
    private VideoFormat defaultFormat = null;
    private VideoFormat requestedFormat = null;
    private VideoFormat fullFormat = null;
    private CaptureDeviceInfo cdi = null;
    CircularBuffer bufferQ = new CircularBuffer(8);
    private float[] FRAME_RATES = new float[]{1.0f, 2.0f, 5.0f, 7.5f, 10.0f, 12.5f, 15.0f, 20.0f, 24.0f, 25.0f, 30.0f};
    Choice formatChoice = null;
    Choice frameRateChoice = null;
    Panel controlComponent = null;
    Button formatDialog = null;
    Button sourceDialog = null;
    VideoFormatChooser formatChooser = null;
    private Checkbox cbMonitorEnable = null;
    private Panel monitorComponent = null;
    private TextField textPreviewRate = null;
    static /* synthetic */ Class array$B;

    static {
        int n2 = 0;
        while (n2 < MAX_CARDS) {
            VFWSourceStream.inUse[n2] = false;
            ++n2;
        }
    }

    public VFWSourceStream(MediaLocator mediaLocator) {
        super(new ContentDescriptor("raw"), -1L);
        this.locator = mediaLocator;
        this.cardNo = VFWSourceStream.getCardNo(mediaLocator);
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(STRING_CF)) {
            Integer n2 = this.vfwReqLock;
            synchronized (n2) {
                this.vfwRequest = 3;
                this.vfwReqLock.notifyAll();
            }
        }
        if (string.equals(STRING_SD)) {
            Integer n3 = this.vfwReqLock;
            synchronized (n3) {
                this.vfwRequest = 4;
                this.vfwReqLock.notifyAll();
            }
        }
    }

    public static CaptureDeviceInfo autoDetect(int n2) {
        VFWDeviceQuery vFWDeviceQuery;
        block3: {
            vFWDeviceQuery = null;
            try {
                vFWDeviceQuery = new VFWDeviceQuery(n2);
                if (vFWDeviceQuery != null && vFWDeviceQuery.getFormats() != null && vFWDeviceQuery.getFormats().length > 0 && CaptureDeviceManager.addDevice(vFWDeviceQuery)) {
                    CaptureDeviceManager.commit();
                }
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ThreadDeath)) break block3;
                throw (ThreadDeath)throwable;
            }
        }
        return vFWDeviceQuery;
    }

    Object checkDataAllocation(Buffer buffer) {
        Object object;
        if (buffer instanceof ExtBuffer && ((ExtBuffer)buffer).isNativePreferred()) {
            object = ((ExtBuffer)buffer).getNativeData();
            if (object == null || ((NBA)object).size < this.maxDataSize) {
                object = new NBA(array$B != null ? array$B : (array$B = VFWSourceStream.class$("[B")), this.maxDataSize);
            }
            ((ExtBuffer)buffer).setNativeData((NBA)object);
        } else {
            object = buffer.getData();
            if (object == null || !(object instanceof byte[]) || ((byte[])object).length < this.maxDataSize) {
                object = new byte[this.maxDataSize];
                buffer.setData(object);
            }
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void connect(Format format) throws IOException {
        Integer n2 = VFWLock;
        synchronized (n2) {
            if (this.connected) {
                Object var3_3 = null;
                return;
            }
            if (inUse[this.cardNo]) {
                throw new IOException("Capture device in use");
            }
            VFWSourceStream.inUse[this.cardNo] = true;
            this.connected = false;
            if (format != null) {
                this.requestedFormat = (VideoFormat)format;
            }
            Thread thread = new Thread((Runnable)this, "VFW Request Thread");
            thread.start();
            if (!this.connected) {
                try {
                    while (!this.connected) {
                        Thread.currentThread();
                        Thread.sleep(50L);
                        Thread.currentThread();
                        Thread.yield();
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.connectedOK) {
                VFWSourceStream.inUse[this.cardNo] = false;
                this.connected = false;
                throw new IOException("Could not connect to capture device");
            }
            this.updateComponents();
        }
    }

    /*
     * Unable to fully structure code
     */
    synchronized void disconnect() {
        if (this.started) {
            try {
                this.stop();
            }
            catch (IOException v0) {}
        }
        this.connected = false;
        var1_1 = this.vfwReqLock;
        synchronized (var1_1) {
            this.vfwRequest = 5;
            this.vfwReqLock.notifyAll();
            // MONITOREXIT @DISABLED, blocks:[1, 5] lbl12 : MonitorExitStatement: MONITOREXIT : var1_1
            if (true) ** GOTO lbl21
        }
        do {
            try {
                this.wait(50L);
            }
            catch (InterruptedException v2) {}
lbl21:
            // 3 sources

        } while (this.pt != null);
        VFWSourceStream.inUse[this.cardNo] = false;
        var1_1 = this.bufferQ;
        synchronized (var1_1) {
            this.bufferQ.notifyAll();
        }
        var1_1 = this.readLock;
        synchronized (var1_1) {
            this.readLock.notifyAll();
        }
    }

    private boolean doConnect() {
        Object object;
        this.nativeParentWindow = VFWCapture.createWindow("Cap Parent");
        this.capHandle = VFWCapture.capCreateCaptureWindow("Test", this.nativeParentWindow, 0, 0, 320, 240, VFWCapture.getNextID());
        if (this.capHandle == 0) {
            VFWCapture.destroyWindow(this.nativeParentWindow);
            return false;
        }
        this.cbHandle = VFWCapture.createFrameCallback(this.capHandle);
        if (this.cbHandle == 0 || !VFWCapture.capDriverConnect(this.capHandle, this.cardNo)) {
            if (this.cbHandle != 0) {
                VFWCapture.destroyFrameCallback(this.capHandle, this.cbHandle);
            }
            VFWCapture.destroyWindow(this.capHandle);
            VFWCapture.destroyWindow(this.nativeParentWindow);
            return false;
        }
        CapDriverCaps capDriverCaps = new CapDriverCaps();
        VFWCapture.capDriverGetCaps(this.capHandle, capDriverCaps);
        CaptureParms captureParms = new CaptureParms();
        VFWCapture.capCaptureGetSetup(this.capHandle, captureParms);
        captureParms.fYield = true;
        captureParms.fCaptureAudio = false;
        captureParms.fAbortLeftMouse = false;
        captureParms.fAbortRightMouse = false;
        captureParms.fMakeUserHitOKToCapture = false;
        if (capDriverCaps.fHasDlgVideoFormat) {
            this.hasDlgVideoFormat = true;
        }
        if (this.requestedFormat == null) {
            object = new Dimension(320, 240);
            this.requestedFormat = new RGBFormat((Dimension)object, ((Dimension)object).width * ((Dimension)object).height * 3, Format.byteArray, this.requestedFrameRate, 24, 3, 2, 1, 3, ((Dimension)object).width * 3, 1, -1);
        }
        if (captureParms.dwRequestMicroSecPerFrame == 0) {
            captureParms.dwRequestMicroSecPerFrame = 66667;
        }
        this.defaultFrameRate = 1000000.0f / (float)captureParms.dwRequestMicroSecPerFrame;
        if (this.requestedFormat.getFrameRate() > 0.0f && this.requestedFormat.getFrameRate() < 61.0f) {
            this.requestedFrameRate = this.requestedFormat.getFrameRate();
        }
        captureParms.dwRequestMicroSecPerFrame = (int)(1000000.0f / this.requestedFrameRate);
        captureParms.wNumVideoRequested = 15;
        VFWCapture.capCaptureSetSetup(this.capHandle, captureParms);
        VFWCapture.capCaptureGetSetup(this.capHandle, captureParms);
        this.capFrameRate = captureParms.dwRequestMicroSecPerFrame != 0 ? 1000000.0f / (float)captureParms.dwRequestMicroSecPerFrame : this.requestedFrameRate;
        if (capDriverCaps.fHasDlgVideoSource) {
            this.hasDlgVideoSource = true;
        }
        if (capDriverCaps.fHasOverlay) {
            VFWCapture.capOverlay(this.capHandle, this.monitorEnabled);
            this.hasOverlay = true;
        } else {
            VFWCapture.capPreview(this.capHandle, this.monitorEnabled);
            VFWCapture.capPreviewRate(this.capHandle, 33);
            this.hasOverlay = false;
        }
        VFWCapture.capSetWindowPos(this.capHandle, 0, 0, 320, 240);
        object = new BitMapInfo();
        VFWCapture.capGetVideoFormat(this.capHandle, (BitMapInfo)object);
        this.defaultFormat = ((BitMapInfo)object).createVideoFormat(Format.byteArray, this.capFrameRate);
        object = new BitMapInfo(this.requestedFormat);
        VFWCapture.capSetVideoFormat(this.capHandle, (BitMapInfo)object);
        VFWCapture.capGetVideoFormat(this.capHandle, (BitMapInfo)object);
        this.capFormat = ((BitMapInfo)object).createVideoFormat(Format.byteArray);
        VideoFormat videoFormat = new VideoFormat(null, null, -1, null, this.capFrameRate);
        this.fullFormat = (VideoFormat)this.capFormat.intersects(videoFormat);
        this.maxDataSize = ((BitMapInfo)object).biSizeImage;
        this.data = new byte[this.maxDataSize];
        return true;
    }

    private void doDisconnect() {
        VFWCapture.capCaptureAbort(this.capHandle);
        VFWCapture.stopFrameCallback(this.capHandle, this.cbHandle);
        Object object = this.cbHandleLock;
        synchronized (object) {
            this.cbHandle = 0;
        }
        if (this.hasOverlay) {
            VFWCapture.capOverlay(this.capHandle, false);
        } else {
            VFWCapture.capPreview(this.capHandle, false);
        }
        VFWCapture.capDriverDisconnect(this.capHandle);
        object = this;
        synchronized (object) {
            VFWCapture.destroyWindow(this.capHandle);
            VFWCapture.destroyWindow(this.nativeParentWindow);
            this.notifyAll();
        }
    }

    private void doStartCapture() {
        this.handleFormatChange();
        CapStatus capStatus = new CapStatus();
        VFWCapture.capGetStatus(this.capHandle, capStatus);
        if (capStatus.fCapturingNow) {
            return;
        }
        VFWCapture.startFrameCallback(this.capHandle, this.cbHandle);
        VFWCapture.capCaptureSequenceNoFile(this.capHandle);
        this.startTimeStamp = this.systemTimeBase.getNanoseconds();
    }

    public void finalize() {
        if (this.connected) {
            this.disconnect();
        }
    }

    int getCBHandle() {
        return this.cbHandle;
    }

    int getCapHandle() {
        return this.capHandle;
    }

    CaptureDeviceInfo getCaptureDeviceInfo() {
        if (this.cdi == null) {
            String string = "vfw://" + this.cardNo;
            Vector vector = CaptureDeviceManager.getDeviceList(new VideoFormat(null));
            if (vector != null && vector.size() > 0) {
                int n2 = 0;
                while (n2 < vector.size()) {
                    CaptureDeviceInfo captureDeviceInfo = (CaptureDeviceInfo)vector.elementAt(n2);
                    if (captureDeviceInfo.getLocator().toString().equalsIgnoreCase(string)) {
                        this.cdi = captureDeviceInfo;
                        break;
                    }
                    ++n2;
                }
            }
            if (this.cdi == null) {
                this.cdi = VFWSourceStream.autoDetect(this.cardNo);
            }
        }
        return this.cdi;
    }

    static int getCardNo(MediaLocator mediaLocator) {
        int n2;
        block4: {
            n2 = 0;
            String string = mediaLocator.getRemainder();
            if (string == null || string.length() <= 0) break block4;
            while (string.length() > 1 && string.charAt(0) == '/') {
                string = string.substring(1);
            }
            try {
                Integer n3 = Integer.valueOf(string);
                if (n3 != null) {
                    n2 = n3;
                }
            }
            catch (Throwable throwable) {}
        }
        return n2;
    }

    boolean getConnected() {
        return this.connected;
    }

    public Component getControlComponent() {
        if (this.controlComponent == null) {
            this.controlComponent = new Panel(new BorderLayout());
            this.controlComponent.setName("Capture Control");
            Format[] formatArray = this.getSupportedFormats();
            this.formatChooser = new VideoFormatChooser(formatArray, (VideoFormat)this.getFormat(), this.FRAME_RATES);
            this.controlComponent.add("North", this.formatChooser);
            this.formatDialog = new Button(STRING_CF);
            this.sourceDialog = new Button(STRING_SD);
            this.sourceDialog.addActionListener(this);
            Panel panel = new Panel();
            panel.add(this.formatDialog);
            panel.add(this.sourceDialog);
            this.controlComponent.add("South", panel);
            this.updateComponents();
            this.updateFormatChooser();
            this.formatDialog.addActionListener(this);
        }
        return this.controlComponent;
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[2];
            this.controls[0] = this;
            this.controls[1] = new MC();
        }
        return this.controls;
    }

    byte[] getData() {
        return this.data;
    }

    public Object getDataType() {
        return Format.byteArray;
    }

    public Format getFormat() {
        if (this.fullFormat == null) {
            this.fullFormat = (VideoFormat)this.getSupportedFormats()[0];
        }
        return this.fullFormat;
    }

    Component getMonitorControlComponent() {
        if (this.monitorComponent == null) {
            this.monitorComponent = new Panel();
            this.monitorComponent.setLayout(new BorderLayout());
            this.cbMonitorEnable = new Checkbox("Video Monitor");
            this.cbMonitorEnable.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    VFWSourceStream.this.setMonitorEnabled(VFWSourceStream.this.cbMonitorEnable.getState());
                }
            });
            Panel panel = new Panel(new BorderLayout());
            panel.add("East", new Label("frames/sec"));
            this.textPreviewRate = new TextField("30");
            this.textPreviewRate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        float f2 = Float.valueOf(VFWSourceStream.this.textPreviewRate.getText()).floatValue();
                        if (f2 < 0.1f) {
                            f2 = 0.1f;
                        } else if (f2 > 30.0f) {
                            f2 = 30.0f;
                        }
                        VFWSourceStream.this.setMonitorPreviewRate(f2);
                    }
                    catch (Exception exception) {}
                }
            });
            panel.add("Center", this.textPreviewRate);
            this.monitorComponent.add("West", this.cbMonitorEnable);
            this.monitorComponent.add("Center", panel);
        }
        return this.monitorComponent;
    }

    public Object getOwner() {
        return this;
    }

    boolean getStarted() {
        return this.started;
    }

    public Format[] getSupportedFormats() {
        if (this.cdi == null) {
            this.cdi = this.getCaptureDeviceInfo();
        }
        if (this.cdi == null) {
            return new Format[0];
        }
        return this.cdi.getFormats();
    }

    private void handleFormatChange() {
        float f2;
        VideoFormat videoFormat = null;
        VideoFormat videoFormat2 = null;
        if (this.requestedFormat != null) {
            BitMapInfo bitMapInfo = new BitMapInfo(this.requestedFormat);
            VFWCapture.capSetVideoFormat(this.capHandle, bitMapInfo);
            VFWCapture.capGetVideoFormat(this.capHandle, bitMapInfo);
            this.capFormat = bitMapInfo.createVideoFormat(Format.byteArray);
            if (this.requestedFormat.getFrameRate() > 0.0f && this.requestedFormat.getFrameRate() < 61.0f) {
                this.requestedFrameRate = this.requestedFormat.getFrameRate();
            }
            this.requestedFormat = null;
            this.maxDataSize = bitMapInfo.biSizeImage;
            this.data = new byte[this.maxDataSize];
            this.capWidth = bitMapInfo.biWidth;
            this.capHeight = bitMapInfo.biHeight;
        }
        if (this.formatChooser != null && (double)Math.abs((f2 = this.formatChooser.getFrameRate()) - this.capFrameRate) > 0.45) {
            this.requestedFrameRate = f2;
        }
        if (this.requestedFrameRate != -1.0f) {
            this.updateCaptureSetup();
            this.requestedFrameRate = -1.0f;
        }
        videoFormat2 = new VideoFormat(null, null, -1, null, this.capFrameRate);
        videoFormat = (VideoFormat)this.capFormat.intersects(videoFormat2);
        if (this.fullFormat == null || !videoFormat.equals(this.fullFormat)) {
            this.fullFormat = videoFormat;
        }
        this.updateFormatChooser();
    }

    public boolean isEnabled() {
        return true;
    }

    void pushData(int n2) {
        this.length = n2;
        if (this.transferHandler != null) {
            this.transferHandler.transferData(this);
        }
    }

    public void read(Buffer buffer) {
        Integer n2 = this.readLock;
        synchronized (n2) {
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                if (this.bufferQ.canRead()) {
                    Buffer buffer2 = this.bufferQ.read();
                    buffer.copy(buffer2, true);
                    buffer.setOffset(0);
                    buffer.setFormat(this.fullFormat);
                    buffer.setFlags(32912);
                    this.bufferQ.readReport();
                } else {
                    buffer.setDiscard(true);
                }
            }
            this.doneReading = true;
            this.readLock.notifyAll();
        }
    }

    void requestUpdateCaptureSetup() {
        Integer n2 = this.vfwReqLock;
        synchronized (n2) {
            this.vfwRequest = 6;
            this.vfwReqLock.notifyAll();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block37: {
            var1_1 = false;
            var2_2 = 1;
            if (!this.doConnect()) break block37;
            var3_3 = this.lockInit;
            synchronized (var3_3) {
                this.connected = true;
                this.connectedOK = true;
                this.lockInit.notifyAll();
                ** GOTO lbl121
            }
        }
        var3_4 = this.lockInit;
        synchronized (var3_4) {
            this.connected = true;
            this.connectedOK = false;
            this.lockInit.notifyAll();
            var4_6 = null;
            return;
        }
        {
            try {
                Thread.currentThread();
                Thread.yield();
                Thread.currentThread();
                Thread.sleep(50L);
            }
            catch (InterruptedException v2) {}
            var2_2 = VFWCapture.peekWindowLoop(this.nativeParentWindow);
            if (var2_2 == 0) {
                var1_1 = true;
            }
            do {
                if (this.vfwRequest < 0) continue block24;
                var3_5 = this.vfwRequest;
                this.vfwRequest = -1;
                switch (var3_5) {
                    case 2: {
                        if (VFWSourceStream.DEBUG) {
                            System.err.println("capture - Stopping");
                        }
                        VFWCapture.stopFrameCallback(this.capHandle, this.cbHandle);
                        VFWCapture.capCaptureStop(this.capHandle);
                        var4_7 = 0;
                        var5_8 = new CapStatus();
                        while (var4_7 < 100) {
                            VFWCapture.capGetStatus(this.capHandle, var5_8);
                            if (!var5_8.fCapturingNow) {
                                if (!VFWSourceStream.DEBUG) break;
                                System.err.println("capture - Stopped");
                                break;
                            }
                            try {
                                Thread.currentThread();
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException v3) {}
                            ++var4_7;
                        }
                        this.waitingToStop = false;
                        var6_9 = this.waitForStop;
                        synchronized (var6_9) {
                            this.waitForStop.notifyAll();
                            break;
                        }
                    }
                    case 1: {
                        if (VFWSourceStream.DEBUG) {
                            System.err.println("capture - Starting");
                        }
                        this.doStartCapture();
                        if (!VFWSourceStream.DEBUG) break;
                        System.err.println("capture - Started");
                        break;
                    }
                    case 5: {
                        if (!VFWSourceStream.DEBUG) break;
                        System.err.println("capture - Disconnecting");
                        break;
                    }
                    case 3: {
                        if (!this.monitorEnabled) {
                            VFWCapture.showWindow(this.nativeParentWindow, 1, -1, -1);
                        }
                        VFWCapture.capDlgVideoFormat(this.capHandle);
                        this.setMonitorEnabled(this.monitorEnabled);
                        var6_9 = new BitMapInfo();
                        VFWCapture.capGetVideoFormat(this.capHandle, (BitMapInfo)var6_9);
                        var7_10 = var6_9.createVideoFormat(Format.byteArray, this.requestedFrameRate);
                        if (!var7_10.equals(this.capFormat)) {
                            this.requestedFormat = var7_10;
                            this.maxDataSize = this.requestedFormat.getMaxDataLength();
                            this.data = new byte[this.maxDataSize];
                        }
                        this.updateFormatChooser();
                        break;
                    }
                    case 4: {
                        if (!this.monitorEnabled) {
                            VFWCapture.showWindow(this.nativeParentWindow, 1, -1, -1);
                        }
                        VFWCapture.capDlgVideoSource(this.capHandle);
                        this.setMonitorEnabled(this.monitorEnabled);
                        break;
                    }
                    case 6: {
                        this.updateCaptureSetup();
                        break;
                    }
                    case 7: {
                        if (this.hasOverlay) {
                            VFWCapture.capOverlay(this.capHandle, this.monitorEnabled);
                            break;
                        }
                        VFWCapture.capPreview(this.capHandle, this.monitorEnabled);
                        VFWCapture.capPreviewRate(this.capHandle, this.capPreviewRate);
                    }
                }
lbl121:
                // 12 sources

            } while (this.connected);
        }
        this.doDisconnect();
        if (VFWSourceStream.DEBUG) {
            System.err.println("capture - Disconnected");
        }
        while (!var1_1) {
            try {
                Thread.currentThread();
                Thread.yield();
                Thread.currentThread();
                Thread.sleep(50L);
            }
            catch (InterruptedException v5) {}
            var2_2 = VFWCapture.peekWindowLoop(this.nativeParentWindow);
            if (var2_2 != 0) continue;
            var1_1 = true;
        }
        this.pt = null;
    }

    public void setEnabled(boolean bl) {
    }

    public Format setFormat(Format format) {
        if (!(format instanceof VideoFormat)) {
            return null;
        }
        Format format2 = BasicPlugIn.matches(format, this.getSupportedFormats());
        if (format2 != null) {
            this.requestedFormat = (VideoFormat)format;
        }
        if (this.connected && !this.started) {
            this.handleFormatChange();
            return this.fullFormat;
        }
        return format2;
    }

    boolean setMonitorEnabled(boolean bl) {
        if (bl) {
            if (this.nativeParentWindow != 0) {
                VFWCapture.showWindow(this.nativeParentWindow, 2, this.capWidth, this.capHeight);
            }
            this.monitorEnabled = true;
        } else {
            if (this.nativeParentWindow != 0) {
                VFWCapture.showWindow(this.nativeParentWindow, 0, -1, -1);
            }
            this.monitorEnabled = false;
        }
        Integer n2 = this.vfwReqLock;
        synchronized (n2) {
            this.vfwRequest = 7;
            this.vfwReqLock.notifyAll();
        }
        return bl;
    }

    float setMonitorPreviewRate(float f2) {
        int n2;
        if (f2 > 30.0f) {
            f2 = 30.0f;
        } else if ((double)f2 < 0.1) {
            f2 = 0.1f;
        }
        this.capPreviewRate = n2 = (int)(1000.0f / f2);
        Integer n3 = this.vfwReqLock;
        synchronized (n3) {
            this.vfwRequest = 7;
            this.vfwReqLock.notifyAll();
        }
        return f2;
    }

    public void setTransferHandler(BufferTransferHandler bufferTransferHandler) {
        this.transferHandler = bufferTransferHandler;
    }

    void start() throws IOException {
        this.started = true;
        this.updateComponents();
        VFWSourceStream vFWSourceStream = this;
        synchronized (vFWSourceStream) {
            if (!this.connected) {
                this.started = false;
                Object var2_2 = null;
                return;
            }
            Object object = this.bufferQ;
            synchronized (object) {
                this.bufferQ.reset();
            }
            if (this.pt == null) {
                this.pt = new PushThread(this);
                this.pt.start();
            }
            object = this.pt;
            synchronized (object) {
                this.pt.buffer = null;
                this.pt.data = null;
                this.pt.dataBytes = 0L;
            }
            if (this.tdt == null) {
                this.tdt = new TransferDataThread(this);
                this.tdt.start();
            }
            object = this.vfwReqLock;
            synchronized (object) {
                this.vfwRequest = 1;
                this.vfwReqLock.notifyAll();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void stop() throws IOException {
        this.started = false;
        Integer n2 = this.vfwReqLock;
        synchronized (n2) {
            this.vfwRequest = 2;
            this.waitingToStop = true;
            this.vfwReqLock.notifyAll();
        }
        n2 = this.waitForStop;
        synchronized (n2) {
            while (this.waitingToStop) {
                try {
                    this.waitForStop.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.updateComponents();
    }

    void updateCaptureSetup() {
        CaptureParms captureParms = new CaptureParms();
        VFWCapture.capCaptureGetSetup(this.capHandle, captureParms);
        if (this.requestedFrameRate < 1.0f) {
            this.requestedFrameRate = 1.0f;
        }
        captureParms.dwRequestMicroSecPerFrame = (int)(1000000.0f / this.requestedFrameRate);
        VFWCapture.capCaptureSetSetup(this.capHandle, captureParms);
        VFWCapture.capCaptureGetSetup(this.capHandle, captureParms);
        if (captureParms.dwRequestMicroSecPerFrame != 0) {
            this.capFrameRate = 1000000.0f / (float)captureParms.dwRequestMicroSecPerFrame;
        }
        this.updateFormatChooser();
    }

    private void updateComponents() {
        if (this.formatChoice != null) {
            this.formatChoice.setEnabled(this.started ^ true);
        }
        if (this.formatChooser != null) {
            this.formatChooser.setEnabled(this.connected && !this.started);
        }
        if (this.formatDialog != null) {
            this.formatDialog.setEnabled(this.connected && !this.started);
        }
        if (this.sourceDialog != null) {
            this.sourceDialog.setEnabled(this.connected && !this.started);
        }
        if (this.frameRateChoice != null) {
            this.frameRateChoice.setEnabled(this.started ^ true);
        }
        if (this.cbMonitorEnable != null) {
            this.cbMonitorEnable.setEnabled(this.started ^ true);
        }
    }

    void updateFormatChooser() {
        if (this.formatChooser != null) {
            this.formatChooser.setCurrentFormat(this.capFormat);
            this.formatChooser.setFrameRate(this.capFrameRate);
        }
    }

    class MC
    implements MonitorControl,
    Owned {
        public Component getControlComponent() {
            return VFWSourceStream.this.getMonitorControlComponent();
        }

        public Object getOwner() {
            return VFWSourceStream.this;
        }

        public boolean setEnabled(boolean bl) {
            return VFWSourceStream.this.setMonitorEnabled(bl);
        }

        public float setPreviewFrameRate(float f2) {
            return VFWSourceStream.this.setMonitorPreviewRate(f2);
        }
    }

    class PushThread
    extends Thread {
        VFWSourceStream stream;
        public Object data = null;
        public long dataBytes = 0L;
        public Buffer buffer = null;

        public PushThread(VFWSourceStream vFWSourceStream2) {
            super("VFW VideoPollThread");
            this.stream = vFWSourceStream2;
        }

        public void run() {
            int n2 = VFWSourceStream.this.getCapHandle();
            int n3 = VFWSourceStream.this.getCBHandle();
            int n4 = 0;
            while (VFWSourceStream.this.getConnected()) {
                try {
                    Thread.sleep(10L);
                    Thread.yield();
                    n4 += 10;
                }
                catch (Exception exception) {}
                PushThread pushThread = this;
                synchronized (pushThread) {
                    if (VFWSourceStream.this.getStarted()) {
                        Object object;
                        if (this.buffer == null) {
                            object = VFWSourceStream.this.bufferQ;
                            synchronized (object) {
                                if (!VFWSourceStream.this.bufferQ.canWrite()) {
                                    VFWSourceStream.this.bufferQ.read();
                                    VFWSourceStream.this.bufferQ.readReport();
                                }
                                this.buffer = VFWSourceStream.this.bufferQ.getEmptyBuffer();
                            }
                            this.data = VFWSourceStream.this.checkDataAllocation(this.buffer);
                            this.dataBytes = this.data instanceof NBA ? ((NBA)this.data).data : 0L;
                        }
                        object = VFWSourceStream.this.cbHandleLock;
                        synchronized (object) {
                            int n5;
                            n3 = VFWSourceStream.this.getCBHandle();
                            if (n3 != 0 && (n5 = VFWCapture.getAvailableData(n2, n3, this.data, this.dataBytes, VFWSourceStream.this.maxDataSize, VFWSourceStream.this.resultTimeStamp)) > 0) {
                                VFWSourceStream.this.lastTimeStamp = VFWSourceStream.this.startTimeStamp + VFWSourceStream.this.resultTimeStamp[0] * 1000000L;
                                CircularBuffer circularBuffer = VFWSourceStream.this.bufferQ;
                                synchronized (circularBuffer) {
                                    this.buffer.setOffset(0);
                                    this.buffer.setTimeStamp(VFWSourceStream.this.lastTimeStamp);
                                    this.buffer.setLength(n5);
                                    VFWSourceStream.this.bufferQ.writeReport();
                                    VFWSourceStream.this.bufferQ.notifyAll();
                                    this.buffer = null;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    class TransferDataThread
    extends Thread {
        VFWSourceStream stream;

        public TransferDataThread(VFWSourceStream vFWSourceStream2) {
            super("VFW TransferDataThread");
            this.stream = vFWSourceStream2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (VFWSourceStream.this.getConnected()) {
                Object object = VFWSourceStream.this.bufferQ;
                synchronized (object) {
                    while (!VFWSourceStream.this.bufferQ.canRead() && VFWSourceStream.this.getConnected()) {
                        try {
                            VFWSourceStream.this.bufferQ.wait(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                object = this.stream.readLock;
                synchronized (object) {
                    this.stream.doneReading = false;
                }
                if (VFWSourceStream.this.bufferQ.canRead() && VFWSourceStream.this.getConnected() && VFWSourceStream.this.getStarted()) {
                    VFWSourceStream.this.pushData(1);
                }
                object = this.stream.readLock;
                synchronized (object) {
                    if (!VFWSourceStream.this.doneReading) {
                        try {
                            this.stream.readLock.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
    }
}

