/*
 * Decompiled with CFR 0.152.
 */
package jmapps.registry;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import jmapps.registry.VectorEditor;
import jmapps.ui.JMPanel;
import jmapps.ui.MessageDialog;

public class VectorPanel
extends JMPanel
implements ItemListener,
ActionListener {
    VectorEditor editor;
    int code;
    TextField textAdd;
    Vector values;
    List listBox;
    Button buttonAdd;
    Button buttonUp;
    Button buttonDown;
    Button buttonRemove;
    Button buttonRestore;
    Button buttonCommit;

    public VectorPanel(String string, VectorEditor vectorEditor, int n2) {
        this.editor = vectorEditor;
        this.code = n2;
        this.setLayout(new BorderLayout(6, 6));
        Panel panel = new Panel(new BorderLayout(6, 6));
        this.add((Component)panel, "Center");
        Panel panel2 = new Panel(new BorderLayout(6, 6));
        this.add((Component)panel2, "East");
        Panel panel3 = new Panel(new GridLayout(0, 1, 6, 6));
        panel2.add((Component)panel3, "North");
        Panel panel4 = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panel4, "North");
        Label label = new Label(string);
        panel4.add((Component)label, "North");
        this.textAdd = new TextField(20);
        this.textAdd.addActionListener(this);
        panel4.add((Component)this.textAdd, "Center");
        this.listBox = new List();
        this.listBox.addItemListener(this);
        panel.add((Component)this.listBox, "Center");
        this.values = this.editor.getList(n2);
        int n3 = this.values.size();
        int n4 = 0;
        while (n4 < n3) {
            Object e2 = this.values.elementAt(n4);
            this.listBox.add(e2.toString());
            ++n4;
        }
        this.buttonAdd = new Button(JMFI18N.getResource("jmfregistry.vector.add"));
        this.buttonAdd.addActionListener(this);
        panel3.add(this.buttonAdd);
        this.buttonUp = new Button(JMFI18N.getResource("jmfregistry.vector.moveup"));
        this.buttonUp.addActionListener(this);
        panel3.add(this.buttonUp);
        this.buttonDown = new Button(JMFI18N.getResource("jmfregistry.vector.movedown"));
        this.buttonDown.addActionListener(this);
        panel3.add(this.buttonDown);
        this.buttonRemove = new Button(JMFI18N.getResource("jmfregistry.vector.remove"));
        this.buttonRemove.addActionListener(this);
        panel3.add(this.buttonRemove);
        this.buttonRestore = new Button(JMFI18N.getResource("jmfregistry.vector.restore"));
        this.buttonRestore.addActionListener(this);
        panel3.add(this.buttonRestore);
        this.buttonCommit = new Button(JMFI18N.getResource("jmfregistry.vector.commit"));
        this.buttonCommit.addActionListener(this);
        panel3.add(this.buttonCommit);
        this.updateButtons();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.textAdd || object == this.buttonAdd) {
            this.addNew();
        } else if (object == this.buttonUp) {
            this.moveUp();
        } else if (object == this.buttonDown) {
            this.moveDown();
        } else if (object == this.buttonRemove) {
            this.remove();
        } else if (object == this.buttonRestore) {
            this.restore();
        } else if (object == this.buttonCommit) {
            this.commit();
        }
        this.updateButtons();
    }

    private void addNew() {
        String string = this.textAdd.getText();
        if (string != null && string.length() > 0 && this.editor.addToList(this.code, string)) {
            this.values.addElement(string);
            this.refresh();
        } else {
            MessageDialog.createErrorDialog(this.getFrame(), JMFI18N.getResource("jmfregistry.appname"), JMFI18N.getResource("jmfregistry.error.additem"));
        }
        this.updateButtons();
    }

    public void commit() {
        this.editor.commit(this.code);
        this.updateButtons();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n2 = this.listBox.getSelectedIndex();
        this.editor.selectedIndex(this.code, n2);
        this.updateButtons();
    }

    public void moveDown() {
        int n2 = this.listBox.getSelectedIndex();
        if (n2 == this.listBox.getItemCount() - 1) {
            return;
        }
        Object e2 = this.values.elementAt(n2);
        this.values.removeElementAt(n2);
        this.values.insertElementAt(e2, n2 + 1);
        this.refresh();
        this.editor.setList(this.code, this.values);
        this.listBox.select(n2 + 1);
        this.updateButtons();
    }

    public void moveUp() {
        int n2 = this.listBox.getSelectedIndex();
        if (n2 == 0) {
            return;
        }
        Object e2 = this.values.elementAt(n2);
        this.values.removeElementAt(n2);
        this.values.insertElementAt(e2, n2 - 1);
        this.refresh();
        this.editor.setList(this.code, this.values);
        this.listBox.select(n2 - 1);
        this.updateButtons();
    }

    private void refresh() {
        this.listBox.removeAll();
        int n2 = this.values.size();
        int n3 = 0;
        while (n3 < n2) {
            Object e2 = this.values.elementAt(n3);
            this.listBox.add(e2.toString());
            ++n3;
        }
        this.repaint();
    }

    public void remove() {
        int n2 = this.listBox.getSelectedIndex();
        if (n2 < 0) {
            this.updateButtons();
            return;
        }
        this.values.removeElementAt(n2);
        this.refresh();
        this.editor.setList(this.code, this.values);
        int n3 = this.values.size();
        if (n2 >= n3) {
            --n2;
        }
        if (n3 > 0) {
            this.listBox.select(n2);
        } else {
            n2 = -1;
        }
        this.editor.selectedIndex(this.code, n2);
        this.updateButtons();
    }

    public void restore() {
        System.err.println("restoring");
        this.values = this.editor.getList(this.code);
        System.err.println("value = " + this.values);
        this.refresh();
        this.updateButtons();
    }

    private void updateButtons() {
        int n2 = this.values.size();
        int n3 = this.listBox.getSelectedIndex();
        if (n3 < 1) {
            this.buttonUp.setEnabled(false);
        } else {
            this.buttonUp.setEnabled(true);
        }
        if (n3 >= n2 - 1 || n3 < 0) {
            this.buttonDown.setEnabled(false);
        } else {
            this.buttonDown.setEnabled(true);
        }
        if (n3 < 0) {
            this.buttonRemove.setEnabled(false);
        } else {
            this.buttonRemove.setEnabled(true);
        }
    }
}

