/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.data;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.MalformedInputException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.TreeSet;
import mpi.annex.data.AnnexAnnotation;
import mpi.annex.data.AnnexMediaDescriptor;
import mpi.annex.data.AnnexTier;
import mpi.annex.data.AnnexTranscription;
import mpi.annex.data.DataUtil;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;

public class AnnexChatParser {
    private static Logger _logger = Logger.getLogger(AnnexChatParser.class.getName());

    public static void parse(File file, AnnexTranscription transcription) throws IOException {
        int i;
        String[] fullLines = DataUtil.readLines(file, null);
        String[] trimmedLines = new String[fullLines.length];
        for (int i2 = 0; i2 < fullLines.length; ++i2) {
            trimmedLines[i2] = fullLines[i2].trim();
        }
        String encoding = null;
        for (i = 0; i < fullLines.length && !trimmedLines[i].startsWith("*"); ++i) {
            if (!trimmedLines[i].startsWith("@")) continue;
            if (trimmedLines[i].toLowerCase().indexOf("utf8") >= 0) {
                encoding = "UTF-8";
                break;
            }
            if (trimmedLines[i].toLowerCase().indexOf("utf16") < 0) continue;
            encoding = "UTF-16";
            break;
        }
        if (encoding != null) {
            try {
                fullLines = DataUtil.readLines(file, encoding);
            }
            catch (MalformedInputException mie) {
                _logger.warn("File claims to be " + encoding + " but is not, reloading as ISO-8859-1: " + file);
                fullLines = DataUtil.readLines(file, null);
            }
            for (i = 0; i < fullLines.length; ++i) {
                trimmedLines[i] = fullLines[i].trim();
            }
        }
        for (i = 0; i < fullLines.length; ++i) {
            if (trimmedLines[i].indexOf("%snd") != 0) continue;
            fullLines[i] = trimmedLines[i];
        }
        AnnexChatParser.parse(file.getName(), fullLines, trimmedLines, transcription);
    }

    public static void parse(URL url, AnnexTranscription transcription) throws IOException {
        int i;
        InputSource inputSource = new InputSource(url.openStream());
        String[] fullLines = DataUtil.readLines(inputSource, null);
        String[] trimmedLines = new String[fullLines.length];
        for (int i2 = 0; i2 < fullLines.length; ++i2) {
            trimmedLines[i2] = fullLines[i2].trim();
        }
        String encoding = null;
        for (i = 0; i < fullLines.length && !fullLines[i].startsWith("*"); ++i) {
            if (!fullLines[i].startsWith("@")) continue;
            if (trimmedLines[i].toLowerCase().indexOf("utf8") >= 0) {
                encoding = "UTF-8";
                break;
            }
            if (trimmedLines[i].toLowerCase().indexOf("utf16") < 0) continue;
            encoding = "UTF-16";
            break;
        }
        if (encoding != null) {
            inputSource = new InputSource(url.openStream());
            try {
                fullLines = DataUtil.readLines(inputSource, encoding);
            }
            catch (MalformedInputException mie) {
                _logger.warn("Remote file claims to be " + encoding + " but is not, reloading as ISO-8859-1: " + url);
                fullLines = DataUtil.readLines(inputSource, null);
            }
            for (i = 0; i < fullLines.length; ++i) {
                trimmedLines[i] = fullLines[i].trim();
            }
        }
        for (i = 0; i < fullLines.length; ++i) {
            if (trimmedLines[i].indexOf("%snd") != 0) continue;
            fullLines[i] = trimmedLines[i];
        }
        AnnexChatParser.parse("remote node", fullLines, trimmedLines, transcription);
    }

    public static void parse(String fileName, String[] fullLines, String[] trimmedLines, AnnexTranscription transcription) throws IOException {
        AnnexTier tier;
        String nopTierName = "qqqqFAKETIERqqqq";
        boolean nopTierUsed = false;
        String info = "";
        HashMap<String, String> participantHash = new HashMap<String, String>();
        for (int i = 0; i < fullLines.length && !fullLines[i].startsWith("*"); ++i) {
            String[] tokens;
            String part;
            if (trimmedLines[i].startsWith("*")) {
                _logger.info("Header line " + i + " has * after leading whitespace: '" + trimmedLines[i] + "' in: " + fileName);
            }
            if (trimmedLines[i].startsWith("%") && !fullLines[i].startsWith("%")) {
                _logger.info("Header line " + i + " has % after leading whitespace: '" + trimmedLines[i] + "' in: " + fileName);
            } else if (trimmedLines[i].startsWith("@") && !fullLines[i].startsWith("@")) {
                _logger.info("Header line " + i + " has @ after leading whitespace: '" + trimmedLines[i] + "' in: " + fileName);
            }
            if ((fullLines[i].startsWith("%act") || fullLines[i].startsWith("%com") || fullLines[i].startsWith("%sit")) && i > 0 && !nopTierUsed) {
                trimmedLines[i - 1] = "*" + nopTierName + ":\tFAKE ANNOTATION";
                fullLines[i - 1] = "*" + nopTierName + ":\tFAKE ANNOTATION";
                _logger.debug("Had to insert fake annotation before '" + trimmedLines[i] + "' in: " + fileName);
                nopTierUsed = true;
            }
            if (fullLines[i].startsWith("%")) {
                if (nopTierUsed) continue;
                _logger.warn("Spurious % line before first annotation dropped: '" + trimmedLines[i] + "' in: " + fileName);
                trimmedLines[i] = "@Comment:\tDropped: " + trimmedLines[i];
                fullLines[i] = "@Comment:\tDropped: " + fullLines[i];
                continue;
            }
            if (!fullLines[i].startsWith("@")) continue;
            info = info + trimmedLines[i] + "\n";
            if (fullLines[i].toLowerCase().startsWith("@participants")) {
                part = fullLines[i].substring(13).trim();
                tokens = part.split(",");
                String[] tokens2 = part.split(";");
                if (tokens2.length > tokens.length) {
                    tokens = tokens2;
                }
                for (int j = 0; j < tokens.length; ++j) {
                    String token = tokens[j].trim();
                    int firstSpace = token.indexOf(32);
                    if (firstSpace < 0) continue;
                    String tierName = "*" + token.substring(0, firstSpace).trim();
                    String participant = token.substring(firstSpace).trim();
                    participantHash.put(tierName, participant);
                }
                continue;
            }
            if (!fullLines[i].toLowerCase().startsWith("@mediafile")) continue;
            part = fullLines[i].substring(10).trim();
            tokens = part.split(",");
            for (int j = 0; j < tokens.length; ++j) {
                String soundFileName = tokens[j].trim();
                AnnexMediaDescriptor mediaDescriptor = new AnnexMediaDescriptor();
                mediaDescriptor.fileName = soundFileName;
                mediaDescriptor.mimeType = DataUtil.getMediaTypeFromName(mediaDescriptor.fileName);
                transcription.getMediaDescriptors().add(mediaDescriptor);
            }
        }
        transcription.setInfo(info);
        boolean aligned = false;
        String soundFileName = null;
        for (int i = 0; i < fullLines.length; ++i) {
            if (!trimmedLines[i].startsWith("%snd")) continue;
            aligned = true;
            String[] tokens = trimmedLines[i].split("[\\s\"]+");
            if (tokens.length > 1) {
                soundFileName = tokens[1];
                break;
            }
            _logger.warn("No sound file name: '" + trimmedLines[i] + "' in: " + fileName);
            soundFileName = "Unknown.wav";
            break;
        }
        if (aligned) {
            int index = -1;
            ArrayList mds = transcription.getMediaDescriptors();
            for (int i = 0; i < mds.size(); ++i) {
                AnnexMediaDescriptor md = (AnnexMediaDescriptor)mds.get(i);
                if (!md.fileName.toLowerCase().equals(soundFileName.toLowerCase())) continue;
                index = i;
                break;
            }
            AnnexMediaDescriptor mediaDescriptor = new AnnexMediaDescriptor();
            mediaDescriptor.fileName = soundFileName;
            mediaDescriptor.mimeType = DataUtil.getMediaTypeFromName(mediaDescriptor.fileName);
            transcription.getMediaDescriptors().add(0, mediaDescriptor);
            if (index > 0) {
                transcription.getMediaDescriptors().remove(index + 1);
            }
        }
        String ALIGNED_PARENT_TIER_SUFFIX = "-aligned";
        long lastUsedTime = 0L;
        HashMap<String, AnnexTier> tierHash = new HashMap<String, AnnexTier>();
        ArrayList<ChatBlock> chatBlocks = new ArrayList<ChatBlock>();
        int i = 0;
        for (i = 0; i < fullLines.length; ++i) {
            int lastLine;
            if (!fullLines[i].startsWith("*")) {
                if (!trimmedLines[i].startsWith("*")) continue;
                if (trimmedLines[i].lastIndexOf("*") > 0) {
                    _logger.debug("Continuation line has initial * after whitespace: '" + trimmedLines[i] + "' in: " + fileName);
                    continue;
                }
                _logger.info("Continuation line starts with * after whitespace: '" + trimmedLines[i] + "' in: " + fileName);
                continue;
            }
            int firstLine = i;
            if (aligned) {
                for (lastLine = i; lastLine < fullLines.length && fullLines[lastLine].indexOf("%snd") != 0; ++lastLine) {
                }
                if (lastLine == fullLines.length) {
                    aligned = false;
                    --i;
                    continue;
                }
                int sndLine = lastLine;
                while (lastLine + 1 < fullLines.length && fullLines[lastLine + 1].indexOf("*") != 0) {
                    String temp = trimmedLines[++lastLine - 1];
                    trimmedLines[lastLine - 1] = trimmedLines[lastLine];
                    trimmedLines[lastLine] = temp;
                    temp = fullLines[lastLine - 1];
                    fullLines[lastLine - 1] = fullLines[lastLine];
                    fullLines[lastLine] = temp;
                }
            } else {
                while (lastLine + 1 < fullLines.length && fullLines[lastLine + 1].indexOf("%") == 0) {
                    ++lastLine;
                }
            }
            int nLines = lastLine - firstLine + 1;
            ChatBlock block = new ChatBlock();
            block.tierNames = new String[nLines];
            block.annotationValues = new String[nLines];
            block.beginTime = lastUsedTime;
            block.endTime = block.beginTime + 1000L;
            String lastMainTierName = "";
            String[] tokens = new String[4];
            for (int j = 0; j < nLines; ++j) {
                AnnexTier tier2;
                int firstColon;
                String line = trimmedLines[firstLine + j];
                String fullLine = fullLines[firstLine + j];
                if (fullLine.startsWith("@")) {
                    block.tierNames[j] = null;
                    continue;
                }
                if (line.startsWith("%snd")) {
                    block.tierNames[j] = null;
                    StringTokenizer st = new StringTokenizer(line);
                    int nn = 0;
                    tokens[2] = null;
                    tokens[3] = null;
                    while (nn < tokens.length && st.hasMoreTokens()) {
                        tokens[nn++] = st.nextToken();
                    }
                    if (tokens[2] == null || tokens[3] == null) {
                        _logger.warn("Chat parser syntax error in snd line: " + (firstLine + j) + " text: " + line + " in: " + fileName);
                        throw new IOException("AnnexChatParser: Incomplete snd line: " + line);
                    }
                    try {
                        block.beginTime = (long)Float.parseFloat(tokens[2]);
                        block.endTime = (long)Float.parseFloat(tokens[3]);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        _logger.warn("Chat parser number format error in snd line: " + (firstLine + j) + " text: " + line + " in: " + fileName);
                        throw new IOException("AnnexChatParser: Malformed snd line: " + line);
                    }
                }
                if (fullLine.startsWith("*")) {
                    firstColon = line.indexOf(58);
                    if (firstColon < 1) {
                        _logger.warn("Chat parser error, missing colon in main tier line: " + (firstLine + j) + " text: " + line + " in: " + fileName);
                        throw new IOException("Chat parse error, missing colon in main tier line: " + line);
                    }
                    tokens[0] = line.substring(0, firstColon).trim();
                    tokens[1] = line.substring(firstColon + 1).trim();
                    block.tierNames[j] = lastMainTierName = tokens[0];
                    block.annotationValues[j] = tokens[1];
                    if (tierHash.containsKey(lastMainTierName)) continue;
                    AnnexTier parentTier = AnnexChatParser.makeTier(lastMainTierName + ALIGNED_PARENT_TIER_SUFFIX, fileName);
                    parentTier.hasVirtualTime = true;
                    transcription.getTiers().add(parentTier);
                    tierHash.put(parentTier.name, parentTier);
                    tier2 = AnnexChatParser.makeTier(lastMainTierName, fileName);
                    tier2.participant = (String)participantHash.get(tier2.name);
                    if (tier2.participant == null) {
                        tier2.participant = "unknown";
                    }
                    tier2.parentTier = parentTier;
                    transcription.getTiers().add(tier2);
                    tierHash.put(tier2.name, tier2);
                    continue;
                }
                if (fullLine.startsWith("%")) {
                    firstColon = line.indexOf(58);
                    if (firstColon < 1) {
                        _logger.warn("Chat parser error, missing colon in dependent tier line: " + (firstLine + j) + " text: " + line + " in: " + fileName);
                        throw new IOException("Chat parse error, missing colon in dependent tier line: " + line);
                    }
                    tokens[0] = line.substring(0, firstColon).trim();
                    tokens[1] = line.substring(firstColon + 1).trim();
                    block.tierNames[j] = lastMainTierName + "-" + tokens[0];
                    block.annotationValues[j] = tokens[1];
                    if (tierHash.containsKey(block.tierNames[j])) continue;
                    ArrayList tiers = transcription.getTiers();
                    tier2 = AnnexChatParser.makeTier(block.tierNames[j], fileName);
                    tier2.parentTier = (AnnexTier)tierHash.get(lastMainTierName);
                    transcription.getTiers().add(tier2);
                    tierHash.put(tier2.name, tier2);
                    continue;
                }
                if (line.startsWith("*") || line.startsWith("@") || line.startsWith("%")) {
                    _logger.info("Line starts with whitespace followed by *, @ or %: '" + line + "' in: " + fileName);
                }
                block.tierNames[j] = block.tierNames[j - 1];
                block.annotationValues[j] = block.annotationValues[j - 1] + " " + line.trim();
                block.tierNames[j - 1] = null;
                block.annotationValues[j - 1] = null;
            }
            chatBlocks.add(block);
            lastUsedTime = block.endTime;
            i = lastLine;
        }
        HashMap done = new HashMap();
        for (i = 0; i < chatBlocks.size(); ++i) {
            ChatBlock block = (ChatBlock)chatBlocks.get(i);
            AnnexAnnotation alignedAnnotation = null;
            AnnexAnnotation annotation = null;
            AnnexAnnotation depAnnotation = null;
            done.clear();
            for (int j = 0; j < block.tierNames.length; ++j) {
                if (block.tierNames[j] == null || done.containsKey(block.tierNames[j]) || block.tierNames[j].indexOf(45) >= 0) continue;
                String mainTierName = block.tierNames[j];
                String parentTierName = mainTierName + ALIGNED_PARENT_TIER_SUFFIX;
                alignedAnnotation = new AnnexAnnotation("", block.beginTime, block.endTime, true, null);
                alignedAnnotation.refAnnotation = null;
                ((AnnexTier)tierHash.get((Object)parentTierName)).annotations.add(alignedAnnotation);
                int nAnnotations = 0;
                for (int k = j; k < block.tierNames.length; ++k) {
                    if (block.tierNames[k] == null || !block.tierNames[k].equals(mainTierName)) continue;
                    ++nAnnotations;
                }
                long timeStep = (alignedAnnotation.endTime - alignedAnnotation.beginTime) / (long)nAnnotations;
                long lastEndTime = alignedAnnotation.beginTime;
                for (int k = j; k < block.tierNames.length; ++k) {
                    if (block.tierNames[k] == null || !block.tierNames[k].equals(mainTierName)) continue;
                    annotation = new AnnexAnnotation(block.annotationValues[k], lastEndTime, lastEndTime + timeStep, false, null);
                    annotation.refAnnotation = alignedAnnotation;
                    ((AnnexTier)tierHash.get((Object)mainTierName)).annotations.add(annotation);
                    lastEndTime = annotation.endTime;
                    for (int m = k + 1; m < block.tierNames.length && block.tierNames[m] != null && block.tierNames[m].startsWith(mainTierName) && block.tierNames[m].indexOf(37) > 0; ++m) {
                        depAnnotation = new AnnexAnnotation(block.annotationValues[m], annotation.beginTime, annotation.endTime, false, null);
                        depAnnotation.refAnnotation = annotation;
                        ((AnnexTier)tierHash.get((Object)block.tierNames[m])).annotations.add(depAnnotation);
                    }
                }
                if (annotation != null && alignedAnnotation != null) {
                    annotation.endTime = alignedAnnotation.endTime;
                    if (depAnnotation != null) {
                        depAnnotation.endTime = annotation.endTime;
                    }
                }
                done.put(block.tierNames[j], null);
            }
        }
        ArrayList tiers = transcription.getTiers();
        for (i = 0; i < tiers.size(); ++i) {
            AnnexTier tier3 = (AnnexTier)tiers.get(i);
            if (tier3.name.indexOf(ALIGNED_PARENT_TIER_SUFFIX) < 0) continue;
            AnnexAnnotation ann = null;
            AnnexAnnotation prev = null;
            for (int j = 0; j < tier3.annotations.size(); ++j) {
                ann = (AnnexAnnotation)tier3.annotations.get(j);
                if (prev != null && prev.endTime > ann.beginTime) {
                    for (int k = 0; k < chatBlocks.size(); ++k) {
                        ChatBlock block = (ChatBlock)chatBlocks.get(k);
                        if (ann.beginTime != block.beginTime || ann.endTime != block.endTime) continue;
                        String firstTierName = block.tierNames[0] + ALIGNED_PARENT_TIER_SUFFIX;
                        if (firstTierName.equals(tier3.name)) {
                            prev.endTime = ann.beginTime;
                            AnnexChatParser.updateReferencesTo(prev, transcription);
                            continue;
                        }
                        ann.beginTime = prev.endTime;
                        AnnexChatParser.updateReferencesTo(ann, transcription);
                    }
                }
                prev = ann;
            }
        }
        String[] specialTierNames = new String[]{"%act", "%sit", "%com"};
        tiers = transcription.getTiers();
        for (i = 0; i < specialTierNames.length; ++i) {
            ArrayList<AnnexTier> specialTiers = new ArrayList<AnnexTier>();
            for (int j = 0; j < tiers.size(); ++j) {
                AnnexTier tier4 = (AnnexTier)tiers.get(j);
                if (tier4.name.toLowerCase().indexOf(specialTierNames[i]) < 0) continue;
                specialTiers.add(tier4);
            }
            if (specialTiers.size() <= 0) continue;
            AnnexTier parentTier = AnnexChatParser.makeTier(specialTierNames[i] + ALIGNED_PARENT_TIER_SUFFIX, fileName);
            parentTier.hasVirtualTime = true;
            tiers.add(parentTier);
            AnnexTier specialTier = AnnexChatParser.makeTier(specialTierNames[i], fileName);
            specialTier.parentTier = parentTier;
            tiers.add(specialTier);
            TreeSet annotations = new TreeSet(new AnnotationTimeComparator());
            for (int j = 0; j < specialTiers.size(); ++j) {
                AnnexTier tier5 = (AnnexTier)specialTiers.get(j);
                annotations.addAll(tier5.annotations);
                tiers.remove(tier5);
            }
            Object previousAnnotation = null;
            for (AnnexAnnotation annotation : annotations) {
                AnnexAnnotation parentAnnotation;
                if (previousAnnotation != null && previousAnnotation.endTime > annotation.beginTime) {
                    annotation.beginTime = previousAnnotation.endTime;
                }
                annotation.refAnnotation = parentAnnotation = new AnnexAnnotation("", annotation.beginTime, annotation.endTime, true, null);
                parentTier.annotations.add(parentAnnotation);
                specialTier.annotations.add(annotation);
            }
        }
        for (i = 0; i < tiers.size(); ++i) {
            tier = (AnnexTier)tiers.get(i);
            if (tier.name.toLowerCase().indexOf(nopTierName) < 0) continue;
            tiers.remove(tier);
            break;
        }
        for (i = 0; i < tiers.size(); ++i) {
            tier = (AnnexTier)tiers.get(i);
            if (tier.name.toLowerCase().indexOf(nopTierName) < 0) continue;
            tiers.remove(tier);
            break;
        }
    }

    private static AnnexTier makeTier(String name, String fileName) {
        int pos = name.lastIndexOf("%");
        String type = "unknown";
        if (pos >= 0) {
            type = name.substring(pos + 1).trim();
        } else if (name.lastIndexOf("*") > -1) {
            type = "text";
        } else {
            _logger.warn("Tier type neither text nor dependant: " + name + " in: " + fileName);
        }
        return new AnnexTier(name, type);
    }

    private static void updateReferencesTo(AnnexAnnotation annotation, AnnexTranscription transcription) {
        ArrayList<AnnexAnnotation> referers = new ArrayList<AnnexAnnotation>();
        ArrayList tiers = transcription.getTiers();
        for (int i = 0; i < tiers.size(); ++i) {
            int j;
            AnnexTier tier = (AnnexTier)tiers.get(i);
            referers.clear();
            for (int j2 = 0; j2 < tier.annotations.size(); ++j2) {
                AnnexAnnotation ann = (AnnexAnnotation)tier.annotations.get(j2);
                if (ann.refAnnotation != annotation) continue;
                referers.add(ann);
            }
            if (referers.size() <= 0) continue;
            AnnexAnnotation referer = null;
            long step = (annotation.endTime - annotation.beginTime) / (long)referers.size();
            for (j = 0; j < referers.size(); ++j) {
                referer = (AnnexAnnotation)referers.get(j);
                referer.beginTime = annotation.beginTime + (long)j * step;
                referer.endTime = referer.beginTime + step;
            }
            referer.endTime = annotation.endTime;
            for (j = 0; j < referers.size(); ++j) {
                referer = (AnnexAnnotation)referers.get(j);
                AnnexChatParser.updateReferencesTo(referer, transcription);
            }
        }
    }

    private static class AnnotationTimeComparator
    implements Comparator {
        private AnnotationTimeComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            AnnexAnnotation ann1 = (AnnexAnnotation)obj1;
            AnnexAnnotation ann2 = (AnnexAnnotation)obj2;
            if (ann1.beginTime - ann2.beginTime < 0L) {
                return -1;
            }
            if (ann1.beginTime - ann2.beginTime > 0L) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            return false;
        }
    }

    private static class ChatBlock {
        public String[] tierNames;
        public String[] annotationValues;
        public long beginTime;
        public long endTime;

        private ChatBlock() {
        }
    }
}

