/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.data;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import mpi.annex.data.AnnexAnnotation;
import mpi.annex.data.AnnexChatParser;
import mpi.annex.data.AnnexEAFHandler;
import mpi.annex.data.AnnexMediaDescriptor;
import mpi.annex.data.AnnexTier;
import mpi.annex.data.AnnexTranscription;
import mpi.annex.data.CSVParser;
import mpi.annex.data.DataUtil;
import mpi.annex.data.ShoeboxParser;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AnnexParser {
    public static final int UNKNOWN_TYPE = -1;
    public static final int EAF_TYPE = 0;
    public static final int CHAT_TYPE = 1;
    public static final int SHOEBOX_TYPE = 2;
    public static final int TEXT_PLAIN_TYPE = 3;
    public static final int TEXT_HTML_TYPE = 4;
    public static final int TEXT_XML_TYPE = 5;
    public static final int TEXT_CSV_TYPE = 6;
    private static File _typFile;
    private static SAXParser _eafParser;
    private static Logger _logger;

    public static void setTypFile(File shoeboxTypFile) {
        _typFile = shoeboxTypFile;
    }

    public static boolean parse(File file, int annotationType, AnnexTranscription transcription) {
        boolean valid = true;
        try {
            switch (annotationType) {
                case 0: {
                    AnnexParser.parseEAF(file, transcription);
                    break;
                }
                case 1: {
                    AnnexChatParser.parse(file, transcription);
                    break;
                }
                case 2: {
                    if (_typFile != null) {
                        new ShoeboxParser(file, _typFile).parse(transcription);
                    } else {
                        new ShoeboxParser(file).parse(transcription);
                    }
                    valid = true;
                    break;
                }
                case 3: {
                    AnnexParser.parseTextLines(DataUtil.readLines(file, DataUtil.getCharsetName(file)), transcription);
                    break;
                }
                case 4: {
                    AnnexParser.parseTextLines(AnnexParser.filterXML(DataUtil.readLines(file, null), true), transcription);
                    break;
                }
                case 5: {
                    AnnexParser.parseTextLines(AnnexParser.filterXML(DataUtil.readLines(file, null), false), transcription);
                    break;
                }
                case 6: {
                    CSVParser.parseCSV(DataUtil.readLines(file, DataUtil.getCharsetName(file)), transcription);
                    break;
                }
                default: {
                    valid = false;
                    break;
                }
            }
        }
        catch (SAXException saxe) {
            valid = false;
            _logger.warn("AnnexParser.parse SAXException, skipped file: " + file.getAbsolutePath() + ": " + saxe);
        }
        catch (IOException ioe) {
            valid = false;
            _logger.warn("AnnexParser.parse IOException, skipped file: " + file.getAbsolutePath() + ": " + ioe);
        }
        catch (RuntimeException e) {
            valid = false;
            _logger.error("AnnexParser.parse RuntimeException, skipped file: " + file.getAbsolutePath() + ": " + e, e);
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseEAF(File file, AnnexTranscription transcription) throws SAXException, IOException {
        if (_eafParser == null) {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setValidating(false);
            saxFactory.setNamespaceAware(false);
            try {
                _eafParser = saxFactory.newSAXParser();
            }
            catch (ParserConfigurationException pce) {
                throw new SAXException("ParserConfigurationException: " + pce);
            }
        }
        AnnexEAFHandler handler = new AnnexEAFHandler(transcription);
        SAXParser pce = _eafParser;
        synchronized (pce) {
            _eafParser.parse(file, (DefaultHandler)handler);
            _eafParser.reset();
        }
        if (transcription.getMediaDescriptors().size() == 0) {
            String name = file.getName();
            name = name.substring(0, name.length() - 3);
            AnnexMediaDescriptor md = new AnnexMediaDescriptor();
            md.fileName = name + "mpg";
            md.mimeType = "video/x-mpeg1";
            transcription.getMediaDescriptors().add(md);
            md = new AnnexMediaDescriptor();
            md.fileName = name + "wav";
            md.mimeType = "audio/x-wav";
            md.extractedFrom = name + "mpg";
            transcription.getMediaDescriptors().add(md);
        }
    }

    private static String[] filterXML(String[] lines, boolean stripHead) {
        boolean inBody = false;
        for (int i = 0; i < lines.length; ++i) {
            if (!inBody && stripHead) {
                if (lines[i].toLowerCase().indexOf("body") < 0) {
                    lines[i] = "";
                } else {
                    inBody = true;
                }
            }
            if (!inBody || lines[i].toLowerCase().indexOf("/body") < 0) continue;
            inBody = false;
        }
        ArrayList<String> filteredLines = new ArrayList<String>();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            StringBuilder filteredLine = new StringBuilder();
            boolean inTag = false;
            for (int j = 0; j < line.length(); ++j) {
                char c = line.charAt(j);
                if (c == '<') {
                    inTag = true;
                } else if (!inTag) {
                    filteredLine.append(c);
                }
                if (c != '>') continue;
                inTag = false;
            }
            if (filteredLine.length() <= 0) continue;
            filteredLines.add(filteredLine.toString());
        }
        String[] result = new String[filteredLines.size()];
        for (int i = 0; i < filteredLines.size(); ++i) {
            result[i] = (String)filteredLines.get(i);
        }
        return result;
    }

    private static void parseTextLines(String[] lines, AnnexTranscription transcription) {
        AnnexTier tier = new AnnexTier("text", "text");
        tier.participant = "unknown";
        tier.hasVirtualTime = true;
        long fakeTime = 0L;
        Pattern textSplitPattern = Pattern.compile("[\\s\\!\\.\\,\\;\\?\\:]+");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (line.length() == 0) continue;
            String[] tokens = textSplitPattern.split(line);
            for (int j = 0; j < tokens.length; ++j) {
                String token = tokens[j];
                if (token.length() == 0) continue;
                AnnexAnnotation annotation = new AnnexAnnotation(token, fakeTime, fakeTime + 300L, false, "" + i + "/" + j);
                tier.annotations.add(annotation);
                fakeTime = annotation.endTime;
            }
        }
        transcription.getTiers().add(tier);
    }

    public static boolean parse(URL url, int annotationType, AnnexTranscription transcription) {
        boolean valid = true;
        try {
            InputSource inputSource = new InputSource(url.openStream());
            String uri = url.toString();
            int lastSlash = uri.lastIndexOf("/");
            if (lastSlash >= 0) {
                uri = uri.substring(0, lastSlash);
            }
            inputSource.setSystemId(uri + "/");
            switch (annotationType) {
                case 0: {
                    AnnexParser.parseEAF(inputSource, transcription);
                    break;
                }
                case 1: {
                    AnnexChatParser.parse(url, transcription);
                    break;
                }
                case 3: {
                    AnnexParser.parseTextLines(DataUtil.readLines(inputSource, DataUtil.getCharsetName(inputSource)), transcription);
                    break;
                }
                case 4: {
                    AnnexParser.parseTextLines(AnnexParser.filterXML(DataUtil.readLines(inputSource, null), true), transcription);
                    break;
                }
                case 5: {
                    AnnexParser.parseTextLines(AnnexParser.filterXML(DataUtil.readLines(inputSource, null), false), transcription);
                    break;
                }
                case 6: {
                    CSVParser.parseCSV(DataUtil.readLines(inputSource, DataUtil.getCharsetName(inputSource)), transcription);
                    break;
                }
                default: {
                    valid = false;
                    break;
                }
            }
        }
        catch (Exception e) {
            valid = false;
            _logger.error("AnnexParser.parse Exception in stream: " + url.toString() + ": " + e, e);
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseEAF(InputSource inputSource, AnnexTranscription transcription) throws SAXException, IOException {
        if (_eafParser == null) {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setValidating(false);
            saxFactory.setNamespaceAware(false);
            try {
                _eafParser = saxFactory.newSAXParser();
            }
            catch (ParserConfigurationException pce) {
                throw new SAXException("ParserConfigurationException: " + pce);
            }
        }
        AnnexEAFHandler handler = new AnnexEAFHandler(transcription);
        SAXParser sAXParser = _eafParser;
        synchronized (sAXParser) {
            _eafParser.parse(inputSource, (DefaultHandler)handler);
            _eafParser.reset();
        }
    }

    static {
        _eafParser = null;
        _logger = Logger.getLogger(AnnexParser.class.getName());
    }
}

