/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;

public class DataUtil {
    private static Logger _logger = Logger.getLogger(DataUtil.class.getName());

    public static ArrayList getUniqueEAFFilesIn(ArrayList dirsAndPaths) {
        ArrayList dirs = new ArrayList();
        ArrayList paths = new ArrayList();
        for (int i = 0; i < dirsAndPaths.size(); ++i) {
            File f = new File((String)dirsAndPaths.get(i));
            if (f.isDirectory()) {
                dirs.add(dirsAndPaths.get(i));
                continue;
            }
            paths.add(dirsAndPaths.get(i));
        }
        return DataUtil.getUniqueEAFFilesIn(dirs, paths);
    }

    public static ArrayList getUniqueEAFFilesIn(ArrayList dirs, ArrayList paths) {
        int i;
        TreeSet<File> sortedUniqueFiles = new TreeSet<File>();
        for (i = 0; i < dirs.size(); ++i) {
            File dir = new File((String)dirs.get(i));
            if (!dir.exists() || !dir.isDirectory() || !dir.canRead()) continue;
            sortedUniqueFiles.addAll(DataUtil.getAllEafFilesUnder(dir));
        }
        for (i = 0; i < paths.size(); ++i) {
            File file;
            String path = (String)paths.get(i);
            if (!path.toLowerCase().endsWith(".eaf") || !(file = new File(path)).exists() || !file.canRead()) continue;
            sortedUniqueFiles.add(file);
        }
        ArrayList<File> result = new ArrayList<File>();
        result.addAll(sortedUniqueFiles);
        return result;
    }

    public static ArrayList getAllEafFilesUnder(File directory) {
        ArrayList<File> eafFiles = new ArrayList<File>();
        File[] filesAndDirs = directory.listFiles();
        for (int i = 0; i < filesAndDirs.length; ++i) {
            File fileOrDir = filesAndDirs[i];
            if (fileOrDir.isFile() && fileOrDir.canRead()) {
                if (!fileOrDir.getName().toLowerCase().endsWith(".eaf")) continue;
                eafFiles.add(fileOrDir);
                continue;
            }
            if (!fileOrDir.isDirectory() || !fileOrDir.canRead()) continue;
            eafFiles.addAll(DataUtil.getAllEafFilesUnder(fileOrDir));
        }
        return eafFiles;
    }

    public static String getCharsetName(File file) {
        try {
            FileInputStream stream = new FileInputStream(file);
            byte[] buf = new byte[3];
            stream.read(buf);
            stream.close();
            return DataUtil.getCharsetName(buf);
        }
        catch (IOException e) {
            _logger.error("getCharsetName: IOException: " + e + " for: " + file);
            return "ISO-8859-1";
        }
    }

    public static String getCharsetName(InputSource inputSource) {
        try {
            InputStream stream = inputSource.getByteStream();
            byte[] buf = new byte[3];
            stream.read(buf);
            stream.close();
            return DataUtil.getCharsetName(buf);
        }
        catch (IOException e) {
            _logger.error("getCharsetName: IOException: " + e + " for: " + inputSource);
            return "ISO-8859-1";
        }
    }

    public static String getCharsetName(byte[] firstBytes) {
        if ((firstBytes[0] & 0xFF) == 239 && (firstBytes[1] & 0xFF) == 187 && (firstBytes[2] & 0xFF) == 191) {
            return "UTF-8";
        }
        if ((firstBytes[0] & 0xFF) == 254 && (firstBytes[1] & 0xFF) == 255) {
            return "UTF-16BE";
        }
        if ((firstBytes[0] & 0xFF) == 255 && (firstBytes[1] & 0xFF) == 254) {
            return "UTF-16LE";
        }
        return "ISO-8859-1";
    }

    public static String[] readLines(File file, String charSetName) throws IOException {
        String[] lines = new String[]{""};
        if (file == null) {
            return lines;
        }
        Charset charset = Charset.forName("ISO-8859-1");
        if (charSetName != null) {
            charset = Charset.forName(charSetName);
        }
        FileInputStream fis = new FileInputStream(file);
        FileChannel fc = fis.getChannel();
        int size = (int)fc.size();
        MappedByteBuffer byteBuffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, size);
        CharsetDecoder decoder = charset.newDecoder();
        CharBuffer charBuffer = decoder.decode(byteBuffer);
        String txt = charBuffer.toString();
        lines = txt.split("\r?\n");
        fc.close();
        fis.close();
        return lines;
    }

    public static String[] readLines(InputSource inputSource, String charSetName) throws IOException {
        if (charSetName != null) {
            inputSource.setEncoding(charSetName);
        }
        ArrayList<String> lines = new ArrayList<String>();
        InputStream inStream = inputSource.getByteStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
        String line = reader.readLine();
        while (line != null) {
            lines.add(line);
            line = reader.readLine();
        }
        String[] lineArray = new String[lines.size()];
        for (int i = 0; i < lines.size(); ++i) {
            lineArray[i] = (String)lines.get(i);
        }
        return lineArray;
    }

    public static int getAnnotationType(File file) {
        int type = -1;
        String[] lines = null;
        try {
            lines = DataUtil.readLines(file, null);
        }
        catch (IOException e) {
            _logger.debug("getCharsetName: IOException: " + e + " for: " + file);
            return type;
        }
        String line1 = null;
        String line2 = null;
        if (lines.length > 0) {
            line1 = lines[0];
        }
        if (lines.length > 1) {
            line2 = lines[1];
        }
        int eaf1 = -1;
        int shb1 = -1;
        int cht1 = -1;
        if (line1 != null) {
            eaf1 = line1.indexOf("<ANNOTATION_DOCUMENT");
            shb1 = line1.indexOf("\\_sh");
            cht1 = line1.indexOf("@Begin");
        }
        int eaf2 = -1;
        int shb2 = -1;
        int cht2 = -1;
        if (line2 != null) {
            eaf2 = line2.indexOf("ANNOTATION_DOCUMENT");
            shb2 = line2.indexOf("\\_sh");
            cht2 = line2.indexOf("@Begin");
        }
        if (eaf1 >= 0 || eaf2 >= 0) {
            type = 0;
        } else if (shb1 >= 0 || shb2 >= 0) {
            type = 2;
        } else if (cht1 >= 0 || cht2 >= 0) {
            type = 1;
        }
        return type;
    }

    public static String getMediaTypeFromName(String filename) {
        if (filename.endsWith(".wav")) {
            return "audio/x-wav";
        }
        if (filename.endsWith(".mpg")) {
            return "video/x-mpeg1";
        }
        if (filename.endsWith(".mov")) {
            _logger.debug("DataUtil.getMediaTypeFromName: QuickTime: " + filename);
            return "video/quicktime";
        }
        if (filename.endsWith(".mpeg")) {
            return "video/x-mpeg2";
        }
        if (filename.endsWith(".m4a") || filename.endsWith(".mp4")) {
            _logger.info("DataUtil.getMediaTypeFromName: MPEG4: " + filename);
            if (filename.endsWith(".m4a")) {
                return "audio/mp4";
            }
            return "video/mp4";
        }
        _logger.warn("No mimetype known for: " + filename);
        return "Unknown";
    }
}

