/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.data;

import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;
import java.util.TreeSet;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import mpi.annex.data.CountHash;
import mpi.annex.data.UTF8Validator;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexEncReader
extends Reader {
    private static Logger _logger = Logger.getLogger(FlexEncReader.class.getName());
    protected static final int BUFFER_SIZE = 1024;
    protected static final int SUBBUFFER_SIZE = 2048;
    public static final boolean DEBUG = false;
    public static final byte SPACE_CHAR = 32;
    public static final byte BACKSLASH_CHAR = 92;
    public static final byte LF_CHAR = 10;
    public static final byte CR_CHAR = 13;
    private byte[] buffer;
    private int position;
    private int bytesInBuffer;
    private InputStream in;
    private String currentCharset;
    private Hashtable<String, String> encodings;
    private boolean windowsLineDelim;
    private JTextArea textAreaGUI;

    public FlexEncReader(InputStream in, Hashtable<String, String> encodings) {
        this.in = in;
        this.encodings = encodings;
        if (this.encodings == null) {
            this.encodings = new Hashtable();
        }
        this.buffer = new byte[1024];
        this.currentCharset = "ISO-8859-1";
        this.windowsLineDelim = false;
    }

    public FlexEncReader(File infile) throws FileNotFoundException {
        this.in = new FileInputStream(infile);
        this.buffer = new byte[1024];
        try {
            this.encodings = this.guessUTF8(infile);
            this.in.close();
        }
        catch (IOException e) {
            _logger.error("IOException in guessUTF8: " + e + " for: " + infile);
        }
        this.position = 0;
        this.bytesInBuffer = 0;
        this.in = new FileInputStream(infile);
        this.currentCharset = "ISO-8859-1";
        this.windowsLineDelim = false;
    }

    private byte nextByte() throws EOFException, IOException {
        if (this.position == this.bytesInBuffer) {
            this.bytesInBuffer = this.in.read(this.buffer);
            this.position = 0;
        }
        if (this.bytesInBuffer > 0) {
            return this.buffer[this.position++];
        }
        throw new EOFException();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        throw new RuntimeException("not implemented. use readLine");
    }

    public String readTagOrContent(String charsetName) throws EOFException, IOException {
        byte[] subbuffer = new byte[2048];
        int pos = 0;
        boolean tag = false;
        subbuffer[0] = this.nextByte();
        if (subbuffer[0] == 92) {
            tag = true;
        } else if (subbuffer[0] == 10 || subbuffer[0] == 13) {
            return new String(subbuffer, 0, 1, charsetName);
        }
        do {
            if (++pos >= 2048) {
                throw new IOException("this implementation supports lines of max length 2048");
            }
            subbuffer[pos] = this.nextByte();
        } while ((!tag || subbuffer[pos] != 32) && subbuffer[pos] != 10 && subbuffer[pos] != 13);
        String result = null;
        result = tag ? new String(subbuffer, 0, pos + 1, "ISO-8859-1") : new String(subbuffer, 0, pos + 1, charsetName);
        return result;
    }

    public int readTagOrContent(byte[] subbuffer) throws EOFException, IOException {
        int pos = 0;
        boolean tag = false;
        subbuffer[0] = this.nextByte();
        if (subbuffer[0] == 92) {
            tag = true;
        } else if (subbuffer[0] == 10 || subbuffer[0] == 13) {
            return 1;
        }
        do {
            if (++pos >= 2048) {
                throw new IOException("this implementation supports lines of max length 2048");
            }
            subbuffer[pos] = this.nextByte();
        } while ((!tag || subbuffer[pos] != 32) && subbuffer[pos] != 10 && subbuffer[pos] != 13);
        return pos;
    }

    public String readLine() throws IOException {
        String result = null;
        try {
            result = this.readTagOrContent(this.currentCharset);
        }
        catch (EOFException e) {
            return result;
        }
        if (result.startsWith("\\")) {
            this.currentCharset = this.encodings.get(result.substring(1, result.length() - 1));
            if (this.currentCharset == null) {
                this.currentCharset = "ISO-8859-1";
            }
            if (result.charAt(result.length() - 1) != '\n') {
                try {
                    result = result + this.readTagOrContent(this.currentCharset);
                }
                catch (EOFException e) {
                    return result;
                }
            }
        }
        if (result.equals("\n") && this.windowsLineDelim) {
            this.windowsLineDelim = false;
            return this.readLine();
        }
        this.windowsLineDelim = result.endsWith("\r");
        return result.substring(0, result.length() - 1);
    }

    private Hashtable<String, String> guessUTF8(File infile) throws IOException {
        CountHash<String> multibytes = new CountHash<String>();
        CountHash<String> errors = new CountHash<String>();
        TreeSet<String> tags = new TreeSet<String>();
        byte[] subbuffer = new byte[2048];
        int pos = 0;
        String tag = "";
        try {
            while (true) {
                pos = this.readTagOrContent(subbuffer);
                if (subbuffer[0] == 92) {
                    tag = new String(subbuffer, 1, pos - 1, "ISO-8859-1");
                    continue;
                }
                int guess = UTF8Validator.validateUTF8(subbuffer, pos, false);
                tags.add(tag);
                if (guess == -1) {
                    errors.put(tag, 1);
                    continue;
                }
                if (guess <= 0) continue;
                multibytes.put(tag, guess);
            }
        }
        catch (EOFException ee) {
            Hashtable<String, String> result = new Hashtable<String, String>();
            Hashtable<String, String> ascii = new Hashtable<String, String>();
            for (String t : tags) {
                if (multibytes.getCount(t) == 0) {
                    if (errors.getCount(t) != 0) continue;
                    ascii.put(t, "ASCII");
                    continue;
                }
                if (errors.getCount(t) == 0) {
                    result.put(t, "UTF-8");
                    continue;
                }
                _logger.warn("Mixed UTF-8 / Latin? Tag: " + t + " Multi: " + multibytes.getCount(t) + " Badmulti: " + errors.getCount(t) + " for: " + infile);
            }
            _logger.debug("Encodings: " + (ascii.isEmpty() ? "" : " ASCII: " + ascii.keySet()) + (multibytes.isEmpty() ? "" : " multibytes: " + multibytes) + (errors.isEmpty() ? "" : " extended: " + errors) + (result.isEmpty() ? "" : " UTF-8: " + result.keySet()) + " for: " + infile);
            return result;
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public void buildGUI() {
        JFrame frame = new JFrame();
        this.textAreaGUI = new JTextArea();
        this.textAreaGUI.setFont(new Font("DejaVu Sans", 0, 12));
        frame.getContentPane().add(new JScrollPane(this.textAreaGUI));
        frame.pack();
        frame.setVisible(true);
    }

    private void test() {
        this.buildGUI();
        try {
            String line = null;
            while ((line = this.readLine()) != null) {
                _logger.debug("[LINE] " + line);
                this.textAreaGUI.append(line + "\n");
            }
        }
        catch (IOException e) {
            _logger.error("IOException in test: " + e);
        }
    }

    public static void main(String[] args) {
        Hashtable<String, String> test = new Hashtable<String, String>();
        test.put("iso", "ISO-8859-1");
        test.put("uni", "UTF-8");
        try {
            FlexEncReader instance = new FlexEncReader(new FileInputStream(args[0]), test);
            instance.test();
        }
        catch (FileNotFoundException e) {
            _logger.error("File not found: " + args[0]);
        }
    }

    private class EOFException
    extends Exception {
        private EOFException() {
        }
    }
}

