/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.data;

import java.io.FileInputStream;
import java.io.IOException;

public class UTF8Validator {
    public static boolean OUTPUT = false;
    public static int[] BITSEQS = new int[]{Integer.parseInt("00000000", 2), Integer.parseInt("11000000", 2), Integer.parseInt("11100000", 2), Integer.parseInt("11110000", 2), Integer.parseInt("11111000", 2), Integer.parseInt("11111100", 2)};
    public static int[] BITMASKS = new int[]{Integer.parseInt("10000000", 2), Integer.parseInt("11100000", 2), Integer.parseInt("11110000", 2), Integer.parseInt("11111000", 2), Integer.parseInt("11111100", 2), Integer.parseInt("11111110", 2)};
    public static int CONTSEQ = Integer.parseInt("10000000", 2);
    public static int CONTMASK = Integer.parseInt("11000000", 2);

    public static int validateUTF8(byte[] buf, int size, boolean allowMiddle) {
        int count = 0;
        int follow = 0;
        if (OUTPUT) {
            System.out.println("[[validateUTF8]] ");
        }
        for (int pos = 0; pos < size; ++pos) {
            int b = UTF8Validator.unsignedByteToInt(buf[pos]);
            if (follow == 0 && b >= 128) {
                for (int i = 1; i <= 5; ++i) {
                    if ((b & BITMASKS[i]) != BITSEQS[i]) continue;
                    if (OUTPUT) {
                        System.out.print(b + "[MULTI" + i + "] ");
                    }
                    follow = i;
                    break;
                }
                if (follow != 0) continue;
                if (allowMiddle && (b & CONTMASK) == CONTSEQ) {
                    if (!OUTPUT) continue;
                    System.out.print(b + "[IGNORE-CONT] ");
                    continue;
                }
                if (OUTPUT) {
                    System.out.println(b + "[INIT-ERROR]");
                }
                follow = 0;
                count = -1;
                continue;
            }
            if (follow > 0) {
                if ((b & CONTMASK) == CONTSEQ) {
                    if (OUTPUT) {
                        System.out.print(b + "[CONT] ");
                    }
                    --follow;
                    if (count <= -1) continue;
                    ++count;
                    continue;
                }
                if (OUTPUT) {
                    System.out.println(b + "[CONT-ERROR] ");
                }
                follow = 0;
                count = -1;
                continue;
            }
            allowMiddle = false;
            if (!OUTPUT) continue;
            System.out.print((char)b);
        }
        if (OUTPUT) {
            System.out.println("[SUCCESS] result=" + count);
        }
        return count;
    }

    public static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    public static boolean validateFile(String filename) {
        boolean valid = true;
        try {
            FileInputStream stream = new FileInputStream(filename);
            byte[] buf = new byte[1000];
            while (stream.available() > 0) {
                stream.read(buf);
                if (UTF8Validator.validateUTF8(buf, 1000, true) >= 0) continue;
                valid = false;
            }
            stream.close();
        }
        catch (IOException e) {
            System.out.println("UTF8Validator error for: " + filename);
            valid = false;
        }
        return valid;
    }
}

