/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.search;

import java.io.File;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mpi.annex.data.AnnexAnnotation;
import mpi.annex.data.AnnexTier;
import mpi.annex.data.AnnexTranscription;
import mpi.annex.search.SearchHit;
import mpi.annex.search.SearchQuery;
import mpi.annex.util.AnnexUtil;
import org.apache.log4j.Logger;

public class HSQLDBQuery
extends SearchQuery
implements Runnable {
    private static Logger _logger = Logger.getLogger(HSQLDBQuery.class.getName());
    private Connection queryCon;
    private Statement queryStatement;
    private Connection hitCon;
    private Statement hitStatement;
    private String queryId;
    private HSQLDBQuery cloneQuery;
    private ArrayList eafFiles;
    private ArrayList problemFiles;
    private ArrayList tierNames;
    private ArrayList tierTypes;
    private ArrayList participants;
    private float domainInitializationProgress;
    private static Pattern staticRegExpPattern;

    public HSQLDBQuery(String queryId) {
        this.queryId = queryId;
        this.problemFiles = new ArrayList();
        this.schemaName = "search" + queryId;
        String createSchema = "CREATE SCHEMA " + this.schemaName + " AUTHORIZATION DBA";
        String createTierTable = "CREATE TABLE " + this.schemaName + ".tiers (" + "tier_id INTEGER, " + "tier_name VARCHAR, " + "tier_type VARCHAR, " + "default_locale VARCHAR, " + "participant VARCHAR, " + "n_annotations INTEGER, " + "ref_tier_id INTEGER, " + "transcription_type INTEGER, " + "node_id VARCHAR)";
        String createAnnotationTable = "CREATE TABLE " + this.schemaName + ".annotations (" + "ann_id INTEGER, " + "annotation VARCHAR, " + "ann_position INTEGER, " + "begin_time BIGINT, " + "end_time BIGINT, " + "ref_ann_id INTEGER, " + "aligned BOOLEAN, " + "ann_tier_id INTEGER)";
        try {
            this.queryCon = DriverManager.getConnection("jdbc:hsqldb:mem:doQuery", "sa", "");
            this.queryStatement = this.queryCon.createStatement();
            this.hitCon = DriverManager.getConnection("jdbc:hsqldb:mem:getHits", "sa", "");
            this.hitStatement = this.hitCon.createStatement();
            this.queryStatement.executeUpdate(createSchema);
            this.queryStatement.executeUpdate(createTierTable);
            this.queryStatement.executeUpdate(createAnnotationTable);
            this.queryStatement.executeUpdate("CREATE INDEX ann_begin_time_index ON " + this.schemaName + ".annotations( begin_time )");
            this.queryStatement.executeUpdate("CREATE INDEX ann_end_time_index ON " + this.schemaName + ".annotations( end_time )");
            this.hitStatement.executeUpdate(createSchema);
            this.hitStatement.executeUpdate(createTierTable);
            this.hitStatement.executeUpdate(createAnnotationTable);
            this.hitStatement.executeUpdate("CREATE INDEX ann_begin_time_index ON " + this.schemaName + ".annotations( begin_time )");
            this.hitStatement.executeUpdate("CREATE INDEX ann_end_time_index ON " + this.schemaName + ".annotations( end_time )");
        }
        catch (SQLException e) {
            _logger.error("HSQLDBQuery create tables SQLException: " + e, e);
        }
    }

    public void doQuery(String encodedQuery) {
        this.cancelQuery();
        this.statistics.reset();
        this.clearFrequencyStatistics();
        if (this.eafFiles.size() == 0) {
            return;
        }
        this.createLayers(encodedQuery);
        this.keepExecuting = true;
        this.isExecuting = true;
        new Thread(new QueryExecutor()).start();
    }

    public void cancelQuery() {
        if (this.isExecuting) {
            this.keepExecuting = false;
            try {
                while (this.isExecuting) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.isExecuting = false;
    }

    protected String createQueryPatternPart(String pattern, String[] queryModes, Pattern regexpPattern, boolean patternNOTMode) {
        int patternLength = pattern.length();
        String queryPart = "";
        this.patternNeedsFullStatistics = false;
        if (queryModes[0].equals(" Annotation")) {
            if (queryModes[1].equals(" case sensitive")) {
                if (queryModes[2].equals(" exact match")) {
                    queryPart = patternNOTMode ? "annotation != '" + pattern + "'" : "annotation = '" + pattern + "'";
                } else if (queryModes[2].equals(" substring match")) {
                    if (patternNOTMode) {
                        queryPart = "annotation NOT LIKE '%" + this.escape(pattern) + "%' ESCAPE '\u00b1'";
                    } else {
                        queryPart = "annotation LIKE '%" + this.escape(pattern) + "%' ESCAPE '\u00b1'";
                        this.patternNeedsFullStatistics = true;
                    }
                } else if (queryModes[2].equals(" regular expression")) {
                    staticRegExpPattern = regexpPattern;
                    if (patternNOTMode) {
                        queryPart = "\"mpi.annex.search.HSQLDBQuery.match\"(annotation, true, true)";
                    } else {
                        queryPart = "\"mpi.annex.search.HSQLDBQuery.match\"(annotation, true, false)";
                        this.patternNeedsFullStatistics = true;
                    }
                }
            } else if (queryModes[2].equals(" exact match")) {
                queryPart = patternNOTMode ? "LCASE(annotation) != '" + pattern.toLowerCase() + "'" : "LCASE(annotation) = '" + pattern.toLowerCase() + "'";
            } else if (queryModes[2].equals(" substring match")) {
                if (patternNOTMode) {
                    queryPart = "LCASE(annotation) NOT LIKE '%" + this.escape(pattern.toLowerCase()) + "%' ESCAPE '\u00b1'";
                } else {
                    queryPart = "LCASE(annotation) LIKE '%" + this.escape(pattern.toLowerCase()) + "%' ESCAPE '\u00b1'";
                    this.patternNeedsFullStatistics = true;
                }
            } else if (queryModes[2].equals(" regular expression")) {
                staticRegExpPattern = regexpPattern;
                if (patternNOTMode) {
                    queryPart = "\"mpi.annex.search.HSQLDBQuery.match\"(annotation, false, true)";
                } else {
                    queryPart = "\"mpi.annex.search.HSQLDBQuery.match\"(annotation, false, false)";
                    this.patternNeedsFullStatistics = true;
                }
            }
        } else if (queryModes[0].equals(" N-gram over annotations") || queryModes[0].equals(" N-gram within annotation")) {
            String nGramPart = this.getLongestNonWildcardPart(pattern);
            if (queryModes[2].equals(" regular expression")) {
                if (queryModes[0].equals(" N-gram within annotation")) {
                    if (nGramPart.startsWith("^")) {
                        nGramPart = nGramPart.substring(1);
                    }
                    if (nGramPart.endsWith("$")) {
                        nGramPart = nGramPart.substring(0, nGramPart.length() - 1);
                    }
                }
                staticRegExpPattern = Pattern.compile(nGramPart);
                if (queryModes[1].equals(" case sensitive")) {
                    if (patternNOTMode) {
                        queryPart = "\"mpi.annex.search.HSQLDBQuery.match\"(annotation, true, true)";
                    } else {
                        queryPart = "\"mpi.annex.search.HSQLDBQuery.match\"(annotation, true, false)";
                        this.patternNeedsFullStatistics = true;
                    }
                } else if (patternNOTMode) {
                    queryPart = "\"mpi.annex.search.HSQLDBQuery.match\"(annotation, false, true)";
                } else {
                    queryPart = "\"mpi.annex.search.HSQLDBQuery.match\"(annotation, false, false)";
                    this.patternNeedsFullStatistics = true;
                }
            } else if (queryModes[1].equals(" case sensitive")) {
                if (patternNOTMode) {
                    queryPart = "annotation NOT LIKE '%" + this.escape(nGramPart) + "%'";
                } else {
                    queryPart = "annotation LIKE '%" + this.escape(nGramPart) + "%'";
                    this.patternNeedsFullStatistics = true;
                }
            } else if (patternNOTMode) {
                queryPart = "LCASE(annotation) NOT LIKE '%" + this.escape(nGramPart.toLowerCase()) + "%'";
            } else {
                queryPart = "LCASE(annotation) LIKE '%" + this.escape(nGramPart.toLowerCase()) + "%'";
                this.patternNeedsFullStatistics = true;
            }
        }
        return queryPart;
    }

    protected String convertRegexpPatternsIfNeeded(String queryString) {
        return queryString;
    }

    public static boolean match(String annotation, boolean caseSensitive, boolean notMode) {
        Matcher matcher = caseSensitive ? staticRegExpPattern.matcher(annotation) : staticRegExpPattern.matcher(annotation.toLowerCase());
        if (notMode) {
            return !matcher.find();
        }
        return matcher.find();
    }

    public ArrayList getHits(int fromIndex, int toIndex, int contextSize) {
        ArrayList<SearchHit> hitList = new ArrayList<SearchHit>();
        try {
            int prevFileId = -1;
            File file = null;
            ArrayList<Long> beginTimes = new ArrayList<Long>();
            int[][] hitAnnIds = new int[this.nLayers][this.nPatternsPerLayer];
            int[] savedHitAnnId = this.searchLayers[this.firstNonEmptyLayerIndex].getHitAnnIdsForPattern(this.firstNonEmptyPatternIndex);
            int[] savedHitNumber = this.searchLayers[this.firstNonEmptyLayerIndex].getHitNumberForPattern(this.firstNonEmptyPatternIndex);
            int[] savedHitFileId = this.searchLayers[this.firstNonEmptyLayerIndex].getHitFileIds();
            for (int i = fromIndex; i < toIndex && i < this.statistics.nHits && i < 100000; ++i) {
                SearchHit hit = new SearchHit();
                int annId = savedHitAnnId[i];
                int fileId = savedHitFileId[i];
                if (fileId != prevFileId) {
                    file = (File)this.eafFiles.get(fileId);
                    AnnexTranscription transcription = new AnnexTranscription(file.getName(), 0, file);
                    this.ingest(transcription, this.hitCon);
                    prevFileId = fileId;
                }
                ResultSet rs = this.hitStatement.executeQuery("SELECT ann_position, annotation, begin_time, end_time, ann_tier_id, aligned FROM " + this.schemaName + ".annotations WHERE ann_id = " + annId);
                rs.next();
                hit.positionInTier = rs.getInt(1);
                if (this.isSimpleQuery) {
                    hit.annotation = rs.getString(2);
                    hit.beginTime = this.getValue(rs, 3);
                    hit.endTime = this.getValue(rs, 4);
                } else {
                    for (int layer = 0; layer < this.nLayers; ++layer) {
                        for (int pattern = 0; pattern < this.nPatternsPerLayer; ++pattern) {
                            int[] annIds = this.searchLayers[layer].getHitAnnIdsForPattern(pattern);
                            hitAnnIds[layer][pattern] = annIds != null ? annIds[i] : -1;
                        }
                    }
                    SearchQuery.ComplexHitData hitData = this.constructComplexHitResultString(null, this.hitStatement, hitAnnIds, true);
                    hit.annotation = hitData.hitString;
                    hit.beginTime = hitData.beginTime;
                    hit.endTime = hitData.endTime;
                }
                int ann_tier_id = rs.getInt(5);
                hit.aligned = rs.getBoolean(6);
                rs = this.hitStatement.executeQuery("SELECT node_id, tier_name, tier_type, participant, n_annotations FROM " + this.schemaName + ".tiers WHERE tier_id = " + ann_tier_id);
                rs.next();
                hit.transcriptionNodeId = rs.getString(1);
                hit.transcriptionName = file.getAbsolutePath();
                hit.tierName = rs.getString(2);
                hit.tierType = this.isSimpleQuery ? rs.getString(3) : "xxxCOMPLEX_QUERY_INDICATORxxx";
                hit.participant = rs.getString(4);
                int nAnnotationsInTier = rs.getInt(5);
                hit.hitNumberInAnnotation = savedHitNumber[i];
                String pattern = this.searchLayers[this.firstNonEmptyLayerIndex].getPattern(this.firstNonEmptyPatternIndex);
                boolean patternNOTMode = this.searchLayers[this.firstNonEmptyLayerIndex].getPatternNOTMode(this.firstNonEmptyPatternIndex);
                Pattern regExpPattern = this.searchLayers[this.firstNonEmptyLayerIndex].getRegExpPattern(this.firstNonEmptyPatternIndex);
                String[] queryModes = this.searchLayers[this.firstNonEmptyLayerIndex].getMode(this.firstNonEmptyPatternIndex);
                hit.hitPositionInAnnotation = this.getHitPosition(hit.annotation, hit.hitNumberInAnnotation, queryModes, pattern, regExpPattern, patternNOTMode);
                hit.hitLength = this.getHitLength(hit.annotation, hit.hitNumberInAnnotation, queryModes, pattern, regExpPattern, patternNOTMode);
                if (queryModes[0].equals(" N-gram over annotations")) {
                    int leftContextSize = contextSize + this.nGramSizeLeftFromHit;
                    rs = this.hitStatement.executeQuery("SELECT annotation, ann_position, begin_time FROM " + this.schemaName + ".annotations " + "WHERE ann_tier_id = " + ann_tier_id + "AND ann_position < " + hit.positionInTier + "AND ann_position >= " + (hit.positionInTier - leftContextSize) + "ORDER BY ann_position DESC");
                    beginTimes.clear();
                    while (rs.next()) {
                        hit.leftContext.add(rs.getString(1));
                        beginTimes.add(new Long(this.getValue(rs, 3)));
                    }
                    for (int j = 0; j < this.nGramSizeLeftFromHit; ++j) {
                        if (hit.leftContext.size() <= 0) continue;
                        String part = (String)hit.leftContext.get(0);
                        hit.annotation = part + " " + hit.annotation;
                        hit.beginTime = (Long)beginTimes.get(0);
                        hit.leftContext.remove(0);
                        beginTimes.remove(0);
                    }
                    int rightContextSize = contextSize + this.nGramSizeRightFromHit;
                    rs = this.hitStatement.executeQuery("SELECT annotation, ann_position, end_time FROM " + this.schemaName + ".annotations " + "WHERE ann_tier_id = " + ann_tier_id + "AND ann_position > " + hit.positionInTier + "AND ann_position <= " + (hit.positionInTier + rightContextSize) + "ORDER BY ann_position");
                    int n = 0;
                    while (rs.next()) {
                        if (n < this.nGramSizeRightFromHit) {
                            hit.annotation = hit.annotation + " " + rs.getString(1);
                            hit.endTime = this.getValue(rs, 3);
                        } else {
                            hit.rightContext.add(rs.getString(1));
                        }
                        ++n;
                    }
                    hit.hitPositionInAnnotation = 0;
                    hit.hitLength = hit.annotation.length();
                    hit.positionInTier -= leftContextSize;
                    ++hit.positionInTier;
                } else {
                    rs = this.hitStatement.executeQuery("SELECT annotation, ann_position FROM " + this.schemaName + ".annotations " + "WHERE ann_tier_id = " + ann_tier_id + "AND ann_position < " + hit.positionInTier + "AND ann_position >= " + (hit.positionInTier - contextSize) + "ORDER BY ann_position DESC");
                    while (rs.next()) {
                        hit.leftContext.add(rs.getString(1));
                    }
                    rs = this.hitStatement.executeQuery("SELECT annotation, ann_position FROM " + this.schemaName + ".annotations " + "WHERE ann_tier_id = " + ann_tier_id + "AND ann_position > " + hit.positionInTier + "AND ann_position <= " + (hit.positionInTier + contextSize) + "ORDER BY ann_position");
                    while (rs.next()) {
                        hit.rightContext.add(rs.getString(1));
                    }
                    ++hit.positionInTier;
                }
                hitList.add(hit);
            }
        }
        catch (SQLException e) {
            _logger.error("SQLException in getHits: " + e, e);
        }
        return hitList;
    }

    public ArrayList getViewerParametersFor(int annId, int fileId) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        try {
            File file = (File)this.eafFiles.get(fileId);
            AnnexTranscription transcription = new AnnexTranscription(file.getName(), 0, file);
            this.ingest(transcription, this.hitCon);
            ResultSet rs = this.hitStatement.executeQuery("SELECT begin_time, end_time, ann_tier_id FROM " + this.schemaName + ".annotations WHERE ann_id = " + annId);
            rs.next();
            Long beginTime = new Long(this.getValue(rs, 1));
            Long endTime = new Long(this.getValue(rs, 2));
            int tierId = rs.getInt(3);
            rs = this.hitStatement.executeQuery("SELECT tier_name FROM " + this.schemaName + ".tiers WHERE tier_id = " + tierId);
            rs.next();
            String tierName = rs.getString(1);
            parameters.add(file.getAbsolutePath());
            parameters.add(tierName);
            parameters.add(beginTime);
            parameters.add(endTime);
        }
        catch (SQLException e) {
            _logger.error("SQLException in getViewerParametersFor: " + e, e);
        }
        return parameters;
    }

    private String escape(String string) {
        String s = string.replaceAll("\u00b1", "\u00b1\u00b1");
        s = s.replaceAll("%", "\u00b1%");
        s = s.replaceAll("'", "\\\\'");
        s = s.replaceAll("\"", "\u00b1\"");
        return s.replaceAll("_", "\u00b1_");
    }

    private DomainStats ingest(AnnexTranscription transcription, Connection con) {
        DomainStats stats = new DomainStats();
        Statement st = null;
        try {
            st = con.createStatement();
            st.executeUpdate("DELETE FROM " + this.schemaName + ".tiers");
            st.executeUpdate("DELETE FROM " + this.schemaName + ".annotations");
            HashMap<Serializable, Integer> ids = new HashMap<Serializable, Integer>();
            int nTiers = transcription.getTiers().size();
            int tierId = 0;
            int annotationId = 0;
            stats.nTiers = nTiers;
            for (int i = 0; i < nTiers; ++i) {
                AnnexTier tier = (AnnexTier)transcription.getTiers().get(i);
                ids.put(tier, new Integer(tierId++));
                int nAnnotations = tier.annotations.size();
                stats.nAnnotations += (long)nAnnotations;
                for (int j = 0; j < nAnnotations; ++j) {
                    AnnexAnnotation annotation = (AnnexAnnotation)tier.annotations.get(j);
                    ids.put(annotation, new Integer(annotationId++));
                    stats.annotationsSize += (long)annotation.value.length();
                }
            }
            PreparedStatement stAnnotation = con.prepareStatement("INSERT INTO " + this.schemaName + ".annotations VALUES(?, ?, ?, ?, ?, ?, ?, ?)");
            PreparedStatement stTier = con.prepareStatement("INSERT INTO " + this.schemaName + ".tiers VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)");
            tierId = 0;
            annotationId = 0;
            for (int i = 0; i < nTiers; ++i) {
                AnnexTier tier = (AnnexTier)transcription.getTiers().get(i);
                int ref_tier_id = -1;
                if (tier.parentTier != null) {
                    ref_tier_id = (Integer)ids.get(tier.parentTier);
                }
                int nAnnotations = tier.annotations.size();
                stTier.setInt(1, tierId);
                stTier.setString(2, tier.name);
                stTier.setString(3, tier.type);
                stTier.setString(4, tier.defaultLocale);
                stTier.setString(5, tier.participant);
                stTier.setInt(6, nAnnotations);
                stTier.setInt(7, ref_tier_id);
                stTier.setInt(8, transcription.getType());
                stTier.setString(9, transcription.getNodeId());
                stTier.executeUpdate();
                for (int j = 0; j < nAnnotations; ++j) {
                    String filePath;
                    AnnexAnnotation annotation = (AnnexAnnotation)tier.annotations.get(j);
                    int ref_ann_id = -1;
                    if (annotation.refAnnotation != null) {
                        ref_ann_id = (Integer)ids.get(annotation.refAnnotation);
                    }
                    if (annotation.value.length() > 2600) {
                        filePath = AnnexUtil.getFilePathFor(transcription.getNodeId());
                        _logger.warn("Info: there is an annotation longer than 2600 characters in: " + filePath);
                        annotation.value = annotation.value.substring(0, 2600) + "...";
                    }
                    if (annotation.value.indexOf(0) != -1) {
                        filePath = AnnexUtil.getFilePathFor(transcription.getNodeId());
                        _logger.warn("Info: there is an annotation which contains NUL chars in: " + filePath);
                        annotation.value = annotation.value.replaceAll("\\000", "*");
                    }
                    stAnnotation.setInt(1, annotationId++);
                    stAnnotation.setString(2, annotation.value);
                    stAnnotation.setInt(3, j);
                    stAnnotation.setLong(4, annotation.beginTime);
                    stAnnotation.setLong(5, annotation.endTime);
                    stAnnotation.setInt(6, ref_ann_id);
                    stAnnotation.setBoolean(7, annotation.isTimeAligned);
                    stAnnotation.setInt(8, tierId);
                    stAnnotation.executeUpdate();
                }
                ++tierId;
            }
        }
        catch (SQLException e) {
            _logger.error("SQLException in ingest: " + e, e);
        }
        catch (RuntimeException re) {
            _logger.error("RuntimeException in ingest: " + re, re);
        }
        return stats;
    }

    public void setDomain(ArrayList eafFiles) {
        this.eafFiles = (ArrayList)eafFiles.clone();
        this.problemFiles.clear();
        this.statistics.reset();
        this.clearFrequencyStatistics();
        this.domainInitializationProgress = 0.0f;
        new Thread(this).start();
    }

    public void setDomain(HSQLDBQuery query) {
        this.problemFiles.clear();
        this.statistics.reset();
        this.clearFrequencyStatistics();
        this.cloneQuery = query;
        this.domainInitializationProgress = 0.0f;
        new Thread(this).start();
    }

    public float getDomainInitializationProgress() {
        return this.domainInitializationProgress;
    }

    public ArrayList getDomain() {
        return this.eafFiles;
    }

    public ArrayList getProblemFiles() {
        return this.problemFiles;
    }

    public ArrayList getTierNames() {
        return this.tierNames;
    }

    public ArrayList getTierTypes() {
        return this.tierTypes;
    }

    public ArrayList getParticipants() {
        return this.participants;
    }

    public void run() {
        if (this.cloneQuery != null) {
            while (this.cloneQuery.getDomainInitializationProgress() < 1.0f) {
                try {
                    this.domainInitializationProgress = this.cloneQuery.getDomainInitializationProgress() - 0.01f;
                    Thread.currentThread();
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {}
            }
            this.eafFiles = (ArrayList)this.cloneQuery.getDomain().clone();
            this.tierNames = (ArrayList)this.cloneQuery.getTierNames().clone();
            this.tierTypes = (ArrayList)this.cloneQuery.getTierTypes().clone();
            this.participants = (ArrayList)this.cloneQuery.getParticipants().clone();
            this.domainInitializationProgress = 1.0f;
            this.cloneQuery = null;
        } else {
            int i;
            AnnexTranscription transcription = null;
            TreeSet<String> tierNamesSet = new TreeSet<String>();
            TreeSet<String> tierTypesSet = new TreeSet<String>();
            TreeSet<String> participantsSet = new TreeSet<String>();
            this.problemFiles = new ArrayList();
            for (i = 0; i < this.eafFiles.size(); ++i) {
                File file = (File)this.eafFiles.get(i);
                if (file.exists()) {
                    transcription = new AnnexTranscription(file.getName(), 0, file);
                    if (transcription.isValid()) {
                        ArrayList tiers = transcription.getTiers();
                        for (int j = 0; j < tiers.size(); ++j) {
                            AnnexTier tier = (AnnexTier)tiers.get(j);
                            if (tier.name != null && tier.name.trim().length() > 0) {
                                tierNamesSet.add(tier.name);
                            }
                            if (tier.type != null && tier.type.trim().length() > 0) {
                                tierTypesSet.add(tier.type);
                            }
                            if (tier.participant == null || tier.participant.trim().length() <= 0) continue;
                            participantsSet.add(tier.participant);
                        }
                    } else {
                        this.problemFiles.add(this.eafFiles.get(i));
                    }
                }
                this.domainInitializationProgress = (float)((double)this.domainInitializationProgress + 1.0 / (double)(this.eafFiles.size() + 1));
            }
            this.tierNames = new ArrayList(tierNamesSet);
            this.tierTypes = new ArrayList(tierTypesSet);
            this.participants = new ArrayList(participantsSet);
            if (this.problemFiles.size() > 0) {
                for (i = 0; i < this.problemFiles.size(); ++i) {
                    this.eafFiles.remove(this.problemFiles.get(i));
                }
            }
            this.domainInitializationProgress = 1.0f;
        }
    }

    static {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (ClassNotFoundException e) {
            System.out.println("No JAR with org.hsqldb.jdbcDriver in classpath!");
            _logger.error("No JAR with org.hsqldb.jdbcDriver in classpath!");
        }
    }

    private class DomainStats {
        public int nFiles;
        public int nExist;
        public int nPermissionDenied;
        public int nNotParsable;
        public int nDBProblems;
        public int nEmpty;
        public int nTiers;
        public long nAnnotations;
        public long annotationsSize;

        private DomainStats() {
        }
    }

    private class QueryExecutor
    implements Runnable {
        String pattern;
        boolean patternNOTMode;
        Pattern regExpPattern;
        String[] queryModes;

        public QueryExecutor() {
            if (HSQLDBQuery.this.firstNonEmptyPatternIndex >= 0) {
                this.pattern = HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getPattern(HSQLDBQuery.this.firstNonEmptyPatternIndex);
                this.patternNOTMode = HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getPatternNOTMode(HSQLDBQuery.this.firstNonEmptyPatternIndex);
                this.regExpPattern = HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getRegExpPattern(HSQLDBQuery.this.firstNonEmptyPatternIndex);
                this.queryModes = HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getMode(HSQLDBQuery.this.firstNonEmptyPatternIndex);
            }
        }

        public void run() {
            if (this.pattern == null) {
                HSQLDBQuery.this.statistics.progress = 1.0f;
                HSQLDBQuery.this.isExecuting = false;
            } else {
                String queryString = "SELECT ann_id, annotation, begin_time, end_time, ann_position, ann_tier_id FROM " + HSQLDBQuery.this.schemaName + ".annotations WHERE ";
                queryString = queryString + HSQLDBQuery.this.createQueryPatternPart(this.pattern, this.queryModes, this.regExpPattern, this.patternNOTMode);
                queryString = queryString + HSQLDBQuery.this.createGlobalTimeConstraintPart();
                try {
                    AnnexTranscription transcription = null;
                    for (int fileIndex = 0; fileIndex < HSQLDBQuery.this.eafFiles.size(); ++fileIndex) {
                        File file = (File)HSQLDBQuery.this.eafFiles.get(fileIndex);
                        if (file.exists()) {
                            transcription = new AnnexTranscription(file.getName(), 0, file);
                            if (transcription.isValid()) {
                                HSQLDBQuery.this.currentNodeId = transcription.getNodeId();
                                DomainStats stat = HSQLDBQuery.this.ingest(transcription, HSQLDBQuery.this.queryCon);
                                HSQLDBQuery.this.statistics.nAnnotationsSearched = (int)((long)HSQLDBQuery.this.statistics.nAnnotationsSearched + stat.nAnnotations);
                                if (fileIndex < HSQLDBQuery.this.eafFiles.size() - 1) {
                                    HSQLDBQuery.this.statistics.progress = ((float)fileIndex - 0.5f) / (float)HSQLDBQuery.this.eafFiles.size();
                                }
                                if (!HSQLDBQuery.this.isSimpleQuery) {
                                    staticRegExpPattern = this.regExpPattern;
                                }
                                HSQLDBQuery.this.setTierDomainForLayers(false, HSQLDBQuery.this.queryStatement);
                                String tierDomain = HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getTierIdsInLayerDomain();
                                String query = queryString;
                                if (HSQLDBQuery.this.thereIsALayerWithAnEmptyTierDomain) continue;
                                if (!tierDomain.equals(HSQLDBQuery.this.fullTranscriptionTierDomain)) {
                                    query = query + tierDomain;
                                }
                                _logger.debug("query: " + query);
                                ResultSet rs = HSQLDBQuery.this.queryStatement.executeQuery(query);
                                while (rs.next()) {
                                    int annId = rs.getInt(1);
                                    String annotation = rs.getString(2);
                                    int tierId = rs.getInt(6);
                                    if (HSQLDBQuery.this.isSimpleQuery) {
                                        if (this.queryModes[0].equals(" Annotation")) {
                                            long endTime;
                                            long beginTime = HSQLDBQuery.this.getValue(rs, 3);
                                            if (!HSQLDBQuery.this.patternHasValidDuration(beginTime, endTime = HSQLDBQuery.this.getValue(rs, 4), HSQLDBQuery.this.queryCon)) continue;
                                            HSQLDBQuery.this.updateFrequencyStatistics(annotation, annId, fileIndex, HSQLDBQuery.this.firstNonEmptyLayerIndex, HSQLDBQuery.this.firstNonEmptyPatternIndex);
                                            ++HSQLDBQuery.this.statistics.nAnnotationsWithHit;
                                            int nHitsInAnnotation = 1;
                                            if (HSQLDBQuery.this.patternNeedsFullStatistics) {
                                                nHitsInAnnotation = HSQLDBQuery.this.countHitsInAnnotation(annotation, this.queryModes, this.pattern, this.regExpPattern, this.patternNOTMode);
                                            }
                                            for (int j = 0; j < nHitsInAnnotation; ++j) {
                                                if (HSQLDBQuery.this.statistics.nHits < 100000) {
                                                    HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getHitAnnIdsForPattern((int)HSQLDBQuery.this.firstNonEmptyPatternIndex)[HSQLDBQuery.this.statistics.nHits] = annId;
                                                    HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getHitNumberForPattern((int)HSQLDBQuery.this.firstNonEmptyPatternIndex)[HSQLDBQuery.this.statistics.nHits] = j + 1;
                                                    HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getHitFileIds()[HSQLDBQuery.this.statistics.nHits] = fileIndex;
                                                }
                                                ++HSQLDBQuery.this.statistics.nHits;
                                            }
                                        } else {
                                            String[] nGrams;
                                            if (this.queryModes[0].equals(" N-gram over annotations")) {
                                                HSQLDBQuery.this.nGramSizeLeftFromHit = HSQLDBQuery.this.getLongestNonWildcardPartPosition(this.pattern);
                                                HSQLDBQuery.this.nGramSizeRightFromHit = HSQLDBQuery.this.getNGramLength(this.pattern) - HSQLDBQuery.this.nGramSizeLeftFromHit - 1;
                                            }
                                            if ((nGrams = HSQLDBQuery.this.constructNGrams(annId, HSQLDBQuery.this.queryStatement, HSQLDBQuery.this.schemaName, this.pattern, this.queryModes)) != null) {
                                                boolean frequencyStatisticsUpdated = false;
                                                boolean firstNAnnotationsUpdate = true;
                                                int hitNumber = 1;
                                                for (int j = 0; j < nGrams.length; ++j) {
                                                    String nGram = nGrams[j];
                                                    if (!HSQLDBQuery.this.isNGramMatch(nGram, this.pattern, this.queryModes)) continue;
                                                    if (!frequencyStatisticsUpdated) {
                                                        nGram = nGram.replace("xxxSAFE_SPLITTERxxx", " ");
                                                        HSQLDBQuery.this.updateFrequencyStatistics(nGram, annId, fileIndex, HSQLDBQuery.this.firstNonEmptyLayerIndex, HSQLDBQuery.this.firstNonEmptyPatternIndex);
                                                        frequencyStatisticsUpdated = true;
                                                    }
                                                    if (this.queryModes[0].equals(" N-gram over annotations") || firstNAnnotationsUpdate) {
                                                        ++HSQLDBQuery.this.statistics.nAnnotationsWithHit;
                                                        firstNAnnotationsUpdate = false;
                                                    }
                                                    if (HSQLDBQuery.this.statistics.nHits < 100000) {
                                                        HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getHitAnnIdsForPattern((int)HSQLDBQuery.this.firstNonEmptyPatternIndex)[HSQLDBQuery.this.statistics.nHits] = annId;
                                                        HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getHitNumberForPattern((int)HSQLDBQuery.this.firstNonEmptyPatternIndex)[HSQLDBQuery.this.statistics.nHits] = hitNumber++;
                                                        HSQLDBQuery.this.searchLayers[HSQLDBQuery.this.firstNonEmptyLayerIndex].getHitFileIds()[HSQLDBQuery.this.statistics.nHits] = fileIndex;
                                                    }
                                                    ++HSQLDBQuery.this.statistics.nHits;
                                                }
                                            }
                                        }
                                    } else {
                                        HSQLDBQuery.this.currentTranscriptionTierDomain = "";
                                        HSQLDBQuery.this.clearHitData(fileIndex);
                                        HSQLDBQuery.this.globalHitAnnId[HSQLDBQuery.this.firstNonEmptyLayerIndex][HSQLDBQuery.this.firstNonEmptyPatternIndex] = annId;
                                        HSQLDBQuery.this.globalHitTierId[HSQLDBQuery.this.firstNonEmptyLayerIndex][HSQLDBQuery.this.firstNonEmptyPatternIndex] = tierId;
                                        HSQLDBQuery.this.globalHitBeginTime[HSQLDBQuery.this.firstNonEmptyLayerIndex][HSQLDBQuery.this.firstNonEmptyPatternIndex] = HSQLDBQuery.this.getValue(rs, 3);
                                        HSQLDBQuery.this.globalHitEndTime[HSQLDBQuery.this.firstNonEmptyLayerIndex][HSQLDBQuery.this.firstNonEmptyPatternIndex] = HSQLDBQuery.this.getValue(rs, 4);
                                        HSQLDBQuery.this.globalHitPosition[HSQLDBQuery.this.firstNonEmptyLayerIndex][HSQLDBQuery.this.firstNonEmptyPatternIndex] = rs.getInt(5);
                                        HSQLDBQuery.this.investigateComplexPattern(HSQLDBQuery.this.firstNonEmptyLayerIndex, HSQLDBQuery.this.firstNonEmptyPatternIndex, HSQLDBQuery.this.queryCon);
                                    }
                                    if (HSQLDBQuery.this.keepExecuting) continue;
                                    break;
                                }
                                if (!HSQLDBQuery.this.keepExecuting) break;
                            }
                            if (!HSQLDBQuery.this.keepExecuting) break;
                        }
                        if (!HSQLDBQuery.this.keepExecuting) break;
                        HSQLDBQuery.this.statistics.progress = (float)fileIndex / (float)HSQLDBQuery.this.eafFiles.size();
                    }
                    HSQLDBQuery.this.statistics.progress = 1.0f;
                }
                catch (SQLException e) {
                    _logger.error("SQLException in run: " + e, e);
                }
                catch (RuntimeException re) {
                    _logger.error("RuntimeException in run: " + re, re);
                }
                HSQLDBQuery.this.isExecuting = false;
            }
        }
    }
}

