/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.search;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;
import mpi.annex.search.SearchHit;
import mpi.annex.search.SearchQuery;
import mpi.annex.util.AnnexUtil;
import org.apache.log4j.Logger;

public class PostgresQuery
extends SearchQuery {
    private static Logger logger = Logger.getLogger("ANNEX.PostgresQuery");
    private String url;
    private String usr;
    private String pwd;
    private ArrayList domainNodeIds;
    private ArrayList domainTiers;
    private ArrayList domainTiersSize;
    private ArrayList domainTiersNodeId;

    public PostgresQuery(String url, String usr, String pwd) {
        this.url = url;
        this.usr = usr;
        this.pwd = pwd;
        this.schemaName = "search";
        this.domainTiers = new ArrayList();
        this.domainTiersSize = new ArrayList();
        this.domainTiersNodeId = new ArrayList();
    }

    public void doQuery(ArrayList nodeIds, String encodedQuery) {
        this.domainNodeIds = nodeIds;
        this.cancelQuery();
        this.statistics.reset();
        this.clearFrequencyStatistics();
        this.createLayers(encodedQuery);
        this.keepExecuting = true;
        this.isExecuting = true;
        new Thread(new QueryExecutor()).start();
    }

    public void cancelQuery() {
        if (this.isExecuting) {
            this.keepExecuting = false;
            try {
                while (this.isExecuting) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.isExecuting = false;
    }

    private String constructMainQueryPart() {
        String queryPart = "";
        return queryPart;
    }

    private String constructDomainQueryPart() {
        String queryPart = "";
        for (int layerIndex = 0; layerIndex < this.nLayers; ++layerIndex) {
            for (int patternIndex = 0; patternIndex < this.nPatternsPerLayer; ++patternIndex) {
                if (this.searchLayers[layerIndex].getPattern(patternIndex).length() <= 0) continue;
            }
        }
        return queryPart;
    }

    protected String createQueryPatternPart(String pattern, String[] queryModes, Pattern regexpPattern, boolean patternNOTMode) {
        int patternLength = pattern.length();
        String queryPart = "";
        this.patternNeedsFullStatistics = false;
        if (queryModes[0].equals(" Annotation")) {
            if (queryModes[1].equals(" case sensitive")) {
                if (queryModes[2].equals(" exact match")) {
                    queryPart = patternNOTMode ? "annotation != '" + pattern + "'" : "annotation = '" + pattern + "'";
                } else if (queryModes[2].equals(" substring match")) {
                    if (patternNOTMode) {
                        queryPart = "annotation NOT LIKE '%" + this.escape(pattern) + "%' ESCAPE '\u00b1'";
                    } else {
                        queryPart = "annotation LIKE '%" + this.escape(pattern) + "%' ESCAPE '\u00b1'";
                        this.patternNeedsFullStatistics = true;
                    }
                } else if (queryModes[2].equals(" regular expression")) {
                    if (patternNOTMode) {
                        queryPart = "annotation !~ '" + this.escapeRegExp(pattern) + "'";
                    } else {
                        queryPart = "annotation ~ '" + this.escapeRegExp(pattern) + "'";
                        this.patternNeedsFullStatistics = true;
                    }
                }
            } else if (queryModes[2].equals(" exact match")) {
                queryPart = patternNOTMode ? "annotation NOT ILIKE '" + pattern + "'" : "annotation ILIKE '" + pattern + "'";
            } else if (queryModes[2].equals(" substring match")) {
                if (patternNOTMode) {
                    queryPart = "annotation NOT ILIKE '%" + this.escape(pattern) + "%' ESCAPE '\u00b1'";
                } else {
                    queryPart = "annotation ILIKE '%" + this.escape(pattern) + "%' ESCAPE '\u00b1'";
                    this.patternNeedsFullStatistics = true;
                }
            } else if (queryModes[2].equals(" regular expression")) {
                if (patternNOTMode) {
                    queryPart = "annotation !~* '" + this.escapeRegExp(pattern) + "'";
                } else {
                    queryPart = "annotation ~* '" + this.escapeRegExp(pattern) + "'";
                    this.patternNeedsFullStatistics = true;
                }
            }
        } else if (queryModes[0].equals(" N-gram over annotations") || queryModes[0].equals(" N-gram within annotation")) {
            String nGramPart = this.getLongestNonWildcardPart(pattern);
            if (queryModes[2].equals(" regular expression")) {
                if (queryModes[0].equals(" N-gram within annotation")) {
                    if (nGramPart.startsWith("^")) {
                        nGramPart = nGramPart.substring(1);
                    }
                    if (nGramPart.endsWith("$")) {
                        nGramPart = nGramPart.substring(0, nGramPart.length() - 1);
                    }
                }
                if (queryModes[1].equals(" case sensitive")) {
                    if (patternNOTMode) {
                        queryPart = "annotation !~ '" + this.escapeRegExp(nGramPart) + "'";
                    } else {
                        queryPart = "annotation ~ '" + this.escapeRegExp(nGramPart) + "'";
                        this.patternNeedsFullStatistics = true;
                    }
                } else if (patternNOTMode) {
                    queryPart = "annotation !~* '" + this.escapeRegExp(nGramPart) + "'";
                } else {
                    queryPart = "annotation ~* '" + this.escapeRegExp(nGramPart) + "'";
                    this.patternNeedsFullStatistics = true;
                }
            } else if (queryModes[1].equals(" case sensitive")) {
                if (patternNOTMode) {
                    queryPart = "annotation NOT LIKE '%" + this.escape(nGramPart) + "%' ESCAPE '\u00b1'";
                } else {
                    queryPart = "annotation LIKE '%" + this.escape(nGramPart) + "%' ESCAPE '\u00b1'";
                    this.patternNeedsFullStatistics = true;
                }
            } else if (patternNOTMode) {
                queryPart = "annotation NOT ILIKE '%" + this.escape(nGramPart) + "%' ESCAPE '\u00b1'";
            } else {
                queryPart = "annotation ILIKE '%" + this.escape(nGramPart) + "%' ESCAPE '\u00b1'";
                this.patternNeedsFullStatistics = true;
            }
        }
        return queryPart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructTierDomain(ArrayList nodeIds, ArrayList tierConstraints) {
        Connection con = null;
        try {
            con = DriverManager.getConnection(this.url, this.usr, this.pwd);
            Statement st = con.createStatement(1004, 1007);
            this.domainTiers.clear();
            this.domainTiersSize.clear();
            this.domainTiersNodeId.clear();
            HashSet domainNodeIds = new HashSet(nodeIds);
            String tierConstraintPart = "";
            if (!tierConstraints.contains(" All Tiers ")) {
                for (int i = 0; i < tierConstraints.size(); ++i) {
                    String constraint = (String)tierConstraints.get(i);
                    if (constraint.startsWith(" Tier Name: ")) {
                        tierConstraintPart = tierConstraintPart + " tier_name = '" + constraint.substring(" Tier Name: ".length()) + "' OR";
                        continue;
                    }
                    if (constraint.startsWith(" Tier Type: ")) {
                        tierConstraintPart = tierConstraintPart + " tier_type = '" + constraint.substring(" Tier Type: ".length()) + "' OR";
                        continue;
                    }
                    if (!constraint.startsWith(" Participant: ")) continue;
                    tierConstraintPart = tierConstraintPart + " participant = '" + constraint.substring(" Participant: ".length()) + "' OR";
                }
                if (tierConstraintPart.length() > 0) {
                    tierConstraintPart = tierConstraintPart.substring(0, tierConstraintPart.length() - 2);
                    tierConstraintPart = " WHERE ( " + tierConstraintPart + ")";
                }
            }
            String tierQuery = "SELECT node_id, tier_id, n_annotations FROM search.tiers " + tierConstraintPart + " ORDER BY node_id";
            ResultSet rs = st.executeQuery(tierQuery);
            while (rs.next()) {
                String nodeId = rs.getString(1);
                if (!domainNodeIds.contains(nodeId)) continue;
                this.domainTiers.add(new Integer(rs.getInt(2)));
                this.domainTiersSize.add(new Integer(rs.getInt(3)));
                this.domainTiersNodeId.add(nodeId);
            }
            logger.debug("#tiers in domain: " + this.domainTiers.size());
            rs.close();
        }
        catch (SQLException e) {
            logger.debug("setDomain", e);
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException ex) {
                logger.debug("setDomain, close connection", ex);
            }
        }
    }

    public ArrayList getViewerParametersFor(int annId, int fileId) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        Connection con = null;
        try {
            con = DriverManager.getConnection(this.url, this.usr, this.pwd);
            Statement statement = con.createStatement();
            ResultSet rs = statement.executeQuery("SELECT begin_time, end_time, ann_tier_id FROM " + this.schemaName + ".annotations WHERE ann_id = " + annId);
            rs.next();
            Long beginTime = new Long(this.getValue(rs, 1));
            Long endTime = new Long(this.getValue(rs, 2));
            int tierId = rs.getInt(3);
            rs = statement.executeQuery("SELECT tier_name, node_id FROM " + this.schemaName + ".tiers WHERE tier_id = " + tierId);
            rs.next();
            String tierName = rs.getString(1);
            String nodeId = rs.getString(2);
            parameters.add(nodeId);
            parameters.add(tierName);
            parameters.add(beginTime);
            parameters.add(endTime);
        }
        catch (SQLException e) {
            try {
                con.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
        }
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getHits(int fromIndex, int toIndex, int contextSize) {
        ArrayList<SearchHit> hitList = new ArrayList<SearchHit>();
        Connection con = null;
        try {
            con = DriverManager.getConnection(this.url, this.usr, this.pwd);
            Statement st = con.createStatement(1004, 1007);
            ArrayList<Long> beginTimes = new ArrayList<Long>();
            int[][] hitAnnIds = new int[this.nLayers][this.nPatternsPerLayer];
            int[] savedHitAnnId = this.searchLayers[this.firstNonEmptyLayerIndex].getHitAnnIdsForPattern(this.firstNonEmptyPatternIndex);
            int[] savedHitNumber = this.searchLayers[this.firstNonEmptyLayerIndex].getHitNumberForPattern(this.firstNonEmptyPatternIndex);
            int[] savedHitFileId = this.searchLayers[this.firstNonEmptyLayerIndex].getHitFileIds();
            for (int i = fromIndex; i < toIndex && i < this.statistics.nHits && i < 100000; ++i) {
                SearchHit hit = new SearchHit();
                int annId = savedHitAnnId[i];
                ResultSet rs = st.executeQuery("SELECT ann_position, annotation, begin_time, end_time, ann_tier_id, aligned FROM " + this.schemaName + ".annotations WHERE ann_id = " + annId);
                rs.next();
                hit.positionInTier = rs.getInt(1);
                if (this.isSimpleQuery) {
                    hit.annotation = rs.getString(2);
                    hit.beginTime = this.getValue(rs, 3);
                    hit.endTime = this.getValue(rs, 4);
                } else {
                    for (int layer = 0; layer < this.nLayers; ++layer) {
                        for (int pattern = 0; pattern < this.nPatternsPerLayer; ++pattern) {
                            int[] annIds = this.searchLayers[layer].getHitAnnIdsForPattern(pattern);
                            hitAnnIds[layer][pattern] = annIds != null ? annIds[i] : -1;
                        }
                    }
                    Statement st2 = con.createStatement(1004, 1007);
                    SearchQuery.ComplexHitData hitData = this.constructComplexHitResultString(null, st2, hitAnnIds, true);
                    hit.annotation = hitData.hitString;
                    hit.beginTime = hitData.beginTime;
                    hit.endTime = hitData.endTime;
                }
                int ann_tier_id = rs.getInt(5);
                hit.aligned = rs.getBoolean(6);
                rs = st.executeQuery("SELECT node_id, tier_name, tier_type, participant, n_annotations FROM " + this.schemaName + ".tiers WHERE tier_id = " + ann_tier_id);
                rs.next();
                hit.transcriptionNodeId = rs.getString(1);
                hit.transcriptionName = AnnexUtil.getNamePathFor(hit.transcriptionNodeId);
                hit.tierName = rs.getString(2);
                hit.tierType = this.isSimpleQuery ? rs.getString(3) : "xxxCOMPLEX_QUERY_INDICATORxxx";
                hit.participant = rs.getString(4);
                int nAnnotationsInTier = rs.getInt(5);
                hit.hitNumberInAnnotation = savedHitNumber[i];
                String pattern = this.searchLayers[this.firstNonEmptyLayerIndex].getPattern(this.firstNonEmptyPatternIndex);
                boolean patternNOTMode = this.searchLayers[this.firstNonEmptyLayerIndex].getPatternNOTMode(this.firstNonEmptyPatternIndex);
                Pattern regExpPattern = this.searchLayers[this.firstNonEmptyLayerIndex].getRegExpPattern(this.firstNonEmptyPatternIndex);
                String[] queryModes = this.searchLayers[this.firstNonEmptyLayerIndex].getMode(this.firstNonEmptyPatternIndex);
                hit.hitPositionInAnnotation = this.getHitPosition(hit.annotation, hit.hitNumberInAnnotation, queryModes, pattern, regExpPattern, patternNOTMode);
                hit.hitLength = this.getHitLength(hit.annotation, hit.hitNumberInAnnotation, queryModes, pattern, regExpPattern, patternNOTMode);
                if (queryModes[0].equals(" N-gram over annotations")) {
                    int leftContextSize = contextSize + this.nGramSizeLeftFromHit;
                    rs = st.executeQuery("SELECT annotation, ann_position, begin_time FROM " + this.schemaName + ".annotations " + "WHERE ann_tier_id = " + ann_tier_id + "AND ann_position < " + hit.positionInTier + "AND ann_position >= " + (hit.positionInTier - leftContextSize) + "ORDER BY ann_position DESC");
                    beginTimes.clear();
                    while (rs.next()) {
                        hit.leftContext.add(rs.getString(1));
                        beginTimes.add(new Long(this.getValue(rs, 3)));
                    }
                    for (int j = 0; j < this.nGramSizeLeftFromHit; ++j) {
                        if (hit.leftContext.size() <= 0) continue;
                        String part = (String)hit.leftContext.get(0);
                        hit.annotation = part + " " + hit.annotation;
                        hit.beginTime = (Long)beginTimes.get(0);
                        hit.leftContext.remove(0);
                        beginTimes.remove(0);
                    }
                    int rightContextSize = contextSize + this.nGramSizeRightFromHit;
                    rs = st.executeQuery("SELECT annotation, ann_position, end_time FROM " + this.schemaName + ".annotations " + "WHERE ann_tier_id = " + ann_tier_id + "AND ann_position > " + hit.positionInTier + "AND ann_position <= " + (hit.positionInTier + rightContextSize) + "ORDER BY ann_position");
                    int n = 0;
                    while (rs.next()) {
                        if (n < this.nGramSizeRightFromHit) {
                            hit.annotation = hit.annotation + " " + rs.getString(1);
                            hit.endTime = this.getValue(rs, 3);
                        } else {
                            hit.rightContext.add(rs.getString(1));
                        }
                        ++n;
                    }
                    hit.hitPositionInAnnotation = 0;
                    hit.hitLength = hit.annotation.length();
                    hit.positionInTier -= leftContextSize;
                    ++hit.positionInTier;
                } else {
                    rs = st.executeQuery("SELECT annotation, ann_position FROM " + this.schemaName + ".annotations " + "WHERE ann_tier_id = " + ann_tier_id + "AND ann_position < " + hit.positionInTier + "AND ann_position >= " + (hit.positionInTier - contextSize) + "ORDER BY ann_position DESC");
                    while (rs.next()) {
                        hit.leftContext.add(rs.getString(1));
                    }
                    rs = st.executeQuery("SELECT annotation, ann_position FROM " + this.schemaName + ".annotations " + "WHERE ann_tier_id = " + ann_tier_id + "AND ann_position > " + hit.positionInTier + "AND ann_position <= " + (hit.positionInTier + contextSize) + "ORDER BY ann_position");
                    while (rs.next()) {
                        hit.rightContext.add(rs.getString(1));
                    }
                    ++hit.positionInTier;
                }
                hitList.add(hit);
            }
        }
        catch (SQLException e) {
            logger.debug(e.toString());
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException ex) {}
        }
        return hitList;
    }

    private String escape(String string) {
        String s = string.replaceAll("\u00b1", "\u00b1\u00b1");
        s = s.replaceAll("%", "\u00b1%");
        s = s.replaceAll("'", "\\\\'");
        s = s.replaceAll("\"", "\u00b1\"");
        return s.replaceAll("_", "\u00b1_");
    }

    private String escapeRegExp(String regexp) {
        return regexp.replaceAll("\\\\", "\\\\\\\\");
    }

    protected String convertRegexpPatternsIfNeeded(String queryString) {
        return this.convertRegexpPatternsForPostgres(queryString);
    }

    private String convertRegexpPatternsForPostgres(String queryString) {
        for (int i = 2; i < queryString.length(); ++i) {
            if (queryString.charAt(i) == 'b' && queryString.charAt(i - 1) == '\\' && queryString.charAt(i - 2) == '\\') {
                queryString = queryString.substring(0, i) + "y" + queryString.substring(i + 1);
            }
            if (queryString.charAt(i) != 'B' || queryString.charAt(i - 1) != '\\' || queryString.charAt(i - 2) != '\\') continue;
            queryString = queryString.substring(0, i) + "Y" + queryString.substring(i + 1);
        }
        return queryString;
    }

    protected void clearPreparedStatements() {
        try {
            for (int i = 0; i < this.nLayers; ++i) {
                for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                    this.preparedStatements[i][j].close();
                    this.preparedStatements[i][j] = null;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (Exception e) {
            System.out.println("You need the PostgreSQL JDBC JAR in ClassPath");
            System.exit(1);
        }
    }

    private class QueryExecutor
    implements Runnable {
        private Connection con;
        private String pattern;
        private boolean patternNOTMode;
        private Pattern regExpPattern;
        private String[] queryModes;
        private Statement statement;
        private PreparedStatement getHitsInTier;
        private ResultSet rs;
        private int fileIndex;
        private String previousNodeId;

        public QueryExecutor() {
            try {
                this.con = DriverManager.getConnection(PostgresQuery.this.url, PostgresQuery.this.usr, PostgresQuery.this.pwd);
                this.statement = this.con.createStatement();
                this.previousNodeId = "";
                if (PostgresQuery.this.firstNonEmptyPatternIndex >= 0) {
                    this.pattern = PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getPattern(PostgresQuery.this.firstNonEmptyPatternIndex);
                    this.patternNOTMode = PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getPatternNOTMode(PostgresQuery.this.firstNonEmptyPatternIndex);
                    this.regExpPattern = PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getRegExpPattern(PostgresQuery.this.firstNonEmptyPatternIndex);
                    this.queryModes = PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getMode(PostgresQuery.this.firstNonEmptyPatternIndex);
                }
                PostgresQuery.this.constructTierDomain(PostgresQuery.this.domainNodeIds, PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getTierConstraints());
                String queryString = "SELECT ann_id, annotation, begin_time, end_time, ann_position FROM " + PostgresQuery.this.schemaName + ".annotations WHERE ann_tier_id = ? AND ";
                queryString = queryString + PostgresQuery.this.createQueryPatternPart(this.pattern, this.queryModes, this.regExpPattern, this.patternNOTMode);
                queryString = queryString + PostgresQuery.this.createGlobalTimeConstraintPart();
                queryString = PostgresQuery.this.convertRegexpPatternsForPostgres(queryString);
                logger.debug("query: " + queryString);
                this.getHitsInTier = this.con.prepareStatement(queryString, 1004, 1007);
            }
            catch (SQLException e) {
                logger.debug("constructor query executor", e);
                try {
                    this.con.close();
                }
                catch (SQLException ex) {
                    logger.debug("closing connection", ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.pattern == null) {
                PostgresQuery.this.statistics.progress = 1.0f;
                PostgresQuery.this.isExecuting = false;
            } else {
                try {
                    for (int i = 0; i < PostgresQuery.this.domainTiers.size(); ++i) {
                        int tierId = (Integer)PostgresQuery.this.domainTiers.get(i);
                        PostgresQuery.this.currentNodeId = (String)PostgresQuery.this.domainTiersNodeId.get(i);
                        if (!PostgresQuery.this.isSimpleQuery && !PostgresQuery.this.currentNodeId.equals(this.previousNodeId)) {
                            this.previousNodeId = PostgresQuery.this.currentNodeId;
                            PostgresQuery.this.setTierDomainForLayers(true, this.statement);
                        }
                        this.getHitsInTier.setInt(1, tierId);
                        this.rs = this.getHitsInTier.executeQuery();
                        while (this.rs.next()) {
                            int annId = this.rs.getInt(1);
                            String annotation = this.rs.getString(2);
                            if (PostgresQuery.this.isSimpleQuery) {
                                if (this.queryModes[0].equals(" Annotation")) {
                                    long endTime;
                                    long beginTime = PostgresQuery.this.getValue(this.rs, 3);
                                    if (!PostgresQuery.this.patternHasValidDuration(beginTime, endTime = PostgresQuery.this.getValue(this.rs, 4), this.con)) continue;
                                    PostgresQuery.this.updateFrequencyStatistics(annotation, annId, this.fileIndex, PostgresQuery.this.firstNonEmptyLayerIndex, PostgresQuery.this.firstNonEmptyPatternIndex);
                                    ++PostgresQuery.this.statistics.nAnnotationsWithHit;
                                    int nHitsInAnnotation = 1;
                                    if (PostgresQuery.this.patternNeedsFullStatistics) {
                                        nHitsInAnnotation = PostgresQuery.this.countHitsInAnnotation(annotation, this.queryModes, this.pattern, this.regExpPattern, this.patternNOTMode);
                                    }
                                    for (int j = 0; j < nHitsInAnnotation; ++j) {
                                        if (PostgresQuery.this.statistics.nHits < 100000) {
                                            PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getHitAnnIdsForPattern((int)PostgresQuery.this.firstNonEmptyPatternIndex)[PostgresQuery.this.statistics.nHits] = annId;
                                            PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getHitNumberForPattern((int)PostgresQuery.this.firstNonEmptyPatternIndex)[PostgresQuery.this.statistics.nHits] = j + 1;
                                            PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getHitFileIds()[PostgresQuery.this.statistics.nHits] = this.fileIndex;
                                        }
                                        ++PostgresQuery.this.statistics.nHits;
                                    }
                                } else {
                                    String[] nGrams;
                                    if (this.queryModes[0].equals(" N-gram over annotations")) {
                                        PostgresQuery.this.nGramSizeLeftFromHit = PostgresQuery.this.getLongestNonWildcardPartPosition(this.pattern);
                                        PostgresQuery.this.nGramSizeRightFromHit = PostgresQuery.this.getNGramLength(this.pattern) - PostgresQuery.this.nGramSizeLeftFromHit - 1;
                                    }
                                    if ((nGrams = PostgresQuery.this.constructNGrams(annId, this.statement, PostgresQuery.this.schemaName, this.pattern, this.queryModes)) != null) {
                                        boolean frequencyStatisticsUpdated = false;
                                        boolean firstNAnnotationsUpdate = true;
                                        int hitNumber = 1;
                                        for (int j = 0; j < nGrams.length; ++j) {
                                            String nGram = nGrams[j];
                                            if (!PostgresQuery.this.isNGramMatch(nGram, this.pattern, this.queryModes)) continue;
                                            if (!frequencyStatisticsUpdated) {
                                                nGram = nGram.replace("xxxSAFE_SPLITTERxxx", " ");
                                                PostgresQuery.this.updateFrequencyStatistics(nGram, annId, this.fileIndex, PostgresQuery.this.firstNonEmptyLayerIndex, PostgresQuery.this.firstNonEmptyPatternIndex);
                                                frequencyStatisticsUpdated = true;
                                            }
                                            if (this.queryModes[0].equals(" N-gram over annotations") || firstNAnnotationsUpdate) {
                                                ++PostgresQuery.this.statistics.nAnnotationsWithHit;
                                                firstNAnnotationsUpdate = false;
                                            }
                                            if (PostgresQuery.this.statistics.nHits < 100000) {
                                                PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getHitAnnIdsForPattern((int)PostgresQuery.this.firstNonEmptyPatternIndex)[PostgresQuery.this.statistics.nHits] = annId;
                                                PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getHitNumberForPattern((int)PostgresQuery.this.firstNonEmptyPatternIndex)[PostgresQuery.this.statistics.nHits] = hitNumber++;
                                                PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getHitFileIds()[PostgresQuery.this.statistics.nHits] = this.fileIndex;
                                            }
                                            ++PostgresQuery.this.statistics.nHits;
                                        }
                                    }
                                }
                            } else {
                                PostgresQuery.this.clearHitData(this.fileIndex);
                                PostgresQuery.this.globalHitAnnId[PostgresQuery.this.firstNonEmptyLayerIndex][PostgresQuery.this.firstNonEmptyPatternIndex] = annId;
                                PostgresQuery.this.globalHitTierId[PostgresQuery.this.firstNonEmptyLayerIndex][PostgresQuery.this.firstNonEmptyPatternIndex] = tierId;
                                PostgresQuery.this.globalHitBeginTime[PostgresQuery.this.firstNonEmptyLayerIndex][PostgresQuery.this.firstNonEmptyPatternIndex] = PostgresQuery.this.getValue(this.rs, 3);
                                PostgresQuery.this.globalHitEndTime[PostgresQuery.this.firstNonEmptyLayerIndex][PostgresQuery.this.firstNonEmptyPatternIndex] = PostgresQuery.this.getValue(this.rs, 4);
                                PostgresQuery.this.globalHitPosition[PostgresQuery.this.firstNonEmptyLayerIndex][PostgresQuery.this.firstNonEmptyPatternIndex] = this.rs.getInt(5);
                                PostgresQuery.this.investigateComplexPattern(PostgresQuery.this.firstNonEmptyLayerIndex, PostgresQuery.this.firstNonEmptyPatternIndex, this.con);
                            }
                            if (PostgresQuery.this.keepExecuting) continue;
                            break;
                        }
                        if (!PostgresQuery.this.keepExecuting) {
                        } else {
                            PostgresQuery.this.statistics.nAnnotationsSearched += ((Integer)PostgresQuery.this.domainTiersSize.get(i)).intValue();
                            PostgresQuery.this.statistics.progress = i == PostgresQuery.this.domainTiers.size() - 1 ? 1.0f : (float)i / (float)PostgresQuery.this.domainTiers.size();
                            if (PostgresQuery.this.keepExecuting) continue;
                        }
                        break;
                    }
                }
                catch (SQLException e) {
                    logger.debug("exception during query execution", e);
                }
                finally {
                    try {
                        this.con.close();
                        this.getHitsInTier.close();
                    }
                    catch (SQLException ex) {
                        logger.debug("exception during finally part of query execution", ex);
                    }
                }
                PostgresQuery.this.isExecuting = false;
            }
        }
    }
}

