/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.search;

import java.io.File;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import mpi.annex.data.AnnexAnnotation;
import mpi.annex.data.AnnexTier;
import mpi.annex.data.AnnexTranscription;
import mpi.annex.search.SearchClient;
import mpi.annex.util.AnnexUtil;
import mpi.corpusstructure.CorpusStructureDB;
import org.apache.log4j.Logger;

public class SearchCorpusDB {
    private static Logger _log = Logger.getLogger("SearchCorpusDB-ingester");
    private static final boolean _storeLongTimes = false;
    private static final int BATCHSIZE = 1000;
    private int TIER_ID;
    private int ANN_ID;
    private static int rollbacks;
    private static int missedRollbacks;
    private Connection con;
    private ArrayList permissionDenied;
    private ArrayList notExisting;
    private ArrayList emptyTranscriptions;
    private ArrayList notParsable;
    private ArrayList dbProblem;
    private boolean simulate = false;
    private final boolean showProgress = true;

    public SearchCorpusDB(String url, String usr, String pwd) throws SQLException {
        this.simulate = usr.equals("simulate");
        if (!this.simulate) {
            this.con = DriverManager.getConnection(url, usr, pwd);
        }
    }

    public void close() {
        if (!this.simulate) {
            try {
                this.con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void initTables(Statement st) throws SQLException {
        try {
            st.executeUpdate("CREATE SCHEMA search");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            st.executeUpdate("DROP TABLE search.new_annotations CASCADE");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            st.executeUpdate("DROP TABLE search.new_tiers CASCADE");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            st.executeUpdate("DROP TABLE search.new_prog_data CASCADE");
        }
        catch (SQLException e) {
            // empty catch block
        }
        st.executeUpdate("CREATE TABLE search.new_tiers (tier_id INTEGER NOT NULL, tier_name TEXT NOT NULL, tier_type TEXT NOT NULL, default_locale TEXT, participant TEXT NOT NULL, n_annotations INTEGER NOT NULL, ref_tier_id INTEGER NOT NULL, transcription_type INTEGER NOT NULL, node_id TEXT NOT NULL)");
        String timeType = "INTEGER";
        st.executeUpdate("CREATE TABLE search.new_annotations (ann_id INTEGER NOT NULL, annotation TEXT NOT NULL, ann_position INTEGER NOT NULL, begin_time " + timeType + " NOT NULL, " + "end_time " + timeType + " NOT NULL, " + "ref_ann_id INTEGER NOT NULL, " + "aligned BOOLEAN NOT NULL, " + "ann_tier_id INTEGER NOT NULL)");
        st.executeUpdate("CREATE TABLE search.new_prog_data (label TEXT, tier_id INTEGER, ann_id INTEGER)");
        this.TIER_ID = 2;
        this.ANN_ID = 3;
        st.executeUpdate("INSERT INTO search.new_prog_data VALUES ('indices', 0, 0)");
    }

    private void createIndexes(Statement st) throws SQLException {
        _log.debug("creating annotation id index....");
        long stm = this.start_stopwatch();
        st.executeUpdate("CREATE INDEX new_ann_id_index ON search.new_annotations( ann_id )");
        this.stop_stopwatch("anno id index", stm);
        _log.debug("creating annotation tier id index....");
        stm = this.start_stopwatch();
        st.executeUpdate("CREATE INDEX new_ann_tier_id_index ON search.new_annotations( ann_tier_id )");
        this.stop_stopwatch("anno tier id index", stm);
        _log.debug("creating node id index....");
        stm = this.start_stopwatch();
        st.executeUpdate("CREATE INDEX new_node_id_index ON search.new_tiers( node_id )");
        this.stop_stopwatch("node id index", stm);
        _log.debug("creating tier id index....");
        stm = this.start_stopwatch();
        st.executeUpdate("CREATE INDEX new_tier_id_index ON search.new_tiers( tier_id )");
        this.stop_stopwatch("tier id index", stm);
        _log.debug("creating tier name index....");
        stm = this.start_stopwatch();
        st.executeUpdate("CREATE INDEX new_tier_name_index ON search.new_tiers( tier_name )");
        this.stop_stopwatch("tier name index", stm);
        _log.debug("creating tier type index....");
        stm = this.start_stopwatch();
        st.executeUpdate("CREATE INDEX new_tier_type_index ON search.new_tiers( tier_type )");
        this.stop_stopwatch("tier type index", stm);
        _log.debug("creating default locale index....");
        stm = this.start_stopwatch();
        st.executeUpdate("CREATE INDEX new_default_locale_index ON search.new_tiers( default_locale )");
        this.stop_stopwatch("default locale index", stm);
        _log.debug("creating participant index....");
        stm = this.start_stopwatch();
        st.executeUpdate("CREATE INDEX new_participant_index ON search.new_tiers( participant )");
        this.stop_stopwatch("participant index", stm);
        _log.debug("creating transcription type index....");
        stm = this.start_stopwatch();
        st.executeUpdate("CREATE INDEX new_transcription_type_index ON search.new_tiers( transcription_type )");
        this.stop_stopwatch("transcription type index", stm);
    }

    private void dropOldData(Statement st) throws SQLException {
        _log.info("Dropping old data...");
        long stm = this.start_stopwatch();
        try {
            st.executeUpdate("DROP TABLE search.annotations CASCADE");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            st.executeUpdate("DROP INDEX search.ann_id_index CASCADE");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            st.executeUpdate("DROP INDEX search.ann_tier_id_index CASCADE");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            st.executeUpdate("DROP TABLE search.tiers CASCADE");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            st.executeUpdate("DROP INDEX search.node_id_index CASCADE");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            st.executeUpdate("DROP INDEX search.tier_id_index CASCADE");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            st.executeUpdate("DROP INDEX search.tier_name_index CASCADE");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            st.executeUpdate("DROP INDEX search.tier_type_index CASCADE");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            st.executeUpdate("DROP INDEX search.default_locale_index CASCADE");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            st.executeUpdate("DROP INDEX search.participant_index CASCADE");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            st.executeUpdate("DROP INDEX search.transcription_type_index CASCADE");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            st.executeUpdate("DROP TABLE search.prog_data CASCADE");
        }
        catch (SQLException e) {
            // empty catch block
        }
    }

    private void renameTables(Statement st) throws SQLException {
        st.executeUpdate("ALTER TABLE search.new_annotations RENAME TO annotations");
        st.executeUpdate("ALTER INDEX search.new_ann_id_index RENAME TO ann_id_index");
        st.executeUpdate("ALTER INDEX search.new_ann_tier_id_index RENAME TO ann_tier_id_index");
        st.executeUpdate("ALTER TABLE search.new_tiers RENAME TO tiers");
        st.executeUpdate("ALTER INDEX search.new_node_id_index RENAME TO node_id_index");
        st.executeUpdate("ALTER INDEX search.new_tier_id_index RENAME TO tier_id_index");
        st.executeUpdate("ALTER INDEX search.new_tier_name_index RENAME TO tier_name_index");
        st.executeUpdate("ALTER INDEX search.new_tier_type_index RENAME TO tier_type_index");
        st.executeUpdate("ALTER INDEX search.new_default_locale_index RENAME TO default_locale_index");
        st.executeUpdate("ALTER INDEX search.new_participant_index RENAME TO participant_index");
        st.executeUpdate("ALTER INDEX search.new_transcription_type_index RENAME TO transcription_type_index");
        st.executeUpdate("ALTER TABLE search.new_prog_data RENAME TO prog_data");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillDatabase() {
        int i;
        long totalDuration = this.start_stopwatch();
        Statement st = null;
        if (!this.simulate) {
            try {
                st = this.con.createStatement();
                this.initTables(st);
            }
            catch (SQLException e) {
                _log.error("Error creating database tables, giving up: " + e, e);
                return;
            }
            finally {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
        }
        _log.info("Database tables created" + (this.simulate ? " (simulation)" : ""));
        this.permissionDenied = new ArrayList();
        this.notExisting = new ArrayList();
        this.notParsable = new ArrayList();
        this.emptyTranscriptions = new ArrayList();
        this.dbProblem = new ArrayList();
        rollbacks = 0;
        missedRollbacks = 0;
        long stm = -1L;
        String[] mimetypes = SearchClient.getSearchableFormats();
        Stats[] stats = new Stats[mimetypes.length];
        for (i = 0; i < mimetypes.length; ++i) {
            stm = this.start_stopwatch();
            stats[i] = this.process(mimetypes[i]);
            this.stop_stopwatch(mimetypes[i] + " processing", stm);
        }
        _log.info("Ready parsing...");
        for (i = 0; i < mimetypes.length; ++i) {
            this.printStats(stats[i], mimetypes[i]);
        }
        _log.info("Overview of problematic files: " + this.notExisting.size() + " missing, " + this.permissionDenied.size() + " not readable, " + this.emptyTranscriptions.size() + " without transcriptions, " + this.notParsable.size() + " not parseable, " + this.dbProblem.size() + " triggered DB exceptions");
        if (this.notExisting.size() > 0) {
            _log.error("Not exisiting: " + this.notExisting.size());
        }
        for (i = 0; i < this.notExisting.size(); ++i) {
            _log.warn(this.notExisting.get(i));
        }
        if (this.permissionDenied.size() > 0) {
            _log.error("Permission denied: " + this.permissionDenied.size());
        }
        for (i = 0; i < this.permissionDenied.size(); ++i) {
            _log.warn(this.permissionDenied.get(i));
        }
        if (this.emptyTranscriptions.size() > 0) {
            _log.error("Empty Transcriptions: " + this.emptyTranscriptions.size());
        }
        for (i = 0; i < this.emptyTranscriptions.size(); ++i) {
            _log.warn(this.emptyTranscriptions.get(i));
        }
        if (this.notParsable.size() > 0) {
            _log.error("Not parsable: " + this.notParsable.size());
        }
        for (i = 0; i < this.notParsable.size(); ++i) {
            _log.warn(this.notParsable.get(i));
        }
        if (this.dbProblem.size() > 0) {
            _log.error("Database problems: " + this.dbProblem.size());
        }
        for (i = 0; i < this.dbProblem.size(); ++i) {
            _log.warn(this.dbProblem.get(i));
        }
        if (rollbacks > 0) {
            _log.error("Needed " + rollbacks + " rollbacks");
        }
        if (missedRollbacks > 0) {
            _log.error("Missed " + missedRollbacks + " rollbacks");
        }
        if (missedRollbacks > 0) {
            _log.error("DUE TO MISSED ROLLBACKS NO NEW DATABASE!!!!");
            _log.error("The current search database is still usable");
            _log.error("In the log info above the problematic rollbacks are marked with:");
            this.mentionRollbackProblem();
            _log.error("The current search database is still usable");
            this.stop_stopwatch("aborted at total ", totalDuration);
            return;
        }
        if (!this.simulate) {
            try {
                st = this.con.createStatement();
                this.createIndexes(st);
                this.dropOldData(st);
                this.renameTables(st);
            }
            catch (SQLException e) {
                _log.error("Error swapping database content: " + e, e);
            }
            finally {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
        }
        _log.info("Ready!!");
        this.stop_stopwatch("total", totalDuration);
        if (!this.simulate) {
            try {
                this.con.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
    }

    private Stats process(String annotationFormat) {
        CorpusStructureDB csdb = AnnexUtil.getCorpusStructureDB();
        String[] format = new String[]{annotationFormat};
        String[] desc = csdb.getDescendants(csdb.getRootNodeId(), 8, format, "ignore", true);
        _log.info(annotationFormat + " processing " + desc.length + " '" + annotationFormat + "' files:");
        int feedBackStep = desc.length / 100;
        if (feedBackStep < 1) {
            feedBackStep = 1;
        }
        AnnexTranscription transcription = null;
        Stats stats = new Stats();
        System.err.print(annotationFormat + ": ");
        for (int i = 0; i < desc.length; ++i) {
            if (i % feedBackStep == 0) {
                System.err.print(100 * i / desc.length + " ");
            }
            ++stats.nFiles;
            String filePath = AnnexUtil.getFilePathFor(desc[i]);
            File file = new File(filePath);
            if (!file.exists()) {
                this.notExisting.add(annotationFormat + "  ne  " + filePath);
                continue;
            }
            ++stats.nExist;
            if (!file.canRead()) {
                this.permissionDenied.add(annotationFormat + "  pd  " + filePath);
                ++stats.nPermissionDenied;
                continue;
            }
            if (file.length() > 10000000L) {
                _log.warn("Too big file, skipped: " + file.length() + " bytes in: " + file.getAbsolutePath());
                this.notParsable.add(annotationFormat + "  np  " + filePath);
                ++stats.nNotParsable;
                continue;
            }
            transcription = null;
            int type = -1;
            try {
                type = AnnexUtil.getTypeFor(desc[i]);
                transcription = new AnnexTranscription(desc[i], type, file);
            }
            catch (RuntimeException e) {
                _log.error("process: Exception in AnnexTranscription for: " + file + " " + type + " " + desc[i] + ": " + e, e);
                this.notParsable.add(annotationFormat + "  np  " + filePath);
                ++stats.nNotParsable;
                continue;
            }
            if (transcription == null || !transcription.isValid()) {
                this.notParsable.add(annotationFormat + "  np  " + filePath);
                ++stats.nNotParsable;
                continue;
            }
            Stats st = this.ingest(transcription, false);
            if (st == null) {
                _log.warn("Database problem with: " + filePath);
                this.dbProblem.add(annotationFormat + "  db  " + filePath);
                ++stats.nDBProblems;
                continue;
            }
            if (st.nEmpty > 0) {
                ++stats.nEmpty;
                this.emptyTranscriptions.add(annotationFormat + "  em  " + filePath);
                continue;
            }
            stats.nTiers += st.nTiers;
            stats.nAnnotations += st.nAnnotations;
            stats.annotationsSize += st.annotationsSize;
        }
        System.err.println(annotationFormat + " done.");
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stats ingest(AnnexTranscription transcription, boolean inCurrent) {
        Stats stats = new Stats();
        HashMap<Serializable, Integer> ids = new HashMap<Serializable, Integer>();
        boolean acm = false;
        int nTiers = transcription.getTiers().size();
        if (nTiers == 0) {
            ++stats.nEmpty;
            return stats;
        }
        String prog_dataTable = "search.new_prog_data";
        if (inCurrent) {
            prog_dataTable = "search.prog_data";
        }
        Statement stTier = null;
        Statement stAnnotation = null;
        try {
            AnnexTier tier;
            int i;
            Statement st = null;
            ResultSet rs = null;
            int tierId = -1;
            int annotationId = -1;
            if (!this.simulate) {
                acm = this.con.getAutoCommit();
                this.con.setAutoCommit(false);
                st = this.con.createStatement();
                rs = st.executeQuery("SELECT * FROM " + prog_dataTable + " WHERE label = 'indices'");
                rs.next();
                tierId = rs.getInt(this.TIER_ID);
                annotationId = rs.getInt(this.ANN_ID);
                stAnnotation = this.con.prepareStatement("INSERT INTO " + (inCurrent ? "search.annotations" : "search.new_annotations") + " VALUES(?, ?, ?, ?, ?, ?, ?, ?)");
                stTier = this.con.prepareStatement("INSERT INTO " + (inCurrent ? "search.tiers" : "search.new_tiers") + " VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)");
            }
            stats.nTiers = nTiers;
            for (i = 0; i < nTiers; ++i) {
                tier = (AnnexTier)transcription.getTiers().get(i);
                ids.put(tier, tierId++);
                int nAnnotations = tier.annotations.size();
                stats.nAnnotations += (long)nAnnotations;
                for (int j = 0; j < nAnnotations; ++j) {
                    AnnexAnnotation annotation = (AnnexAnnotation)tier.annotations.get(j);
                    ids.put(annotation, annotationId++);
                    stats.annotationsSize += (long)annotation.value.length();
                }
            }
            if (!this.simulate) {
                rs = st.executeQuery("SELECT * FROM " + prog_dataTable + " WHERE label = 'indices'");
                rs.next();
                tierId = rs.getInt(this.TIER_ID);
                annotationId = rs.getInt(this.ANN_ID);
            }
            for (i = 0; i < nTiers; ++i) {
                tier = (AnnexTier)transcription.getTiers().get(i);
                int ref_tier_id = -1;
                if (tier.parentTier != null) {
                    if (ids.get(tier.parentTier) != null) {
                        ref_tier_id = (Integer)ids.get(tier.parentTier);
                    } else {
                        _log.warn("Ignored bad parent tier reference: " + tier.name + " ==> " + tier.parentTier.name + " in: " + AnnexUtil.getFilePathFor(transcription.getNodeId()));
                    }
                }
                int nAnnotations = tier.annotations.size();
                if (tier.type == null) {
                    _log.error("Tier without type in: " + AnnexUtil.getFilePathFor(transcription.getNodeId()));
                    tier.type = "unknown";
                }
                if (tier.participant == null) {
                    _log.error("Tier without participant info in: " + AnnexUtil.getFilePathFor(transcription.getNodeId()));
                    tier.participant = "unknown";
                }
                if (!this.simulate) {
                    stTier.clearParameters();
                    stTier.setInt(1, tierId);
                    stTier.setString(2, tier.name);
                    stTier.setString(3, tier.type);
                    stTier.setString(4, tier.defaultLocale);
                    stTier.setString(5, tier.participant);
                    stTier.setInt(6, nAnnotations);
                    stTier.setInt(7, ref_tier_id);
                    stTier.setInt(8, transcription.getType());
                    stTier.setString(9, transcription.getNodeId());
                    stTier.executeUpdate();
                }
                int nulCharLines = 0;
                for (int j = 0; j < nAnnotations; ++j) {
                    int endTime;
                    String filePath;
                    AnnexAnnotation annotation = (AnnexAnnotation)tier.annotations.get(j);
                    int ref_ann_id = -1;
                    if (annotation.refAnnotation != null) {
                        if (ids.get(annotation.refAnnotation) != null) {
                            ref_ann_id = (Integer)ids.get(annotation.refAnnotation);
                        } else {
                            _log.warn("Ignored bad annotation reference: " + annotation.id + "(" + annotation.value + ") ==> " + annotation.refAnnotation.id + "(" + annotation.refAnnotation.value + ") in: " + AnnexUtil.getFilePathFor(transcription.getNodeId()));
                        }
                    }
                    if (annotation.value.length() > 2600) {
                        filePath = AnnexUtil.getFilePathFor(transcription.getNodeId());
                        _log.warn("Truncated annotation longer than 2600 characters in: " + filePath);
                        annotation.value = annotation.value.substring(0, 2600) + "...";
                    }
                    if (annotation.value.indexOf(0) != -1) {
                        filePath = AnnexUtil.getFilePathFor(transcription.getNodeId());
                        ++nulCharLines;
                        annotation.value = annotation.value.replace('\u0000', '*');
                    }
                    if (this.simulate) continue;
                    stAnnotation.clearParameters();
                    stAnnotation.setInt(1, annotationId++);
                    stAnnotation.setString(2, annotation.value);
                    stAnnotation.setInt(3, j);
                    int startTime = annotation.beginTime < Integer.MIN_VALUE ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                    int n = endTime = annotation.endTime < Integer.MIN_VALUE ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                    if (annotation.beginTime >= Integer.MIN_VALUE && annotation.beginTime <= Integer.MAX_VALUE) {
                        startTime = (int)annotation.beginTime;
                    } else {
                        _log.warn("Bad annotation start time: " + annotation.beginTime + " to " + annotation.endTime + " for '" + annotation.value + "' in " + AnnexUtil.getFilePathFor(transcription.getNodeId()));
                    }
                    if (annotation.endTime >= Integer.MIN_VALUE && annotation.endTime <= Integer.MAX_VALUE) {
                        endTime = (int)annotation.endTime;
                    } else {
                        _log.warn("Bad annotation end time: " + annotation.beginTime + " to " + annotation.endTime + " for '" + annotation.value + "' in " + AnnexUtil.getFilePathFor(transcription.getNodeId()));
                    }
                    stAnnotation.setInt(4, startTime);
                    stAnnotation.setInt(5, endTime);
                    stAnnotation.setInt(6, ref_ann_id);
                    stAnnotation.setBoolean(7, annotation.isTimeAligned);
                    stAnnotation.setInt(8, tierId);
                    stAnnotation.addBatch();
                    if (j % 1000 != 0 && j != nAnnotations - 1) continue;
                    stAnnotation.executeBatch();
                    stAnnotation.clearBatch();
                }
                if (nulCharLines > 0) {
                    _log.warn("Had to replace NUL chars in " + nulCharLines + " lines for tier: " + tier.name + " in: " + AnnexUtil.getFilePathFor(transcription.getNodeId()));
                }
                ++tierId;
            }
            if (!this.simulate) {
                st.executeUpdate("UPDATE " + prog_dataTable + " SET " + "tier_id = " + tierId + ", " + "ann_id = " + annotationId + " WHERE label = 'indices'");
                this.con.commit();
                this.con.setAutoCommit(acm);
            }
        }
        catch (SQLException e) {
            _log.error("ingest SQLException: " + e + "in: " + AnnexUtil.getFilePathFor(transcription.getNodeId()), e);
            try {
                ++rollbacks;
                this.con.rollback();
                this.con.setAutoCommit(acm);
            }
            catch (SQLException ex) {
                ++missedRollbacks;
                this.mentionRollbackProblem();
                _log.error("ingest: failed rollback: " + ex.toString());
            }
            Stats ex = null;
            return ex;
        }
        catch (RuntimeException re) {
            _log.error("ingest RuntimeException:" + re + "in: " + AnnexUtil.getFilePathFor(transcription.getNodeId()), re);
            try {
                ++rollbacks;
                this.con.rollback();
                this.con.setAutoCommit(acm);
            }
            catch (SQLException ex) {
                ++missedRollbacks;
                this.mentionRollbackProblem();
                _log.error("ingest: failed rollback: " + ex.toString());
            }
            Stats stats2 = null;
            return stats2;
        }
        finally {
            if (stTier != null) {
                try {
                    stTier.close();
                }
                catch (SQLException e) {}
            }
            if (stAnnotation != null) {
                try {
                    stAnnotation.close();
                }
                catch (SQLException e) {}
            }
        }
        return stats;
    }

    private void mentionRollbackProblem() {
        _log.error("ROLLBACK PROBLEM");
    }

    private void printStats(Stats stats, String type) {
        long aal = 0L;
        if (stats.nAnnotations > 0L) {
            aal = 100L * stats.annotationsSize / stats.nAnnotations;
        }
        int nIngested = stats.nExist - stats.nPermissionDenied - stats.nEmpty - stats.nNotParsable - stats.nDBProblems;
        _log.info("Statistics for " + type + " files:");
        _log.info("#files: " + stats.nFiles + "    existing: " + stats.nExist + "   ingested: " + nIngested);
        _log.info("#permission denied: " + stats.nPermissionDenied + "    empty: " + stats.nEmpty + "    not parsable: " + stats.nNotParsable + "    database problem: " + stats.nDBProblems);
        _log.info("#tiers: " + stats.nTiers + "    #annotations: " + stats.nAnnotations + "    Average annotation length: " + aal / 100L + "." + (aal % 100L < 10L ? "0" : "") + aal % 100L);
    }

    private long start_stopwatch() {
        return System.currentTimeMillis();
    }

    private void stop_stopwatch(String what, long startTime) {
        long millis = System.currentTimeMillis() + 499L - startTime;
        long hours = millis / 3600000L;
        long minutes = (millis -= hours * 3600000L) / 60000L;
        long seconds = (millis -= minutes * 60000L) / 1000L;
        _log.info("Done: " + what + " - duration: " + hours + ":" + (minutes < 10L ? "0" : "") + minutes + ":" + (seconds < 10L ? "0" : "") + seconds);
    }

    private static void usage() {
        System.out.println("\nFill searchdb/annex DB using all annotation files found in corpusstructure DB");
        System.out.println("\nUsage:");
        System.out.println("java -jar SearchDBIngester.jar corpusdb-server[:port] user password searchdb-server[:port] user password\n");
        System.out.println("Sample Usage:");
        System.out.println("java -jar SearchDBIngester.jar lux08 webuser xxxx localhost albertr yyyy\n");
        System.out.println("Simulation mode:");
        System.out.println("use 'simulate' as the second (searchdb) user name to work without a searchdb");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 6) {
            SearchCorpusDB.usage();
            System.exit(0);
        }
        AnnexUtil.corpusDbURL = "jdbc:postgresql://" + args[0] + "/corpusstructure";
        AnnexUtil.corpusDbUser = args[1];
        AnnexUtil.corpusDbPassword = args[2];
        String url = "jdbc:postgresql://" + args[3] + "/annex";
        String usr = args[4];
        String pwd = args[5];
        SearchCorpusDB ingester = null;
        try {
            ingester = new SearchCorpusDB(url, usr, pwd);
        }
        catch (SQLException sqle) {
            System.out.println("Cannot connect to database: " + sqle);
            SearchCorpusDB.usage();
            return;
        }
        try {
            ingester.fillDatabase();
        }
        finally {
            ingester.close();
        }
    }

    public ResultSet executeSQLQuery(String query) throws SQLException {
        Statement st = this.con.createStatement(1004, 1007);
        return st.executeQuery(query);
    }

    public PreparedStatement getPreparedStatement(String statement) throws SQLException {
        return this.con.prepareStatement(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(String nodeId) throws SQLException {
        Statement st = null;
        ResultSet rs = null;
        try {
            st = this.con.createStatement();
            rs = st.executeQuery("select node_id from search.tiers where node_id = '" + nodeId + "'");
            if (rs.next()) {
                throw new SQLException("Already in DB, remove before re-adding: " + nodeId);
            }
        }
        finally {
            if (st != null) {
                st.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        String filePath = AnnexUtil.getFilePathFor(nodeId);
        File file = new File(filePath);
        if (!file.exists()) {
            throw new SQLException("File does not exist for nodeID: " + nodeId + " => " + filePath);
        }
        AnnexTranscription transcription = null;
        int type = AnnexUtil.getTypeFor(nodeId);
        transcription = new AnnexTranscription(nodeId, type, file);
        if (transcription == null || !transcription.isValid()) {
            throw new SQLException("Invalid transcription for nodeID: " + nodeId + " => " + filePath);
        }
        Stats stats = this.ingest(transcription, true);
        if (stats == null) {
            throw new SQLException("Database problem for nodeID: " + nodeId + " => " + filePath);
        }
    }

    public void removeNode(String nodeId) throws SQLException {
        if (this.simulate) {
            return;
        }
        this.con.setAutoCommit(false);
        Statement st = this.con.createStatement();
        ResultSet rs = null;
        try {
            rs = st.executeQuery("SELECT tier_id FROM search.tiers WHERE node_id = '" + nodeId + "'");
            while (rs.next()) {
                int tierId = rs.getInt(1);
                st.executeUpdate("DELETE FROM search.annotations WHERE ann_tier_id = " + tierId);
            }
            st.executeUpdate("DELETE FROM search.tiers WHERE node_id = '" + nodeId + "'");
            this.con.commit();
        }
        catch (SQLException e) {
            this.con.rollback();
            throw e;
        }
        finally {
            st.close();
            if (rs != null) {
                rs.close();
            }
        }
    }

    static {
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            _log.error("org.postgresql.Driver not found - provide JARs, see Class-Path header if running via -jar");
            System.out.println("org.postgresql.Driver not found - provide JARs, see Class-Path header if running via -jar");
        }
    }

    private class Stats {
        public int nFiles;
        public int nExist;
        public int nPermissionDenied;
        public int nNotParsable;
        public int nDBProblems;
        public int nEmpty;
        public int nTiers;
        public long nAnnotations;
        public long annotationsSize;

        private Stats() {
        }
    }
}

