/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.search;

import java.util.ArrayList;
import java.util.regex.Pattern;

public class SearchLayer {
    private boolean isEmpty = true;
    private ArrayList patterns = new ArrayList();
    private ArrayList patternsNOTMode = new ArrayList();
    private ArrayList regExpPatterns = new ArrayList();
    private ArrayList hModeInfo = new ArrayList();
    private ArrayList vModeInfo = new ArrayList();
    private ArrayList modes = new ArrayList();
    private ArrayList innerConstraints = new ArrayList();
    private ArrayList tierConstraints = new ArrayList();
    private ArrayList outerConstraints = new ArrayList();
    private ArrayList hitAnnIdsForPattern = new ArrayList();
    private ArrayList hitNumbersForPattern = new ArrayList();
    private int[] hitFileIds;
    private String tierIdsInLayerDomain = "";

    public void addPattern(String pattern, String mode, String innerConstraint, String outerConstraint) {
        boolean notMode = false;
        while (SearchLayer.isNOTPattern(pattern)) {
            notMode = !notMode;
            pattern = SearchLayer.stripNOTPattern(pattern);
        }
        this.patternsNOTMode.add(new Boolean(notMode));
        this.patterns.add(pattern);
        String[] queryModes = mode.split("xxxMODE_SPLITTERxxx");
        this.modes.add(queryModes);
        if (pattern.length() > 0) {
            this.isEmpty = false;
            if (queryModes[2].equals(" regular expression")) {
                if (queryModes[1].equals(" case sensitive")) {
                    this.regExpPatterns.add(Pattern.compile(pattern));
                } else {
                    this.regExpPatterns.add(Pattern.compile(pattern, 2));
                }
            } else {
                this.regExpPatterns.add(null);
            }
            this.hitAnnIdsForPattern.add(new int[100000]);
            this.hitNumbersForPattern.add(new int[100000]);
            if (this.hitFileIds == null) {
                this.hitFileIds = new int[100000];
            }
        } else {
            this.hitAnnIdsForPattern.add(null);
            this.hitNumbersForPattern.add(null);
            this.regExpPatterns.add(null);
        }
        this.innerConstraints.add(innerConstraint);
        this.outerConstraints.add(outerConstraint);
        this.hModeInfo.add(new int[2]);
        this.vModeInfo.add(new int[1]);
    }

    public void addTierConstraint(String constraint) {
        this.tierConstraints.add(constraint);
    }

    public int getNumberOfPatterns() {
        return this.patterns.size();
    }

    public String getPattern(int i) {
        return (String)this.patterns.get(i);
    }

    public boolean getPatternNOTMode(int i) {
        return (Boolean)this.patternsNOTMode.get(i);
    }

    public Pattern getRegExpPattern(int i) {
        return (Pattern)this.regExpPatterns.get(i);
    }

    public String[] getMode(int i) {
        return (String[])this.modes.get(i);
    }

    public String getInnerConstraint(int i) {
        return (String)this.innerConstraints.get(i);
    }

    public ArrayList getTierConstraints() {
        return this.tierConstraints;
    }

    public int[] getHModeInfo(int i) {
        return (int[])this.hModeInfo.get(i);
    }

    public int[] getVModeInfo(int i) {
        return (int[])this.vModeInfo.get(i);
    }

    public void setTierIdsInLayerDomain(String tierIds) {
        this.tierIdsInLayerDomain = tierIds;
    }

    public String getTierIdsInLayerDomain() {
        return this.tierIdsInLayerDomain;
    }

    public String getOuterConstraint(int i) {
        return (String)this.outerConstraints.get(i);
    }

    public int[] getHitAnnIdsForPattern(int i) {
        return (int[])this.hitAnnIdsForPattern.get(i);
    }

    public int[] getHitNumberForPattern(int i) {
        return (int[])this.hitNumbersForPattern.get(i);
    }

    public int[] getHitFileIds() {
        return this.hitFileIds;
    }

    public int getIndexOfFirstNonEmptyPattern() {
        for (int i = 0; i < this.patterns.size(); ++i) {
            if (((String)this.patterns.get(i)).length() <= 0) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public static boolean isNOTPattern(String pattern) {
        return pattern.trim().startsWith("NOT(") && pattern.trim().endsWith(")");
    }

    public static String stripNOTPattern(String pattern) {
        if (!SearchLayer.isNOTPattern(pattern)) {
            return pattern;
        }
        return pattern.trim().substring(4, pattern.length() - 1).trim();
    }

    public void display() {
        int j;
        System.out.println("\tPatterns and inner constraints: ");
        for (j = 0; j < this.patterns.size(); ++j) {
            String m0 = ((String[])this.modes.get(j))[0];
            String m1 = ((String[])this.modes.get(j))[1];
            String m2 = ((String[])this.modes.get(j))[2];
            System.out.println("\t\t|" + this.patterns.get(j) + "| as " + m0 + " " + m1 + " " + m2);
            System.out.println("\t\tinner: " + this.innerConstraints.get(j));
            System.out.println("\t\touter: " + this.outerConstraints.get(j));
        }
        System.out.println("\n\tTiers: ");
        for (j = 0; j < this.tierConstraints.size(); ++j) {
            System.out.println("\t\t" + this.tierConstraints.get(j));
        }
    }
}

