/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.search;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mpi.annex.search.Constants;
import mpi.annex.search.FrequencyInfo;
import mpi.annex.search.SearchLayer;
import mpi.annex.search.SearchStatistics;

public abstract class SearchQuery {
    protected String schemaName;
    protected HashMap frequencyMap;
    protected TreeSet frequencyInfoTree;
    protected ArrayList orderedFrequencyInfo;
    protected SearchStatistics statistics;
    protected boolean patternNeedsFullStatistics;
    protected SearchLayer[] searchLayers;
    protected int nLayers;
    protected int nPatternsPerLayer;
    protected int firstNonEmptyLayerIndex;
    protected int firstNonEmptyPatternIndex;
    protected boolean isSimpleQuery;
    protected boolean isMultipleLayerQuery;
    protected boolean isExecuting;
    protected boolean keepExecuting;
    protected int nGramSizeLeftFromHit;
    protected int nGramSizeRightFromHit;
    protected int[][] globalHitAnnId;
    protected int[][] globalHitTierId;
    protected int[][] globalHitFileId;
    protected int[][] globalHitPosition;
    protected long[][] globalHitBeginTime;
    protected long[][] globalHitEndTime;
    protected PreparedStatement[][] preparedStatements;
    protected PreparedStatement prepStatComplexHitResultData;
    protected PreparedStatement prepStatCheckValidDuration;
    protected long minimalDuration;
    protected long maximalDuration;
    protected long beginAfter;
    protected long endBefore;
    protected String currentNodeId;
    protected String currentTranscriptionTierDomain;
    protected HashMap domainTierNames = new HashMap();
    protected HashMap domainTierTypes = new HashMap();
    protected HashMap domainTierParticipants = new HashMap();
    protected String fullTranscriptionTierDomain;
    protected boolean thereIsALayerWithAnEmptyTierDomain;

    public SearchQuery() {
        this.statistics = new SearchStatistics();
        this.frequencyMap = new HashMap();
    }

    public long getValue(ResultSet rs, int column) throws SQLException {
        if (rs.getMetaData().getColumnType(column) == -5) {
            return rs.getLong(column);
        }
        return rs.getInt(column);
    }

    public ArrayList getSearchModes() {
        int i;
        ArrayList<String> modes = new ArrayList<String>();
        modes.add(Integer.toString(Constants.targetModes.length));
        for (i = 0; i < Constants.targetModes.length; ++i) {
            modes.add(Constants.targetModes[i]);
        }
        modes.add(Integer.toString(Constants.caseModes.length));
        for (i = 0; i < Constants.caseModes.length; ++i) {
            modes.add(Constants.caseModes[i]);
        }
        modes.add(Integer.toString(Constants.matchModes.length));
        for (i = 0; i < Constants.matchModes.length; ++i) {
            modes.add(Constants.matchModes[i]);
        }
        return modes;
    }

    public void createLayers(String encodedQuery) {
        String[] queryParts = encodedQuery.split("xxxSAFE_SPLITTERxxx");
        this.firstNonEmptyLayerIndex = -1;
        this.firstNonEmptyPatternIndex = -1;
        int nPatterns = 0;
        String[] header = queryParts[0].split(",");
        this.minimalDuration = Long.parseLong(header[0].trim());
        this.maximalDuration = Long.parseLong(header[1].trim());
        this.beginAfter = Long.parseLong(header[2].trim());
        this.endBefore = Long.parseLong(header[3].trim());
        this.nLayers = Integer.parseInt(header[4].trim());
        this.nPatternsPerLayer = Integer.parseInt(header[5].trim());
        this.searchLayers = new SearchLayer[this.nLayers];
        int partIndex = 1;
        for (int i = 0; i < this.nLayers; ++i) {
            this.searchLayers[i] = new SearchLayer();
            for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                String pattern;
                if ((pattern = queryParts[partIndex++]).length() > 0) {
                    ++nPatterns;
                }
                String mode = queryParts[partIndex++];
                String innerConstraint = queryParts[partIndex++];
                String outerConstraint = queryParts[partIndex++];
                this.searchLayers[i].addPattern(pattern, mode, innerConstraint, outerConstraint);
                if (this.firstNonEmptyPatternIndex >= 0 || pattern.length() <= 0) continue;
                this.firstNonEmptyLayerIndex = i;
                this.firstNonEmptyPatternIndex = j;
            }
            int nTiers = Integer.parseInt(header[i + 6].trim());
            for (int j = 0; j < nTiers; ++j) {
                this.searchLayers[i].addTierConstraint(queryParts[partIndex++]);
            }
        }
        this.isSimpleQuery = nPatterns <= 1;
        int nNonEmptyLayers = 0;
        for (int i = 0; i < this.nLayers; ++i) {
            if (this.searchLayers[i].isEmpty()) continue;
            ++nNonEmptyLayers;
        }
        this.isMultipleLayerQuery = nNonEmptyLayers > 1;
        this.globalHitAnnId = new int[this.nLayers][this.nPatternsPerLayer];
        this.globalHitTierId = new int[this.nLayers][this.nPatternsPerLayer];
        this.globalHitFileId = new int[this.nLayers][this.nPatternsPerLayer];
        this.globalHitPosition = new int[this.nLayers][this.nPatternsPerLayer];
        this.globalHitBeginTime = new long[this.nLayers][this.nPatternsPerLayer];
        this.globalHitEndTime = new long[this.nLayers][this.nPatternsPerLayer];
        this.preparedStatements = new PreparedStatement[this.nLayers][this.nPatternsPerLayer];
        this.prepStatComplexHitResultData = null;
        this.prepStatCheckValidDuration = null;
    }

    private void displayLayerInfo() {
        System.out.println("nLayers: " + this.nLayers);
        for (int i = 0; i < this.nLayers; ++i) {
            System.out.println("\nLayer " + i);
            this.searchLayers[i].display();
        }
    }

    public boolean isRunning() {
        return this.isExecuting;
    }

    public SearchStatistics getSearchStatistics() {
        this.statistics.nFrequencyInfoItems = this.frequencyMap.size();
        return this.statistics;
    }

    protected void clearFrequencyStatistics() {
        this.frequencyMap.clear();
        this.frequencyInfoTree = null;
        this.orderedFrequencyInfo = null;
    }

    protected void updateFrequencyStatistics(String annotation, int annId, int fileIndex, int layerIndex, int patternIndex) {
        FrequencyInfo info = (FrequencyInfo)this.frequencyMap.get(annotation);
        if (info != null) {
            ++info.numberOfHits;
        } else if (this.frequencyMap.size() < 100000) {
            info = new FrequencyInfo();
            info.annId = annId;
            info.fileIndex = fileIndex;
            info.layerIndex = layerIndex;
            info.patternIndex = patternIndex;
            info.numberOfHits = 1;
            this.frequencyMap.put(annotation, info);
        }
    }

    public ArrayList getFrequencyInfo(int from, int to) {
        ArrayList<FrequencyInfo> info = new ArrayList<FrequencyInfo>();
        if (this.frequencyMap.size() >= 100000) {
            FrequencyInfo freqInfo = new FrequencyInfo();
            freqInfo.annotation = "No frequency statistics available, there were more than 100000 different hit patterns";
            freqInfo.numberOfHits = -1;
            info.add(freqInfo);
        } else {
            if (this.orderedFrequencyInfo == null) {
                this.frequencyInfoTree = new TreeSet(new FreqInfoComparator());
                for (String annotation : this.frequencyMap.keySet()) {
                    FrequencyInfo freqInfo = (FrequencyInfo)this.frequencyMap.get(annotation);
                    freqInfo.annotation = annotation;
                    this.frequencyInfoTree.add(freqInfo);
                }
                this.orderedFrequencyInfo = new ArrayList();
                Iterator<Object> iter = this.frequencyInfoTree.iterator();
                while (iter.hasNext()) {
                    this.orderedFrequencyInfo.add(0, iter.next());
                }
            }
            for (int i = from; i < to; ++i) {
                if (i >= this.orderedFrequencyInfo.size()) continue;
                FrequencyInfo freqInfo = (FrequencyInfo)this.orderedFrequencyInfo.get(i);
                freqInfo.nOccurences = this.frequencyMap.size();
                if (freqInfo.hitPositionInAnnotation == 0 && freqInfo.hitLength == 0) {
                    String[] queryModes = this.searchLayers[freqInfo.layerIndex].getMode(freqInfo.patternIndex);
                    String pattern = this.searchLayers[freqInfo.layerIndex].getPattern(freqInfo.patternIndex);
                    boolean patternNOTMode = this.searchLayers[freqInfo.layerIndex].getPatternNOTMode(freqInfo.patternIndex);
                    Pattern regExpPattern = this.searchLayers[freqInfo.layerIndex].getRegExpPattern(freqInfo.patternIndex);
                    if (queryModes[0].equals(" Annotation") && this.isSimpleQuery) {
                        freqInfo.hitPositionInAnnotation = this.getHitPosition(freqInfo.annotation, 1, queryModes, pattern, regExpPattern, patternNOTMode);
                        freqInfo.hitLength = this.getHitLength(freqInfo.annotation, 1, queryModes, pattern, regExpPattern, patternNOTMode);
                    } else {
                        freqInfo.hitPositionInAnnotation = 0;
                        freqInfo.hitLength = 0;
                    }
                }
                info.add(freqInfo);
            }
        }
        return info;
    }

    protected void investigateComplexPattern(int layerIndex, int patternIndex, Connection con) {
        try {
            Statement statement = con.createStatement();
            while (layerIndex < this.nLayers) {
                if (patternIndex + 1 < this.nPatternsPerLayer) {
                    ++patternIndex;
                } else {
                    ++layerIndex;
                    patternIndex = 0;
                }
                if (layerIndex == this.nLayers) {
                    if (!this.patternHasValidDuration(-1L, -1L, con)) {
                        return;
                    }
                    if (this.statistics.nHits < 100000) {
                        this.rememberHitData(this.statistics.nHits);
                    }
                    String complexHitResultString = this.constructComplexHitResultString((Connection)con, (Statement)statement, (int[][])this.globalHitAnnId, (boolean)false).hitString.replaceAll("xxxSAFE_SPLITTERxxx", " ");
                    int annId = this.globalHitAnnId[this.firstNonEmptyLayerIndex][this.firstNonEmptyPatternIndex];
                    int fileId = this.globalHitFileId[this.firstNonEmptyLayerIndex][this.firstNonEmptyPatternIndex];
                    this.updateFrequencyStatistics(complexHitResultString.replaceAll("xxxLAYER_SPLITTERxxx", "  #"), annId, fileId, this.firstNonEmptyLayerIndex, this.firstNonEmptyPatternIndex);
                    ++this.statistics.nHits;
                    ++this.statistics.nAnnotationsWithHit;
                    return;
                }
                if (this.searchLayers[layerIndex].getPattern(patternIndex).length() <= 0) continue;
            }
            String pattern = this.searchLayers[layerIndex].getPattern(patternIndex);
            boolean patternNOTMode = this.searchLayers[layerIndex].getPatternNOTMode(patternIndex);
            Pattern regExpPattern = this.searchLayers[layerIndex].getRegExpPattern(patternIndex);
            String[] queryModes = this.searchLayers[layerIndex].getMode(patternIndex);
            String queryString = "SELECT ann_id, ann_tier_id, annotation, ann_position, begin_time, end_time, aligned, ref_ann_id FROM " + this.schemaName + ".annotations WHERE ";
            queryString = queryString + this.createQueryPatternPart(pattern, queryModes, regExpPattern, patternNOTMode);
            queryString = queryString + this.createHorizontalConstraintPart(layerIndex, patternIndex, statement);
            queryString = queryString + this.createVerticalConstraintPart(layerIndex, patternIndex, statement);
            queryString = queryString + this.createTierConstraintPart(layerIndex, patternIndex);
            queryString = queryString + this.createGlobalTimeConstraintPart();
            queryString = this.convertRegexpPatternsIfNeeded(queryString);
            System.out.println("layerq: " + queryString);
            ResultSet rs = statement.executeQuery(queryString);
            while (rs.next()) {
                int annId = rs.getInt(1);
                int tierId = rs.getInt(2);
                this.globalHitAnnId[layerIndex][patternIndex] = annId;
                this.globalHitTierId[layerIndex][patternIndex] = tierId;
                this.globalHitBeginTime[layerIndex][patternIndex] = this.getValue(rs, 5);
                this.globalHitEndTime[layerIndex][patternIndex] = this.getValue(rs, 6);
                this.globalHitPosition[layerIndex][patternIndex] = rs.getInt(4);
                this.investigateComplexPattern(layerIndex, patternIndex, con);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract String createQueryPatternPart(String var1, String[] var2, Pattern var3, boolean var4);

    protected abstract String convertRegexpPatternsIfNeeded(String var1);

    protected String createHorizontalConstraintPart(int layerIndex, int patternIndex, Statement statement) {
        String queryPart = "";
        try {
            if (patternIndex > 0 && this.globalHitAnnId[layerIndex][patternIndex - 1] != -1) {
                int relativePosition = this.globalHitPosition[layerIndex][patternIndex - 1];
                long relativeEndTime = this.globalHitEndTime[layerIndex][patternIndex - 1];
                String constraint = this.searchLayers[layerIndex].getInnerConstraint(patternIndex - 1);
                if (constraint.equals("cns none")) {
                    queryPart = " AND ann_position > " + relativePosition;
                } else if (constraint.indexOf("cns an=:") >= 0) {
                    String[] parts = constraint.split(":");
                    int nAnnotations = Integer.parseInt(parts[1]) + 1;
                    queryPart = " AND ann_position = " + (relativePosition + nAnnotations);
                } else if (constraint.indexOf("cns an-:") >= 0) {
                    String[] parts = constraint.split(":");
                    int nAnnotations = Integer.parseInt(parts[1]) + 1;
                    queryPart = " AND ann_position < " + (relativePosition + nAnnotations) + " AND ann_position > " + relativePosition;
                } else if (constraint.indexOf("cns an+:") >= 0) {
                    String[] parts = constraint.split(":");
                    int nAnnotations = Integer.parseInt(parts[1]) + 1;
                    queryPart = " AND ann_position > " + (relativePosition + nAnnotations);
                } else if (constraint.indexOf("cns ms=:") >= 0) {
                    String[] parts = constraint.split(":");
                    int nMilliseconds = Integer.parseInt(parts[1]);
                    queryPart = " AND begin_time = " + (relativeEndTime + (long)nMilliseconds);
                } else if (constraint.indexOf("cns ms-:") >= 0) {
                    String[] parts = constraint.split(":");
                    int nMilliseconds = Integer.parseInt(parts[1]);
                    queryPart = " AND begin_time < " + (relativeEndTime + (long)nMilliseconds) + " AND begin_time >= " + relativeEndTime;
                } else if (constraint.indexOf("cns ms+:") >= 0) {
                    String[] parts = constraint.split(":");
                    int nMilliseconds = Integer.parseInt(parts[1]);
                    queryPart = " AND begin_time > " + (relativeEndTime + (long)nMilliseconds);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return queryPart;
    }

    protected String createVerticalConstraintPart(int layerIndex, int patternIndex, Statement statement) {
        String queryPart = "";
        try {
            String constraint;
            if (layerIndex > 0 && this.globalHitAnnId[layerIndex - 1][patternIndex] != -1 && !(constraint = this.searchLayers[layerIndex - 1].getOuterConstraint(patternIndex)).equals("cns none")) {
                long relativeBeginTime = this.globalHitBeginTime[layerIndex - 1][patternIndex];
                long relativeEndTime = this.globalHitEndTime[layerIndex - 1][patternIndex];
                if (!constraint.equals("cns none")) {
                    if (constraint.equals("cns aligned")) {
                        queryPart = " AND begin_time = " + relativeBeginTime + " AND end_time = " + relativeEndTime;
                    } else if (constraint.equals("cns overlap")) {
                        queryPart = " AND end_time >= " + relativeBeginTime + " AND begin_time <= " + relativeEndTime;
                    } else if (constraint.equals("cns l overlap")) {
                        queryPart = " AND begin_time <= " + relativeBeginTime + " AND end_time >= " + relativeBeginTime + " AND end_time <= " + relativeEndTime;
                    } else if (constraint.equals("cns r overlap")) {
                        queryPart = " AND begin_time <= " + relativeEndTime + " AND end_time >= " + relativeEndTime + " AND begin_time >= " + relativeBeginTime;
                    } else if (constraint.equals("cns surrounding")) {
                        queryPart = " AND begin_time <= " + relativeBeginTime + " AND end_time >= " + relativeEndTime;
                    } else if (constraint.equals("cns within")) {
                        queryPart = " AND begin_time >= " + relativeBeginTime + " AND end_time <= " + relativeEndTime;
                    } else if (constraint.equals("cns no overlap")) {
                        queryPart = " AND (end_time < " + relativeBeginTime + " OR begin_time > " + relativeEndTime + ")";
                    } else if (constraint.indexOf("cns bb=:") >= 0) {
                        String[] parts = constraint.split(":");
                        int nMilliSeconds = Integer.parseInt(parts[1]);
                        queryPart = " AND begin_time = " + (relativeBeginTime + (long)nMilliSeconds);
                    } else if (constraint.indexOf("cns bb-:") >= 0) {
                        String[] parts = constraint.split(":");
                        int nMilliSeconds = Integer.parseInt(parts[1]);
                        queryPart = " AND begin_time < " + (relativeBeginTime + (long)nMilliSeconds) + " AND begin_time >= " + relativeBeginTime;
                    } else if (constraint.indexOf("cns bb+:") >= 0) {
                        String[] parts = constraint.split(":");
                        int nMilliSeconds = Integer.parseInt(parts[1]);
                        queryPart = " AND begin_time > " + (relativeBeginTime + (long)nMilliSeconds);
                    } else if (constraint.indexOf("cns be=:") >= 0) {
                        String[] parts = constraint.split(":");
                        int nMilliSeconds = Integer.parseInt(parts[1]);
                        queryPart = " AND begin_time = " + (relativeEndTime + (long)nMilliSeconds);
                    } else if (constraint.indexOf("cns be-:") >= 0) {
                        String[] parts = constraint.split(":");
                        int nMilliSeconds = Integer.parseInt(parts[1]);
                        queryPart = " AND begin_time < " + (relativeEndTime + (long)nMilliSeconds) + " AND begin_time >= " + relativeEndTime;
                    } else if (constraint.indexOf("cns be+:") >= 0) {
                        String[] parts = constraint.split(":");
                        int nMilliSeconds = Integer.parseInt(parts[1]);
                        queryPart = " AND begin_time > " + (relativeEndTime + (long)nMilliSeconds);
                    } else if (constraint.indexOf("cns eb=:") >= 0) {
                        String[] parts = constraint.split(":");
                        int nMilliSeconds = Integer.parseInt(parts[1]);
                        queryPart = " AND end_time = " + (relativeBeginTime + (long)nMilliSeconds);
                    } else if (constraint.indexOf("cns eb-:") >= 0) {
                        String[] parts = constraint.split(":");
                        int nMilliSeconds = Integer.parseInt(parts[1]);
                        queryPart = " AND end_time < " + (relativeBeginTime + (long)nMilliSeconds) + " AND end_time >= " + relativeBeginTime;
                    } else if (constraint.indexOf("cns eb+:") >= 0) {
                        String[] parts = constraint.split(":");
                        int nMilliSeconds = Integer.parseInt(parts[1]);
                        queryPart = " AND end_time > " + (relativeBeginTime + (long)nMilliSeconds);
                    } else if (constraint.indexOf("cns ee=:") >= 0) {
                        String[] parts = constraint.split(":");
                        int nMilliSeconds = Integer.parseInt(parts[1]);
                        queryPart = " AND end_time = " + (relativeEndTime + (long)nMilliSeconds);
                    } else if (constraint.indexOf("cns ee-:") >= 0) {
                        String[] parts = constraint.split(":");
                        int nMilliSeconds = Integer.parseInt(parts[1]);
                        queryPart = " AND end_time < " + (relativeEndTime + (long)nMilliSeconds) + " AND end_time >= " + relativeEndTime;
                    } else if (constraint.indexOf("cns ee+:") >= 0) {
                        String[] parts = constraint.split(":");
                        int nMilliSeconds = Integer.parseInt(parts[1]);
                        queryPart = " AND end_time > " + (relativeEndTime + (long)nMilliSeconds);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return queryPart;
    }

    protected String createTierConstraintPart(int layerIndex, int patternIndex) {
        String queryPart = "";
        if (patternIndex > 0 && this.globalHitTierId[layerIndex][patternIndex - 1] != -1) {
            queryPart = " AND ann_tier_id = " + this.globalHitTierId[layerIndex][patternIndex - 1];
        } else {
            String layerDomain = this.searchLayers[layerIndex].getTierIdsInLayerDomain();
            if (layerDomain != null) {
                queryPart = queryPart + layerDomain;
            }
            --layerIndex;
            while (layerIndex >= 0) {
                for (int i = 0; i < this.nPatternsPerLayer; ++i) {
                    int forbiddenTierId = this.globalHitTierId[layerIndex][patternIndex];
                    if (forbiddenTierId == -1) continue;
                    queryPart = queryPart + " AND ann_tier_id != " + forbiddenTierId;
                    break;
                }
                --layerIndex;
            }
        }
        return queryPart;
    }

    protected void setTierDomainForLayers(boolean defineFullTranscriptionTierDomain, Statement statement) {
        try {
            this.fullTranscriptionTierDomain = "";
            this.thereIsALayerWithAnEmptyTierDomain = false;
            this.domainTierNames.clear();
            this.domainTierTypes.clear();
            this.domainTierParticipants.clear();
            String queryString = "SELECT tier_id, tier_name, tier_type, participant FROM " + this.schemaName + ".tiers WHERE node_id = '" + this.currentNodeId + "'";
            ResultSet rst = statement.executeQuery(queryString);
            while (rst.next()) {
                String tierParticipant;
                String tierType;
                int domainTierId = rst.getInt(1);
                this.fullTranscriptionTierDomain = this.fullTranscriptionTierDomain + " OR ann_tier_id = " + domainTierId;
                String tierName = rst.getString(2);
                if (tierName != null) {
                    tierName = tierName.trim();
                    this.domainTierNames.put(tierName, " OR ann_tier_id = " + domainTierId);
                }
                if ((tierType = rst.getString(3)) != null) {
                    String typeDomain = (String)this.domainTierTypes.get(tierType = tierType.trim());
                    if (typeDomain == null) {
                        this.domainTierTypes.put(tierType, " OR ann_tier_id = " + domainTierId);
                    } else {
                        this.domainTierTypes.put(tierType, typeDomain + " OR ann_tier_id = " + domainTierId);
                    }
                }
                if ((tierParticipant = rst.getString(4)) == null) continue;
                String participantDomain = (String)this.domainTierParticipants.get(tierParticipant = tierParticipant.trim());
                if (participantDomain == null) {
                    this.domainTierParticipants.put(tierParticipant, " OR ann_tier_id = " + domainTierId);
                    continue;
                }
                this.domainTierParticipants.put(tierParticipant, participantDomain + " OR ann_tier_id = " + domainTierId);
            }
            if (this.fullTranscriptionTierDomain.length() > 3) {
                this.fullTranscriptionTierDomain = defineFullTranscriptionTierDomain ? " AND (" + this.fullTranscriptionTierDomain.substring(3) + " ) " : "";
            } else {
                this.fullTranscriptionTierDomain = null;
                this.thereIsALayerWithAnEmptyTierDomain = true;
            }
            boolean searchInAllTiers = false;
            for (int l = 0; l < this.nLayers; ++l) {
                if (this.searchLayers[l].isEmpty()) continue;
                String layerDomain = "";
                ArrayList tierConstraints = this.searchLayers[l].getTierConstraints();
                for (int c = 0; c < tierConstraints.size(); ++c) {
                    String constraint = (String)tierConstraints.get(c);
                    if (constraint.startsWith(" All Tiers ")) {
                        searchInAllTiers = true;
                        break;
                    }
                    if (constraint.startsWith(" Tier Name: ")) {
                        if (this.domainTierNames.get(constraint = constraint.substring(" Tier Name: ".length())) == null) continue;
                        layerDomain = layerDomain + this.domainTierNames.get(constraint);
                        continue;
                    }
                    if (constraint.startsWith(" Tier Type: ")) {
                        if (this.domainTierTypes.get(constraint = constraint.substring(" Tier Type: ".length())) == null) continue;
                        layerDomain = layerDomain + this.domainTierTypes.get(constraint);
                        continue;
                    }
                    if (!constraint.startsWith(" Participant: ") || this.domainTierParticipants.get(constraint = constraint.substring(" Participant: ".length())) == null) continue;
                    layerDomain = layerDomain + this.domainTierParticipants.get(constraint);
                }
                if (layerDomain == null) {
                    this.searchLayers[l].setTierIdsInLayerDomain(null);
                    this.thereIsALayerWithAnEmptyTierDomain = true;
                    continue;
                }
                if (searchInAllTiers) {
                    this.searchLayers[l].setTierIdsInLayerDomain(this.fullTranscriptionTierDomain);
                    searchInAllTiers = false;
                    continue;
                }
                if (layerDomain.length() > 3) {
                    this.searchLayers[l].setTierIdsInLayerDomain(" AND  (" + layerDomain.substring(3) + ")");
                    continue;
                }
                this.searchLayers[l].setTierIdsInLayerDomain(null);
                this.thereIsALayerWithAnEmptyTierDomain = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String xcreateQueryTierDomainPart(ArrayList tierConstraints) {
        String queryPart = "";
        for (int i = 0; i < tierConstraints.size(); ++i) {
            String constraint = (String)tierConstraints.get(i);
            if (i > 0) {
                queryPart = queryPart + " OR ";
            }
            if (constraint.startsWith(" All Tiers ")) {
                return null;
            }
            if (constraint.startsWith(" Tier Name: ")) {
                queryPart = queryPart + " tier_name = '" + constraint.substring(" Tier Name: ".length()) + "'";
                continue;
            }
            if (constraint.startsWith(" Tier Type: ")) {
                queryPart = queryPart + " tier_type = '" + constraint.substring(" Tier Type: ".length()) + "'";
                continue;
            }
            if (!constraint.startsWith(" Participant: ")) continue;
            queryPart = queryPart + " participant = '" + constraint.substring(" Participant: ".length()) + "'";
        }
        return queryPart;
    }

    protected ComplexHitData constructComplexHitResultString(Connection con, Statement st, int[][] annIds, boolean addPositionAndTime) {
        String hitString = "";
        long complexPatternBeginTime = Long.MAX_VALUE;
        long complexPatternEndTime = 0L;
        try {
            if (con != null && this.prepStatComplexHitResultData == null) {
                String queryString = "SELECT annotation, ann_position, begin_time, end_time  FROM " + this.schemaName + ".annotations WHERE ann_id = ?";
                this.prepStatComplexHitResultData = con.prepareStatement(queryString, 1004, 1007);
            }
            for (int i = 0; i < this.nLayers; ++i) {
                hitString = hitString + "xxxLAYER_SPLITTERxxx" + (i + 1);
                for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                    if (annIds[i][j] > 0) {
                        ResultSet rs;
                        if (con != null) {
                            this.prepStatComplexHitResultData.setInt(1, annIds[i][j]);
                            rs = this.prepStatComplexHitResultData.executeQuery();
                        } else {
                            String queryString = "SELECT annotation, ann_position, begin_time, end_time  FROM " + this.schemaName + ".annotations WHERE ann_id = " + annIds[i][j];
                            rs = st.executeQuery(queryString);
                        }
                        rs.next();
                        String annotation = rs.getString(1);
                        int position = rs.getInt(2);
                        long beginTime = this.getValue(rs, 3);
                        long endTime = this.getValue(rs, 4);
                        hitString = hitString + "xxxSAFE_SPLITTERxxx|" + annotation + "|";
                        if (addPositionAndTime) {
                            hitString = hitString + "xxxNUMBER_SPLITTERxxx" + position + "xxxNUMBER_SPLITTERxxx" + beginTime + "xxxNUMBER_SPLITTERxxx" + endTime;
                        }
                        if (beginTime < complexPatternBeginTime) {
                            complexPatternBeginTime = beginTime;
                        }
                        if (endTime <= complexPatternEndTime) continue;
                        complexPatternEndTime = endTime;
                        continue;
                    }
                    hitString = hitString + "xxxSAFE_SPLITTERxxx||";
                    if (!addPositionAndTime) continue;
                    hitString = hitString + ":0:0:0";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ComplexHitData result = new ComplexHitData();
        result.hitString = hitString;
        result.beginTime = complexPatternBeginTime;
        result.endTime = complexPatternEndTime;
        return result;
    }

    protected String[] constructNGramsWithinAnnotation(String annotation, String nGramPattern, String[] queryModes) {
        int nResults;
        String nGram;
        Matcher matcher;
        String[] result = null;
        String[] annotationParts = annotation.split(" +");
        String LongestNonWildcardPart = this.getLongestNonWildcardPart(nGramPattern);
        boolean notMode = false;
        while (SearchLayer.isNOTPattern(LongestNonWildcardPart)) {
            notMode = !notMode;
            LongestNonWildcardPart = SearchLayer.stripNOTPattern(LongestNonWildcardPart);
        }
        ArrayList<String> resultList = new ArrayList<String>();
        if (queryModes[1].equals(" case sensitive")) {
            if (queryModes[2].equals(" exact match")) {
                for (int i = 0; i < annotationParts.length; ++i) {
                    String nGram2;
                    if (notMode == annotationParts[i].equals(LongestNonWildcardPart) || (nGram2 = this.constructNGram(nGramPattern, annotationParts, i, queryModes)) == null) continue;
                    resultList.add(nGram2);
                }
            } else if (queryModes[2].equals(" substring match")) {
                for (int i = 0; i < annotationParts.length; ++i) {
                    String nGram3;
                    if (notMode == annotationParts[i].indexOf(LongestNonWildcardPart) >= 0 || (nGram3 = this.constructNGram(nGramPattern, annotationParts, i, queryModes)) == null) continue;
                    resultList.add(nGram3);
                }
            } else if (queryModes[2].equals(" regular expression")) {
                Pattern regExpPattern = Pattern.compile(LongestNonWildcardPart);
                for (int i = 0; i < annotationParts.length; ++i) {
                    matcher = regExpPattern.matcher(annotationParts[i]);
                    if (notMode == matcher.find() || (nGram = this.constructNGram(nGramPattern, annotationParts, i, queryModes)) == null) continue;
                    resultList.add(nGram);
                }
            }
        } else if (queryModes[2].equals(" exact match")) {
            for (int i = 0; i < annotationParts.length; ++i) {
                String nGram4;
                if (notMode == annotationParts[i].toLowerCase().equals(LongestNonWildcardPart.toLowerCase()) || (nGram4 = this.constructNGram(nGramPattern, annotationParts, i, queryModes)) == null) continue;
                resultList.add(nGram4);
            }
        } else if (queryModes[2].equals(" substring match")) {
            for (int i = 0; i < annotationParts.length; ++i) {
                String nGram5;
                if (notMode == annotationParts[i].toLowerCase().indexOf(LongestNonWildcardPart.toLowerCase()) >= 0 || (nGram5 = this.constructNGram(nGramPattern, annotationParts, i, queryModes)) == null) continue;
                resultList.add(nGram5);
            }
        } else if (queryModes[2].equals(" regular expression")) {
            Pattern regExpPattern = Pattern.compile(LongestNonWildcardPart, 2);
            for (int i = 0; i < annotationParts.length; ++i) {
                matcher = regExpPattern.matcher(annotationParts[i].toLowerCase());
                if (notMode == matcher.find() || (nGram = this.constructNGram(nGramPattern, annotationParts, i, queryModes)) == null) continue;
                resultList.add(nGram);
            }
        }
        if ((nResults = resultList.size()) > 0) {
            result = new String[nResults];
            for (int i = 0; i < nResults; ++i) {
                result[i] = ((String)resultList.get(i)).trim();
            }
            return result;
        }
        return null;
    }

    protected String[] constructNGrams(int annId, Statement st, String schemaName, String nGramPattern, String[] queryModes) {
        String[] result = null;
        try {
            if (queryModes[0].equals(" N-gram within annotation")) {
                String queryString = "SELECT annotation FROM " + schemaName + ".annotations WHERE ann_id = " + annId;
                ResultSet rs = st.executeQuery(queryString);
                rs.next();
                String annotation = rs.getString(1);
                return this.constructNGramsWithinAnnotation(annotation, nGramPattern, queryModes);
            }
            String queryString = "SELECT ann_position, ann_tier_id FROM " + schemaName + ".annotations WHERE ann_id = " + annId;
            ResultSet rs = st.executeQuery(queryString);
            rs.next();
            int annPosition = rs.getInt(1);
            int annTierId = rs.getInt(2);
            int firstPos = annPosition - this.getLongestNonWildcardPartPosition(nGramPattern);
            if (firstPos < 0) {
                return null;
            }
            String nGram = "";
            int lastPos = firstPos + this.getNGramLength(nGramPattern);
            String inString = "";
            for (int annPos = firstPos; annPos < lastPos; ++annPos) {
                inString = inString + ", " + annPos;
            }
            inString = inString.substring(2);
            queryString = "SELECT annotation, ann_position FROM " + schemaName + ".annotations WHERE ann_tier_id = " + annTierId + " AND ann_position IN (" + inString + ") ORDER BY ann_position";
            rs = st.executeQuery(queryString);
            int nParts = 0;
            while (rs.next()) {
                ++nParts;
                nGram = nGram + rs.getString(1) + "xxxSAFE_SPLITTERxxx";
            }
            if (nParts != lastPos - firstPos) {
                return null;
            }
            result = new String[]{nGram.trim()};
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String constructNGram(String nGramPattern, String[] annotationParts, int hitIndex, String[] queryModes) {
        int firstPos = hitIndex - this.getLongestNonWildcardPartPosition(nGramPattern);
        if (firstPos < 0) {
            return null;
        }
        int lastPos = firstPos + this.getNGramLength(nGramPattern);
        if (lastPos > annotationParts.length) {
            return null;
        }
        String nGram = "";
        for (int j = firstPos; j < lastPos; ++j) {
            nGram = queryModes[0].equals(" N-gram over annotations") ? nGram + annotationParts[j] + "xxxSAFE_SPLITTERxxx" : nGram + annotationParts[j] + " ";
        }
        if (queryModes[0].equals(" N-gram over annotations")) {
            return nGram.substring(0, nGram.length() - "xxxSAFE_SPLITTERxxx".length());
        }
        return nGram.trim();
    }

    protected boolean isNGramMatch(String nGram, String nGramPattern, String[] queryModes) {
        String[] nGramPatternParts;
        String[] nGramParts = null;
        nGramParts = queryModes[0].equals(" N-gram over annotations") ? nGram.split("xxxSAFE_SPLITTERxxx") : nGram.split(" +");
        if (nGramParts.length != (nGramPatternParts = nGramPattern.split(" +")).length) {
            return false;
        }
        for (int i = 0; i < nGramParts.length; ++i) {
            Pattern regExpPattern;
            Matcher matcher;
            String patternPart = nGramPatternParts[i];
            if (patternPart.equals("#")) continue;
            boolean notMode = false;
            while (SearchLayer.isNOTPattern(patternPart)) {
                notMode = !notMode;
                patternPart = SearchLayer.stripNOTPattern(patternPart);
            }
            if (!(queryModes[1].equals(" case sensitive") ? (queryModes[2].equals(" exact match") ? notMode == nGramParts[i].equals(patternPart) : (queryModes[2].equals(" substring match") ? notMode == nGramParts[i].indexOf(patternPart) >= 0 : queryModes[2].equals(" regular expression") && notMode == (matcher = (regExpPattern = Pattern.compile(patternPart)).matcher(nGramParts[i])).find())) : (queryModes[2].equals(" exact match") ? notMode == nGramParts[i].toLowerCase().equals(patternPart.toLowerCase()) : (queryModes[2].equals(" substring match") ? notMode == nGramParts[i].toLowerCase().indexOf(patternPart.toLowerCase()) >= 0 : queryModes[2].equals(" regular expression") && notMode == (matcher = (regExpPattern = Pattern.compile(patternPart, 2)).matcher(nGramParts[i].toLowerCase())).find())))) continue;
            return false;
        }
        return true;
    }

    protected String getLongestNonWildcardPart(String nGramPattern) {
        String[] nGramPatternParts = nGramPattern.split(" +");
        int position = this.getLongestNonWildcardPartPosition(nGramPattern);
        return nGramPatternParts[position];
    }

    protected int getLongestNonWildcardPartPosition(String nGramPattern) {
        String part;
        int i;
        String[] nGramPatternParts = nGramPattern.split(" +");
        int position = -1;
        int maxLength = 0;
        for (i = 0; i < nGramPatternParts.length; ++i) {
            part = nGramPatternParts[i];
            if (part.equals("#") || SearchLayer.isNOTPattern(part) || part.length() <= maxLength) continue;
            maxLength = part.length();
            position = i;
        }
        if (position >= 0) {
            return position;
        }
        for (i = 0; i < nGramPatternParts.length; ++i) {
            part = nGramPatternParts[i];
            if (part.equals("#")) continue;
            return i;
        }
        return 0;
    }

    protected int getNGramLength(String nGramPattern) {
        return nGramPattern.split(" +").length;
    }

    protected int countHitsInAnnotation(String annotation, String[] queryModes, String pattern, Pattern regExpPattern, boolean patternNOTMode) {
        int nHits = 0;
        int patternLength = pattern.length();
        if (patternNOTMode) {
            nHits = 1;
        } else if (queryModes[0].equals(" Annotation")) {
            if (queryModes[1].equals(" case sensitive")) {
                if (queryModes[2].equals(" substring match")) {
                    int p = annotation.indexOf(pattern);
                    while (p >= 0) {
                        ++nHits;
                        p = annotation.indexOf(pattern, p + patternLength);
                    }
                } else if (queryModes[2].equals(" regular expression")) {
                    Matcher matcher = regExpPattern.matcher(annotation);
                    if (matcher.find()) {
                        ++nHits;
                        while (matcher.find()) {
                            ++nHits;
                        }
                    }
                } else {
                    nHits = 1;
                }
            } else if (queryModes[2].equals(" substring match")) {
                pattern = pattern.toLowerCase();
                annotation = annotation.toLowerCase();
                int p = annotation.indexOf(pattern);
                while (p >= 0) {
                    ++nHits;
                    p = annotation.indexOf(pattern, p + patternLength);
                }
            } else if (queryModes[2].equals(" regular expression")) {
                Matcher matcher = regExpPattern.matcher(annotation.toLowerCase());
                if (matcher.find()) {
                    ++nHits;
                    while (matcher.find()) {
                        ++nHits;
                    }
                }
            } else {
                nHits = 1;
            }
        } else {
            nHits = 1;
        }
        return nHits;
    }

    protected int getHitPosition(String annotation, int nthHit, String[] queryModes, String pattern, Pattern regExpPattern, boolean patternNOTMode) {
        if (queryModes[0].equals(" N-gram over annotations")) {
            pattern = this.getLongestNonWildcardPart(pattern);
            regExpPattern = queryModes[1].equals(" case sensitive") ? Pattern.compile(pattern) : Pattern.compile(pattern, 2);
        }
        int position = 0;
        int patternLength = pattern.length();
        if (!patternNOTMode) {
            Matcher matcher;
            if (queryModes[0].equals(" N-gram within annotation")) {
                int hitNumber = nthHit;
                String[] nGrams = this.constructNGramsWithinAnnotation(annotation, pattern, queryModes);
                if (nGrams != null) {
                    for (int i = 0; i < nGrams.length; ++i) {
                        if (!this.isNGramMatch(nGrams[i], pattern, queryModes) || --hitNumber > 0) continue;
                        String singleSpaceAnnotation = annotation.replaceAll(" +", " ");
                        position = singleSpaceAnnotation.indexOf(nGrams[i]);
                        int nSame = 0;
                        for (int j = 0; j < i; ++j) {
                            if (!nGrams[i].equals(nGrams[j])) continue;
                            ++nSame;
                        }
                        while (nSame > 0) {
                            position = singleSpaceAnnotation.indexOf(nGrams[i], position + 1);
                            --nSame;
                        }
                        break;
                    }
                }
            } else if (queryModes[1].equals(" case sensitive")) {
                Matcher matcher2;
                if (queryModes[2].equals(" exact match")) {
                    int p = annotation.indexOf(pattern);
                    --nthHit;
                    while (nthHit > 0) {
                        p = annotation.indexOf(pattern, p + patternLength);
                        --nthHit;
                    }
                    position = p;
                } else if (queryModes[2].equals(" substring match")) {
                    int p = annotation.indexOf(pattern);
                    --nthHit;
                    while (nthHit > 0) {
                        p = annotation.indexOf(pattern, p + patternLength);
                        --nthHit;
                    }
                    position = p;
                } else if (queryModes[2].equals(" regular expression") && (matcher2 = regExpPattern.matcher(annotation)).find()) {
                    --nthHit;
                    while (nthHit > 0) {
                        matcher2.find();
                        --nthHit;
                    }
                    position = matcher2.start();
                }
            } else if (queryModes[2].equals(" exact match") && queryModes[0].equals(" N-gram within annotation")) {
                pattern = pattern.toLowerCase();
                annotation = annotation.toLowerCase();
                int p = annotation.indexOf(pattern);
                --nthHit;
                while (nthHit > 0) {
                    p = annotation.indexOf(pattern, p + patternLength);
                    --nthHit;
                }
                position = p;
            } else if (queryModes[2].equals(" substring match")) {
                pattern = pattern.toLowerCase();
                annotation = annotation.toLowerCase();
                int p = annotation.indexOf(pattern);
                --nthHit;
                while (nthHit > 0) {
                    p = annotation.indexOf(pattern, p + patternLength);
                    --nthHit;
                }
                position = p;
            } else if (queryModes[2].equals(" regular expression") && (matcher = regExpPattern.matcher(annotation.toLowerCase())).find()) {
                --nthHit;
                while (nthHit > 0) {
                    matcher.find();
                    --nthHit;
                }
                position = matcher.start();
            }
        }
        return position;
    }

    private int getTokenNumberForPosition(String annotation, int p) {
        int pos = 0;
        int tokenNr = 0;
        while (pos < p) {
            pos = annotation.indexOf(32, pos) + 1;
            ++tokenNr;
        }
        return tokenNr;
    }

    protected int getHitLength(String annotation, int nthHit, String[] queryModes, String pattern, Pattern regExpPattern, boolean patternNOTMode) {
        if (queryModes[0].equals(" N-gram over annotations")) {
            pattern = this.getLongestNonWildcardPart(pattern);
            regExpPattern = queryModes[1].equals(" case sensitive") ? Pattern.compile(pattern) : Pattern.compile(pattern, 2);
        }
        int length = pattern.length();
        if (patternNOTMode) {
            length = annotation.length();
        } else if (queryModes[0].equals(" N-gram within annotation")) {
            String[] nGrams = this.constructNGramsWithinAnnotation(annotation, pattern, queryModes);
            for (int i = 0; i < nGrams.length; ++i) {
                if (!this.isNGramMatch(nGrams[i], pattern, queryModes) || --nthHit > 0) continue;
                length = nGrams[i].length();
                break;
            }
        } else if (queryModes[2].equals(" regular expression")) {
            Matcher matcher = null;
            matcher = queryModes[1].equals(" case sensitive") ? regExpPattern.matcher(annotation) : regExpPattern.matcher(annotation.toLowerCase());
            if (matcher.find()) {
                --nthHit;
                while (nthHit > 0) {
                    matcher.find();
                    --nthHit;
                }
                length = matcher.end() - matcher.start();
            }
        }
        return length;
    }

    protected String createGlobalTimeConstraintPart() {
        String queryPart = "";
        if (this.beginAfter > 0L) {
            queryPart = queryPart + " AND begin_time > " + this.beginAfter;
        }
        if (this.endBefore > 0L) {
            queryPart = queryPart + " AND end_time < " + this.endBefore;
        }
        return queryPart;
    }

    protected boolean patternHasValidDuration(long smallestBeginTime, long biggestEndTime, Connection con) {
        if (this.minimalDuration <= 0L && this.maximalDuration <= 0L) {
            return true;
        }
        if (smallestBeginTime < 0L || biggestEndTime < 0L) {
            smallestBeginTime = Long.MAX_VALUE;
            biggestEndTime = 0L;
            try {
                if (this.prepStatCheckValidDuration == null) {
                    String queryString = "SELECT begin_time, end_time FROM " + this.schemaName + ".annotations WHERE ann_id = ?";
                    this.prepStatCheckValidDuration = con.prepareStatement(queryString, 1004, 1007);
                }
                for (int i = 0; i < this.nLayers; ++i) {
                    for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                        long endTime;
                        if (this.globalHitAnnId[i][j] == -1) continue;
                        this.prepStatCheckValidDuration.setInt(1, this.globalHitAnnId[i][j]);
                        ResultSet rs = this.prepStatCheckValidDuration.executeQuery();
                        rs.next();
                        long beginTime = this.getValue(rs, 1);
                        if (beginTime < smallestBeginTime) {
                            smallestBeginTime = beginTime;
                        }
                        if ((endTime = this.getValue(rs, 2)) <= biggestEndTime) continue;
                        biggestEndTime = endTime;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        long duration = biggestEndTime - smallestBeginTime;
        if (this.minimalDuration > 0L) {
            if (this.maximalDuration > 0L) {
                return duration >= this.minimalDuration && duration <= this.maximalDuration;
            }
            return duration >= this.minimalDuration;
        }
        return duration <= this.maximalDuration;
    }

    protected void clearHitData(int fileId) {
        try {
            for (int i = 0; i < this.nLayers; ++i) {
                for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                    this.globalHitFileId[i][j] = fileId;
                    this.globalHitAnnId[i][j] = -1;
                    this.globalHitTierId[i][j] = -1;
                }
            }
            this.prepStatCheckValidDuration = null;
            this.prepStatCheckValidDuration = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void rememberHitData(int index) {
        for (int i = 0; i < this.nLayers; ++i) {
            for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                if (this.globalHitAnnId[i][j] == -1) continue;
                this.searchLayers[i].getHitAnnIdsForPattern((int)j)[index] = this.globalHitAnnId[i][j];
                this.searchLayers[i].getHitFileIds()[index] = this.globalHitFileId[i][j];
            }
        }
    }

    protected class ComplexHitData {
        String hitString;
        long beginTime;
        long endTime;

        protected ComplexHitData() {
        }
    }

    protected class FreqInfoComparator
    implements Comparator {
        protected FreqInfoComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            FrequencyInfo info1 = (FrequencyInfo)arg0;
            FrequencyInfo info2 = (FrequencyInfo)arg1;
            if (info1.numberOfHits < info2.numberOfHits) {
                return -1;
            }
            if (info1.numberOfHits > info2.numberOfHits) {
                return 1;
            }
            if (info1.annotation.compareTo(info2.annotation) < 0) {
                return -1;
            }
            return 1;
        }
    }
}

