/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import mpi.annex.search.Constants;
import mpi.annex.search.FrequencyInfo;
import mpi.annex.search.PostgresQuery;
import mpi.annex.search.SearchClient;
import mpi.annex.search.SearchHit;
import mpi.annex.search.SearchStatistics;
import mpi.annex.util.AnnexUtil;
import mpi.corpusstructure.CorpusStructureDB;
import org.apache.log4j.Logger;

public class SearchServlet
extends HttpServlet {
    private static Logger logger = Logger.getLogger("ANNEX.SearchServlet");
    private static int queryIdCounter;
    private HashMap busySavingHits = new HashMap();
    final String UID_ATTRIBUTE = "userid";
    private static final boolean flexMode = true;

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        req.setCharacterEncoding("UTF-8");
        this.doGetFlexRequest(req, res);
    }

    public void doGetFlexRequest(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        HttpSession session = req.getSession();
        String domainId = req.getParameter("domainId");
        String queryId = req.getParameter("queryId");
        String command = req.getParameter("command");
        logger.debug("com = " + command + "  qid = " + queryId + " domId = " + domainId + "  sesId = " + session);
        if (command.equals("saveHitsUTF16CMD") || command.equals("saveFrequencyInfoUTF16CMD")) {
            res.setCharacterEncoding("UTF-16");
        } else {
            res.setCharacterEncoding("UTF-8");
        }
        ServletOutputStream toFlexClient = res.getOutputStream();
        if (command.equals("getConstantsCMD")) {
            toFlexClient.print(this.constructConstantsXML());
        } else if (command.equals("initCMD")) {
            this.initFlexSearch(req, res, domainId, toFlexClient);
        } else if (command.equals("createQueryCMD")) {
            queryId = Integer.toString(queryIdCounter++);
            try {
                PostgresQuery query = AnnexUtil.getSearchClient().createQuery();
                this.setSessionAttribute(session, queryId, domainId, query);
                toFlexClient.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?><queryId value='" + queryId + "'/>");
            }
            catch (Exception e) {
                logger.error("error while creating query object", e);
                toFlexClient.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?><queryId value='-1'/>");
            }
        } else if (command.equals("doQueryCMD")) {
            logger.debug("do query");
            PostgresQuery query = (PostgresQuery)this.getSessionAttribute(req.getSession(), queryId, domainId);
            String domainTypes = req.getParameter("domainTypes");
            ArrayList nodeIds = new ArrayList();
            if (domainTypes.toLowerCase().indexOf("eaf") >= 0) {
                nodeIds.addAll((ArrayList)this.getSessionAttribute(session, "eafNodes", domainId));
            }
            if (domainTypes.toLowerCase().indexOf("chat") >= 0) {
                nodeIds.addAll((ArrayList)this.getSessionAttribute(session, "chatNodes", domainId));
            }
            if (domainTypes.toLowerCase().indexOf("shoebox") >= 0) {
                nodeIds.addAll((ArrayList)this.getSessionAttribute(session, "shoeboxNodes", domainId));
            }
            if (domainTypes.toLowerCase().indexOf("plaintext") >= 0) {
                nodeIds.addAll((ArrayList)this.getSessionAttribute(session, "plainTextNodes", domainId));
            }
            if (domainTypes.toLowerCase().indexOf("xmltext") >= 0) {
                nodeIds.addAll((ArrayList)this.getSessionAttribute(session, "xmlTextNodes", domainId));
            }
            if (domainTypes.toLowerCase().indexOf("htmltext") >= 0) {
                nodeIds.addAll((ArrayList)this.getSessionAttribute(session, "htmlTextNodes", domainId));
            }
            if (domainTypes.toLowerCase().indexOf("csvtext") >= 0) {
                nodeIds.addAll((ArrayList)this.getSessionAttribute(session, "csvTextNodes", domainId));
            }
            String encodedQuery = req.getParameter("encodedQuery");
            query.doQuery(nodeIds, encodedQuery);
        } else if (command.equals("getStatisticsCMD")) {
            PostgresQuery query = (PostgresQuery)this.getSessionAttribute(req.getSession(), queryId, domainId);
            SearchStatistics stats = query.getSearchStatistics();
            toFlexClient.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?><statistics nHits='" + stats.nHits + "' " + "nAnnotationsWithHit='" + stats.nAnnotationsWithHit + "' " + "nAnnotationsSearched='" + stats.nAnnotationsSearched + "' " + "progress='" + stats.progress + "' " + "nFrequencyInfoItems='" + stats.nFrequencyInfoItems + "'/>");
        } else if (command.equals("getViewParametersCMD")) {
            int annId = Integer.parseInt(req.getParameter("annId"));
            PostgresQuery query = (PostgresQuery)this.getSessionAttribute(req.getSession(), queryId, domainId);
            ArrayList parameters = query.getViewerParametersFor(annId, 0);
            toFlexClient.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?><parameters nodeId='" + (String)parameters.get(0) + "' " + "tierName='" + (String)parameters.get(1) + "' " + "beginTime='" + (Long)parameters.get(2) + "' " + "endTime='" + (Long)parameters.get(3) + "'/>");
        } else if (command.equals("getHitsCMD")) {
            int from = Integer.parseInt(req.getParameter("from"));
            int to = Integer.parseInt(req.getParameter("to"));
            int contextSize = Integer.parseInt(req.getParameter("contextSize"));
            PostgresQuery query = (PostgresQuery)this.getSessionAttribute(req.getSession(), queryId, domainId);
            ArrayList hits = query.getHits(from, to, contextSize);
            String result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><hits>";
            for (int i = 0; i < hits.size(); ++i) {
                SearchHit hit = (SearchHit)hits.get(i);
                result = result + this.getHitAsXML(hit);
            }
            result = result + "</hits>";
            toFlexClient.print(result);
        } else if (command.equals("getFreqInfoCMD")) {
            int from = Integer.parseInt(req.getParameter("from"));
            int to = Integer.parseInt(req.getParameter("to"));
            PostgresQuery query = (PostgresQuery)this.getSessionAttribute(req.getSession(), queryId, domainId);
            ArrayList info = query.getFrequencyInfo(from, to);
            String result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><freqInfo>";
            for (int i = 0; i < info.size(); ++i) {
                FrequencyInfo freqInfo = (FrequencyInfo)info.get(i);
                result = result + this.getFreqInfoAsXML(freqInfo);
            }
            result = result + "</freqInfo>";
            toFlexClient.print(result);
        } else if (command.equals("cancelQueryCMD")) {
            logger.debug("cancel");
            PostgresQuery query = (PostgresQuery)this.getSessionAttribute(req.getSession(), queryId, domainId);
            query.cancelQuery();
        } else if (command.equals("checkRegularExpressionCMD")) {
            String regexp = req.getParameter("regexp");
            String mode = req.getParameter("mode");
            String[] queryParts = new String[]{regexp};
            if (mode.equals("split")) {
                queryParts = regexp.split(" ");
            }
            String response = "";
            for (int i = 0; i < queryParts.length; ++i) {
                try {
                    Pattern.compile(queryParts[i]);
                    continue;
                }
                catch (Exception e) {
                    response = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><regexptest valid='false' problem='" + queryParts[i] + "' />";
                }
            }
            if (response.length() < 1) {
                response = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><regexptest valid='true'/>";
            }
            toFlexClient.print(response);
        } else if (command.equals("saveHitsCMD") || command.equals("saveHitsUTF16CMD")) {
            this.busySavingHits.put("" + queryId, "");
            String fileName = req.getParameter("fileName");
            if (fileName == null || fileName.length() < 1) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");
                Date date = new Date();
                fileName = "Hits-" + dateFormat.format(date) + ".txt";
            }
            res.setHeader("content-disposition", "attachment; filename=" + fileName);
            if (command.equals("saveHitsUTF16CMD")) {
                toFlexClient.write(254);
                toFlexClient.write(255);
            } else {
                toFlexClient.write(239);
                toFlexClient.write(187);
                toFlexClient.write(191);
            }
            PostgresQuery query = (PostgresQuery)this.getSessionAttribute(req.getSession(), queryId, domainId);
            SearchStatistics stats = query.getSearchStatistics();
            int nHits = stats.nHits < 100000 ? stats.nHits : 100000;
            ArrayList hitList = query.getHits(0, nHits, 8);
            for (int i = 0; i < hitList.size(); ++i) {
                toFlexClient.print(this.getHitAsTabDelimited((SearchHit)hitList.get(i), i == 0));
                toFlexClient.flush();
            }
            this.busySavingHits.put("" + queryId, null);
        } else if (command.equals("saveFrequencyInfoCMD") || command.equals("saveFrequencyInfoUTF16CMD")) {
            this.busySavingHits.put("" + queryId, "");
            String fileName = req.getParameter("fileName");
            if (fileName == null || fileName.length() < 1) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");
                Date date = new Date();
                fileName = "Frequency-" + dateFormat.format(date) + ".txt";
            }
            res.setHeader("content-disposition", "attachment; filename=" + fileName);
            if (command.equals("saveFrequencyInfoUTF16CMD")) {
                toFlexClient.write(254);
                toFlexClient.write(255);
            } else {
                toFlexClient.write(239);
                toFlexClient.write(187);
                toFlexClient.write(191);
            }
            PostgresQuery query = (PostgresQuery)this.getSessionAttribute(req.getSession(), queryId, domainId);
            SearchStatistics stats = query.getSearchStatistics();
            ArrayList infoList = query.getFrequencyInfo(0, stats.nFrequencyInfoItems);
            for (int i = 0; i < infoList.size(); ++i) {
                toFlexClient.print(this.getInfoAsTabDelimited((FrequencyInfo)infoList.get(i), i == 0, stats));
                toFlexClient.flush();
            }
            this.busySavingHits.put("" + queryId, null);
        } else if (command.equals("busySavingHitsCMD")) {
            do {
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
            } while (this.busySavingHits.get("" + queryId) != null);
        }
        toFlexClient.flush();
        toFlexClient.close();
    }

    private String getInfoAsTabDelimited(FrequencyInfo freqInfo, boolean includeHeader, SearchStatistics stats) {
        String result = "";
        String delimiter = "\t";
        if (includeHeader) {
            result = result + "\"Annotation\"" + delimiter + "\"Percentage\"" + delimiter + "\"Count\"" + delimiter + "\"HitPositionInAnnotation\"" + delimiter + "\"HitLength\"\n";
        }
        double percentage = 100.0 * (double)freqInfo.numberOfHits / (double)stats.nAnnotationsWithHit;
        String fmt = "##0.00";
        DecimalFormat df = new DecimalFormat(fmt);
        String percentageString = df.format(percentage);
        result = result + "\"" + freqInfo.annotation.replaceAll("\"", "\"\"") + "\"" + delimiter;
        result = result + percentageString + delimiter;
        result = result + freqInfo.numberOfHits + delimiter;
        result = result + freqInfo.hitPositionInAnnotation + delimiter;
        result = result + freqInfo.hitLength + "\n";
        return result;
    }

    private String getHitAsTabDelimited(SearchHit hit, boolean includeHeader) {
        String result = "";
        String delimiter = "\t";
        if (hit.tierType.equals("xxxCOMPLEX_QUERY_INDICATORxxx")) {
            String part;
            int n;
            int k;
            String headerString = "";
            String[] layerStrings = hit.annotation.trim().split("xxxLAYER_SPLITTERxxx");
            String[] layerParts = null;
            if (includeHeader) {
                for (k = 1; k < layerStrings.length; ++k) {
                    layerParts = layerStrings[k].trim().split("xxxSAFE_SPLITTERxxx");
                    for (n = 1; n < layerParts.length; ++n) {
                        part = layerParts[n];
                        if (part.charAt(1) == '|') continue;
                        headerString = headerString + "\"Annotation" + k + "-" + n + "\"" + delimiter + "\"Position\"" + delimiter + "\"Begin Time\"" + delimiter + "\"End Time\"" + delimiter;
                    }
                }
                headerString = headerString + "\"TranscriptionName\"";
                result = result + headerString + "\n\n";
            }
            layerStrings = hit.annotation.trim().split("xxxLAYER_SPLITTERxxx");
            for (k = 1; k < layerStrings.length; ++k) {
                layerParts = layerStrings[k].trim().split("xxxSAFE_SPLITTERxxx");
                for (n = 1; n < layerParts.length; ++n) {
                    part = layerParts[n];
                    if (part.charAt(1) == '|') continue;
                    String[] patternParts = part.split("xxxNUMBER_SPLITTERxxx");
                    String annotation = patternParts[0].substring(1, patternParts[0].length() - 1);
                    int position = Integer.parseInt(patternParts[1]);
                    long beginTime = Long.parseLong(patternParts[2]);
                    long endTime = Long.parseLong(patternParts[3]);
                    result = result + annotation + delimiter;
                    result = result + position + delimiter;
                    result = result + beginTime + delimiter;
                    result = result + endTime + delimiter;
                }
            }
            result = result + hit.transcriptionName + "\n";
        } else {
            int k;
            if (includeHeader) {
                result = result + "\"Annotation\"" + delimiter + "\"HitPositionInAnnotation\"" + delimiter + "\"HitLength\"" + delimiter + "\"HitNumberInAnnotation\"" + delimiter + "\"AnnotationBeginTime\"" + delimiter + "\"AnnotationEndTime\"" + delimiter + "\"HitPositionInTier\"" + delimiter + "\"TierName\"" + delimiter + "\"TierType\"" + delimiter + "\"LeftContext\"" + delimiter + "\"RightContext\"" + delimiter + "\"TranscriptionName\"\n\n";
            }
            result = result + "\"" + hit.annotation.replaceAll("\"", "\"\"") + "\"" + delimiter;
            result = result + (hit.hitPositionInAnnotation + 1) + delimiter;
            result = result + hit.hitLength + delimiter;
            result = result + hit.hitNumberInAnnotation + delimiter;
            result = result + hit.beginTime + delimiter;
            result = result + hit.endTime + delimiter;
            result = result + hit.positionInTier + delimiter;
            result = result + "\"" + hit.tierName.replaceAll("\"", "\"\"") + "\"" + delimiter;
            result = result + "\"" + hit.tierType.replaceAll("\"", "\"\"") + "\"" + delimiter;
            if (hit.leftContext.size() > 0) {
                String leftContext = (String)hit.leftContext.get(0);
                for (k = 1; k < hit.leftContext.size(); ++k) {
                    leftContext = (String)hit.leftContext.get(k) + "  " + leftContext;
                }
                result = result + "\"" + leftContext.replaceAll("\"", "\"\"") + "\"" + delimiter;
            } else {
                result = result + "\"\"" + delimiter;
            }
            if (hit.rightContext.size() > 0) {
                String rightContext = (String)hit.rightContext.get(0);
                for (k = 1; k < hit.rightContext.size(); ++k) {
                    rightContext = rightContext + "  " + (String)hit.rightContext.get(k);
                }
                result = result + "\"" + rightContext.replaceAll("\"", "\"\"") + "\"" + delimiter;
            } else {
                result = result + "\"\"" + delimiter;
            }
            result = result + hit.transcriptionName + "\n";
        }
        return result;
    }

    private String getHitAsXML(SearchHit hit) {
        int i;
        String xml = "\n<hit>";
        xml = xml + "<annotation>" + this.escapeXML(hit.annotation) + "</annotation>\n";
        xml = xml + "<aligned>" + hit.aligned + "</aligned>\n";
        xml = xml + "<beginTime>" + hit.beginTime + "</beginTime>\n";
        xml = xml + "<endTime>" + hit.endTime + "</endTime>\n";
        xml = xml + "<hitLength>" + hit.hitLength + "</hitLength>\n";
        xml = xml + "<hitNumberInAnnotation>" + hit.hitNumberInAnnotation + "</hitNumberInAnnotation>\n";
        xml = xml + "<hitPositionInAnnotation>" + hit.hitPositionInAnnotation + "</hitPositionInAnnotation>\n";
        xml = xml + "<positionInTier>" + hit.positionInTier + "</positionInTier>\n";
        xml = xml + "<tierName>" + this.escapeXML(hit.tierName) + "</tierName>\n";
        xml = xml + "<tierType>" + this.escapeXML(hit.tierType) + "</tierType>\n";
        xml = xml + "<participant>" + this.escapeXML(hit.participant) + "</participant>\n";
        xml = xml + "<transcriptionNodeId>" + hit.transcriptionNodeId + "</transcriptionNodeId>\n";
        xml = xml + "<transcriptionName>" + this.escapeXML(hit.transcriptionName) + "</transcriptionName>\n";
        xml = xml + "<leftContext>";
        String beforeString = "";
        for (i = 0; i < hit.leftContext.size(); ++i) {
            beforeString = (String)hit.leftContext.get(i) + "  " + beforeString;
        }
        xml = xml + this.escapeXML(beforeString.trim()) + "</leftContext>\n";
        xml = xml + "<rightContext>";
        for (i = 0; i < hit.rightContext.size(); ++i) {
            xml = xml + this.escapeXML((String)hit.rightContext.get(i)) + " ";
        }
        xml = xml + "</rightContext>\n";
        xml = xml + "</hit>\n";
        return xml;
    }

    private String getFreqInfoAsXML(FrequencyInfo info) {
        String xml = "<hit>";
        xml = xml + "<annotation>" + this.escapeXML(info.annotation) + "</annotation>";
        xml = xml + "<occurences>" + info.nOccurences + "</occurences>";
        xml = xml + "<numberOfHits>" + info.numberOfHits + "</numberOfHits>";
        xml = xml + "<hitPositionInAnnotation>" + info.hitPositionInAnnotation + "</hitPositionInAnnotation>";
        xml = xml + "<hitLength>" + info.hitLength + "</hitLength>";
        xml = xml + "<annId>" + info.annId + "</annId>";
        xml = xml + "<fileIndex>" + info.fileIndex + "</fileIndex>";
        return xml + "</hit>\n";
    }

    private String escapeXML(String str) {
        if (str != null) {
            return str.replaceAll("\n", "").replaceAll("\r", "").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        }
        return "";
    }

    private void initFlexSearch(HttpServletRequest req, HttpServletResponse res, String domainId, ServletOutputStream toFlexClient) throws IOException, ServletException {
        try {
            HttpSession session = req.getSession();
            String userId = (String)session.getAttribute("userid");
            PostgresQuery query = AnnexUtil.getSearchClient().createQuery();
            this.setSessionAttribute(session, "query", domainId, query);
            ArrayList topNodes = (ArrayList)this.getSessionAttribute(session, "domainTopNodes", domainId);
            HashSet<String> uniqueTopNodeNames = new HashSet<String>();
            String topNodeNames = "";
            int maxVisibleNodeNames = 7;
            for (int i = 0; i < topNodes.size() && uniqueTopNodeNames.size() < maxVisibleNodeNames; ++i) {
                String nodeName = AnnexUtil.getNameFor((String)topNodes.get(i));
                if (uniqueTopNodeNames.contains(nodeName)) continue;
                topNodeNames = topNodeNames + ", " + nodeName;
                uniqueTopNodeNames.add(nodeName);
            }
            topNodeNames = topNodeNames.substring(2);
            if (topNodes.size() > maxVisibleNodeNames) {
                topNodeNames = topNodeNames + ", ...";
            }
            ArrayList domainNodes = this.getUserDomain(topNodes, userId);
            this.setSessionAttribute(session, "domainNodes", domainId, domainNodes);
            ArrayList eafNodes = this.keepIndexedNodes(domainNodes, 0);
            this.setSessionAttribute(session, "eafNodes", domainId, eafNodes);
            ArrayList chatNodes = this.keepIndexedNodes(domainNodes, 1);
            this.setSessionAttribute(session, "chatNodes", domainId, chatNodes);
            ArrayList shoeboxNodes = this.keepIndexedNodes(domainNodes, 2);
            this.setSessionAttribute(session, "shoeboxNodes", domainId, shoeboxNodes);
            ArrayList plainTextNodes = this.keepIndexedNodes(domainNodes, 3);
            this.setSessionAttribute(session, "plainTextNodes", domainId, plainTextNodes);
            ArrayList xmlTextNodes = this.keepIndexedNodes(domainNodes, 5);
            this.setSessionAttribute(session, "xmlTextNodes", domainId, xmlTextNodes);
            ArrayList htmlTextNodes = this.keepIndexedNodes(domainNodes, 4);
            this.setSessionAttribute(session, "htmlTextNodes", domainId, htmlTextNodes);
            ArrayList csvTextNodes = this.keepIndexedNodes(domainNodes, 6);
            this.setSessionAttribute(session, "csvTextNodes", domainId, csvTextNodes);
            toFlexClient.print("<topNodeNames>" + topNodeNames + "</topNodeNames>" + "<eafSize>" + eafNodes.size() + "</eafSize>" + "<chatSize>" + chatNodes.size() + "</chatSize>" + "<shoeboxSize>" + shoeboxNodes.size() + "</shoeboxSize>" + "<plainTextSize>" + plainTextNodes.size() + "</plainTextSize>" + "<xmlTextSize>" + xmlTextNodes.size() + "</xmlTextSize>" + "<htmlTextSize>" + htmlTextNodes.size() + "</htmlTextSize>" + "<csvTextSize>" + csvTextNodes.size() + "</csvTextSize>");
            ResultSet rs = AnnexUtil.getSearchClient().executeSQLQuery("select node_id, tier_name, tier_type, participant from search.tiers");
            HashSet eafTierNames = new HashSet();
            HashSet eafTierTypes = new HashSet();
            HashSet eafParticipants = new HashSet();
            this.getNameAndTypeInfoFor(rs, eafNodes, eafTierNames, eafTierTypes, eafParticipants);
            this.sendXMLArray("eafTierNames", eafTierNames, toFlexClient);
            this.sendXMLArray("eafTierTypes", eafTierTypes, toFlexClient);
            this.sendXMLArray("eafParticipants", eafParticipants, toFlexClient);
            HashSet chatTierNames = new HashSet();
            HashSet chatTierTypes = new HashSet();
            HashSet chatParticipants = new HashSet();
            this.getNameAndTypeInfoFor(rs, chatNodes, chatTierNames, chatTierTypes, chatParticipants);
            this.sendXMLArray("chatTierNames", chatTierNames, toFlexClient);
            this.sendXMLArray("chatTierTypes", chatTierTypes, toFlexClient);
            this.sendXMLArray("chatParticipants", chatParticipants, toFlexClient);
            HashSet shoeboxTierNames = new HashSet();
            HashSet shoeboxTierTypes = new HashSet();
            HashSet shoeboxParticipants = new HashSet();
            this.getNameAndTypeInfoFor(rs, shoeboxNodes, shoeboxTierNames, shoeboxTierTypes, shoeboxParticipants);
            this.sendXMLArray("shoeboxTierNames", shoeboxTierNames, toFlexClient);
            this.sendXMLArray("shoeboxTierTypes", shoeboxTierTypes, toFlexClient);
            this.sendXMLArray("shoeboxParticipants", shoeboxParticipants, toFlexClient);
            HashSet plainTextTierNames = new HashSet();
            HashSet plainTextTierTypes = new HashSet();
            HashSet plainTextParticipants = new HashSet();
            this.getNameAndTypeInfoFor(rs, plainTextNodes, plainTextTierNames, plainTextTierTypes, plainTextParticipants);
            this.sendXMLArray("plainTextTierNames", plainTextTierNames, toFlexClient);
            this.sendXMLArray("plainTextTierTypes", plainTextTierTypes, toFlexClient);
            this.sendXMLArray("plainTextParticipants", plainTextParticipants, toFlexClient);
            HashSet xmlTextTierNames = new HashSet();
            HashSet xmlTextTierTypes = new HashSet();
            HashSet xmlTextParticipants = new HashSet();
            this.getNameAndTypeInfoFor(rs, xmlTextNodes, xmlTextTierNames, xmlTextTierTypes, xmlTextParticipants);
            this.sendXMLArray("xmlTextTierNames", xmlTextTierNames, toFlexClient);
            this.sendXMLArray("xmlTextTierTypes", xmlTextTierTypes, toFlexClient);
            this.sendXMLArray("xmlTextParticipants", xmlTextParticipants, toFlexClient);
            HashSet htmlTextTierNames = new HashSet();
            HashSet htmlTextTierTypes = new HashSet();
            HashSet htmlTextParticipants = new HashSet();
            this.getNameAndTypeInfoFor(rs, htmlTextNodes, htmlTextTierNames, htmlTextTierTypes, htmlTextParticipants);
            this.sendXMLArray("htmlTextTierNames", htmlTextTierNames, toFlexClient);
            this.sendXMLArray("htmlTextTierTypes", htmlTextTierTypes, toFlexClient);
            this.sendXMLArray("htmlTextParticipants", htmlTextParticipants, toFlexClient);
            HashSet csvTextTierNames = new HashSet();
            HashSet csvTextTierTypes = new HashSet();
            HashSet csvTextParticipants = new HashSet();
            this.getNameAndTypeInfoFor(rs, csvTextNodes, csvTextTierNames, csvTextTierTypes, csvTextParticipants);
            this.sendXMLArray("csvTextTierNames", csvTextTierNames, toFlexClient);
            this.sendXMLArray("csvTextTierTypes", csvTextTierTypes, toFlexClient);
            this.sendXMLArray("csvTextParticipants", csvTextParticipants, toFlexClient);
            String targetModes = "<targetModes>";
            for (int i = 0; i < Constants.targetModes.length; ++i) {
                targetModes = targetModes + "<item>" + Constants.targetModes[i] + "</item>";
            }
            targetModes = targetModes + "</targetModes>";
            toFlexClient.print(targetModes);
            String caseModes = "<caseModes>";
            for (int i = 0; i < Constants.caseModes.length; ++i) {
                caseModes = caseModes + "<item>" + Constants.caseModes[i] + "</item>";
            }
            caseModes = caseModes + "</caseModes>";
            toFlexClient.print(caseModes);
            String matchModes = "<matchModes>";
            for (int i = 0; i < Constants.matchModes.length; ++i) {
                matchModes = matchModes + "<item>" + Constants.matchModes[i] + "</item>";
            }
            matchModes = matchModes + "</matchModes>";
            toFlexClient.print(matchModes);
            toFlexClient.flush();
            toFlexClient.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendXMLArray(String resultTag, HashSet items, ServletOutputStream toFlexClient) throws IOException {
        String result = "<" + resultTag + ">";
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            result = result + "<item>" + this.escapeXML((String)iter.next()) + "</item>";
        }
        StringBuilder stringBuilder = new StringBuilder().append(result);
        result = "</" + resultTag + ">";
        result = stringBuilder.append(result).toString();
        toFlexClient.print(result);
    }

    private String constructConstantsXML() {
        return "<INIT_CMD>initCMD</INIT_CMD><CREATE_QUERY_CMD>createQueryCMD</CREATE_QUERY_CMD><GET_HITS_CMD>getHitsCMD</GET_HITS_CMD><GET_FREQ_INFO_CMD>getFreqInfoCMD</GET_FREQ_INFO_CMD><GET_VIEW_PARAMETERS_CMD>getViewParametersCMD</GET_VIEW_PARAMETERS_CMD><GET_STATISTICS_CMD>getStatisticsCMD</GET_STATISTICS_CMD><SET_DOMAIN_CMD>setDomainCMD</SET_DOMAIN_CMD><DO_QUERY_CMD>doQueryCMD</DO_QUERY_CMD><CANCEL_QUERY_CMD>cancelQueryCMD</CANCEL_QUERY_CMD><PUT_PERSISTENT_CMD>putPersistentCMD</PUT_PERSISTENT_CMD><GET_PERSISTENT_CMD>getPersistentMD</GET_PERSISTENT_CMD><DELETE_PERSISTENT_CMD>deletePersistentCMD</DELETE_PERSISTENT_CMD><SAVE_HITS_UTF16_CMD>saveHitsUTF16CMD</SAVE_HITS_UTF16_CMD><SAVE_HITS_CMD>saveHitsCMD</SAVE_HITS_CMD><BUSY_SAVING_HITS_CMD>busySavingHitsCMD</BUSY_SAVING_HITS_CMD><SAVE_FREQUENCY_INFO_UTF16_CMD>saveFrequencyInfoUTF16CMD</SAVE_FREQUENCY_INFO_UTF16_CMD><SAVE_FREQUENCY_INFO_CMD>saveFrequencyInfoCMD</SAVE_FREQUENCY_INFO_CMD><CHECK_REGEXP_CMD>checkRegularExpressionCMD</CHECK_REGEXP_CMD><MAX_HITS_TO_BE_VIEWED_OR_SAVED>100000</MAX_HITS_TO_BE_VIEWED_OR_SAVED><MAX_FREQUENCY_ITEMS>100000</MAX_FREQUENCY_ITEMS><SAFE_SPLITTER>xxxSAFE_SPLITTERxxx</SAFE_SPLITTER><MODE_SPLITTER>xxxMODE_SPLITTERxxx</MODE_SPLITTER><LAYER_SPLITTER>xxxLAYER_SPLITTERxxx</LAYER_SPLITTER><NUMBER_SPLITTER>xxxNUMBER_SPLITTERxxx</NUMBER_SPLITTER><ANNOTATIONS> Annotation</ANNOTATIONS><CASE_INSENSITIVE> case insensitive</CASE_INSENSITIVE><SUBSTRING_MATCH> substring match</SUBSTRING_MATCH><SINGLE_TIER_HISTORY_KEY>singleTierHistory</SINGLE_TIER_HISTORY_KEY><MULTIPLE_TIER_HISTORY_KEY>multipleTierHistory</MULTIPLE_TIER_HISTORY_KEY><MAX_TIER_NAMES>300</MAX_TIER_NAMES><MAX_TIER_TYPES>300</MAX_TIER_TYPES><MAX_PARTICIPANTS>300</MAX_PARTICIPANTS><N_GRAMS_OVER_ANNOTATIONS> N-gram over annotations</N_GRAMS_OVER_ANNOTATIONS><N_GRAMS_WITHIN_ANNOTATIONS> N-gram within annotation</N_GRAMS_WITHIN_ANNOTATIONS><CASE_SENSITIVE> case sensitive</CASE_SENSITIVE><EXACT_MATCH> exact match</EXACT_MATCH><REGEXP_MATCH> regular expression</REGEXP_MATCH><ALL_TIERS_LABEL> All Tiers </ALL_TIERS_LABEL><TIER_TYPE_LABEL> Tier Type: </TIER_TYPE_LABEL><TIER_NAME_LABEL> Tier Name: </TIER_NAME_LABEL><TIER_PARTICIPANT_LABEL> Participant: </TIER_PARTICIPANT_LABEL><NULL_STRING>xxxNULL_STRINGxxx</NULL_STRING><N_GRAM_WILDCARD>#</N_GRAM_WILDCARD><CONSTRAINT_SPLITTER>:</CONSTRAINT_SPLITTER><UNDEFINED_CONSTRAINT>XXXX</UNDEFINED_CONSTRAINT><CONSTRAINT_NONE>cns none</CONSTRAINT_NONE><CONSTRAINT_POSITION_EQUAL>cns an=:</CONSTRAINT_POSITION_EQUAL><CONSTRAINT_POSITION_MORE>cns an+:</CONSTRAINT_POSITION_MORE><CONSTRAINT_POSITION_LESS>cns an-:</CONSTRAINT_POSITION_LESS><CONSTRAINT_TIME_EQUAL>cns ms=:</CONSTRAINT_TIME_EQUAL><CONSTRAINT_TIME_MORE>cns ms+:</CONSTRAINT_TIME_MORE><CONSTRAINT_TIME_LESS>cns ms-:</CONSTRAINT_TIME_LESS><CONSTRAINT_ALIGNED>cns aligned</CONSTRAINT_ALIGNED><CONSTRAINT_OVERLAP>cns overlap</CONSTRAINT_OVERLAP><CONSTRAINT_LEFT_OVERLAP>cns l overlap</CONSTRAINT_LEFT_OVERLAP><CONSTRAINT_RIGHT_OVERLAP>cns r overlap</CONSTRAINT_RIGHT_OVERLAP><CONSTRAINT_SURROUNDING>cns surrounding</CONSTRAINT_SURROUNDING><CONSTRAINT_WITHIN>cns within</CONSTRAINT_WITHIN><CONSTRAINT_NO_OVERLAP>cns no overlap</CONSTRAINT_NO_OVERLAP><CONSTRAINT_BEGIN_BEGIN_EQUAL>cns bb=:</CONSTRAINT_BEGIN_BEGIN_EQUAL><CONSTRAINT_BEGIN_BEGIN_MORE>cns bb+:</CONSTRAINT_BEGIN_BEGIN_MORE><CONSTRAINT_BEGIN_BEGIN_LESS>cns bb-:</CONSTRAINT_BEGIN_BEGIN_LESS><CONSTRAINT_BEGIN_END_EQUAL>cns be=:</CONSTRAINT_BEGIN_END_EQUAL><CONSTRAINT_BEGIN_END_MORE>cns be+:</CONSTRAINT_BEGIN_END_MORE><CONSTRAINT_BEGIN_END_LESS>cns be-:</CONSTRAINT_BEGIN_END_LESS><CONSTRAINT_END_BEGIN_EQUAL>cns eb=:</CONSTRAINT_END_BEGIN_EQUAL><CONSTRAINT_END_BEGIN_MORE>cns eb+:</CONSTRAINT_END_BEGIN_MORE><CONSTRAINT_END_BEGIN_LESS>cns eb-:</CONSTRAINT_END_BEGIN_LESS><CONSTRAINT_END_END_EQUAL>cns ee=:</CONSTRAINT_END_END_EQUAL><CONSTRAINT_END_END_MORE>cns ee+:</CONSTRAINT_END_END_MORE><CONSTRAINT_END_END_LESS>cns ee-:</CONSTRAINT_END_END_LESS><COMPLEX_QUERY_INDICATOR>xxxCOMPLEX_QUERY_INDICATORxxx</COMPLEX_QUERY_INDICATOR>";
    }

    private ArrayList getUserDomain(ArrayList domainNodes, String userId) {
        String[] types = SearchClient.getSearchableFormats();
        CorpusStructureDB csdb = AnnexUtil.getCorpusStructureDB();
        HashSet<String> nodeIds = new HashSet<String>();
        for (int i = 0; i < domainNodes.size(); ++i) {
            String nodeId = (String)domainNodes.get(i);
            if (csdb.getNode(nodeId).getNodeType() == 8) {
                if (!AnnexUtil.hasAccessTo(userId, nodeId)) continue;
                nodeIds.add(nodeId);
                continue;
            }
            String[] desc = csdb.getDescendants(nodeId, 8, types, userId, false);
            for (int j = 0; j < desc.length; ++j) {
                nodeIds.add(desc[j]);
            }
        }
        return new ArrayList(nodeIds);
    }

    private ArrayList keepIndexedNodes(ArrayList nodeIds, int type) {
        ArrayList filteredNodes = new ArrayList();
        try {
            HashSet<String> ingestedNodes = new HashSet<String>();
            String query = "select node_id from search.tiers where transcription_type = " + type;
            ResultSet rs = AnnexUtil.getSearchClient().executeSQLQuery(query);
            while (rs.next()) {
                String nodeId = rs.getString(1);
                ingestedNodes.add(nodeId);
            }
            for (int i = 0; i < nodeIds.size(); ++i) {
                if (!ingestedNodes.contains(nodeIds.get(i))) continue;
                filteredNodes.add(nodeIds.get(i));
            }
        }
        catch (Exception e) {
            logger.error("keepIndexedNodes", e);
        }
        return filteredNodes;
    }

    private void getNameAndTypeInfoFor(ResultSet rs, ArrayList nodeIds, HashSet tierNames, HashSet tierTypes, HashSet participants) {
        HashSet nodeIdSet = new HashSet(nodeIds);
        tierNames.clear();
        tierTypes.clear();
        participants.clear();
        if (rs == null) {
            return;
        }
        try {
            boolean n = false;
            rs.beforeFirst();
            while (rs.next()) {
                String participant;
                String tierType;
                String nodeId = rs.getString(1);
                if (!nodeIdSet.contains(nodeId)) continue;
                String tierName = rs.getString(2);
                if (tierName != null && tierName.length() > 0) {
                    tierNames.add(tierName);
                }
                if ((tierType = rs.getString(3)) != null && tierType.length() > 0) {
                    tierTypes.add(tierType);
                }
                if ((participant = rs.getString(4)) == null || participant.length() <= 0) continue;
                participants.add(participant);
            }
            if (tierNames.size() > 300) {
                tierNames.clear();
            }
            if (tierTypes.size() > 300) {
                tierTypes.clear();
            }
            if (participants.size() > 300) {
                participants.clear();
            }
        }
        catch (Exception e) {
            logger.error("getNameAndTypeInfoFor", e);
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doGet(req, res);
    }

    public void doGetAppletRequest(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        req.setCharacterEncoding("UTF-8");
        res.setCharacterEncoding("UTF-8");
        HttpSession session = req.getSession();
        BufferedReader fromApplet = req.getReader();
        String domainId = fromApplet.readLine();
        String queryId = fromApplet.readLine();
        String command = fromApplet.readLine();
        if (!command.equals("getStatisticsCMD")) {
            // empty if block
        }
        PrintWriter toApplet = res.getWriter();
        if (command.equals("initCMD")) {
            this.initSearch(req, res, domainId);
        } else if (command.equals("putPersistentCMD")) {
            String key = fromApplet.readLine();
            String value = fromApplet.readLine();
            String userId = (String)session.getAttribute("userid");
            logger.debug("key: " + key);
            logger.debug("value part: " + value.substring(0, 40));
            logger.debug("value size: " + value.length());
        } else if (command.equals("getPersistentMD")) {
            String key = fromApplet.readLine();
            String userId = (String)session.getAttribute("userid");
            toApplet.println("xxxNULL_STRINGxxx");
        } else if (command.equals("deletePersistentCMD")) {
            String key = fromApplet.readLine();
            String userId = (String)session.getAttribute("userid");
        } else if (command.equals("createQueryCMD")) {
            queryId = Integer.toString(queryIdCounter++);
            try {
                PostgresQuery query = AnnexUtil.getSearchClient().createQuery();
                this.setSessionAttribute(session, queryId, domainId, query);
            }
            catch (Exception e) {
                logger.error("error while creating query object", e);
            }
            toApplet.println(queryId);
        } else if (command.equals("getHitsCMD")) {
            int from = Integer.parseInt(fromApplet.readLine());
            int to = Integer.parseInt(fromApplet.readLine());
            int contextSize = Integer.parseInt(fromApplet.readLine());
            PostgresQuery query = (PostgresQuery)this.getSessionAttribute(req.getSession(), queryId, domainId);
            ArrayList hits = query.getHits(from, to, contextSize);
            toApplet.println(hits.size());
            for (int i = 0; i < hits.size(); ++i) {
                this.sendHit((SearchHit)hits.get(i), toApplet);
            }
        } else if (command.equals("getFreqInfoCMD")) {
            int from = Integer.parseInt(fromApplet.readLine());
            int to = Integer.parseInt(fromApplet.readLine());
            PostgresQuery query = (PostgresQuery)this.getSessionAttribute(req.getSession(), queryId, domainId);
            ArrayList info = query.getFrequencyInfo(from, to);
            toApplet.println(info.size());
            for (int i = 0; i < info.size(); ++i) {
                this.sendFrequencyInfo((FrequencyInfo)info.get(i), toApplet);
            }
        } else if (command.equals("getViewParametersCMD")) {
            int annId = Integer.parseInt(fromApplet.readLine());
            PostgresQuery query = (PostgresQuery)this.getSessionAttribute(req.getSession(), queryId, domainId);
            ArrayList parameters = query.getViewerParametersFor(annId, 0);
            toApplet.println(4);
            toApplet.println((String)parameters.get(0));
            toApplet.println((String)parameters.get(1));
            toApplet.println((Long)parameters.get(2));
            toApplet.println((Long)parameters.get(3));
        } else if (command.equals("getStatisticsCMD")) {
            PostgresQuery query = (PostgresQuery)this.getSessionAttribute(req.getSession(), queryId, domainId);
            SearchStatistics stats = query.getSearchStatistics();
            toApplet.println(5);
            toApplet.println(stats.nHits);
            toApplet.println(stats.nAnnotationsWithHit);
            toApplet.println(stats.nAnnotationsSearched);
            toApplet.println(stats.progress);
            toApplet.println(stats.nFrequencyInfoItems);
        } else if (command.equals("doQueryCMD")) {
            PostgresQuery query = (PostgresQuery)this.getSessionAttribute(req.getSession(), queryId, domainId);
            String domainTypes = fromApplet.readLine();
            ArrayList nodeIds = new ArrayList();
            if (domainTypes.toLowerCase().indexOf("eaf") >= 0) {
                nodeIds.addAll((ArrayList)this.getSessionAttribute(session, "eafNodes", domainId));
            }
            if (domainTypes.toLowerCase().indexOf("chat") >= 0) {
                nodeIds.addAll((ArrayList)this.getSessionAttribute(session, "chatNodes", domainId));
            }
            if (domainTypes.toLowerCase().indexOf("shoebox") >= 0) {
                nodeIds.addAll((ArrayList)this.getSessionAttribute(session, "shoeboxNodes", domainId));
            }
            if (domainTypes.toLowerCase().indexOf("plaintext") >= 0) {
                nodeIds.addAll((ArrayList)this.getSessionAttribute(session, "plainTextNodes", domainId));
            }
            if (domainTypes.toLowerCase().indexOf("xmltext") >= 0) {
                nodeIds.addAll((ArrayList)this.getSessionAttribute(session, "xmlTextNodes", domainId));
            }
            if (domainTypes.toLowerCase().indexOf("htmltext") >= 0) {
                nodeIds.addAll((ArrayList)this.getSessionAttribute(session, "htmlTextNodes", domainId));
            }
            if (domainTypes.toLowerCase().indexOf("csvtext") >= 0) {
                nodeIds.addAll((ArrayList)this.getSessionAttribute(session, "csvTextNodes", domainId));
            }
            String encodedQuery = fromApplet.readLine();
            query.doQuery(nodeIds, encodedQuery);
            toApplet.println(0);
        } else if (command.equals("cancelQueryCMD")) {
            PostgresQuery query = (PostgresQuery)this.getSessionAttribute(req.getSession(), queryId, domainId);
            query.cancelQuery();
            toApplet.println(0);
        }
        toApplet.flush();
        toApplet.close();
        fromApplet.close();
    }

    private void sendHit(SearchHit hit, PrintWriter toApplet) {
        int i;
        toApplet.println(13);
        toApplet.println(hit.annotation.replaceAll("\n", "").replaceAll("\r", ""));
        toApplet.println(hit.aligned);
        toApplet.println(hit.beginTime);
        toApplet.println(hit.endTime);
        toApplet.println(hit.hitLength);
        toApplet.println(hit.hitNumberInAnnotation);
        toApplet.println(hit.hitPositionInAnnotation);
        toApplet.println(hit.positionInTier);
        toApplet.println(hit.tierName);
        toApplet.println(hit.tierType);
        toApplet.println(hit.participant);
        toApplet.println(hit.transcriptionNodeId);
        toApplet.println(hit.transcriptionName);
        toApplet.println(hit.leftContext.size());
        for (i = 0; i < hit.leftContext.size(); ++i) {
            toApplet.println(((String)hit.leftContext.get(i)).replaceAll("\n", "").replaceAll("\r", ""));
        }
        toApplet.println(hit.rightContext.size());
        for (i = 0; i < hit.rightContext.size(); ++i) {
            toApplet.println(((String)hit.rightContext.get(i)).replaceAll("\n", "").replaceAll("\r", ""));
        }
    }

    private void sendFrequencyInfo(FrequencyInfo info, PrintWriter toApplet) {
        toApplet.println(7);
        toApplet.println(info.nOccurences);
        toApplet.println(info.annotation.replaceAll("\n", "").replaceAll("\r", ""));
        toApplet.println(info.numberOfHits);
        toApplet.println(info.hitPositionInAnnotation);
        toApplet.println(info.hitLength);
        toApplet.println(info.annId);
        toApplet.println(info.fileIndex);
    }

    private void initSearch(HttpServletRequest req, HttpServletResponse res, String domainId) throws IOException, ServletException {
        try {
            HttpSession session = req.getSession();
            String userId = (String)session.getAttribute("userid");
            logger.debug("got userid: " + userId);
            PrintWriter toApplet = res.getWriter();
            ArrayList topNodes = (ArrayList)this.getSessionAttribute(session, "domainTopNodes", domainId);
            HashSet<String> uniqueTopNodeNames = new HashSet<String>();
            String topNodeNames = "";
            int maxVisibleNodeNames = 7;
            for (int i = 0; i < topNodes.size() && uniqueTopNodeNames.size() < maxVisibleNodeNames; ++i) {
                String nodeName = AnnexUtil.getNameFor((String)topNodes.get(i));
                if (uniqueTopNodeNames.contains(nodeName)) continue;
                topNodeNames = topNodeNames + ", " + nodeName;
                uniqueTopNodeNames.add(nodeName);
            }
            topNodeNames = topNodeNames.substring(2);
            if (topNodes.size() > maxVisibleNodeNames) {
                topNodeNames = topNodeNames + ", ...";
            }
            toApplet.println(topNodeNames);
            ArrayList domainNodes = this.getUserDomain(topNodes, userId);
            this.setSessionAttribute(session, "domainNodes", domainId, domainNodes);
            ArrayList eafNodes = this.keepIndexedNodes(domainNodes, 0);
            this.setSessionAttribute(session, "eafNodes", domainId, eafNodes);
            ArrayList chatNodes = this.keepIndexedNodes(domainNodes, 1);
            this.setSessionAttribute(session, "chatNodes", domainId, chatNodes);
            ArrayList shoeboxNodes = this.keepIndexedNodes(domainNodes, 2);
            this.setSessionAttribute(session, "shoeboxNodes", domainId, shoeboxNodes);
            ArrayList plainTextNodes = this.keepIndexedNodes(domainNodes, 3);
            this.setSessionAttribute(session, "plainTextNodes", domainId, plainTextNodes);
            ArrayList xmlTextNodes = this.keepIndexedNodes(domainNodes, 5);
            this.setSessionAttribute(session, "xmlTextNodes", domainId, xmlTextNodes);
            ArrayList htmlTextNodes = this.keepIndexedNodes(domainNodes, 4);
            this.setSessionAttribute(session, "htmlTextNodes", domainId, htmlTextNodes);
            ArrayList csvTextNodes = this.keepIndexedNodes(domainNodes, 6);
            this.setSessionAttribute(session, "csvTextNodes", domainId, csvTextNodes);
            toApplet.println(eafNodes.size());
            toApplet.println(chatNodes.size());
            toApplet.println(shoeboxNodes.size());
            toApplet.println(plainTextNodes.size());
            toApplet.println(xmlTextNodes.size());
            toApplet.println(htmlTextNodes.size());
            toApplet.println(csvTextNodes.size());
            ResultSet rs = AnnexUtil.getSearchClient().executeSQLQuery("select node_id, tier_name, tier_type, participant from search.tiers");
            HashSet eafTierNames = new HashSet();
            HashSet eafTierTypes = new HashSet();
            HashSet eafParticipants = new HashSet();
            this.getNameAndTypeInfoFor(rs, eafNodes, eafTierNames, eafTierTypes, eafParticipants);
            this.sendLinesToApplet(new ArrayList(eafTierNames), toApplet);
            this.sendLinesToApplet(new ArrayList(eafTierTypes), toApplet);
            this.sendLinesToApplet(new ArrayList(eafParticipants), toApplet);
            HashSet chatTierNames = new HashSet();
            HashSet chatTierTypes = new HashSet();
            HashSet chatParticipants = new HashSet();
            this.getNameAndTypeInfoFor(rs, chatNodes, chatTierNames, chatTierTypes, chatParticipants);
            this.sendLinesToApplet(new ArrayList(chatTierNames), toApplet);
            this.sendLinesToApplet(new ArrayList(chatTierTypes), toApplet);
            this.sendLinesToApplet(new ArrayList(chatParticipants), toApplet);
            HashSet shoeboxTierNames = new HashSet();
            HashSet shoeboxTierTypes = new HashSet();
            HashSet shoeboxParticipants = new HashSet();
            this.getNameAndTypeInfoFor(rs, shoeboxNodes, shoeboxTierNames, shoeboxTierTypes, shoeboxParticipants);
            this.sendLinesToApplet(new ArrayList(shoeboxTierNames), toApplet);
            this.sendLinesToApplet(new ArrayList(shoeboxTierTypes), toApplet);
            this.sendLinesToApplet(new ArrayList(shoeboxParticipants), toApplet);
            HashSet plainTextTierNames = new HashSet();
            HashSet plainTextTierTypes = new HashSet();
            HashSet plainTextParticipants = new HashSet();
            this.getNameAndTypeInfoFor(rs, plainTextNodes, plainTextTierNames, plainTextTierTypes, plainTextParticipants);
            this.sendLinesToApplet(new ArrayList(plainTextTierNames), toApplet);
            this.sendLinesToApplet(new ArrayList(plainTextTierTypes), toApplet);
            this.sendLinesToApplet(new ArrayList(plainTextParticipants), toApplet);
            HashSet xmlTextTierNames = new HashSet();
            HashSet xmlTextTierTypes = new HashSet();
            HashSet xmlTextParticipants = new HashSet();
            this.getNameAndTypeInfoFor(rs, xmlTextNodes, xmlTextTierNames, xmlTextTierTypes, xmlTextParticipants);
            this.sendLinesToApplet(new ArrayList(xmlTextTierNames), toApplet);
            this.sendLinesToApplet(new ArrayList(xmlTextTierTypes), toApplet);
            this.sendLinesToApplet(new ArrayList(xmlTextParticipants), toApplet);
            HashSet htmlTextTierNames = new HashSet();
            HashSet htmlTextTierTypes = new HashSet();
            HashSet htmlTextParticipants = new HashSet();
            this.getNameAndTypeInfoFor(rs, htmlTextNodes, htmlTextTierNames, htmlTextTierTypes, htmlTextParticipants);
            this.sendLinesToApplet(new ArrayList(htmlTextTierNames), toApplet);
            this.sendLinesToApplet(new ArrayList(htmlTextTierTypes), toApplet);
            this.sendLinesToApplet(new ArrayList(htmlTextParticipants), toApplet);
            HashSet csvTextTierNames = new HashSet();
            HashSet csvTextTierTypes = new HashSet();
            HashSet csvTextParticipants = new HashSet();
            this.getNameAndTypeInfoFor(rs, csvTextNodes, csvTextTierNames, csvTextTierTypes, csvTextParticipants);
            this.sendLinesToApplet(new ArrayList(csvTextTierNames), toApplet);
            this.sendLinesToApplet(new ArrayList(csvTextTierTypes), toApplet);
            this.sendLinesToApplet(new ArrayList(csvTextParticipants), toApplet);
            PostgresQuery query = AnnexUtil.getSearchClient().createQuery();
            this.setSessionAttribute(session, "query", domainId, query);
            ArrayList searchModes = query.getSearchModes();
            this.sendLinesToApplet(searchModes, toApplet);
            rs.close();
            logger.debug("closing applet communication after init");
            toApplet.flush();
            toApplet.close();
        }
        catch (Exception e) {
            logger.error("initSearch", e);
        }
    }

    private void sendLinesToApplet(ArrayList lines, PrintWriter toApplet) {
        toApplet.println(lines.size());
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            line = line.replaceAll("\n", "").replaceAll("\r", "");
            toApplet.println(line);
        }
        toApplet.flush();
    }

    private void setSessionAttribute(HttpSession session, String attributeName, String domainId, Object attribute) {
        session.setAttribute(attributeName + domainId, attribute);
    }

    private Object getSessionAttribute(HttpSession session, String attributeName, String domainId) {
        return session.getAttribute(attributeName + domainId);
    }
}

