/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.swingsearch;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import mpi.annex.search.Constants;
import mpi.annex.swingsearch.ExportResultStatsDialog;
import mpi.annex.swingsearch.SearchMediator;
import mpi.eudico.client.annotator.export.ExportTabCustomizePanel;

public class ExportResultsComplexOptionsDialog
extends ExportResultStatsDialog {
    private ExportTabCustomizePanel custPanel;
    private TitledBorder columnBorder;
    private JCheckBox multiRowCB;

    public ExportResultsComplexOptionsDialog() throws HeadlessException {
    }

    public ExportResultsComplexOptionsDialog(ResourceBundle bundle) throws HeadlessException {
        super(bundle);
    }

    public ExportResultsComplexOptionsDialog(Frame owner) throws HeadlessException {
        super(owner);
    }

    public ExportResultsComplexOptionsDialog(Frame owner, ResourceBundle bundle, SearchMediator mediator) throws HeadlessException {
        super(owner, bundle, mediator);
    }

    public ExportResultsComplexOptionsDialog(Dialog owner) throws HeadlessException {
        super(owner);
    }

    public ExportResultsComplexOptionsDialog(Dialog owner, ResourceBundle bundle, SearchMediator mediator) throws HeadlessException {
        super(owner, bundle, mediator);
    }

    protected void initComponents() {
        super.initComponents();
        this.multiRowCB = new JCheckBox();
        this.columnBorder = new TitledBorder("");
        if (this.mediator != null) {
            String multiRowPref;
            String storedSortedColumns = this.mediator.getPersistent("MFSearchResultComplex.ExportColumnOrder");
            if (storedSortedColumns != null) {
                String[] headers = storedSortedColumns.split(",");
                int[] incCols = null;
                String storedIncluded = this.mediator.getPersistent("MFSearchResultComplex.ExportColumnIncluded");
                if (storedIncluded != null) {
                    String[] colInd = storedIncluded.split(",");
                    incCols = new int[colInd.length];
                    for (int i = 0; i < colInd.length; ++i) {
                        try {
                            incCols[i] = Integer.parseInt(colInd[i]);
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            incCols[i] = 0;
                        }
                    }
                }
                this.custPanel = incCols != null ? new ExportTabCustomizePanel(headers, incCols) : new ExportTabCustomizePanel(headers);
            }
            if ((multiRowPref = this.mediator.getPersistent("MFSearchResultComplex.ExportMultipleRowsPerHit")) != null) {
                this.multiRowCB.setSelected(Boolean.valueOf(multiRowPref));
            }
        }
        this.distinguishHitsCB.setVisible(false);
        this.getContentPane().remove(this.distinguishHitsCB);
        Insets insets = new Insets(2, 6, 2, 6);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panel.add((Component)this.multiRowCB, gridBagConstraints);
        if (this.custPanel == null) {
            boolean[] selected = new boolean[Constants.EXPORT_HEADERS_COMPLEX.length];
            for (int i = 0; i < Constants.EXPORT_HEADERS_COMPLEX.length; ++i) {
                selected[i] = true;
            }
            this.custPanel = new ExportTabCustomizePanel(Constants.EXPORT_HEADERS_COMPLEX, selected);
        }
        this.custPanel.setBorder((Border)this.columnBorder);
        this.custPanel.setPreferredSize(new Dimension(550, 80));
        this.getContentPane().remove(this.buttonPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.getContentPane().add((Component)this.custPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
    }

    protected void postInit() {
        this.pack();
        int w = 640;
        if (this.getParent() != null && this.getParent().getWidth() > w) {
            w = this.getParent().getWidth() - 10;
        }
        this.setSize(this.getSize().width < w ? w : this.getSize().width, this.getSize().height);
        this.setLocationRelativeTo(this.getParent());
    }

    public void updateLocale() {
        super.updateLocale();
        if (this.bundle != null) {
            if (this.columnBorder != null) {
                this.columnBorder.setTitle("");
            }
            if (this.multiRowCB != null) {
                this.multiRowCB.setText("");
            }
        } else {
            if (this.columnBorder != null) {
                this.columnBorder.setTitle("Select and order columns");
            }
            if (this.multiRowCB != null) {
                this.multiRowCB.setText("Export multiple rows per hit");
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.mediator != null) {
            String[] heads = this.custPanel.getColumnOrder();
            int[] selectInd = this.custPanel.getSelectedColumnIndices();
            if (heads != null) {
                int i;
                StringBuilder sb = new StringBuilder();
                for (i = 0; i < heads.length; ++i) {
                    sb.append(heads[i]);
                    if (i == heads.length - 1) continue;
                    sb.append(',');
                }
                this.mediator.putPersistent("MFSearchResultComplex.ExportColumnOrder", sb.toString());
                sb = new StringBuilder();
                for (i = 0; i < selectInd.length; ++i) {
                    sb.append(selectInd[i]);
                    if (i == selectInd.length - 1) continue;
                    sb.append(',');
                }
                this.mediator.putPersistent("MFSearchResultComplex.ExportColumnIncluded", sb.toString());
            }
            this.mediator.putPersistent("MFSearchResultComplex.ExportMultipleRowsPerHit", String.valueOf(this.multiRowCB.isSelected()));
        }
        super.actionPerformed(e);
    }
}

