/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.swingsearch;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import mpi.annex.search.Constants;
import mpi.annex.swingsearch.ExportResultStatsDialog;
import mpi.annex.swingsearch.SearchMediator;
import mpi.eudico.client.annotator.export.ExportTabCustomizePanel;

public class ExportResultsOptionsDialog
extends ExportResultStatsDialog {
    private ExportTabCustomizePanel custPanel;
    private TitledBorder columnBorder;

    public ExportResultsOptionsDialog() throws HeadlessException {
    }

    public ExportResultsOptionsDialog(ResourceBundle bundle) throws HeadlessException {
        super(bundle);
    }

    public ExportResultsOptionsDialog(Frame owner) throws HeadlessException {
        super(owner);
    }

    public ExportResultsOptionsDialog(Frame owner, ResourceBundle bundle, SearchMediator mediator) throws HeadlessException {
        super(owner, bundle, mediator);
    }

    public ExportResultsOptionsDialog(Dialog owner) throws HeadlessException {
        super(owner);
    }

    public ExportResultsOptionsDialog(Dialog owner, ResourceBundle bundle, SearchMediator mediator) throws HeadlessException {
        super(owner, bundle, mediator);
    }

    protected void initComponents() {
        String storedSortedColumns;
        super.initComponents();
        this.distinguishHitsCB.setVisible(false);
        this.columnBorder = new TitledBorder("");
        if (this.mediator != null && (storedSortedColumns = this.mediator.getPersistent("MFSearchResult.ExportColumnOrder")) != null) {
            String[] headers = storedSortedColumns.split(",");
            int[] incCols = null;
            String storedIncluded = this.mediator.getPersistent("MFSearchResult.ExportColumnIncluded");
            if (storedIncluded != null) {
                String[] colInd = storedIncluded.split(",");
                incCols = new int[colInd.length];
                for (int i = 0; i < colInd.length; ++i) {
                    try {
                        incCols[i] = Integer.parseInt(colInd[i]);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        incCols[i] = 0;
                    }
                }
            }
            this.custPanel = incCols != null ? new ExportTabCustomizePanel(headers, incCols) : new ExportTabCustomizePanel(headers);
        }
        if (this.custPanel == null) {
            boolean[] selected = new boolean[Constants.EXPORT_HEADERS.length];
            for (int i = 0; i < Constants.EXPORT_HEADERS.length; ++i) {
                selected[i] = true;
            }
            this.custPanel = new ExportTabCustomizePanel(Constants.EXPORT_HEADERS, selected);
        }
        this.custPanel.setBorder((Border)this.columnBorder);
        this.custPanel.setPreferredSize(new Dimension(550, 80));
        this.getContentPane().remove(this.buttonPanel);
        Insets insets = new Insets(2, 6, 2, 6);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.getContentPane().add((Component)this.custPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
    }

    protected void postInit() {
        this.pack();
        int w = 640;
        if (this.getParent() != null && this.getParent().getWidth() > w) {
            w = this.getParent().getWidth() - 10;
        }
        this.setSize(this.getSize().width < w ? w : this.getSize().width, this.getSize().height);
        this.setLocationRelativeTo(this.getParent());
    }

    public void updateLocale() {
        super.updateLocale();
        if (this.bundle != null) {
            if (this.columnBorder != null) {
                this.columnBorder.setTitle("");
            }
        } else if (this.columnBorder != null) {
            this.columnBorder.setTitle("Select and order columns");
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.mediator != null) {
            String[] heads = this.custPanel.getColumnOrder();
            int[] selectInd = this.custPanel.getSelectedColumnIndices();
            if (heads != null) {
                int i;
                StringBuilder sb = new StringBuilder();
                for (i = 0; i < heads.length; ++i) {
                    sb.append(heads[i]);
                    if (i == heads.length - 1) continue;
                    sb.append(',');
                }
                this.mediator.putPersistent("MFSearchResult.ExportColumnOrder", sb.toString());
                sb = new StringBuilder();
                for (i = 0; i < selectInd.length; ++i) {
                    sb.append(selectInd[i]);
                    if (i == selectInd.length - 1) continue;
                    sb.append(',');
                }
                this.mediator.putPersistent("MFSearchResult.ExportColumnIncluded", sb.toString());
            }
        }
        super.actionPerformed(e);
    }
}

