/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.swingsearch;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mpi.annex.search.Constants;
import mpi.annex.swingsearch.SearchListener;

public class SearchHistoryPanel
extends JPanel
implements ActionListener {
    private final String SPLITTER = "qzbxv";
    private SearchListener searchListener;
    private ArrayList history;
    int currentItem;
    private JButton historyPrevious;
    private JButton historyNext;
    private boolean persistentHistoryLoaded;

    public SearchHistoryPanel(SearchListener searchListener, Color backgroundColor) {
        this.searchListener = searchListener;
        this.history = new ArrayList();
        this.currentItem = 0;
        this.setBackground(backgroundColor);
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createHorizontalStrut(5));
        JLabel historyLabel = new JLabel("Query History:");
        historyLabel.setFont(Constants.bigBoldFont);
        this.add(historyLabel);
        this.add(Box.createHorizontalStrut(10));
        this.historyPrevious = new JButton("<");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.historyPrevious.setBackground(backgroundColor);
        }
        this.historyPrevious.addActionListener(this);
        this.add(this.historyPrevious);
        this.add(Box.createHorizontalStrut(5));
        this.historyNext = new JButton(">");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.historyNext.setBackground(backgroundColor);
        }
        this.historyNext.addActionListener(this);
        this.add(this.historyNext);
        this.add(Box.createHorizontalGlue());
    }

    public void setHistory(String hist) {
        if (hist != null) {
            String[] his = hist.split("qzbxv");
            this.history.clear();
            for (int i = 0; i < his.length; ++i) {
                this.history.add(his[i]);
            }
            this.currentItem = -1;
        }
        this.persistentHistoryLoaded = true;
    }

    public void reset() {
        this.currentItem = -1;
    }

    public String getHistory() {
        if (this.history.size() == 0) {
            return "xxxNULL_STRINGxxx";
        }
        String his = "";
        for (int i = 0; i < this.history.size(); ++i) {
            his = his + "qzbxv" + (String)this.history.get(i);
        }
        return his.substring("qzbxv".length());
    }

    public void remember(String item) {
        if (this.history.size() == 0 || !item.equals((String)this.history.get(0))) {
            this.history.add(0, item);
            this.currentItem = 0;
            if (this.history.size() >= 20) {
                this.history.remove(this.history.size() - 1);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.historyPrevious) {
            if (this.currentItem + 1 < this.history.size()) {
                ++this.currentItem;
                this.searchListener.setQuery((String)this.history.get(this.currentItem));
            }
        } else if (this.currentItem > 0) {
            --this.currentItem;
            this.searchListener.setQuery((String)this.history.get(this.currentItem));
        }
    }
}

