/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.util;

import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import mpi.annex.search.SearchClient;
import mpi.corpusstructure.AccessInfo;
import mpi.corpusstructure.ArchiveObjectsDB;
import mpi.corpusstructure.CorpusStructureDB;
import mpi.corpusstructure.CorpusStructureDBImpl;
import mpi.corpusstructure.UnknownNodeException;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;

public class AnnexUtil {
    private static Logger logger = Logger.getLogger("ANNEX.Util");
    public static String corpusDbURL;
    public static String corpusDbUser;
    public static String corpusDbPassword;
    public static String searchDbURL;
    public static String searchDbUser;
    public static String searchDbPassword;
    public static String darwinAnonymizerHost;
    public static String darwinAnonymizerPort;
    public static String darwinStreamingURL;
    public static String flashAnonymizerHost;
    public static String flashAnonymizerPort;
    public static String flashStreamingURL;
    public static String videoServer;
    public static String audioServer;
    private static CorpusStructureDB csdb;
    private static ArchiveObjectsDB aodb;
    private static SearchClient searchClient;

    public static String getCorpusDbURL() {
        if (corpusDbURL == null) {
            return "jdbc:postgresql://lux08.mpi.nl:5432/corpusstructure";
        }
        return corpusDbURL;
    }

    public static void setCorpusDbURL(String n) {
        corpusDbURL = n;
    }

    public static String getCorpusDbUser() {
        if (corpusDbUser == null) {
            return "webuser";
        }
        return corpusDbUser;
    }

    public static void setCorpusDbUser(String n) {
        corpusDbUser = n;
    }

    public static String getCorpusDbPassword() {
        return corpusDbPassword;
    }

    public static void setCorpusDbPassword(String n) {
        corpusDbPassword = n;
    }

    public static String getSearchDbURL() {
        if (searchDbURL == null) {
            return "jdbc:postgresql://lux08.mpi.nl:5432/annex";
        }
        return searchDbURL;
    }

    public static String getSearchDbUser() {
        return searchDbUser;
    }

    public static String getSearchDbPassword() {
        return searchDbPassword;
    }

    public static void setSearchDbURL(String n) {
        searchDbURL = n;
    }

    public static boolean hasAccessTo(String user, String nodeId) {
        AccessInfo ai = AnnexUtil.getArchiveObjectsDB().getObjectAccessInfo(nodeId);
        boolean b = ai.hasReadAccess(user);
        if (!b) {
            logger.warn("hasAccessTo: false for: " + user + " ai: " + ai + " in: " + nodeId);
        }
        return b;
    }

    public static InputSource getInputSourceFor(String nodeId) {
        URL url = AnnexUtil.getURLFor(nodeId);
        InputSource inputSource = null;
        try {
            inputSource = new InputSource(url.openStream());
            String uri = url.toString();
            int lastSlash = uri.lastIndexOf("/");
            if (lastSlash >= 0) {
                uri = uri.substring(0, lastSlash);
            }
            inputSource.setSystemId(uri + "/");
        }
        catch (IOException e) {
            logger.error("IOException: " + e);
        }
        return inputSource;
    }

    public static URL getURLFor(String nodeId) {
        return AnnexUtil.getArchiveObjectsDB().getObjectURL(nodeId, 1).toURL();
    }

    public static String getFilePathFor(String nodeId) {
        if (nodeId == null) {
            return null;
        }
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0) {
            return AnnexUtil.getFilePathForWindows(nodeId);
        }
        if (System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0) {
            return AnnexUtil.getFilePathForMac(nodeId);
        }
        return AnnexUtil.getFilePathForUnix(nodeId);
    }

    public static String getFilePathForUnix(String nodeId) {
        if (nodeId == null) {
            return null;
        }
        return AnnexUtil.getArchiveObjectsDB().getObjectURL(nodeId, 1).getPath();
    }

    public static String getFilePathForMac(String nodeId) {
        if (nodeId == null) {
            return null;
        }
        return AnnexUtil.getURLFor(nodeId).getPath();
    }

    public static String getFilePathForWindows(String nodeId) {
        if (nodeId == null) {
            return null;
        }
        return AnnexUtil.getArchiveObjectsDB().getObjectURL(nodeId, 2).getPath();
    }

    public static ArrayList getPossibleMediaFor(String nodeId) {
        ArrayList<String> media = new ArrayList<String>();
        if (AnnexUtil.getTypeFor(nodeId) == -1) {
            return media;
        }
        try {
            String[] parentNodeIds = AnnexUtil.getCorpusStructureDB().getParentNodes(nodeId);
            if (parentNodeIds == null) {
                return media;
            }
            String[] mediaNodeIds = AnnexUtil.getCorpusStructureDB().getDescendants(parentNodeIds[0], 16, (String)null);
            for (int i = 0; i < mediaNodeIds.length; ++i) {
                media.add(AnnexUtil.getCorpusStructureDB().getNode(mediaNodeIds[i]).getName());
            }
        }
        catch (UnknownNodeException une) {
            logger.error("UnknownNodeException: " + (Object)((Object)une), une);
        }
        return media;
    }

    public static int getTypeFor(String nodeId) {
        if (nodeId == null) {
            return -1;
        }
        String format = AnnexUtil.getCorpusStructureDB().getNode(nodeId).getFormat();
        if (format.equals("text/x-eaf+xml")) {
            return 0;
        }
        if (format.equals("text/x-chat")) {
            return 1;
        }
        if (format.equals("text/x-shoebox-text")) {
            return 2;
        }
        if (format.equals("text/x-shoebox-text".replaceFirst("shoe", "tool"))) {
            return 2;
        }
        if (format.equals("text/plain")) {
            return 3;
        }
        if (format.equals("text/xml")) {
            return 5;
        }
        if (format.equals("text/html")) {
            return 4;
        }
        if (format.equals("text/csv")) {
            return 6;
        }
        return -1;
    }

    public static String getNameFor(String nodeId) {
        if (nodeId == null) {
            return null;
        }
        try {
            return AnnexUtil.getCorpusStructureDB().getNode(nodeId).getName();
        }
        catch (UnknownNodeException une) {
            logger.error("UnknownNodeException: " + (Object)((Object)une), une);
            return "UNKNOWN";
        }
    }

    public static String getNamePathFor(String nodeId) {
        if (nodeId == null) {
            return null;
        }
        return AnnexUtil.getCorpusStructureDB().getNamePath(nodeId);
    }

    public static SearchClient getSearchClient() throws SQLException {
        if (searchClient == null) {
            String url = AnnexUtil.getSearchDbURL();
            String usr = AnnexUtil.getSearchDbUser();
            String pwd = AnnexUtil.getSearchDbPassword();
            searchClient = new SearchClient(url, usr, pwd);
        }
        return searchClient;
    }

    private static void initCorpusStructureDBImpl() {
        if (csdb == null || aodb == null) {
            String dbname = AnnexUtil.getCorpusDbURL();
            String user = AnnexUtil.getCorpusDbUser();
            String passwd = AnnexUtil.getCorpusDbPassword();
            CorpusStructureDBImpl csdbimpl = new CorpusStructureDBImpl(dbname, false, user, passwd);
            csdb = csdbimpl;
            aodb = csdbimpl;
        }
    }

    public static CorpusStructureDB getCorpusStructureDB() {
        if (csdb == null) {
            AnnexUtil.initCorpusStructureDBImpl();
        }
        return csdb;
    }

    public static ArchiveObjectsDB getArchiveObjectsDB() {
        if (aodb == null) {
            AnnexUtil.initCorpusStructureDBImpl();
        }
        return aodb;
    }

    public static void closeCorpusStructureDBImpl() {
        if (csdb != null) {
            csdb.close();
            csdb = null;
        }
        if (aodb != null) {
            aodb.close();
            aodb = null;
        }
    }
}

