/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.customizer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.media.CaptureDeviceInfo;

public class CusRegistry {
    private Hashtable defaultHash = null;
    private Hashtable fullHash = null;
    private static String filename = null;
    static final int versionNumber = 200;
    private static final String CLASSPATH = "java.class.path";
    private String classpath = null;
    private String workDir = null;
    private String javacpath = null;

    public void setWorkDir(String string) {
        this.workDir = string;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setJavacPath(String string) {
        this.javacpath = string;
    }

    public String getJavacPath() {
        return this.javacpath;
    }

    public boolean loadRegistry() {
        InputStream inputStream = null;
        boolean bl = false;
        this.defaultHash = new Hashtable();
        this.fullHash = new Hashtable();
        inputStream = this.findJMFPropertiesFile();
        boolean bl2 = this.readRegistry(this.fullHash, inputStream);
        if (bl2) {
            return true;
        }
        try {
            Class<?> clazz = Class.forName("com.sun.media.util.RegistryLib");
            byte[] byArray = (byte[])clazz.getMethod("getData", null).invoke(clazz, null);
            if (byArray != null) {
                inputStream = new ByteArrayInputStream(byArray);
                bl = this.readRegistry(this.defaultHash, inputStream);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            inputStream = null;
            bl = false;
        }
        return bl;
    }

    public Hashtable getDefaultRegistry() {
        return this.defaultHash;
    }

    public Hashtable getFullRegistry() {
        return this.fullHash;
    }

    public void removePlugIn(Hashtable hashtable, String string, int n) {
        String string2 = "PIM." + n + "_" + string + ".in";
        hashtable.remove(string2);
        string2 = "PIM." + n + "_" + string + ".out";
        hashtable.remove(string2);
    }

    public void removeCaptureD(Hashtable hashtable, String string) {
        String string2 = "CDM.nDevices";
        if (hashtable.get(string2) != null) {
            String string3;
            Object v;
            int n = (Integer)hashtable.get(string2);
            int n2 = -1;
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                CaptureDeviceInfo captureDeviceInfo;
                v = hashtable.get("CDM." + n4);
                if (v != null && (captureDeviceInfo = (CaptureDeviceInfo)v).getLocator().getProtocol().equalsIgnoreCase(string)) {
                    hashtable.put(string2, new Integer(n - 1));
                    hashtable.remove("CDM." + n4);
                    n2 = n4;
                    break;
                }
                ++n4;
            }
            int n5 = n2 + 1;
            while (n5 < n) {
                v = hashtable.get("CDM." + n5);
                n3 = n5 - 1;
                string3 = "CDM." + n3;
                hashtable.put(string3, v);
                ++n5;
            }
            if (n2 >= 0) {
                string3 = "CDM." + --n;
                hashtable.remove(string3);
            }
        }
    }

    private final InputStream findJMFPropertiesFile() {
        String string = this.findJMF();
        FileInputStream fileInputStream = null;
        if (string != null) {
            try {
                fileInputStream = new FileInputStream(string);
            }
            catch (Exception exception) {
                fileInputStream = null;
            }
        }
        return fileInputStream;
    }

    public final String findJMF() {
        this.classpath = System.getProperty(CLASSPATH);
        if (this.classpath == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.classpath, File.pathSeparator);
        String string = "jmf.properties";
        File file = null;
        Object var5_4 = null;
        filename = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = string2.toUpperCase();
            try {
                if (string3.indexOf(".ZIP") > 0 || string3.indexOf(".JAR") > 0) {
                    int n = string2.lastIndexOf(File.separator);
                    if (n == -1 && !File.separator.equals("/")) {
                        n = string2.lastIndexOf("/");
                    }
                    string2 = n == -1 ? ((n = string2.lastIndexOf(":")) == -1 ? string : string2.substring(0, n) + ":" + string) : string2.substring(0, n) + File.separator + string;
                } else {
                    string2 = string2 + File.separator + string;
                }
            }
            catch (Exception exception) {
                string2 = string2 + File.separator + string;
            }
            try {
                file = new File(string2);
                if (!file.exists() || file.length() <= 0L) continue;
                filename = string2;
                System.out.println("Found jmf.properties in " + string2);
                break;
            }
            catch (Throwable throwable) {
                filename = null;
                return null;
            }
        }
        return filename;
    }

    private final boolean readRegistry(Hashtable hashtable, InputStream inputStream) {
        if (inputStream == null) {
            return false;
        }
        if (hashtable == null) {
            hashtable = new Hashtable<String, Object>();
        }
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            int n = objectInputStream.readInt();
            int n2 = objectInputStream.readInt();
            if (n2 > 200) {
                System.err.println("Version number mismatch.\nThere could be errors in reading the registry");
            }
            int n3 = 0;
            while (n3 < n) {
                String string = objectInputStream.readUTF();
                boolean bl = false;
                try {
                    Object object = objectInputStream.readObject();
                    hashtable.put(string, object);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                    bl = true;
                }
                catch (OptionalDataException optionalDataException) {
                    optionalDataException.printStackTrace();
                    bl = true;
                }
                ++n3;
            }
            objectInputStream.close();
            inputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("IOException in readRegistry: " + iOException);
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
        System.out.println("Registry Size = " + hashtable.size());
        return true;
    }

    public boolean saveRegistry(Hashtable hashtable) {
        String string = this.workDir + File.separator + "new_jmf.properties";
        try {
            File file = new File(string);
            if (file.exists()) {
                file.delete();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            int n = hashtable.size();
            objectOutputStream.writeInt(n);
            objectOutputStream.writeInt(200);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Object v = hashtable.get(string2);
                objectOutputStream.writeUTF(string2);
                objectOutputStream.writeObject(v);
                objectOutputStream.flush();
            }
            objectOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }
}

