/*
 * Decompiled with CFR 0.152.
 */
package quicktime.internal.jdirect;

import quicktime.internal.jdirect.ArrayCopy;
import quicktime.internal.jdirect.Struct;

public class FloatArrayStruct
extends Struct {
    protected float[] floats;
    private int logicalSize;

    protected FloatArrayStruct(int sizeInBytes) {
        this.logicalSize = sizeInBytes;
        this.floats = new float[(sizeInBytes + 3) / 4];
    }

    protected byte getByteAt(int byteOffset) {
        int temp = Float.floatToRawIntBits(this.floats[byteOffset / 4]);
        int inset = byteOffset % 4;
        if (inset == Struct.INT_LOW_BYTE_OFFSET) {
            return (byte)temp;
        }
        if (inset == Struct.INT_HIGH_BYTE_OFFSET) {
            return (byte)(temp >>> 24);
        }
        if (inset == Struct.INT_THREE_BYTE_OFFSET) {
            return (byte)(temp >>> 16);
        }
        return (byte)(temp >>> 8);
    }

    protected float getFloatAt(int offset) {
        if (offset % 4 == 0) {
            return this.floats[offset / 4];
        }
        return super.getFloatAt(offset);
    }

    protected void setByteAt(int byteOffset, byte value) {
        int bits = Float.floatToRawIntBits(this.floats[byteOffset / 4]);
        int intValue = value & 0xFF;
        int inset = byteOffset % 4;
        bits = inset == Struct.INT_LOW_BYTE_OFFSET ? (bits |= intValue) : (inset == Struct.INT_HIGH_BYTE_OFFSET ? (bits |= intValue << 24) : (inset == Struct.INT_TWO_BYTE_OFFSET ? (bits |= intValue << 16) : (bits |= intValue << 8)));
        this.floats[byteOffset / 4] = Float.intBitsToFloat(bits);
    }

    protected void setFloatAt(int offset, float value) {
        if (offset % 4 == 0) {
            this.floats[offset / 4] = value;
        } else {
            super.setFloatAt(offset, value);
        }
    }

    protected void setBytesAt(int byteOffset, byte[] source) {
        ArrayCopy.copyArrayToArray(source, 0, this.floats, byteOffset, source.length);
    }

    protected void setStructAt(int byteOffset, Struct src) {
        int srcByteCount = src.getSize();
        ArrayCopy.copyArrayToArray(src.getBytesAt(0, srcByteCount), 0, this.floats, byteOffset, srcByteCount);
    }

    public byte[] getBytesAt(int byteOffset, int byteCount) {
        byte[] result = new byte[byteCount];
        ArrayCopy.copyArrayToArray(this.floats, byteOffset, result, 0, byteCount);
        return result;
    }

    public byte[] getBytes() {
        return this.getBytesAt(0, this.getSize());
    }

    public final float[] getArray() {
        return this.floats;
    }

    public final int getSize() {
        return this.logicalSize;
    }
}

