/*
 * Decompiled with CFR 0.152.
 */
package quicktime.internal.jdirect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.internal.jdirect.JDPrivilegedAction;

class JDAccessController {
    private static final Method sDoPrivilegedMethod = JDAccessController.getDoPrivileged();

    JDAccessController() {
    }

    static Object doPrivileged(JDPrivilegedAction action) throws Error {
        if (sDoPrivilegedMethod != null) {
            try {
                return sDoPrivilegedMethod.invoke(null, new MyPrivilegedAction(action));
            }
            catch (IllegalAccessException x) {
                x.printStackTrace();
                return null;
            }
            catch (InvocationTargetException x) {
                throw (Error)x.getTargetException();
            }
        }
        return action.run();
    }

    private static Method getDoPrivileged() {
        if (System.getSecurityManager() != null) {
            try {
                final Class<?> accessController = Class.forName("java.security.AccessController");
                final Class<?> privilegedAction = Class.forName("java.security.PrivilegedAction");
                return (Method)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return accessController.getDeclaredMethod("doPrivileged", privilegedAction);
                        }
                        catch (Throwable t) {
                            return null;
                        }
                    }
                });
            }
            catch (Throwable t) {
            }
        }
        return null;
    }

    static class MyPrivilegedAction
    implements PrivilegedAction {
        private final JDPrivilegedAction action;

        MyPrivilegedAction(JDPrivilegedAction action) {
            this.action = action;
        }

        public Object run() {
            return this.action.run();
        }
    }
}

