/*
 * Decompiled with CFR 0.152.
 */
package quicktime.internal.jdirect;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;
import quicktime.internal.jdirect.Linkage;
import quicktime.internal.jdirect.Linker;
import quicktime.internal.jdirect.LinkerAbstract;

class LinkerMacOS
extends LinkerAbstract {
    private Hashtable knownThunks = new Hashtable();
    private static String kJNILibraryName = "JDirectLib";

    LinkerMacOS() {
    }

    String doGetJNILibraryName() {
        return kJNILibraryName;
    }

    String doGetLibraryFieldName() {
        return "JDirect_MacOS";
    }

    String doGetLockObjectFieldName() {
        return "JDirect_Lock_MacOS";
    }

    Object processLibraryStringsInfo(Vector libNames) {
        CFMLibrary[] libs = new CFMLibrary[libNames.size()];
        int i = 0;
        while (i < libNames.size()) {
            libs[i] = CFMLibrary.get((String)libNames.elementAt(i));
            ++i;
        }
        return libs;
    }

    long findFunction(Linkage linkage, String functionName) {
        CFMLibrary[] searchLibs = (CFMLibrary[])linkage.libInfo;
        int i = 0;
        while (i < searchLibs.length) {
            long func;
            if (searchLibs[i] != null && (func = searchLibs[i].findFunction(functionName)) != 0L) {
                return func;
            }
            ++i;
        }
        return 0L;
    }

    String functionNotFoundMessage(Linkage linkage, String methodName) {
        CFMLibrary[] libraries = (CFMLibrary[])linkage.libInfo;
        int libCount = libraries.length;
        int notLoadedCount = 0;
        int loadedCount = 0;
        if (Linker.verbose) {
            System.err.println("\t" + methodName + " could not be found to link via JDirect");
        }
        StringBuffer loadedLibraries = new StringBuffer();
        StringBuffer notLoadedLibraries = new StringBuffer();
        int i = 0;
        while (i < libCount) {
            if (libraries[i] != null) {
                if (libraries[i].loaded()) {
                    ++loadedCount;
                    if (loadedLibraries.length() > 0) {
                        loadedLibraries.append(", ");
                    }
                    loadedLibraries.append(libraries[i].fragName);
                } else {
                    ++notLoadedCount;
                    if (notLoadedLibraries.length() > 0) {
                        notLoadedLibraries.append(", ");
                    }
                    notLoadedLibraries.append(libraries[i].fragName);
                }
            }
            ++i;
        }
        if (libCount == 0) {
            return "JDirect native method \"" + methodName + "\" not found . Unable to find \"JDirect_MacOS\" String field";
        }
        if (loadedCount == 0) {
            return "JDirect native method \"" + methodName + "\" not found because unable to load fragments named(s): " + notLoadedLibraries;
        }
        if (notLoadedCount == 0) {
            return "JDirect native method \"" + methodName + "\" not found in fragment(s) named: " + loadedLibraries;
        }
        return "JDirect native method \"" + methodName + "\" not found in fragment(s): " + loadedLibraries + ".  Unable to load fragments(s): " + notLoadedLibraries;
    }

    private static native int loadLibrary(byte[] var0, boolean var1);

    private static native long findSymbol(String var0, int var1, int var2);

    private static native int currentZone();

    static {
        LinkerAbstract.loadJNILibrary(kJNILibraryName);
    }

    static class CFMLibrary {
        final String fragName;
        final int connectionID;
        final int connectionZone;
        final boolean privateCopy;
        static final Hashtable sLoadedLibs = new Hashtable();

        private CFMLibrary(String fragName, int connectionID, int connectionZone, boolean privateCopy) {
            this.fragName = fragName;
            this.connectionID = connectionID;
            this.connectionZone = connectionZone;
            this.privateCopy = privateCopy;
        }

        private CFMLibrary(String fragName, byte[] asciiName, boolean privateCopy) {
            this(fragName, LinkerMacOS.loadLibrary(asciiName, privateCopy), LinkerMacOS.currentZone(), privateCopy);
        }

        boolean loaded() {
            return this.connectionID != 0;
        }

        long findFunction(String name) {
            return LinkerMacOS.findSymbol(name, this.connectionID, this.connectionZone);
        }

        static CFMLibrary get(String path) {
            byte[] asciiName;
            CFMLibrary possibleLib;
            String fragmentName;
            boolean privateCopy = false;
            if (path.startsWith("cfmpriv:")) {
                privateCopy = true;
                fragmentName = path.substring(8);
            } else {
                fragmentName = path.startsWith("cfm:") ? path.substring(4) : path;
            }
            if (!privateCopy && (possibleLib = (CFMLibrary)sLoadedLibs.get(fragmentName)) != null) {
                return possibleLib;
            }
            try {
                asciiName = fragmentName.getBytes("MacRoman");
            }
            catch (UnsupportedEncodingException exception) {
                asciiName = fragmentName.getBytes();
            }
            CFMLibrary result = new CFMLibrary(fragmentName, asciiName, privateCopy);
            if (!privateCopy) {
                sLoadedLibs.put(fragmentName, result);
            }
            return result;
        }
    }
}

