/*
 * Decompiled with CFR 0.152.
 */
package quicktime.internal.jdirect;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import quicktime.internal.jdirect.JDAccessController;
import quicktime.internal.jdirect.JDPrivilegedAction;
import quicktime.internal.jdirect.Linkage;
import quicktime.internal.jdirect.Linker;
import quicktime.internal.jdirect.LinkerAbstract;

class LinkerMacOSX
extends LinkerAbstract {
    private static String kJNILibraryName = "/System/Library/QuickTimeJava/QuickTimeJava.bundle/Contents/Resources/libQTJSupport.jnilib";

    LinkerMacOSX() {
    }

    String doGetJNILibraryName() {
        return kJNILibraryName;
    }

    String doGetLibraryFieldName() {
        return "JDirect_MacOSX";
    }

    String doGetLockObjectFieldName() {
        return "JDirect_Lock_MacOSX";
    }

    Object processLibraryStringsInfo(Vector libNames) {
        Library[] libs = new Library[libNames.size()];
        int i = 0;
        while (i < libNames.size()) {
            libs[i] = Library.get((String)libNames.elementAt(i));
            ++i;
        }
        return libs;
    }

    long findFunction(Linkage linkage, String functionName) {
        Library[] searchLibs = (Library[])linkage.libInfo;
        int i = 0;
        while (i < searchLibs.length) {
            long func;
            if (searchLibs[i] != null && (func = searchLibs[i].findSymbol(functionName)) != 0L) {
                return func;
            }
            ++i;
        }
        return 0L;
    }

    String functionNotFoundMessage(Linkage linkage, String methodName) {
        Library[] libraries = (Library[])linkage.libInfo;
        int libCount = libraries.length;
        int notLoadedCount = 0;
        int loadedCount = 0;
        if (Linker.verbose) {
            System.err.println("\t" + methodName + " could not be found to link via JDirect");
        }
        StringBuffer loadedLibraries = new StringBuffer();
        StringBuffer notLoadedLibraries = new StringBuffer();
        int i = 0;
        while (i < libCount) {
            if (libraries[i] != null) {
                if (libraries[i].loaded) {
                    ++loadedCount;
                    if (loadedLibraries.length() > 0) {
                        loadedLibraries.append(", ");
                    }
                    loadedLibraries.append(libraries[i].path);
                } else {
                    ++notLoadedCount;
                    if (notLoadedLibraries.length() > 0) {
                        notLoadedLibraries.append(", ");
                    }
                    notLoadedLibraries.append(libraries[i].path);
                }
            }
            ++i;
        }
        if (libCount == 0) {
            return "JDirect native method \"" + methodName + "\" not found . Unable to find \"JDirect_MacOSX\" String field";
        }
        if (loadedCount == 0) {
            return "JDirect native method \"" + methodName + "\" not found because unable to load library(s): " + notLoadedLibraries;
        }
        if (notLoadedCount == 0) {
            return "JDirect native method \"" + methodName + "\" not found in library(s): " + loadedLibraries;
        }
        return "JDirect native method \"" + methodName + "\" not found in library(s): " + loadedLibraries + ".  Unable to load library(s): " + notLoadedLibraries;
    }

    static native long loadCFBundle(String var0);

    static native long loadDyldImage(String var0);

    static native long loadDyldBundle(String var0);

    static native long findSymbolInModule(long var0, String var2);

    static native long findSymbolInImage(long var0, String var2);

    static native long findSymbolInCFBundle(long var0, String var2);

    static {
        LinkerAbstract.loadJNILibrary(kJNILibraryName);
    }

    static class CFBundle
    extends Library {
        private long bundleRef;

        private CFBundle(String path, long ref) {
            super(path, ref != 0L);
            this.bundleRef = ref;
        }

        CFBundle(String path) {
            this(path, LinkerMacOSX.loadCFBundle(path));
        }

        long findSymbol(String name) {
            return LinkerMacOSX.findSymbolInCFBundle(this.bundleRef, name);
        }
    }

    static class DylibImage
    extends Library {
        private long image;

        private DylibImage(String path, long ref) {
            super(path, ref != 0L);
            this.image = ref;
        }

        static Library load(String path) {
            long image = LinkerMacOSX.loadDyldImage(path);
            if (image == 0L) {
                return DylibBundle.load(path);
            }
            return new DylibImage(path, image);
        }

        long findSymbol(String name) {
            return LinkerMacOSX.findSymbolInImage(this.image, name);
        }
    }

    static class DylibBundle
    extends Library {
        long module;

        private DylibBundle(String path, long module) {
            super(path, module != 0L);
            this.module = module;
        }

        static Library load(String path) {
            return new DylibBundle(path, LinkerMacOSX.loadDyldBundle(path));
        }

        long findSymbol(String name) {
            return LinkerMacOSX.findSymbolInModule(this.module, name);
        }
    }

    static abstract class Library {
        final String path;
        final boolean loaded;
        static final Hashtable sLoadedLibs = new Hashtable();

        Library(String path, boolean loaded) {
            this.path = path;
            this.loaded = loaded;
        }

        abstract long findSymbol(String var1);

        static Library get(String path) {
            Library theResult = (Library)sLoadedLibs.get(path);
            if (theResult == null) {
                return (Library)JDAccessController.doPrivileged(new JDPrivilegedAction(path){
                    private final /* synthetic */ String val$path;
                    {
                        this.val$path = val$path;
                    }

                    public Object run() {
                        Library result;
                        block9: {
                            result = null;
                            String betterPath = this.val$path;
                            boolean hadBundlePrefix = false;
                            if (betterPath.startsWith("bundle:")) {
                                betterPath = this.val$path.substring(7);
                                hadBundlePrefix = true;
                            } else if (betterPath.startsWith("dylib:")) {
                                betterPath = betterPath.substring(6);
                            } else if (betterPath.startsWith("framework:")) {
                                String shortName = betterPath.substring(10);
                                betterPath = "/System/Library/Frameworks/" + shortName + ".framework/" + shortName;
                            }
                            try {
                                File file = new File(betterPath);
                                boolean isDir = file.isDirectory();
                                betterPath = file.getCanonicalPath();
                                result = (Library)Library.sLoadedLibs.get(betterPath);
                                if (result != null) {
                                    Library.sLoadedLibs.put(betterPath, result);
                                    break block9;
                                }
                                if (isDir || hadBundlePrefix) {
                                    result = new CFBundle(this.val$path);
                                    break block9;
                                }
                                result = DylibImage.load(this.val$path);
                            }
                            catch (IOException x) {}
                        }
                        return result;
                    }
                });
            }
            return theResult;
        }
    }
}

