/*
 * Decompiled with CFR 0.152.
 */
package quicktime.internal.jdirect;

import java.util.StringTokenizer;
import java.util.Vector;
import quicktime.internal.jdirect.JDAccessController;
import quicktime.internal.jdirect.JDPrivilegedAction;
import quicktime.internal.jdirect.LinkerAbstract;

class Logger {
    private static final Vector sLogInvocationClasses = new Vector();
    private static final Vector sLogLoadingClasses = new Vector();

    Logger() {
    }

    public static void logLoading(String classes) {
        if (classes != null) {
            StringTokenizer st = new StringTokenizer(classes, ":");
            while (st.hasMoreTokens()) {
                sLogLoadingClasses.addElement(st.nextToken());
            }
        }
    }

    public static void logInvocations(String classes) {
        if (classes != null) {
            StringTokenizer st = new StringTokenizer(classes, ":");
            while (st.hasMoreTokens()) {
                sLogInvocationClasses.addElement(st.nextToken());
            }
        }
    }

    static boolean shouldLogInvocationForClass(String className) {
        return Logger.stringVectorMatches(sLogInvocationClasses, className);
    }

    static boolean shouldLogLoadingForClass(String className) {
        return Logger.stringVectorMatches(sLogLoadingClasses, className);
    }

    private static boolean stringVectorMatches(Vector vec, String name) {
        int i = 0;
        while (i < vec.size()) {
            String s = (String)vec.elementAt(i);
            if (s.endsWith("*") ? name.startsWith(s.substring(0, s.length() - 1)) : name.equals(s)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean initialLogAllocations() {
        String logAllocation = (String)JDAccessController.doPrivileged(new JDPrivilegedAction(){

            public Object run() {
                return System.getProperty("jdirect.verbose.allocation");
            }
        });
        if (logAllocation != null && logAllocation.toLowerCase().equals("true")) {
            return true;
        }
        logAllocation = LinkerAbstract.getShellVariable("JDIRECT_VERBOSE_ALLOCATION");
        return logAllocation != null;
    }

    static {
        Logger.logLoading((String)JDAccessController.doPrivileged(new JDPrivilegedAction(){

            public Object run() {
                return null;
            }
        }));
        Logger.logLoading((String)JDAccessController.doPrivileged(new JDPrivilegedAction(){

            public Object run() {
                return null;
            }
        }));
        Logger.logLoading(LinkerAbstract.getShellVariable("JDIRECT_VERBOSE_LOADING"));
        Logger.logInvocations(LinkerAbstract.getShellVariable("JDIRECT_VERBOSE_INVOCATION"));
    }
}

