/*
 * Decompiled with CFR 0.152.
 */
package quicktime.internal.jdirect;

import quicktime.internal.jdirect.Accessor;
import quicktime.internal.jdirect.ArrayCopy;
import quicktime.internal.jdirect.Struct;

public abstract class PointerStruct
extends Struct {
    protected int pointer;

    protected PointerStruct(int pointer) {
        this.pointer = pointer;
    }

    protected final boolean getBooleanAt(int offset) {
        return Accessor.getBooleanFromPointer(this.pointer, offset);
    }

    protected final byte getByteAt(int offset) {
        return Accessor.getByteFromPointer(this.pointer, offset);
    }

    protected final char getCharAt(int offset) {
        return Accessor.getCharFromPointer(this.pointer, offset);
    }

    protected final short getShortAt(int offset) {
        return Accessor.getShortFromPointer(this.pointer, offset);
    }

    protected final int getIntAt(int offset) {
        return Accessor.getIntFromPointer(this.pointer, offset);
    }

    protected final long getLongAt(int offset) {
        return Accessor.getLongFromPointer(this.pointer, offset);
    }

    protected final float getFloatAt(int offset) {
        return Accessor.getFloatFromPointer(this.pointer, offset);
    }

    protected final double getDoubleAt(int offset) {
        return Accessor.getDoubleFromPointer(this.pointer, offset);
    }

    protected final void setBooleanAt(int offset, boolean value) {
        Accessor.setBooleanInPointer(this.pointer, offset, value);
    }

    protected final void setByteAt(int offset, byte value) {
        Accessor.setByteInPointer(this.pointer, offset, value);
    }

    protected final void setCharAt(int offset, char value) {
        Accessor.setCharInPointer(this.pointer, offset, value);
    }

    protected final void setShortAt(int offset, short value) {
        Accessor.setShortInPointer(this.pointer, offset, value);
    }

    protected final void setIntAt(int offset, int value) {
        Accessor.setIntInPointer(this.pointer, offset, value);
    }

    protected final void setLongAt(int offset, long value) {
        Accessor.setLongInPointer(this.pointer, offset, value);
    }

    protected final void setFloatAt(int offset, float value) {
        Accessor.setFloatInPointer(this.pointer, offset, value);
    }

    protected final void setDoubleAt(int offset, double value) {
        Accessor.setDoubleInPointer(this.pointer, offset, value);
    }

    protected void setBytesAt(int byteOffset, byte[] source) {
        ArrayCopy.copyArrayToPointer(source, 0, this.pointer, byteOffset, source.length);
    }

    protected void setStructAt(int byteOffset, Struct src) {
        byte[] bytes = src.getBytesAt(0, src.getSize());
        this.setBytesAt(byteOffset, bytes);
    }

    public byte[] getBytesAt(int byteOffset, int byteCount) {
        byte[] bytes = new byte[byteCount];
        ArrayCopy.copyPointerToArray(this.pointer, byteOffset, bytes, 0, byteCount);
        return bytes;
    }

    public byte[] getBytes() {
        return this.getBytesAt(0, this.getSize());
    }

    public abstract int getSize();

    public final int getPointer() {
        return this.pointer;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject != null && anObject instanceof PointerStruct) {
            PointerStruct ptr = (PointerStruct)anObject;
            return this.pointer == ptr.pointer;
        }
        return false;
    }
}

