package mpi.eudico.client.annotator.nativemedia.quartztypelib;

import com.jniwrapper.*;
import com.jniwrapper.win32.com.*;
import com.jniwrapper.win32.com.types.*;
import com.jniwrapper.win32.ole.*;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.*;

/**
 * Represents COM coclass FilgraphManager
 */
public class FilgraphManager extends CoClass
{
    public static final CLSID CLASS_ID = CLSID.create("{E436EBB3-524F-11CE-9F53-0020AF0BA770}");

    public FilgraphManager()
    {
    }

    public FilgraphManager(FilgraphManager that)
    {
        super(that);
    }

    /**
     * creates coclass and returns its default interface
     */
    public static IMediaControl create(ClsCtx dwClsContext) throws ComException
    {
        final IMediaControlImpl intf = new IMediaControlImpl(CLASS_ID, dwClsContext);
        OleFunctions.oleRun(intf);
        return intf;
    }

    /**
     * queries the <code>IMediaControl</code> interface from IUnknown instance
     */
    public static IMediaControl queryInterface(IUnknown unknown) throws ComException
    {
        final IMediaControlImpl result = new IMediaControlImpl();
        unknown.queryInterface(result.getIID(), result);
        return result;
    }

    public CLSID getCLSID()
    {
        return CLASS_ID;
    }

    public Object clone()
    {
        return new FilgraphManager(this);
    }
}