package mpi.eudico.client.annotator.nativemedia.quartztypelib;

import com.jniwrapper.*;
import com.jniwrapper.win32.*;
import com.jniwrapper.win32.automation.*;
import com.jniwrapper.win32.automation.impl.*;
import com.jniwrapper.win32.automation.types.*;
import com.jniwrapper.win32.com.*;
import com.jniwrapper.win32.com.impl.*;
import com.jniwrapper.win32.com.types.*;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.*;

/**
 * Represents Java interface for COM interface IAMStats
 */
public interface IAMStats extends IDispatch
{
    public static final String INTERFACE_IDENTIFIER = "{BC9BCF80-DCD2-11D2-ABF6-00A0C905F375}";

    void reset()
        throws ComException;

    Int32 getCount()
        throws ComException;

    void getValueByIndex(
        Int32 /*[in]*/ lIndex,
        BStr /*[out]*/ szName,
        Int32 /*[out]*/ lCount,
        DoubleFloat /*[out]*/ dLast,
        DoubleFloat /*[out]*/ dAverage,
        DoubleFloat /*[out]*/ dStdDev,
        DoubleFloat /*[out]*/ dMin,
        DoubleFloat /*[out]*/ dMax)
        throws ComException;

    void getValueByName(
        BStr /*[in]*/ szName,
        Int32 /*[out]*/ lIndex,
        Int32 /*[out]*/ lCount,
        DoubleFloat /*[out]*/ dLast,
        DoubleFloat /*[out]*/ dAverage,
        DoubleFloat /*[out]*/ dStdDev,
        DoubleFloat /*[out]*/ dMin,
        DoubleFloat /*[out]*/ dMax)
        throws ComException;

    Int32 getIndex(
        BStr /*[in]*/ szName,
        Int32 /*[in]*/ lCreate)
        throws ComException;

    void addValue(
        Int32 /*[in]*/ lIndex,
        DoubleFloat /*[in]*/ dValue)
        throws ComException;
}
