package mpi.eudico.client.annotator.nativemedia.quartztypelib;

import com.jniwrapper.*;
import com.jniwrapper.win32.*;
import com.jniwrapper.win32.automation.*;
import com.jniwrapper.win32.automation.impl.*;
import com.jniwrapper.win32.automation.types.*;
import com.jniwrapper.win32.com.*;
import com.jniwrapper.win32.com.impl.*;
import com.jniwrapper.win32.com.types.*;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.*;

/**
 * Represents Java interface for COM interface IMediaControl
 */
public interface IMediaControl extends IDispatch
{
    public static final String INTERFACE_IDENTIFIER = "{56A868B1-0AD4-11CE-B03A-0020AF0BA770}";

    void run()
        throws ComException;

    void pause()
        throws ComException;

    void stop()
        throws ComException;

    Int32 getState(
        Int32 /*[in]*/ msTimeout)
        throws ComException;

    void renderFile(
        BStr /*[in]*/ strFilename)
        throws ComException;

    IDispatch addSourceFilter(
        BStr /*[in]*/ strFilename)
        throws ComException;

    IDispatch getFilterCollection()
        throws ComException;

    IDispatch getRegFilterCollection()
        throws ComException;

    void stopWhenReady()
        throws ComException;
}
