package mpi.eudico.client.annotator.nativemedia.quartztypelib.impl;

import com.jniwrapper.*;
import com.jniwrapper.win32.*;
import com.jniwrapper.win32.automation.*;
import com.jniwrapper.win32.automation.impl.*;
import com.jniwrapper.win32.automation.types.*;
import com.jniwrapper.win32.com.*;
import com.jniwrapper.win32.com.impl.*;
import com.jniwrapper.win32.com.types.*;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.*;

/**
 * Represents COM interface IAMStats
 */
public class IAMStatsImpl extends IDispatchImpl
    implements IAMStats
{
    public static final String INTERFACE_IDENTIFIER = IAMStats.INTERFACE_IDENTIFIER;
    private static final IID _iid = IID.create(INTERFACE_IDENTIFIER);

    public IAMStatsImpl()
    {
    }

    protected IAMStatsImpl(IUnknownImpl that) throws ComException
    {
        super(that);
    }

    public IAMStatsImpl(IUnknown that) throws ComException
    {
        super(that);
    }

    public IAMStatsImpl(CLSID clsid, ClsCtx dwClsContext) throws ComException
    {
        super(clsid, dwClsContext);
    }

    public IAMStatsImpl(CLSID clsid, IUnknownImpl pUnkOuter, ClsCtx dwClsContext) throws ComException
    {
        super(clsid, pUnkOuter, dwClsContext);
    }

    public void reset()
        throws ComException
    {
        invokeStandardVirtualMethod(
            7,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[0]
        );
    }

    public Int32 getCount()
        throws ComException
    {
        Int32 plCount = new Int32();
        invokeStandardVirtualMethod(
            8,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                plCount == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(plCount)
            }
        );
        return plCount;
    }

    public void getValueByIndex(
        Int32 /*[in]*/ lIndex,
        BStr /*[out]*/ szName,
        Int32 /*[out]*/ lCount,
        DoubleFloat /*[out]*/ dLast,
        DoubleFloat /*[out]*/ dAverage,
        DoubleFloat /*[out]*/ dStdDev,
        DoubleFloat /*[out]*/ dMin,
        DoubleFloat /*[out]*/ dMax)
        throws ComException
    {
        invokeStandardVirtualMethod(
            9,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                lIndex,
                szName == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(szName),
                lCount == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(lCount),
                dLast == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(dLast),
                dAverage == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(dAverage),
                dStdDev == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(dStdDev),
                dMin == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(dMin),
                dMax == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(dMax)
            }
        );
    }

    public void getValueByName(
        BStr /*[in]*/ szName,
        Int32 /*[out]*/ lIndex,
        Int32 /*[out]*/ lCount,
        DoubleFloat /*[out]*/ dLast,
        DoubleFloat /*[out]*/ dAverage,
        DoubleFloat /*[out]*/ dStdDev,
        DoubleFloat /*[out]*/ dMin,
        DoubleFloat /*[out]*/ dMax)
        throws ComException
    {
        invokeStandardVirtualMethod(
            10,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                szName == null ? (Parameter)PTR_NULL : new Const(szName),
                lIndex == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(lIndex),
                lCount == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(lCount),
                dLast == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(dLast),
                dAverage == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(dAverage),
                dStdDev == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(dStdDev),
                dMin == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(dMin),
                dMax == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(dMax)
            }
        );
    }

    public Int32 getIndex(
        BStr /*[in]*/ szName,
        Int32 /*[in]*/ lCreate)
        throws ComException
    {
        Int32 plIndex = new Int32();
        invokeStandardVirtualMethod(
            11,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                szName == null ? (Parameter)PTR_NULL : new Const(szName),
                lCreate,
                plIndex == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(plIndex)
            }
        );
        return plIndex;
    }

    public void addValue(
        Int32 /*[in]*/ lIndex,
        DoubleFloat /*[in]*/ dValue)
        throws ComException
    {
        invokeStandardVirtualMethod(
            12,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                lIndex,
                dValue
            }
        );
    }

    public IID getIID()
    {
        return _iid;
    }

    public Object clone()
    {
        IAMStatsImpl that = null;
        try
        {
            that = new IAMStatsImpl(this);
        }
        catch (ComException e)
        {
        }
        return that;
    }
}
