package mpi.eudico.client.annotator.nativemedia.quartztypelib.impl;

import com.jniwrapper.*;
import com.jniwrapper.win32.*;
import com.jniwrapper.win32.com.*;
import com.jniwrapper.win32.com.impl.*;
import com.jniwrapper.win32.com.types.*;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.*;

/**
 * Represents COM interface IDeferredCommand
 */
public class IDeferredCommandImpl extends IUnknownImpl
    implements IDeferredCommand
{
    public static final String INTERFACE_IDENTIFIER = IDeferredCommand.INTERFACE_IDENTIFIER;
    private static final IID _iid = IID.create(INTERFACE_IDENTIFIER);

    public IDeferredCommandImpl()
    {
    }

    protected IDeferredCommandImpl(IUnknownImpl that) throws ComException
    {
        super(that);
    }

    public IDeferredCommandImpl(IUnknown that) throws ComException
    {
        super(that);
    }

    public IDeferredCommandImpl(CLSID clsid, ClsCtx dwClsContext) throws ComException
    {
        super(clsid, dwClsContext);
    }

    public IDeferredCommandImpl(CLSID clsid, IUnknownImpl pUnkOuter, ClsCtx dwClsContext) throws ComException
    {
        super(clsid, pUnkOuter, dwClsContext);
    }

    public void cancel()
        throws ComException
    {
        invokeStandardVirtualMethod(
            3,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[0]
        );
    }

    public Int32 confidence()
        throws ComException
    {
        Int32 pConfidence = new Int32();
        invokeStandardVirtualMethod(
            4,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                pConfidence == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(pConfidence)
            }
        );
        return pConfidence;
    }

    public void postpone(
        DoubleFloat /*[in]*/ newtime)
        throws ComException
    {
        invokeStandardVirtualMethod(
            5,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                newtime
            }
        );
    }

    public HResult getHResult()
        throws ComException
    {
        HResult phrResult = new HResult();
        invokeStandardVirtualMethod(
            6,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                phrResult == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(phrResult)
            }
        );
        return phrResult;
    }

    public IID getIID()
    {
        return _iid;
    }

    public Object clone()
    {
        IDeferredCommandImpl that = null;
        try
        {
            that = new IDeferredCommandImpl(this);
        }
        catch (ComException e)
        {
        }
        return that;
    }
}
