package mpi.eudico.client.annotator.nativemedia.quartztypelib.impl;

import com.jniwrapper.*;
import com.jniwrapper.win32.*;
import com.jniwrapper.win32.automation.*;
import com.jniwrapper.win32.automation.impl.*;
import com.jniwrapper.win32.automation.types.*;
import com.jniwrapper.win32.com.*;
import com.jniwrapper.win32.com.impl.*;
import com.jniwrapper.win32.com.types.*;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.*;

/**
 * Represents COM interface IMediaControl
 */
public class IMediaControlImpl extends IDispatchImpl
    implements IMediaControl
{
    public static final String INTERFACE_IDENTIFIER = IMediaControl.INTERFACE_IDENTIFIER;
    private static final IID _iid = IID.create(INTERFACE_IDENTIFIER);

    public IMediaControlImpl()
    {
    }

    protected IMediaControlImpl(IUnknownImpl that) throws ComException
    {
        super(that);
    }

    public IMediaControlImpl(IUnknown that) throws ComException
    {
        super(that);
    }

    public IMediaControlImpl(CLSID clsid, ClsCtx dwClsContext) throws ComException
    {
        super(clsid, dwClsContext);
    }

    public IMediaControlImpl(CLSID clsid, IUnknownImpl pUnkOuter, ClsCtx dwClsContext) throws ComException
    {
        super(clsid, pUnkOuter, dwClsContext);
    }

    public void run()
        throws ComException
    {
        invokeStandardVirtualMethod(
            7,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[0]
        );
    }

    public void pause()
        throws ComException
    {
        invokeStandardVirtualMethod(
            8,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[0]
        );
    }

    public void stop()
        throws ComException
    {
        invokeStandardVirtualMethod(
            9,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[0]
        );
    }

    public Int32 getState(
        Int32 /*[in]*/ msTimeout)
        throws ComException
    {
        Int32 pfs = new Int32();
        invokeStandardVirtualMethod(
            10,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                msTimeout,
                pfs == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(pfs)
            }
        );
        return pfs;
    }

    public void renderFile(
        BStr /*[in]*/ strFilename)
        throws ComException
    {
        invokeStandardVirtualMethod(
            11,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                strFilename == null ? (Parameter)PTR_NULL : new Const(strFilename)
            }
        );
    }

    public IDispatch addSourceFilter(
        BStr /*[in]*/ strFilename)
        throws ComException
    {
        IDispatchImpl ppUnk = new IDispatchImpl();
        invokeStandardVirtualMethod(
            12,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                strFilename == null ? (Parameter)PTR_NULL : new Const(strFilename),
                ppUnk == null ? (Parameter)PTR_NULL : new Pointer.OutOnly((Parameter)ppUnk)
            }
        );
        return ppUnk;
    }

    public IDispatch getFilterCollection()
        throws ComException
    {
        IDispatchImpl ppUnk = new IDispatchImpl();
        invokeStandardVirtualMethod(
            13,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                ppUnk == null ? (Parameter)PTR_NULL : new Pointer.OutOnly((Parameter)ppUnk)
            }
        );
        return ppUnk;
    }

    public IDispatch getRegFilterCollection()
        throws ComException
    {
        IDispatchImpl ppUnk = new IDispatchImpl();
        invokeStandardVirtualMethod(
            14,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                ppUnk == null ? (Parameter)PTR_NULL : new Pointer.OutOnly((Parameter)ppUnk)
            }
        );
        return ppUnk;
    }

    public void stopWhenReady()
        throws ComException
    {
        invokeStandardVirtualMethod(
            15,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[0]
        );
    }

    public IID getIID()
    {
        return _iid;
    }

    public Object clone()
    {
        IMediaControlImpl that = null;
        try
        {
            that = new IMediaControlImpl(this);
        }
        catch (ComException e)
        {
        }
        return that;
    }
}
