package mpi.eudico.client.annotator.nativemedia.quartztypelib.impl;

import com.jniwrapper.*;
import com.jniwrapper.win32.*;
import com.jniwrapper.win32.automation.*;
import com.jniwrapper.win32.automation.impl.*;
import com.jniwrapper.win32.automation.types.*;
import com.jniwrapper.win32.com.*;
import com.jniwrapper.win32.com.impl.*;
import com.jniwrapper.win32.com.types.*;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.*;

/**
 * Represents COM interface IMediaEventEx
 */
public class IMediaEventExImpl extends IMediaEventImpl
    implements IMediaEventEx
{
    public static final String INTERFACE_IDENTIFIER = IMediaEventEx.INTERFACE_IDENTIFIER;
    private static final IID _iid = IID.create(INTERFACE_IDENTIFIER);

    public IMediaEventExImpl()
    {
    }

    protected IMediaEventExImpl(IUnknownImpl that) throws ComException
    {
        super(that);
    }

    public IMediaEventExImpl(IUnknown that) throws ComException
    {
        super(that);
    }

    public IMediaEventExImpl(CLSID clsid, ClsCtx dwClsContext) throws ComException
    {
        super(clsid, dwClsContext);
    }

    public IMediaEventExImpl(CLSID clsid, IUnknownImpl pUnkOuter, ClsCtx dwClsContext) throws ComException
    {
        super(clsid, pUnkOuter, dwClsContext);
    }

    public void setNotifyWindow(
        LongPtr /*[in]*/ hwnd,
        Int32 /*[in]*/ lMsg,
        LongPtr /*[in]*/ lInstanceData)
        throws ComException
    {
        invokeStandardVirtualMethod(
            13,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                hwnd,
                lMsg,
                lInstanceData
            }
        );
    }

    public void setNotifyFlags(
        Int32 /*[in]*/ lNoNotifyFlags)
        throws ComException
    {
        invokeStandardVirtualMethod(
            14,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                lNoNotifyFlags
            }
        );
    }

    public Int32 getNotifyFlags()
        throws ComException
    {
        Int32 lplNoNotifyFlags = new Int32();
        invokeStandardVirtualMethod(
            15,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                lplNoNotifyFlags == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(lplNoNotifyFlags)
            }
        );
        return lplNoNotifyFlags;
    }

    public IID getIID()
    {
        return _iid;
    }

    public Object clone()
    {
        IMediaEventExImpl that = null;
        try
        {
            that = new IMediaEventExImpl(this);
        }
        catch (ComException e)
        {
        }
        return that;
    }
}
