package mpi.eudico.client.annotator.nativemedia.quartztypelib.impl;

import com.jniwrapper.*;
import com.jniwrapper.win32.*;
import com.jniwrapper.win32.automation.*;
import com.jniwrapper.win32.automation.impl.*;
import com.jniwrapper.win32.automation.types.*;
import com.jniwrapper.win32.com.*;
import com.jniwrapper.win32.com.impl.*;
import com.jniwrapper.win32.com.types.*;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.*;

/**
 * Represents COM interface IMediaEvent
 */
public class IMediaEventImpl extends IDispatchImpl
    implements IMediaEvent
{
    public static final String INTERFACE_IDENTIFIER = IMediaEvent.INTERFACE_IDENTIFIER;
    private static final IID _iid = IID.create(INTERFACE_IDENTIFIER);

    public IMediaEventImpl()
    {
    }

    protected IMediaEventImpl(IUnknownImpl that) throws ComException
    {
        super(that);
    }

    public IMediaEventImpl(IUnknown that) throws ComException
    {
        super(that);
    }

    public IMediaEventImpl(CLSID clsid, ClsCtx dwClsContext) throws ComException
    {
        super(clsid, dwClsContext);
    }

    public IMediaEventImpl(CLSID clsid, IUnknownImpl pUnkOuter, ClsCtx dwClsContext) throws ComException
    {
        super(clsid, pUnkOuter, dwClsContext);
    }

    public LongPtr getEventHandle()
        throws ComException
    {
        LongPtr hEvent = new LongPtr();
        invokeStandardVirtualMethod(
            7,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                hEvent == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(hEvent)
            }
        );
        return hEvent;
    }

    public void getEvent(
        Int32 /*[out]*/ lEventCode,
        LongPtr /*[out]*/ lParam1,
        LongPtr /*[out]*/ lParam2,
        Int32 /*[in]*/ msTimeout)
        throws ComException
    {
        invokeStandardVirtualMethod(
            8,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                lEventCode == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(lEventCode),
                lParam1 == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(lParam1),
                lParam2 == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(lParam2),
                msTimeout
            }
        );
    }

    public Int32 waitForCompletion(
        Int32 /*[in]*/ msTimeout)
        throws ComException
    {
        Int32 pEvCode = new Int32();
        invokeStandardVirtualMethod(
            9,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                msTimeout,
                pEvCode == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(pEvCode)
            }
        );
        return pEvCode;
    }

    public void cancelDefaultHandling(
        Int32 /*[in]*/ lEvCode)
        throws ComException
    {
        invokeStandardVirtualMethod(
            10,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                lEvCode
            }
        );
    }

    public void restoreDefaultHandling(
        Int32 /*[in]*/ lEvCode)
        throws ComException
    {
        invokeStandardVirtualMethod(
            11,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                lEvCode
            }
        );
    }

    public void freeEventParams(
        Int32 /*[in]*/ lEvCode,
        LongPtr /*[in]*/ lParam1,
        LongPtr /*[in]*/ lParam2)
        throws ComException
    {
        invokeStandardVirtualMethod(
            12,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                lEvCode,
                lParam1,
                lParam2
            }
        );
    }

    public IID getIID()
    {
        return _iid;
    }

    public Object clone()
    {
        IMediaEventImpl that = null;
        try
        {
            that = new IMediaEventImpl(this);
        }
        catch (ComException e)
        {
        }
        return that;
    }
}
