package mpi.eudico.client.annotator.nativemedia.quartztypelib.impl;

import com.jniwrapper.*;
import com.jniwrapper.win32.*;
import com.jniwrapper.win32.automation.*;
import com.jniwrapper.win32.automation.impl.*;
import com.jniwrapper.win32.automation.types.*;
import com.jniwrapper.win32.com.*;
import com.jniwrapper.win32.com.impl.*;
import com.jniwrapper.win32.com.types.*;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.*;

/**
 * Represents COM interface IMediaPosition
 */
public class IMediaPositionImpl extends IDispatchImpl
    implements IMediaPosition
{
    public static final String INTERFACE_IDENTIFIER = IMediaPosition.INTERFACE_IDENTIFIER;
    private static final IID _iid = IID.create(INTERFACE_IDENTIFIER);

    public IMediaPositionImpl()
    {
    }

    protected IMediaPositionImpl(IUnknownImpl that) throws ComException
    {
        super(that);
    }

    public IMediaPositionImpl(IUnknown that) throws ComException
    {
        super(that);
    }

    public IMediaPositionImpl(CLSID clsid, ClsCtx dwClsContext) throws ComException
    {
        super(clsid, dwClsContext);
    }

    public IMediaPositionImpl(CLSID clsid, IUnknownImpl pUnkOuter, ClsCtx dwClsContext) throws ComException
    {
        super(clsid, pUnkOuter, dwClsContext);
    }

    public DoubleFloat getDuration()
        throws ComException
    {
        DoubleFloat plength = new DoubleFloat();
        invokeStandardVirtualMethod(
            7,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                plength == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(plength)
            }
        );
        return plength;
    }

    public void setCurrentPosition(
        DoubleFloat /*[in]*/ pllTime)
        throws ComException
    {
        invokeStandardVirtualMethod(
            8,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                pllTime
            }
        );
    }

    public DoubleFloat getCurrentPosition()
        throws ComException
    {
        DoubleFloat pllTime = new DoubleFloat();
        invokeStandardVirtualMethod(
            9,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                pllTime == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(pllTime)
            }
        );
        return pllTime;
    }

    public DoubleFloat getStopTime()
        throws ComException
    {
        DoubleFloat pllTime = new DoubleFloat();
        invokeStandardVirtualMethod(
            10,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                pllTime == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(pllTime)
            }
        );
        return pllTime;
    }

    public void setStopTime(
        DoubleFloat /*[in]*/ pllTime)
        throws ComException
    {
        invokeStandardVirtualMethod(
            11,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                pllTime
            }
        );
    }

    public DoubleFloat getPrerollTime()
        throws ComException
    {
        DoubleFloat pllTime = new DoubleFloat();
        invokeStandardVirtualMethod(
            12,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                pllTime == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(pllTime)
            }
        );
        return pllTime;
    }

    public void setPrerollTime(
        DoubleFloat /*[in]*/ pllTime)
        throws ComException
    {
        invokeStandardVirtualMethod(
            13,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                pllTime
            }
        );
    }

    public void setRate(
        DoubleFloat /*[in]*/ pdRate)
        throws ComException
    {
        invokeStandardVirtualMethod(
            14,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                pdRate
            }
        );
    }

    public DoubleFloat getRate()
        throws ComException
    {
        DoubleFloat pdRate = new DoubleFloat();
        invokeStandardVirtualMethod(
            15,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                pdRate == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(pdRate)
            }
        );
        return pdRate;
    }

    public Int32 canSeekForward()
        throws ComException
    {
        Int32 pCanSeekForward = new Int32();
        invokeStandardVirtualMethod(
            16,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                pCanSeekForward == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(pCanSeekForward)
            }
        );
        return pCanSeekForward;
    }

    public Int32 canSeekBackward()
        throws ComException
    {
        Int32 pCanSeekBackward = new Int32();
        invokeStandardVirtualMethod(
            17,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                pCanSeekBackward == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(pCanSeekBackward)
            }
        );
        return pCanSeekBackward;
    }

    public IID getIID()
    {
        return _iid;
    }

    public Object clone()
    {
        IMediaPositionImpl that = null;
        try
        {
            that = new IMediaPositionImpl(this);
        }
        catch (ComException e)
        {
        }
        return that;
    }
}
