package mpi.eudico.client.annotator.nativemedia.quartztypelib.impl;

import com.jniwrapper.*;
import com.jniwrapper.win32.*;
import com.jniwrapper.win32.automation.types.*;
import com.jniwrapper.win32.com.*;
import com.jniwrapper.win32.com.impl.*;
import com.jniwrapper.win32.com.types.*;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.*;

/**
 * Represents COM interface IQueueCommand
 */
public class IQueueCommandImpl extends IUnknownImpl
    implements IQueueCommand
{
    public static final String INTERFACE_IDENTIFIER = IQueueCommand.INTERFACE_IDENTIFIER;
    private static final IID _iid = IID.create(INTERFACE_IDENTIFIER);

    public IQueueCommandImpl()
    {
    }

    protected IQueueCommandImpl(IUnknownImpl that) throws ComException
    {
        super(that);
    }

    public IQueueCommandImpl(IUnknown that) throws ComException
    {
        super(that);
    }

    public IQueueCommandImpl(CLSID clsid, ClsCtx dwClsContext) throws ComException
    {
        super(clsid, dwClsContext);
    }

    public IQueueCommandImpl(CLSID clsid, IUnknownImpl pUnkOuter, ClsCtx dwClsContext) throws ComException
    {
        super(clsid, pUnkOuter, dwClsContext);
    }

    public void invokeAtStreamTime(
        IDeferredCommand /*[out]*/ pCmd,
        DoubleFloat /*[in]*/ time,
        GUID /*[in]*/ iid,
        Int32 /*[in]*/ dispidMethod,
        Int16 /*[in]*/ wFlags,
        Int32 /*[in]*/ cArgs,
        Variant /*[in]*/ pDispParams,
        Variant /*[in,out]*/ pvarResult,
        Int16 /*[out]*/ puArgErr)
        throws ComException
    {
        invokeStandardVirtualMethod(
            3,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                pCmd == null ? (Parameter)PTR_NULL : new Pointer.OutOnly((Parameter)pCmd),
                time,
                iid == null ? (Parameter)PTR_NULL : new Pointer.Const(iid),
                dispidMethod,
                wFlags,
                cArgs,
                pDispParams == null ? (Parameter)PTR_NULL : new Pointer.Const(pDispParams),
                pvarResult == null ? (Parameter)PTR_NULL : new Pointer(pvarResult),
                puArgErr == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(puArgErr)
            }
        );
    }

    public void invokeAtPresentationTime(
        IDeferredCommand /*[out]*/ pCmd,
        DoubleFloat /*[in]*/ time,
        GUID /*[in]*/ iid,
        Int32 /*[in]*/ dispidMethod,
        Int16 /*[in]*/ wFlags,
        Int32 /*[in]*/ cArgs,
        Variant /*[in]*/ pDispParams,
        Variant /*[in,out]*/ pvarResult,
        Int16 /*[out]*/ puArgErr)
        throws ComException
    {
        invokeStandardVirtualMethod(
            4,
            Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                pCmd == null ? (Parameter)PTR_NULL : new Pointer.OutOnly((Parameter)pCmd),
                time,
                iid == null ? (Parameter)PTR_NULL : new Pointer.Const(iid),
                dispidMethod,
                wFlags,
                cArgs,
                pDispParams == null ? (Parameter)PTR_NULL : new Pointer.Const(pDispParams),
                pvarResult == null ? (Parameter)PTR_NULL : new Pointer(pvarResult),
                puArgErr == null ? (Parameter)PTR_NULL : new Pointer.OutOnly(puArgErr)
            }
        );
    }

    public IID getIID()
    {
        return _iid;
    }

    public Object clone()
    {
        IQueueCommandImpl that = null;
        try
        {
            that = new IQueueCommandImpl(this);
        }
        catch (ComException e)
        {
        }
        return that;
    }
}
