/*
 * File:     DCIdComparator.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.dcr;

import java.util.Comparator;


/**
 * Compares two DCSmall objects! by comparing the idAsInteger fields.
 *
 * @author Han Sloetjes
 */
public class DCIdComparator implements Comparator {
    /**
     * Creates a new DCIdComparator instance
     */
    public DCIdComparator() {
        super();
    }

    /**
     * Compares to objects containing a summary of the information on a data
     * category. To do: check class (ClassCastException), check nulls
     *
     * @param o1 the first DCSmall object to compare
     * @param o2 the second DCSmall object to compare
     *
     * @return -1 if the id of the first object is less than the id of the
     *         second object
     */
    public int compare(Object o1, Object o2) {
        DCSmall dc1 = (DCSmall) o1;
        DCSmall dc2 = (DCSmall) o2;

        return dc1.getIdAsInteger().compareTo(dc2.getIdAsInteger());
    }
}
