/*
 * File:     DCIdentifierComparator.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.dcr;

import java.util.Comparator;


/**
 * Compares two DCSmall objects! by comparing the identifier fields.
 *
 * @author Han Sloetjes
 */
public class DCIdentifierComparator implements Comparator {
    /**
     * Creates a new DCIdentifierComparator instance
     */
    public DCIdentifierComparator() {
        super();
    }

    /**
     * Compares two DCSmall objects! by comparing the identifier fields.
     * To do: check class (ClassCastException), check nulls
     *
     * @param o1 the first DCSmall object
     * @param o2 the second DCSmall object
     *
     * @return the comparison of the (string) identifiers of the data categories
     */
    public int compare(Object o1, Object o2) {
        DCSmall dc1 = (DCSmall) o1;
        DCSmall dc2 = (DCSmall) o2;

        return dc1.getIdentifier().compareTo(dc2.getIdentifier());
    }
}
