/*
 * File:     DCRConnectorException.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.dcr;


/**
 * This class is an exception wrapper for any excepions that get thrown in the
 * DCR connection proces
 *
 * @author markem
 * @version 1.0
 */
public class DCRConnectorException extends Exception {
    /** serialVersionUID */
    private static final long serialVersionUID = -303440770049705699L;
    private Throwable m_throwable;

    /**
     * Creates a new DCRConnectorException instance
     *
     * @param a_message the message
     */
    public DCRConnectorException(String a_message) {
        super(a_message);
    }

    /**
     * Creates a new DCRConnectorException instance
     *
     * @param a_message the message
     * @param a_throwable the cause
     */
    public DCRConnectorException(String a_message, Throwable a_throwable) {
        super(a_message);
        this.setThrowable(a_throwable);
    }

    /**
     * Creates a new DCRConnectorException instance
     *
     * @param a_throwable the cause!
     */
    public DCRConnectorException(Throwable a_throwable) {
        super();
        this.setThrowable(a_throwable);
    }

    /**
     * Returns the cause
     *
     * @return the cause
     */
    public Throwable getThrowable() {
        return m_throwable;
    }

    /**
     * Sets the cause of the exception.
     *
     * @param a_throwable the cause
     */
    protected void setThrowable(Throwable a_throwable) {
        m_throwable = a_throwable;
    }
}
