/*
 * File:     DCTree.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.dcr;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

import javax.swing.tree.DefaultMutableTreeNode;


/**
 * Class that can create a tree based on the broader concept generic attribute
 * of a data category.
 *
 * @author Han Sloetjes
 * @version 1.0
 */
public class DCTree {
    /**
     * Creates a new DCTree instance
     */
    public DCTree() {
        super();
    }

    /**
     * Creates a tree based on the broader concept generic attributes of
     * categories  and returns the root node.
     *
     * @param datcats the list of data categories!
     *
     * @return the root node of the tree
     */
    public DefaultMutableTreeNode getBroaderGenericConceptTree(List datcats) {
        if (datcats == null) {
            return null;
        }

        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        List nodes = new ArrayList(datcats.size());
        DefaultMutableTreeNode node = null;
        DCSmall dcm = null;

        for (int i = 0; i < datcats.size(); i++) {
            dcm = (DCSmall) datcats.get(i);
            node = new DefaultMutableTreeNode(dcm);

            if (dcm.getBroaderDCId() == null) {
                rootNode.add(node);
            } else {
                nodes.add(new DefaultMutableTreeNode(datcats.get(i)));
            }
        }

        Enumeration en;
        DefaultMutableTreeNode nextNode;
        DCSmall nextdcm;
nodeloop: 
        for (int i = 0; i < nodes.size(); i++) {
            node = (DefaultMutableTreeNode) nodes.get(i);
            dcm = (DCSmall) node.getUserObject();

            // first check the nodes in the tree
            en = rootNode.children();

            while (en.hasMoreElements()) {
                nextNode = (DefaultMutableTreeNode) en.nextElement();
                nextdcm = (DCSmall) nextNode.getUserObject();

                if (nextdcm.getIdentifier().equals(dcm.getBroaderDCId())) {
                    nextNode.add(node);

                    continue nodeloop;
                }
            }

            // not added yet
            for (int j = 0; j < nodes.size(); j++) {
                nextNode = (DefaultMutableTreeNode) nodes.get(j);
                nextdcm = (DCSmall) nextNode.getUserObject();

                if (nextdcm.getIdentifier().equals(dcm.getBroaderDCId())) {
                    nextNode.add(node);

                    continue nodeloop;
                }
            }

            // still not added, the node object has a broader concept, but that one is not in the list
            rootNode.add(node);
        }

        return rootNode;
    }
}
