/*
 * File:     ILATDCRConnector.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.dcr;

import java.util.List;


/**
 * Interface for a DCR connector that extends IDCRConnector by adding a method
 * that returns a list of  "small" data category objects (containing a summary
 * of the information of a category).
 *
 *
 * @author Han Sloetjes
 * @version 1.0
 * @version 2.0 July 2009 the GMT based webservice does not exist anymore,
 * neither in France, nor in Nijmegen
 */
public interface ILATDCRConnector extends IDCRConnector2 {
    /**
     * Returns a list of objects containing only part of the information of
     * each  Data Category of the specified profile.
     *
     * @param a_profile the profile
     * @param a_registrationStatus the registration status
     *
     * @return a list with DCSmall objects
     *
     * @throws DCRConnectorException a connector exception
     */
    public List getDCSmallList(String a_profile, String a_registrationStatus)
        throws DCRConnectorException;
}
