/*
 * File:     AdministrationIdentification.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package mpi.dcr.ISO12620;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

import java.net.URL;

import javax.xml.parsers.ParserConfigurationException;


/**
 * <b>AdministrationIdentification</b> is generated from ISO12620_revised.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element java:className="AdministrationIdentification" name="struct">
 *       <attribute name="type">
 *         <value>AI</value>
 *       </attribute>
 *       <ref name="attId"/>
 *       <ref java:propertyName="administrationRecord" name="struct_AR"/>
 *       <optional>
 *         <ref java:propertyName="decisionGroup" name="struct_decisionGroup"/>
 *       </optional>
 *       <optional>
 *         <ref java:propertyName="registrationGroup" name="struct_registrationGroup"/>
 *       </optional>
 *       <optional>
 *         <ref java:propertyName="submissionGroup" name="struct_submissionGroup"/>
 *       </optional>
 *      <optional>
 *         <ref java:propertyName="stewardshipGroup" name="struct_stewardshipGroup"/>
 *       </optional>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element java:className="AdministrationIdentification" name="struct"&gt;
 *       &lt;attribute name="type"&gt;
 *         &lt;value&gt;AI&lt;/value&gt;
 *       &lt;/attribute&gt;
 *       &lt;ref name="attId"/&gt;
 *       &lt;ref java:propertyName="administrationRecord" name="struct_AR"/&gt;
 *       &lt;optional&gt;
 *         &lt;ref java:propertyName="decisionGroup" name="struct_decisionGroup"/&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;ref java:propertyName="registrationGroup" name="struct_registrationGroup"/&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;ref java:propertyName="submissionGroup" name="struct_submissionGroup"/&gt;
 *       &lt;/optional&gt;
 *         &lt;optional&gt;
 *         &lt;ref java:propertyName="stewardshipGroup" name="struct_stewardshipGroup"/&gt;
 *       &lt;/optional&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version ISO12620_revised.rng (Fri Sep 30 12:49:34 CEST 2005)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class AdministrationIdentification implements java.io.Serializable,
    Cloneable {
    /**
 * serialVersionUID(generated)
 */
    private static final long serialVersionUID = -3431352037838271947L;

    /** Holds value of property DOCUMENT ME! */
    public static final String TYPE_AI = "AI";
    private String type_;
    private String id_;
    private AdministrationRecord administrationRecord_;
    private DecisionGroup decisionGroup_;
    private RegistrationGroup registrationGroup_;
    private SubmissionGroup submissionGroup_;
    private StewardshipGroup stewardshipGroup_;

    /**
 * Creates a <code>AdministrationIdentification</code>.
 *
 */
    public AdministrationIdentification() {
        type_ = "";
    }

    /**
 * Creates a <code>AdministrationIdentification</code>.
 *
 * @param source
 */
    public AdministrationIdentification(AdministrationIdentification source) {
        setup(source);
    }

    /**
 * Creates a <code>AdministrationIdentification</code> by the Stack <code>stack</code>
 * that contains Elements.
 * This constructor is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 */
    public AdministrationIdentification(RStack stack) {
        setup(stack);
    }

    /**
 * Creates a <code>AdministrationIdentification</code> by the Document <code>doc</code>.
 *
 * @param doc
 */
    public AdministrationIdentification(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
 * Creates a <code>AdministrationIdentification</code> by the Element <code>element</code>.
 *
 * @param element
 */
    public AdministrationIdentification(Element element) {
        setup(element);
    }

    /**
 * Creates a <code>AdministrationIdentification</code> by the File <code>file</code>.
 *
 * @param file
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public AdministrationIdentification(File file)
        throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
 * Creates a <code>AdministrationIdentification</code>
 * by the String representation of URI <code>uri</code>.
 *
 * @param uri
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public AdministrationIdentification(String uri)
        throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
 * Creates a <code>AdministrationIdentification</code> by the URL <code>url</code>.
 *
 * @param url
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public AdministrationIdentification(URL url)
        throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
 * Creates a <code>AdministrationIdentification</code> by the InputStream <code>in</code>.
 *
 * @param in
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public AdministrationIdentification(InputStream in)
        throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
 * Creates a <code>AdministrationIdentification</code> by the InputSource <code>is</code>.
 *
 * @param is
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public AdministrationIdentification(InputSource is)
        throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
 * Creates a <code>AdministrationIdentification</code> by the Reader <code>reader</code>.
 *
 * @param reader
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public AdministrationIdentification(Reader reader)
        throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
 * Initializes the <code>AdministrationIdentification</code> by the AdministrationIdentification <code>source</code>.
 *
 * @param source
 */
    public void setup(AdministrationIdentification source) {
        setType(source.getType());
        setId(source.getId());

        if (source.administrationRecord_ != null) {
            setAdministrationRecord((AdministrationRecord) source.getAdministrationRecord()
                                                                 .clone());
        }

        if (source.decisionGroup_ != null) {
            setDecisionGroup((DecisionGroup) source.getDecisionGroup().clone());
        }

        if (source.registrationGroup_ != null) {
            setRegistrationGroup((RegistrationGroup) source.getRegistrationGroup()
                                                           .clone());
        }

        if (source.submissionGroup_ != null) {
            setSubmissionGroup((SubmissionGroup) source.getSubmissionGroup()
                                                       .clone());
        }
    }

    /**
 * Initializes the <code>AdministrationIdentification</code> by the Document <code>doc</code>.
 *
 * @param doc
 */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
 * Initializes the <code>AdministrationIdentification</code> by the Element <code>element</code>.
 *
 * @param element
 */
    public void setup(Element element) {
        init(element);
    }

    /**
 * Initializes the <code>AdministrationIdentification</code> by the Stack <code>stack</code>
 * that contains Elements.
 * This constructor is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
 * @param element
 */
    private void init(Element element) {
        RStack stack = new RStack(element);
        type_ = URelaxer.getAttributePropertyAsString(element, "type");
        id_ = URelaxer.getAttributePropertyAsString(element, "id");
        setAdministrationRecord(new AdministrationRecord(stack));

        if (DecisionGroup.isMatch(stack)) {
            setDecisionGroup(new DecisionGroup(stack));
        }

        if (RegistrationGroup.isMatch(stack)) {
            setRegistrationGroup(new RegistrationGroup(stack));
        }

        if (SubmissionGroup.isMatch(stack)) {
            setSubmissionGroup(new SubmissionGroup(stack));
        }

        if (StewardshipGroup.isMatch(stack)) {
            setStewardshipGroup(new StewardshipGroup(stack));
        }
    }

    /**
 * @return Object
 */
    public Object clone() {
        return (new AdministrationIdentification(this));
    }

    /**
 * Creates a DOM representation of the object.
 * Result is appended to the Node <code>parent</code>.
 *
 * @param parent
 */
    public void makeElement(Node parent) {
        Document doc;

        if (parent instanceof Document) {
            doc = (Document) parent;
        } else {
            doc = parent.getOwnerDocument();
        }

        Element element = doc.createElement("struct");

        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }

        if (this.id_ != null) {
            URelaxer.setAttributePropertyByString(element, "id", this.id_);
        }

        this.administrationRecord_.makeElement(element);

        if (this.decisionGroup_ != null) {
            this.decisionGroup_.makeElement(element);
        }

        if (this.registrationGroup_ != null) {
            this.registrationGroup_.makeElement(element);
        }

        if (this.submissionGroup_ != null) {
            this.submissionGroup_.makeElement(element);
        }

        parent.appendChild(element);
    }

    /**
 * Initializes the <code>AdministrationIdentification</code> by the File <code>file</code>.
 *
 * @param file
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(File file)
        throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
 * Initializes the <code>AdministrationIdentification</code>
 * by the String representation of URI <code>uri</code>.
 *
 * @param uri
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(String uri)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>AdministrationIdentification</code> by the URL <code>url</code>.
 *
 * @param url
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(URL url)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>AdministrationIdentification</code> by the InputStream <code>in</code>.
 *
 * @param in
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(InputStream in)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>AdministrationIdentification</code> by the InputSource <code>is</code>.
 *
 * @param is
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(InputSource is)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>AdministrationIdentification</code> by the Reader <code>reader</code>.
 *
 * @param reader
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(Reader reader)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
 * Creates a DOM document representation of the object.
 *
 * @exception ParserConfigurationException
 * @return Document
 */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);

        return (doc);
    }

    /**
 * Gets the String property <b>type</b>.
 *
 * @return String
 */
    public String getType() {
        return (type_);
    }

    /**
 * Sets the String property <b>type</b>.
 *
 * @param type
 */
    public void setType(String type) {
        this.type_ = type;
    }

    /**
 * Gets the String property <b>id</b>.
 *
 * @return String
 */
    public String getId() {
        return (id_);
    }

    /**
 * Sets the String property <b>id</b>.
 *
 * @param id
 */
    public void setId(String id) {
        this.id_ = id;
    }

    /**
 * Gets the AdministrationRecord property <b>administrationRecord</b>.
 *
 * @return AdministrationRecord
 */
    public AdministrationRecord getAdministrationRecord() {
        return (administrationRecord_);
    }

    /**
 * Sets the AdministrationRecord property <b>administrationRecord</b>.
 *
 * @param administrationRecord
 */
    public void setAdministrationRecord(
        AdministrationRecord administrationRecord) {
        this.administrationRecord_ = administrationRecord;
    }

    /**
 * Gets the DecisionGroup property <b>decisionGroup</b>.
 *
 * @return DecisionGroup
 */
    public DecisionGroup getDecisionGroup() {
        return (decisionGroup_);
    }

    /**
 * Sets the DecisionGroup property <b>decisionGroup</b>.
 *
 * @param decisionGroup
 */
    public void setDecisionGroup(DecisionGroup decisionGroup) {
        this.decisionGroup_ = decisionGroup;
    }

    /**
 * Gets the RegistrationGroup property <b>registrationGroup</b>.
 *
 * @return RegistrationGroup
 */
    public RegistrationGroup getRegistrationGroup() {
        return (registrationGroup_);
    }

    /**
 * Sets the RegistrationGroup property <b>registrationGroup</b>.
 *
 * @param registrationGroup
 */
    public void setRegistrationGroup(RegistrationGroup registrationGroup) {
        this.registrationGroup_ = registrationGroup;
    }

    /**
 * Gets the SubmissionGroup property <b>submissionGroup</b>.
 *
 * @return SubmissionGroup
 */
    public SubmissionGroup getSubmissionGroup() {
        return (submissionGroup_);
    }

    /**
 * Sets the SubmissionGroup property <b>submissionGroup</b>.
 *
 * @param submissionGroup
 */
    public void setSubmissionGroup(SubmissionGroup submissionGroup) {
        this.submissionGroup_ = submissionGroup;
    }

    /**
 * @return Returns the stewardshipGroup.
 */
    public StewardshipGroup getStewardshipGroup() {
        return stewardshipGroup_;
    }

    /**
 * @param stewardshipGroup The stewardshipGroup to set.
 */
    public void setStewardshipGroup(StewardshipGroup stewardshipGroup) {
        this.stewardshipGroup_ = stewardshipGroup;
    }

    /**
 * Makes an XML text representation.
 *
 * @return String
 */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);

        return (new String(buffer));
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<struct");

        if (type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.append("\"");
        }

        if (id_ != null) {
            buffer.append(" id=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.append("\"");
        }

        buffer.append(">");
        administrationRecord_.makeTextElement(buffer);

        if (decisionGroup_ != null) {
            decisionGroup_.makeTextElement(buffer);
        }

        if (registrationGroup_ != null) {
            registrationGroup_.makeTextElement(buffer);
        }

        if (submissionGroup_ != null) {
            submissionGroup_.makeTextElement(buffer);
        }

        buffer.append("</struct>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 * @exception IOException
 */
    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<struct");

        if (type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.write("\"");
        }

        if (id_ != null) {
            buffer.write(" id=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.write("\"");
        }

        buffer.write(">");
        administrationRecord_.makeTextElement(buffer);

        if (decisionGroup_ != null) {
            decisionGroup_.makeTextElement(buffer);
        }

        if (registrationGroup_ != null) {
            registrationGroup_.makeTextElement(buffer);
        }

        if (submissionGroup_ != null) {
            submissionGroup_.makeTextElement(buffer);
        }

        buffer.write("</struct>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<struct");

        if (type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.print("\"");
        }

        if (id_ != null) {
            buffer.print(" id=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.print("\"");
        }

        buffer.print(">");
        administrationRecord_.makeTextElement(buffer);

        if (decisionGroup_ != null) {
            decisionGroup_.makeTextElement(buffer);
        }

        if (registrationGroup_ != null) {
            registrationGroup_.makeTextElement(buffer);
        }

        if (submissionGroup_ != null) {
            submissionGroup_.makeTextElement(buffer);
        }

        buffer.print("</struct>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 * @exception IOException
 */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
 * Gets the property value as String.
 *
 * @return String
 */
    public String getTypeAsString() {
        return (URelaxer.getString(getType()));
    }

    /**
 * Gets the property value as String.
 *
 * @return String
 */
    public String getIdAsString() {
        return (URelaxer.getString(getId()));
    }

    /**
 * Sets the property value by String.
 *
 * @param string
 */
    public void setTypeByString(String string) {
        setType(string);
    }

    /**
 * Sets the property value by String.
 *
 * @param string
 */
    public void setIdByString(String string) {
        setId(string);
    }

    /**
 * Returns a String representation of this object.
 * While this method informs as XML format representaion, 
 *  it's purpose is just information, not making 
 * a rigid XML documentation.
 *
 * @return String
 */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
 * Tests if a Element <code>element</code> is valid
 * for the <code>AdministrationIdentification</code>.
 *
 * @param element
 * @return boolean
 */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "struct")) {
            return (false);
        }

        RStack target = new RStack(element);

        if (!URelaxer.hasAttributeHungry(target, "type")) {
            return (false);
        }

        if (!URelaxer.isMatchDataValuesAttr(element, "type", "token", "AI")) {
            return (false);
        }

        if (!AdministrationRecord.isMatchHungry(target)) {
            return (false);
        }

        if (DecisionGroup.isMatchHungry(target)) {
        }

        if (RegistrationGroup.isMatchHungry(target)) {
        }

        if (SubmissionGroup.isMatchHungry(target)) {
        }

        if (StewardshipGroup.isMatchHungry(target)) {
        }

        if (!target.isEmptyElement()) {
            return (false);
        }

        return (true);
    }

    /**
 * Tests if elements contained in a Stack <code>stack</code>
 * is valid for the <code>AdministrationIdentification</code>.
 * This mehtod is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 * @return boolean
 */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();

        if (element == null) {
            return (false);
        }

        return (isMatch(element));
    }

    /**
 * Tests if elements contained in a Stack <code>stack</code>
 * is valid for the <code>AdministrationIdentification</code>.
 * This method consumes the stack contents during matching operation.
 * This mehtod is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 * @return boolean
 */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();

        if (element == null) {
            return (false);
        }

        if (isMatch(element)) {
            stack.popElement();

            return (true);
        } else {
            return (false);
        }
    }
}
