/*
 * File:     AdministrationRecord.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package mpi.dcr.ISO12620;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

import java.net.URL;

import java.util.logging.Logger;

import javax.xml.parsers.ParserConfigurationException;


/**
 * <b>AdministrationRecord</b> is generated from ISO12620_revised.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element java:className="AdministrationRecord" name="struct">
 *       <attribute name="type">
 *         <value>AR</value>
 *       </attribute>
 *       <ref name="attId"/>
 *       <ref java:propertyName="identifier" name="identifier_struct_AR"/>
 *       <ref java:propertyName="registrationStatus" name="registrationStatus_struct_AR"/>
 *       <ref java:propertyName="creationDate" name="creationDate_struct_AR"/>
 *       <optional>
 *           <ref java:propertyName="lastChangeDate" name="lastChangeDate_struct_AR"/>
 *       </optional>
 *       <optional>
 *           <ref java:propertyName="origin" name="origin_struct_AR"/>
 *       </optional>
 *       <zeroOrMore>
 *           <ref java:propertyName="explanatoryComment" name="explanatoryComment_struct_AR"/>
 *       </zeroOrMore>
 *       <optional>
 *         <ref java:propertyName="effectiveDate" name="effectiveDate_struct_AR"/>
 *       </optional>
 *       <ref java:propertyName="administrationStatus" name="administrationStatus_struct_AR"/>
 *       
 *       
 *       <zeroOrMore>
 *         <ref java:propertyName="unresolvedIssues" name="unresolvedIssue_struct_AR"/>
 *       </zeroOrMore>
 *       <optional>
 *         <ref java:propertyName="untilDate" name="untilDate_struct_AR"/>
 *       </optional>
 *       
 *       
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element java:className="AdministrationRecord" name="struct"&gt;
 *       &lt;attribute name="type"&gt;
 *         &lt;value&gt;AR&lt;/value&gt;
 *       &lt;/attribute&gt;
 *       &lt;ref name="attId"/&gt;
 *       &lt;ref java:propertyName="identifier" name="identifier_struct_AR"/&gt;
 *       &lt;ref java:propertyName="registrationStatus" name="registrationStatus_struct_AR"/&gt;
 *       &lt;ref java:propertyName="creationDate" name="creationDate_struct_AR"/&gt;
 *       &lt;optional&gt;
 *           &lt;ref java:propertyName="lastChangeDate" name="lastChangeDate_struct_AR"/&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *           &lt;ref java:propertyName="origin" name="origin_struct_AR"/&gt;
 *       &lt;/optional&gt;
 *       &lt;zeroOrMore&gt;
 *           &lt;ref java:propertyName="explanatoryComment" name="explanatoryComment_struct_AR"/&gt;
 *       &lt;/zeroOrMore&gt;
 *       &lt;optional&gt;
 *         &lt;ref java:propertyName="effectiveDate" name="effectiveDate_struct_AR"/&gt;
 *       &lt;/optional&gt;
 *       &lt;ref java:propertyName="administrationStatus" name="administrationStatus_struct_AR"/&gt;
 *       
 *       
 *       &lt;zeroOrMore&gt;
 *         &lt;ref java:propertyName="unresolvedIssues" name="unresolvedIssue_struct_AR"/&gt;
 *       &lt;/zeroOrMore&gt;
 *       &lt;optional&gt;
 *         &lt;ref java:propertyName="untilDate" name="untilDate_struct_AR"/&gt;
 *       &lt;/optional&gt;
 *       
 *       
 *     &lt;/element&gt;</pre>
 *
 * @version ISO12620_revised.rng (Fri Sep 30 12:49:34 CEST 2005)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class AdministrationRecord implements java.io.Serializable, Cloneable {
    /**
 * serialVersionUID(generated)
 */
    private static final long serialVersionUID = -5891400710110625665L;

    /** Logger for this class and subclasses */
    protected final static Logger logger = Logger.getLogger("DCR");

    /** Holds value of property DOCUMENT ME! */
    public static final String TYPE_AR = "AR";
    private String type_;
    private String id_;
    private IdentifierBrack identifier_;
    private RegistrationStatus registrationStatus_;
    private ICreationDate creationDateStructAR_;
    private ILastChangeDate lastChangeDate_;
    private Origin origin_;

    // List<ExplanatoryComment>
    private java.util.List explanatoryComment_ = new java.util.ArrayList();
    private EffectiveDate effectiveDate_;
    private AdministrationStatus administrationStatus_;

    // List<UnresolvedIssue>
    private java.util.List unresolvedIssues_ = new java.util.ArrayList();
    private UntilDate untilDate_;

    /**
 * Creates a <code>AdministrationRecord</code>.
 *
 */
    public AdministrationRecord() {
        type_ = "";
    }

    /**
 * Creates a <code>AdministrationRecord</code>.
 *
 * @param source
 */
    public AdministrationRecord(AdministrationRecord source) {
        setup(source);
    }

    /**
 * Creates a <code>AdministrationRecord</code> by the Stack <code>stack</code>
 * that contains Elements.
 * This constructor is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 */
    public AdministrationRecord(RStack stack) {
        setup(stack);
    }

    /**
 * Creates a <code>AdministrationRecord</code> by the Document <code>doc</code>.
 *
 * @param doc
 */
    public AdministrationRecord(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
 * Creates a <code>AdministrationRecord</code> by the Element <code>element</code>.
 *
 * @param element
 */
    public AdministrationRecord(Element element) {
        setup(element);
    }

    /**
 * Creates a <code>AdministrationRecord</code> by the File <code>file</code>.
 *
 * @param file
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public AdministrationRecord(File file)
        throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
 * Creates a <code>AdministrationRecord</code>
 * by the String representation of URI <code>uri</code>.
 *
 * @param uri
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public AdministrationRecord(String uri)
        throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
 * Creates a <code>AdministrationRecord</code> by the URL <code>url</code>.
 *
 * @param url
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public AdministrationRecord(URL url)
        throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
 * Creates a <code>AdministrationRecord</code> by the InputStream <code>in</code>.
 *
 * @param in
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public AdministrationRecord(InputStream in)
        throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
 * Creates a <code>AdministrationRecord</code> by the InputSource <code>is</code>.
 *
 * @param is
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public AdministrationRecord(InputSource is)
        throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
 * Creates a <code>AdministrationRecord</code> by the Reader <code>reader</code>.
 *
 * @param reader
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public AdministrationRecord(Reader reader)
        throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
 * Initializes the <code>AdministrationRecord</code> by the AdministrationRecord <code>source</code>.
 *
 * @param source
 */
    public void setup(AdministrationRecord source) {
        int size;
        setType(source.getType());
        setId(source.getId());

        if (source.identifier_ != null) {
            setIdentifier((IdentifierBrack) source.getIdentifier().clone());
        }

        if (source.registrationStatus_ != null) {
            setRegistrationStatus((RegistrationStatus) source.getRegistrationStatus()
                                                             .clone());
        }

        if (source.creationDateStructAR_ != null) {
            setCreationDate((ICreationDate) source.getCreationDate().clone());
        }

        if (source.lastChangeDate_ != null) {
            setLastChangeDate((ILastChangeDate) source.getLastChangeDate()
                                                      .clone());
        }

        if (source.origin_ != null) {
            setOrigin((Origin) source.getOrigin().clone());
        }

        this.explanatoryComment_.clear();
        size = source.explanatoryComment_.size();

        for (int i = 0; i < size; i++) {
            addExplanatoryComment((ExplanatoryComment) source.getExplanatoryComment(
                    i).clone());
        }

        if (source.effectiveDate_ != null) {
            setEffectiveDate((EffectiveDate) source.getEffectiveDate().clone());
        }

        if (source.administrationStatus_ != null) {
            setAdministrationStatus((AdministrationStatus) source.getAdministrationStatus()
                                                                 .clone());
        }

        this.unresolvedIssues_.clear();
        size = source.unresolvedIssues_.size();

        for (int i = 0; i < size; i++) {
            addUnresolvedIssue((UnresolvedIssue) source.getUnresolvedIssues(i)
                                                       .clone());
        }

        if (source.untilDate_ != null) {
            setUntilDate((UntilDate) source.getUntilDate().clone());
        }
    }

    /**
 * Initializes the <code>AdministrationRecord</code> by the Document <code>doc</code>.
 *
 * @param doc
 */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
 * Initializes the <code>AdministrationRecord</code> by the Element <code>element</code>.
 *
 * @param element
 */
    public void setup(Element element) {
        init(element);
    }

    /**
 * Initializes the <code>AdministrationRecord</code> by the Stack <code>stack</code>
 * that contains Elements.
 * This constructor is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
 * @param element
 */
    private void init(Element element) {
        RStack stack = new RStack(element);
        type_ = URelaxer.getAttributePropertyAsString(element, "type");
        id_ = URelaxer.getAttributePropertyAsString(element, "id");
        setIdentifier(new IdentifierBrack(stack));
        setRegistrationStatus(new RegistrationStatus(stack));

        if (CreationDate.isMatch(stack)) {
            setCreationDate(new CreationDate(stack));
        } else if (CreationDateBrack.isMatch(stack)) {
            setCreationDate(new CreationDateBrack(stack));
        } else {
            throw (new IllegalArgumentException());
        }

        if (LastChangeDate.isMatch(stack)) {
            setLastChangeDate(new LastChangeDate(stack));
        } else if (LastChangeDateBrack.isMatch(stack)) {
            setLastChangeDate(new LastChangeDateBrack(stack));
        } else {
        }

        if (Origin.isMatch(stack)) {
            setOrigin(new Origin(stack));
        }

        explanatoryComment_.clear();

        while (true) {
            if (ExplanatoryComment.isMatch(stack)) {
                addExplanatoryComment(new ExplanatoryComment(stack));
            } else {
                break;
            }
        }

        if (EffectiveDate.isMatch(stack)) {
            setEffectiveDate(new EffectiveDate(stack));
        }

        setAdministrationStatus(new AdministrationStatus(stack));
        unresolvedIssues_.clear();

        while (true) {
            if (UnresolvedIssue.isMatch(stack)) {
                addUnresolvedIssue(new UnresolvedIssue(stack));
            } else {
                break;
            }
        }

        if (UntilDate.isMatch(stack)) {
            setUntilDate(new UntilDate(stack));
        }
    }

    /**
 * @return Object
 */
    public Object clone() {
        return (new AdministrationRecord(this));
    }

    /**
 * Creates a DOM representation of the object.
 * Result is appended to the Node <code>parent</code>.
 *
 * @param parent
 */
    public void makeElement(Node parent) {
        Document doc;

        if (parent instanceof Document) {
            doc = (Document) parent;
        } else {
            doc = parent.getOwnerDocument();
        }

        Element element = doc.createElement("struct");
        int size;

        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }

        if (this.id_ != null) {
            URelaxer.setAttributePropertyByString(element, "id", this.id_);
        }

        this.identifier_.makeElement(element);
        this.registrationStatus_.makeElement(element);
        this.creationDateStructAR_.makeElement(element);

        if (this.lastChangeDate_ != null) {
            this.lastChangeDate_.makeElement(element);
        }

        if (this.origin_ != null) {
            this.origin_.makeElement(element);
        }

        size = this.explanatoryComment_.size();

        for (int i = 0; i < size; i++) {
            ExplanatoryComment value = (ExplanatoryComment) this.explanatoryComment_.get(i);
            value.makeElement(element);
        }

        if (this.effectiveDate_ != null) {
            this.effectiveDate_.makeElement(element);
        }

        this.administrationStatus_.makeElement(element);
        size = this.unresolvedIssues_.size();

        for (int i = 0; i < size; i++) {
            UnresolvedIssue value = (UnresolvedIssue) this.unresolvedIssues_.get(i);
            value.makeElement(element);
        }

        if (this.untilDate_ != null) {
            this.untilDate_.makeElement(element);
        }

        parent.appendChild(element);
    }

    /**
 * Initializes the <code>AdministrationRecord</code> by the File <code>file</code>.
 *
 * @param file
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(File file)
        throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
 * Initializes the <code>AdministrationRecord</code>
 * by the String representation of URI <code>uri</code>.
 *
 * @param uri
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(String uri)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>AdministrationRecord</code> by the URL <code>url</code>.
 *
 * @param url
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(URL url)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>AdministrationRecord</code> by the InputStream <code>in</code>.
 *
 * @param in
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(InputStream in)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>AdministrationRecord</code> by the InputSource <code>is</code>.
 *
 * @param is
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(InputSource is)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>AdministrationRecord</code> by the Reader <code>reader</code>.
 *
 * @param reader
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(Reader reader)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
 * Creates a DOM document representation of the object.
 *
 * @exception ParserConfigurationException
 * @return Document
 */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);

        return (doc);
    }

    /**
 * Gets the String property <b>type</b>.
 *
 * @return String
 */
    public String getType() {
        return (type_);
    }

    /**
 * Sets the String property <b>type</b>.
 *
 * @param type
 */
    public void setType(String type) {
        this.type_ = type;
    }

    /**
 * Gets the String property <b>id</b>.
 *
 * @return String
 */
    public String getId() {
        return (id_);
    }

    /**
 * Sets the String property <b>id</b>.
 *
 * @param id
 */
    public void setId(String id) {
        this.id_ = id;
    }

    /**
 * Gets the IdentifierBrack property <b>identifier</b>.
 *
 * @return IdentifierBrack
 */
    public IdentifierBrack getIdentifier() {
        return (identifier_);
    }

    /**
 * Sets the IdentifierBrack property <b>identifier</b>.
 *
 * @param identifier
 */
    public void setIdentifier(IdentifierBrack identifier) {
        this.identifier_ = identifier;
    }

    /**
 * Gets the RegistrationStatus property <b>registrationStatus</b>.
 *
 * @return RegistrationStatus
 */
    public RegistrationStatus getRegistrationStatus() {
        return (registrationStatus_);
    }

    /**
 * Sets the RegistrationStatus property <b>registrationStatus</b>.
 *
 * @param registrationStatus
 */
    public void setRegistrationStatus(RegistrationStatus registrationStatus) {
        this.registrationStatus_ = registrationStatus;
    }

    /**
 * Gets the ICreationDateStructARChoice property <b>creationDateStructAR</b>.
 *
 * @return ICreationDateStructARChoice
 */
    public ICreationDate getCreationDate() {
        return (creationDateStructAR_);
    }

    /**
 * Sets the ICreationDateStructARChoice property <b>creationDateStructAR</b>.
 *
 * @param creationDateStructAR
 */
    public void setCreationDate(ICreationDate creationDateStructAR) {
        this.creationDateStructAR_ = creationDateStructAR;
    }

    /**
 * Gets the ILastChangeDateStructARChoice property <b>lastChangeDateStructAR</b>.
 *
 * @return ILastChangeDateStructARChoice
 */
    public ILastChangeDate getLastChangeDate() {
        return (lastChangeDate_);
    }

    /**
 * Sets the ILastChangeDateStructARChoice property <b>lastChangeDateStructAR</b>.
 *
 * @param lastChangeDateStructAR
 */
    public void setLastChangeDate(ILastChangeDate lastChangeDateStructAR) {
        this.lastChangeDate_ = lastChangeDateStructAR;
    }

    /**
 * Gets the Origin property <b>origin</b>.
 *
 * @return Origin
 */
    public Origin getOrigin() {
        return (origin_);
    }

    /**
 * Sets the Origin property <b>origin</b>.
 *
 * @param origin
 */
    public void setOrigin(Origin origin) {
        this.origin_ = origin;
    }

    /**
 * Gets the ExplanatoryComment property <b>explanatoryComment</b>.
 *
 * @return ExplanatoryComment[]
 */
    public ExplanatoryComment[] getExplanatoryComment() {
        ExplanatoryComment[] array = new ExplanatoryComment[explanatoryComment_.size()];

        return ((ExplanatoryComment[]) explanatoryComment_.toArray(array));
    }

    /**
 * Sets the ExplanatoryComment property <b>explanatoryComment</b>.
 *
 * @param explanatoryComment
 */
    public void setExplanatoryComments(ExplanatoryComment[] explanatoryComment) {
        this.explanatoryComment_.clear();

        for (int i = 0; i < explanatoryComment.length; i++) {
            addExplanatoryComment(explanatoryComment[i]);
        }
    }

    /**
 * Sets the ExplanatoryComment property <b>explanatoryComment</b>.
 *
 * @param explanatoryComment
 */
    public void setExplanatoryComments(ExplanatoryComment explanatoryComment) {
        this.explanatoryComment_.clear();
        addExplanatoryComment(explanatoryComment);
    }

    /**
 * Adds the ExplanatoryComment property <b>explanatoryComment</b>.
 *
 * @param explanatoryComment
 */
    public void addExplanatoryComment(ExplanatoryComment explanatoryComment) {
        this.explanatoryComment_.add(explanatoryComment);
    }

    /**
 * Adds the ExplanatoryComment property <b>explanatoryComment</b>.
 *
 * @param explanatoryComment
 */
    public void addExplanatoryComments(ExplanatoryComment[] explanatoryComment) {
        for (int i = 0; i < explanatoryComment.length; i++) {
            addExplanatoryComment(explanatoryComment[i]);
        }
    }

    /**
 * Gets number of the ExplanatoryComment property <b>explanatoryComment</b>.
 *
 * @return int
 */
    public int sizeExplanatoryComment() {
        return (explanatoryComment_.size());
    }

    /**
 * Gets the ExplanatoryComment property <b>explanatoryComment</b> by index.
 *
 * @param index
 * @return ExplanatoryComment
 */
    public ExplanatoryComment getExplanatoryComment(int index) {
        return ((ExplanatoryComment) explanatoryComment_.get(index));
    }

    /**
 * Sets the ExplanatoryComment property <b>explanatoryComment</b> by index.
 *
 * @param index
 * @param explanatoryComment
 */
    public void setExplanatoryComment(int index,
        ExplanatoryComment explanatoryComment) {
        this.explanatoryComment_.set(index, explanatoryComment);
    }

    /**
 * Adds the ExplanatoryComment property <b>explanatoryComment</b> by index.
 *
 * @param index
 * @param explanatoryComment
 */
    public void addExplanatoryComment(int index,
        ExplanatoryComment explanatoryComment) {
        this.explanatoryComment_.add(index, explanatoryComment);
    }

    /**
 * Remove the ExplanatoryComment property <b>explanatoryComment</b> by index.
 *
 * @param index
 */
    public void removeExplanatoryComment(int index) {
        this.explanatoryComment_.remove(index);
    }

    /**
 * Remove the ExplanatoryComment property <b>explanatoryComment</b> by object.
 *
 * @param explanatoryComment
 */
    public void removeExplanatoryComment(ExplanatoryComment explanatoryComment) {
        this.explanatoryComment_.remove(explanatoryComment);
    }

    /**
 * Clear the ExplanatoryComment property <b>explanatoryComment</b>.
 *
 */
    public void clearExplanatoryComment() {
        this.explanatoryComment_.clear();
    }

    /**
 * Gets the EffectiveDate property <b>effectiveDate</b>.
 *
 * @return EffectiveDate
 */
    public EffectiveDate getEffectiveDate() {
        return (effectiveDate_);
    }

    /**
 * Sets the EffectiveDate property <b>effectiveDate</b>.
 *
 * @param effectiveDate
 */
    public void setEffectiveDate(EffectiveDate effectiveDate) {
        this.effectiveDate_ = effectiveDate;
    }

    /**
 * Gets the AdministrationStatus property <b>administrationStatus</b>.
 *
 * @return AdministrationStatus
 */
    public AdministrationStatus getAdministrationStatus() {
        return (administrationStatus_);
    }

    /**
 * Sets the AdministrationStatus property <b>administrationStatus</b>.
 *
 * @param administrationStatus
 */
    public void setAdministrationStatus(
        AdministrationStatus administrationStatus) {
        this.administrationStatus_ = administrationStatus;
    }

    /**
 * Gets the UnresolvedIssue property <b>unresolvedIssues</b>.
 *
 * @return UnresolvedIssue[]
 */
    public UnresolvedIssue[] getUnresolvedIssues() {
        UnresolvedIssue[] array = new UnresolvedIssue[unresolvedIssues_.size()];

        return ((UnresolvedIssue[]) unresolvedIssues_.toArray(array));
    }

    /**
 * Sets the UnresolvedIssue property <b>unresolvedIssues</b>.
 *
 * @param unresolvedIssues
 */
    public void setUnresolvedIssues(UnresolvedIssue[] unresolvedIssues) {
        this.unresolvedIssues_.clear();

        for (int i = 0; i < unresolvedIssues.length; i++) {
            addUnresolvedIssue(unresolvedIssues[i]);
        }
    }

    /**
 * Sets the UnresolvedIssue property <b>unresolvedIssues</b>.
 *
 * @param unresolvedIssues
 */
    public void setUnresolvedIssues(UnresolvedIssue unresolvedIssues) {
        this.unresolvedIssues_.clear();
        addUnresolvedIssue(unresolvedIssues);
    }

    /**
 * Adds the UnresolvedIssue property <b>unresolvedIssues</b>.
 *
 * @param unresolvedIssues
 */
    public void addUnresolvedIssue(UnresolvedIssue unresolvedIssues) {
        this.unresolvedIssues_.add(unresolvedIssues);
    }

    /**
 * Adds the UnresolvedIssue property <b>unresolvedIssues</b>.
 *
 * @param unresolvedIssues
 */
    public void addUnresolvedIssues(UnresolvedIssue[] unresolvedIssues) {
        for (int i = 0; i < unresolvedIssues.length; i++) {
            addUnresolvedIssue(unresolvedIssues[i]);
        }
    }

    /**
 * Gets number of the UnresolvedIssue property <b>unresolvedIssues</b>.
 *
 * @return int
 */
    public int sizeUnresolvedIssues() {
        return (unresolvedIssues_.size());
    }

    /**
 * Gets the UnresolvedIssue property <b>unresolvedIssues</b> by index.
 *
 * @param index
 * @return UnresolvedIssue
 */
    public UnresolvedIssue getUnresolvedIssues(int index) {
        return ((UnresolvedIssue) unresolvedIssues_.get(index));
    }

    /**
 * Sets the UnresolvedIssue property <b>unresolvedIssues</b> by index.
 *
 * @param index
 * @param unresolvedIssues
 */
    public void setUnresolvedIssue(int index, UnresolvedIssue unresolvedIssues) {
        this.unresolvedIssues_.set(index, unresolvedIssues);
    }

    /**
 * Adds the UnresolvedIssue property <b>unresolvedIssues</b> by index.
 *
 * @param index
 * @param unresolvedIssues
 */
    public void addUnresolvedIssue(int index, UnresolvedIssue unresolvedIssues) {
        this.unresolvedIssues_.add(index, unresolvedIssues);
    }

    /**
 * Remove the UnresolvedIssue property <b>unresolvedIssues</b> by index.
 *
 * @param index
 */
    public void removeUnresolvedIssue(int index) {
        this.unresolvedIssues_.remove(index);
    }

    /**
 * Remove the UnresolvedIssue property <b>unresolvedIssues</b> by object.
 *
 * @param unresolvedIssues
 */
    public void removeUnresolvedIssue(UnresolvedIssue unresolvedIssues) {
        this.unresolvedIssues_.remove(unresolvedIssues);
    }

    /**
 * Clear the UnresolvedIssue property <b>unresolvedIssues</b>.
 *
 */
    public void clearUnresolvedIssues() {
        this.unresolvedIssues_.clear();
    }

    /**
 * Gets the UntilDate property <b>untilDate</b>.
 *
 * @return UntilDate
 */
    public UntilDate getUntilDate() {
        return (untilDate_);
    }

    /**
 * Sets the UntilDate property <b>untilDate</b>.
 *
 * @param untilDate
 */
    public void setUntilDate(UntilDate untilDate) {
        this.untilDate_ = untilDate;
    }

    /**
 * Makes an XML text representation.
 *
 * @return String
 */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);

        return (new String(buffer));
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<struct");

        if (type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.append("\"");
        }

        if (id_ != null) {
            buffer.append(" id=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.append("\"");
        }

        creationDateStructAR_.makeTextAttribute(buffer);

        if (lastChangeDate_ != null) {
            lastChangeDate_.makeTextAttribute(buffer);
        }

        buffer.append(">");
        identifier_.makeTextElement(buffer);
        registrationStatus_.makeTextElement(buffer);
        creationDateStructAR_.makeTextElement(buffer);

        if (lastChangeDate_ != null) {
            lastChangeDate_.makeTextElement(buffer);
        }

        if (origin_ != null) {
            origin_.makeTextElement(buffer);
        }

        size = this.explanatoryComment_.size();

        for (int i = 0; i < size; i++) {
            ExplanatoryComment value = (ExplanatoryComment) this.explanatoryComment_.get(i);
            value.makeTextElement(buffer);
        }

        if (effectiveDate_ != null) {
            effectiveDate_.makeTextElement(buffer);
        }

        administrationStatus_.makeTextElement(buffer);
        size = this.unresolvedIssues_.size();

        for (int i = 0; i < size; i++) {
            UnresolvedIssue value = (UnresolvedIssue) this.unresolvedIssues_.get(i);
            value.makeTextElement(buffer);
        }

        if (untilDate_ != null) {
            untilDate_.makeTextElement(buffer);
        }

        buffer.append("</struct>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 * @exception IOException
 */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<struct");

        if (type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.write("\"");
        }

        if (id_ != null) {
            buffer.write(" id=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.write("\"");
        }

        creationDateStructAR_.makeTextAttribute(buffer);

        if (lastChangeDate_ != null) {
            lastChangeDate_.makeTextAttribute(buffer);
        }

        buffer.write(">");
        identifier_.makeTextElement(buffer);
        registrationStatus_.makeTextElement(buffer);
        creationDateStructAR_.makeTextElement(buffer);

        if (lastChangeDate_ != null) {
            lastChangeDate_.makeTextElement(buffer);
        }

        if (origin_ != null) {
            origin_.makeTextElement(buffer);
        }

        size = this.explanatoryComment_.size();

        for (int i = 0; i < size; i++) {
            ExplanatoryComment value = (ExplanatoryComment) this.explanatoryComment_.get(i);
            value.makeTextElement(buffer);
        }

        if (effectiveDate_ != null) {
            effectiveDate_.makeTextElement(buffer);
        }

        administrationStatus_.makeTextElement(buffer);
        size = this.unresolvedIssues_.size();

        for (int i = 0; i < size; i++) {
            UnresolvedIssue value = (UnresolvedIssue) this.unresolvedIssues_.get(i);
            value.makeTextElement(buffer);
        }

        if (untilDate_ != null) {
            untilDate_.makeTextElement(buffer);
        }

        buffer.write("</struct>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<struct");

        if (type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.print("\"");
        }

        if (id_ != null) {
            buffer.print(" id=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.print("\"");
        }

        creationDateStructAR_.makeTextAttribute(buffer);

        if (lastChangeDate_ != null) {
            lastChangeDate_.makeTextAttribute(buffer);
        }

        buffer.print(">");
        identifier_.makeTextElement(buffer);
        registrationStatus_.makeTextElement(buffer);
        creationDateStructAR_.makeTextElement(buffer);

        if (lastChangeDate_ != null) {
            lastChangeDate_.makeTextElement(buffer);
        }

        if (origin_ != null) {
            origin_.makeTextElement(buffer);
        }

        size = this.explanatoryComment_.size();

        for (int i = 0; i < size; i++) {
            ExplanatoryComment value = (ExplanatoryComment) this.explanatoryComment_.get(i);
            value.makeTextElement(buffer);
        }

        if (effectiveDate_ != null) {
            effectiveDate_.makeTextElement(buffer);
        }

        administrationStatus_.makeTextElement(buffer);
        size = this.unresolvedIssues_.size();

        for (int i = 0; i < size; i++) {
            UnresolvedIssue value = (UnresolvedIssue) this.unresolvedIssues_.get(i);
            value.makeTextElement(buffer);
        }

        if (untilDate_ != null) {
            untilDate_.makeTextElement(buffer);
        }

        buffer.print("</struct>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 * @exception IOException
 */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
 * Gets the property value as String.
 *
 * @return String
 */
    public String getTypeAsString() {
        return (URelaxer.getString(getType()));
    }

    /**
 * Gets the property value as String.
 *
 * @return String
 */
    public String getIdAsString() {
        return (URelaxer.getString(getId()));
    }

    /**
 * Sets the property value by String.
 *
 * @param string
 */
    public void setTypeByString(String string) {
        setType(string);
    }

    /**
 * Sets the property value by String.
 *
 * @param string
 */
    public void setIdByString(String string) {
        setId(string);
    }

    /**
 * Returns a String representation of this object.
 * While this method informs as XML format representaion, 
 *  it's purpose is just information, not making 
 * a rigid XML documentation.
 *
 * @return String
 */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
 * Tests if a Element <code>element</code> is valid
 * for the <code>AdministrationRecord</code>.
 *
 * @param element
 * @return boolean
 */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "struct")) {
            return (false);
        }

        RStack target = new RStack(element);

        if (!URelaxer.hasAttributeHungry(target, "type")) {
            return (false);
        }

        if (!URelaxer.isMatchDataValuesAttr(element, "type", "token", "AR")) {
            return (false);
        }

        if (!IdentifierBrack.isMatchHungry(target)) {
            return (false);
        }

        if (!RegistrationStatus.isMatchHungry(target)) {
            return (false);
        }

        if (CreationDate.isMatchHungry(target)) {
        } else if (CreationDateBrack.isMatchHungry(target)) {
        } else {
            return (false);
        }

        if (LastChangeDate.isMatchHungry(target)) {
        } else if (LastChangeDateBrack.isMatchHungry(target)) {
        } else {
        }

        if (Origin.isMatchHungry(target)) {
        }

        while (true) {
            if (!ExplanatoryComment.isMatchHungry(target)) {
                break;
            }
        }

        if (EffectiveDate.isMatchHungry(target)) {
        }

        if (!AdministrationStatus.isMatchHungry(target)) {
            return (false);
        }

        while (true) {
            if (!UnresolvedIssue.isMatchHungry(target)) {
                break;
            }
        }

        if (UntilDate.isMatchHungry(target)) {
        }

        if (!target.isEmptyElement()) {
            return (false);
        }

        return (true);
    }

    /**
 * Tests if elements contained in a Stack <code>stack</code>
 * is valid for the <code>AdministrationRecord</code>.
 * This mehtod is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 * @return boolean
 */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();

        if (element == null) {
            return (false);
        }

        return (isMatch(element));
    }

    /**
 * Tests if elements contained in a Stack <code>stack</code>
 * is valid for the <code>AdministrationRecord</code>.
 * This method consumes the stack contents during matching operation.
 * This mehtod is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 * @return boolean
 */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();

        if (element == null) {
            return (false);
        }

        if (isMatch(element)) {
            stack.popElement();

            return (true);
        } else {
            return (false);
        }
    }
}
