/*
 * File:     CreationDateBrack.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package mpi.dcr.ISO12620;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

import java.net.URL;

import javax.xml.parsers.ParserConfigurationException;


/**
 * <b>CreationDateBrack</b> is generated from ISO12620_revised.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element java:className="CreationDateBrack" name="brack">
 *         <element java:className="CreationDate" name="feat">
 *           <attribute name="type">
 *             <value>creationDate</value>
 *           </attribute>
 *           <ref java:propertyName="language" name="attLang"/>
 *           <text java:propertyName="value"/>
 *         </element>
 *         <optional>
 *           <ref java:propertyName="changeDescription" name="changeDescription_creationDate_struct_AR"/>
 *         </optional>
 *       </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element java:className="CreationDateBrack" name="brack"&gt;
 *         &lt;element java:className="CreationDate" name="feat"&gt;
 *           &lt;attribute name="type"&gt;
 *             &lt;value&gt;creationDate&lt;/value&gt;
 *           &lt;/attribute&gt;
 *           &lt;ref java:propertyName="language" name="attLang"/&gt;
 *           &lt;text java:propertyName="value"/&gt;
 *         &lt;/element&gt;
 *         &lt;optional&gt;
 *           &lt;ref java:propertyName="changeDescription" name="changeDescription_creationDate_struct_AR"/&gt;
 *         &lt;/optional&gt;
 *       &lt;/element&gt;</pre>
 *
 * @version ISO12620_revised.rng (Fri Sep 30 12:49:34 CEST 2005)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class CreationDateBrack implements java.io.Serializable, Cloneable,
    ICreationDate {
    /**
 * serialVersionID(generated)
 */
    private static final long serialVersionUID = 3725050675213032656L;
    private CreationDate creationDate_;
    private ChangeDescription changeDescription_;

    /**
 * Creates a <code>CreationDateBrack</code>.
 *
 */
    public CreationDateBrack() {
    }

    /**
 * Creates a <code>CreationDateBrack</code>.
 *
 * @param source
 */
    public CreationDateBrack(CreationDateBrack source) {
        setup(source);
    }

    /**
 * Creates a <code>CreationDateBrack</code> by the Stack <code>stack</code>
 * that contains Elements.
 * This constructor is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 */
    public CreationDateBrack(RStack stack) {
        setup(stack);
    }

    /**
 * Creates a <code>CreationDateBrack</code> by the Document <code>doc</code>.
 *
 * @param doc
 */
    public CreationDateBrack(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
 * Creates a <code>CreationDateBrack</code> by the Element <code>element</code>.
 *
 * @param element
 */
    public CreationDateBrack(Element element) {
        setup(element);
    }

    /**
 * Creates a <code>CreationDateBrack</code> by the File <code>file</code>.
 *
 * @param file
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public CreationDateBrack(File file)
        throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
 * Creates a <code>CreationDateBrack</code>
 * by the String representation of URI <code>uri</code>.
 *
 * @param uri
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public CreationDateBrack(String uri)
        throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
 * Creates a <code>CreationDateBrack</code> by the URL <code>url</code>.
 *
 * @param url
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public CreationDateBrack(URL url)
        throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
 * Creates a <code>CreationDateBrack</code> by the InputStream <code>in</code>.
 *
 * @param in
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public CreationDateBrack(InputStream in)
        throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
 * Creates a <code>CreationDateBrack</code> by the InputSource <code>is</code>.
 *
 * @param is
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public CreationDateBrack(InputSource is)
        throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
 * Creates a <code>CreationDateBrack</code> by the Reader <code>reader</code>.
 *
 * @param reader
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public CreationDateBrack(Reader reader)
        throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
 * Initializes the <code>CreationDateBrack</code> by the CreationDateBrack <code>source</code>.
 *
 * @param source
 */
    public void setup(CreationDateBrack source) {
        if (source.creationDate_ != null) {
            setCreationDate((CreationDate) source.getCreationDate().clone());
        }

        if (source.changeDescription_ != null) {
            setChangeDescription((ChangeDescription) source.getChangeDescription()
                                                           .clone());
        }
    }

    /**
 * Initializes the <code>CreationDateBrack</code> by the Document <code>doc</code>.
 *
 * @param doc
 */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
 * Initializes the <code>CreationDateBrack</code> by the Element <code>element</code>.
 *
 * @param element
 */
    public void setup(Element element) {
        init(element);
    }

    /**
 * Initializes the <code>CreationDateBrack</code> by the Stack <code>stack</code>
 * that contains Elements.
 * This constructor is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
 * @param element
 */
    private void init(Element element) {
        RStack stack = new RStack(element);
        setCreationDate(new CreationDate(stack));

        if (ChangeDescription.isMatch(stack)) {
            setChangeDescription(new ChangeDescription(stack));
        }
    }

    /**
 * @return Object
 */
    public Object clone() {
        return (new CreationDateBrack(this));
    }

    /**
 * Creates a DOM representation of the object.
 * Result is appended to the Node <code>parent</code>.
 *
 * @param parent
 */
    public void makeElement(Node parent) {
        Document doc;

        if (parent instanceof Document) {
            doc = (Document) parent;
        } else {
            doc = parent.getOwnerDocument();
        }

        Element element = doc.createElement("brack");
        this.creationDate_.makeElement(element);

        if (this.changeDescription_ != null) {
            this.changeDescription_.makeElement(element);
        }

        parent.appendChild(element);
    }

    /**
 * Initializes the <code>CreationDateBrack</code> by the File <code>file</code>.
 *
 * @param file
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(File file)
        throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
 * Initializes the <code>CreationDateBrack</code>
 * by the String representation of URI <code>uri</code>.
 *
 * @param uri
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(String uri)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>CreationDateBrack</code> by the URL <code>url</code>.
 *
 * @param url
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(URL url)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>CreationDateBrack</code> by the InputStream <code>in</code>.
 *
 * @param in
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(InputStream in)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>CreationDateBrack</code> by the InputSource <code>is</code>.
 *
 * @param is
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(InputSource is)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>CreationDateBrack</code> by the Reader <code>reader</code>.
 *
 * @param reader
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(Reader reader)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
 * Creates a DOM document representation of the object.
 *
 * @exception ParserConfigurationException
 * @return Document
 */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);

        return (doc);
    }

    /**
 * Gets the CreationDate property <b>creationDateStructARBrackFeat</b>.
 *
 * @return CreationDate
 */
    public CreationDate getCreationDate() {
        return (creationDate_);
    }

    /**
 * Sets the CreationDate property <b>creationDateStructARBrackFeat</b>.
 *
 * @param creationDateStructARBrackFeat
 */
    public void setCreationDate(CreationDate creationDateStructARBrackFeat) {
        this.creationDate_ = creationDateStructARBrackFeat;
    }

    /**
 * Gets the ChangeDescription property <b>changeDescription</b>.
 *
 * @return ChangeDescription
 */
    public ChangeDescription getChangeDescription() {
        return (changeDescription_);
    }

    /**
 * Sets the ChangeDescription property <b>changeDescription</b>.
 *
 * @param changeDescription
 */
    public void setChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription_ = changeDescription;
    }

    /**
 * Makes an XML text representation.
 *
 * @return String
 */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);

        return (new String(buffer));
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<brack");
        buffer.append(">");
        creationDate_.makeTextElement(buffer);

        if (changeDescription_ != null) {
            changeDescription_.makeTextElement(buffer);
        }

        buffer.append("</brack>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 * @exception IOException
 */
    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<brack");
        buffer.write(">");
        creationDate_.makeTextElement(buffer);

        if (changeDescription_ != null) {
            changeDescription_.makeTextElement(buffer);
        }

        buffer.write("</brack>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<brack");
        buffer.print(">");
        creationDate_.makeTextElement(buffer);

        if (changeDescription_ != null) {
            changeDescription_.makeTextElement(buffer);
        }

        buffer.print("</brack>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 * @exception IOException
 */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
 * Returns a String representation of this object.
 * While this method informs as XML format representaion, 
 *  it's purpose is just information, not making 
 * a rigid XML documentation.
 *
 * @return String
 */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
 * Tests if a Element <code>element</code> is valid
 * for the <code>CreationDateBrack</code>.
 *
 * @param element
 * @return boolean
 */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "brack")) {
            return (false);
        }

        RStack target = new RStack(element);

        if (!CreationDate.isMatchHungry(target)) {
            return (false);
        }

        if (ChangeDescription.isMatchHungry(target)) {
        }

        if (!target.isEmptyElement()) {
            return (false);
        }

        return (true);
    }

    /**
 * Tests if elements contained in a Stack <code>stack</code>
 * is valid for the <code>CreationDateBrack</code>.
 * This mehtod is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 * @return boolean
 */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();

        if (element == null) {
            return (false);
        }

        return (isMatch(element));
    }

    /**
 * Tests if elements contained in a Stack <code>stack</code>
 * is valid for the <code>CreationDateBrack</code>.
 * This method consumes the stack contents during matching operation.
 * This mehtod is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 * @return boolean
 */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();

        if (element == null) {
            return (false);
        }

        if (isMatch(element)) {
            stack.popElement();

            return (true);
        } else {
            return (false);
        }
    }
}
