/*
 * File:     DCR.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package mpi.dcr.ISO12620;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

import java.net.URL;

import javax.xml.parsers.ParserConfigurationException;


/**
 * <b>DCR</b> is generated from ISO12620_revised.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element java:className="DCR" name="struct">
 *       <attribute name="type">
 *         <value>DCR</value>
 *       </attribute>
 *       <ref name="attId"/>
 *       <zeroOrMore>
 *         <ref java:propertyName="globalInformations" name="struct_GI"/>
 *       </zeroOrMore>
 *       <zeroOrMore>
 *           <ref java:propertyName="dataCategories" name="struct_DC"/>
 *       </zeroOrMore>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element java:className="DCR" name="struct"&gt;
 *       &lt;attribute name="type"&gt;
 *         &lt;value&gt;DCR&lt;/value&gt;
 *       &lt;/attribute&gt;
 *       &lt;ref name="attId"/&gt;
 *       &lt;zeroOrMore&gt;
 *         &lt;ref java:propertyName="globalInformations" name="struct_GI"/&gt;
 *       &lt;/zeroOrMore&gt;
 *       &lt;zeroOrMore&gt;
 *           &lt;ref java:propertyName="dataCategories" name="struct_DC"/&gt;
 *       &lt;/zeroOrMore&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version ISO12620_revised.rng (Fri Sep 30 12:49:34 CEST 2005)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class DCR implements java.io.Serializable, Cloneable {
    /**
 * serialVersionID(generated)
 */
    private static final long serialVersionUID = 4424227135766965426L;

    /** Holds value of property DOCUMENT ME! */
    public static final String TYPE_DCR = "DCR";
    private String type_;
    private String id_;

    // List<GlobalInformation>
    private java.util.List globalInformations_ = new java.util.ArrayList();

    // List<DataCategory>
    private java.util.List dataCategories_ = new java.util.ArrayList();

    /**
 * Creates a <code>DCR</code>.
 *
 */
    public DCR() {
        type_ = "";
    }

    /**
 * Creates a <code>DCR</code>.
 *
 * @param source
 */
    public DCR(DCR source) {
        setup(source);
    }

    /**
 * Creates a <code>DCR</code> by the Stack <code>stack</code>
 * that contains Elements.
 * This constructor is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 */
    public DCR(RStack stack) {
        setup(stack);
    }

    /**
 * Creates a <code>DCR</code> by the Document <code>doc</code>.
 *
 * @param doc
 */
    public DCR(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
 * Creates a <code>DCR</code> by the Element <code>element</code>.
 *
 * @param element
 */
    public DCR(Element element) {
        setup(element);
    }

    /**
 * Creates a <code>DCR</code> by the File <code>file</code>.
 *
 * @param file
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public DCR(File file)
        throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
 * Creates a <code>DCR</code>
 * by the String representation of URI <code>uri</code>.
 *
 * @param uri
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public DCR(String uri)
        throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
 * Creates a <code>DCR</code> by the URL <code>url</code>.
 *
 * @param url
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public DCR(URL url)
        throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
 * Creates a <code>DCR</code> by the InputStream <code>in</code>.
 *
 * @param in
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public DCR(InputStream in)
        throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
 * Creates a <code>DCR</code> by the InputSource <code>is</code>.
 *
 * @param is
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public DCR(InputSource is)
        throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
 * Creates a <code>DCR</code> by the Reader <code>reader</code>.
 *
 * @param reader
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public DCR(Reader reader)
        throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
 * Initializes the <code>DCR</code> by the DCR <code>source</code>.
 *
 * @param source
 */
    public void setup(DCR source) {
        int size;
        setType(source.getType());
        setId(source.getId());
        this.globalInformations_.clear();
        size = source.globalInformations_.size();

        for (int i = 0; i < size; i++) {
            addGlobalInformations((GlobalInformation) source.getGlobalInformations(
                    i).clone());
        }

        this.dataCategories_.clear();
        size = source.dataCategories_.size();

        for (int i = 0; i < size; i++) {
            addDataCategories((DataCategory) source.getDataCategories(i).clone());
        }
    }

    /**
 * Initializes the <code>DCR</code> by the Document <code>doc</code>.
 *
 * @param doc
 */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
 * Initializes the <code>DCR</code> by the Element <code>element</code>.
 *
 * @param element
 */
    public void setup(Element element) {
        init(element);
    }

    /**
 * Initializes the <code>DCR</code> by the Stack <code>stack</code>
 * that contains Elements.
 * This constructor is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
 * @param element
 */
    private void init(Element element) {
        RStack stack = new RStack(element);
        type_ = URelaxer.getAttributePropertyAsString(element, "type");
        id_ = URelaxer.getAttributePropertyAsString(element, "id");
        globalInformations_.clear();

        while (true) {
            if (GlobalInformation.isMatch(stack)) {
                addGlobalInformations(new GlobalInformation(stack));
            } else {
                break;
            }
        }

        dataCategories_.clear();

        while (true) {
            if (DataCategory.isMatch(stack)) {
                addDataCategories(new DataCategory(stack));
            } else {
                break;
            }
        }
    }

    /**
 * @return Object
 */
    public Object clone() {
        return (new DCR(this));
    }

    /**
 * Creates a DOM representation of the object.
 * Result is appended to the Node <code>parent</code>.
 *
 * @param parent
 */
    public void makeElement(Node parent) {
        Document doc;

        if (parent instanceof Document) {
            doc = (Document) parent;
        } else {
            doc = parent.getOwnerDocument();
        }

        Element element = doc.createElement("struct");
        int size;

        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }

        if (this.id_ != null) {
            URelaxer.setAttributePropertyByString(element, "id", this.id_);
        }

        size = this.globalInformations_.size();

        for (int i = 0; i < size; i++) {
            GlobalInformation value = (GlobalInformation) this.globalInformations_.get(i);
            value.makeElement(element);
        }

        size = this.dataCategories_.size();

        for (int i = 0; i < size; i++) {
            DataCategory value = (DataCategory) this.dataCategories_.get(i);
            value.makeElement(element);
        }

        parent.appendChild(element);
    }

    /**
 * Initializes the <code>DCR</code> by the File <code>file</code>.
 *
 * @param file
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(File file)
        throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
 * Initializes the <code>DCR</code>
 * by the String representation of URI <code>uri</code>.
 *
 * @param uri
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(String uri)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>DCR</code> by the URL <code>url</code>.
 *
 * @param url
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(URL url)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>DCR</code> by the InputStream <code>in</code>.
 *
 * @param in
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(InputStream in)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>DCR</code> by the InputSource <code>is</code>.
 *
 * @param is
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(InputSource is)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>DCR</code> by the Reader <code>reader</code>.
 *
 * @param reader
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(Reader reader)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
 * Creates a DOM document representation of the object.
 *
 * @exception ParserConfigurationException
 * @return Document
 */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);

        return (doc);
    }

    /**
 * Gets the String property <b>type</b>.
 *
 * @return String
 */
    public String getType() {
        return (type_);
    }

    /**
 * Sets the String property <b>type</b>.
 *
 * @param type
 */
    public void setType(String type) {
        this.type_ = type;
    }

    /**
 * Gets the String property <b>id</b>.
 *
 * @return String
 */
    public String getId() {
        return (id_);
    }

    /**
 * Sets the String property <b>id</b>.
 *
 * @param id
 */
    public void setId(String id) {
        this.id_ = id;
    }

    /**
 * Gets the GlobalInformation property <b>globalInformations</b>.
 *
 * @return GlobalInformation[]
 */
    public GlobalInformation[] getGlobalInformations() {
        GlobalInformation[] array = new GlobalInformation[globalInformations_.size()];

        return ((GlobalInformation[]) globalInformations_.toArray(array));
    }

    /**
 * Sets the GlobalInformation property <b>globalInformations</b>.
 *
 * @param globalInformations
 */
    public void setGlobalInformations(GlobalInformation[] globalInformations) {
        this.globalInformations_.clear();

        for (int i = 0; i < globalInformations.length; i++) {
            addGlobalInformations(globalInformations[i]);
        }
    }

    /**
 * Sets the GlobalInformation property <b>globalInformations</b>.
 *
 * @param globalInformations
 */
    public void setGlobalInformations(GlobalInformation globalInformations) {
        this.globalInformations_.clear();
        addGlobalInformations(globalInformations);
    }

    /**
 * Adds the GlobalInformation property <b>globalInformations</b>.
 *
 * @param globalInformations
 */
    public void addGlobalInformations(GlobalInformation globalInformations) {
        this.globalInformations_.add(globalInformations);
    }

    /**
 * Adds the GlobalInformation property <b>globalInformations</b>.
 *
 * @param globalInformations
 */
    public void addGlobalInformations(GlobalInformation[] globalInformations) {
        for (int i = 0; i < globalInformations.length; i++) {
            addGlobalInformations(globalInformations[i]);
        }
    }

    /**
 * Gets number of the GlobalInformation property <b>globalInformations</b>.
 *
 * @return int
 */
    public int sizeGlobalInformations() {
        return (globalInformations_.size());
    }

    /**
 * Gets the GlobalInformation property <b>globalInformations</b> by index.
 *
 * @param index
 * @return GlobalInformation
 */
    public GlobalInformation getGlobalInformations(int index) {
        return ((GlobalInformation) globalInformations_.get(index));
    }

    /**
 * Sets the GlobalInformation property <b>globalInformations</b> by index.
 *
 * @param index
 * @param globalInformations
 */
    public void setGlobalInformations(int index,
        GlobalInformation globalInformations) {
        this.globalInformations_.set(index, globalInformations);
    }

    /**
 * Adds the GlobalInformation property <b>globalInformations</b> by index.
 *
 * @param index
 * @param globalInformations
 */
    public void addGlobalInformations(int index,
        GlobalInformation globalInformations) {
        this.globalInformations_.add(index, globalInformations);
    }

    /**
 * Remove the GlobalInformation property <b>globalInformations</b> by index.
 *
 * @param index
 */
    public void removeGlobalInformations(int index) {
        this.globalInformations_.remove(index);
    }

    /**
 * Remove the GlobalInformation property <b>globalInformations</b> by object.
 *
 * @param globalInformations
 */
    public void removeGlobalInformations(GlobalInformation globalInformations) {
        this.globalInformations_.remove(globalInformations);
    }

    /**
 * Clear the GlobalInformation property <b>globalInformations</b>.
 *
 */
    public void clearGlobalInformations() {
        this.globalInformations_.clear();
    }

    /**
 * Gets the DataCategory property <b>dataCategories</b>.
 *
 * @return DataCategory[]
 */
    public DataCategory[] getDataCategories() {
        DataCategory[] array = new DataCategory[dataCategories_.size()];

        return ((DataCategory[]) dataCategories_.toArray(array));
    }

    /**
 * Sets the DataCategory property <b>dataCategories</b>.
 *
 * @param dataCategories
 */
    public void setDataCategories(DataCategory[] dataCategories) {
        this.dataCategories_.clear();

        for (int i = 0; i < dataCategories.length; i++) {
            addDataCategories(dataCategories[i]);
        }
    }

    /**
 * Sets the DataCategory property <b>dataCategories</b>.
 *
 * @param dataCategories
 */
    public void setDataCategories(DataCategory dataCategories) {
        this.dataCategories_.clear();
        addDataCategories(dataCategories);
    }

    /**
 * Adds the DataCategory property <b>dataCategories</b>.
 *
 * @param dataCategories
 */
    public void addDataCategories(DataCategory dataCategories) {
        this.dataCategories_.add(dataCategories);
    }

    /**
 * Adds the DataCategory property <b>dataCategories</b>.
 *
 * @param dataCategories
 */
    public void addDataCategories(DataCategory[] dataCategories) {
        for (int i = 0; i < dataCategories.length; i++) {
            addDataCategories(dataCategories[i]);
        }
    }

    /**
 * Gets number of the DataCategory property <b>dataCategories</b>.
 *
 * @return int
 */
    public int sizeDataCategories() {
        return (dataCategories_.size());
    }

    /**
 * Gets the DataCategory property <b>dataCategories</b> by index.
 *
 * @param index
 * @return DataCategory
 */
    public DataCategory getDataCategories(int index) {
        return ((DataCategory) dataCategories_.get(index));
    }

    /**
 * Sets the DataCategory property <b>dataCategories</b> by index.
 *
 * @param index
 * @param dataCategories
 */
    public void setDataCategories(int index, DataCategory dataCategories) {
        this.dataCategories_.set(index, dataCategories);
    }

    /**
 * Adds the DataCategory property <b>dataCategories</b> by index.
 *
 * @param index
 * @param dataCategories
 */
    public void addDataCategories(int index, DataCategory dataCategories) {
        this.dataCategories_.add(index, dataCategories);
    }

    /**
 * Remove the DataCategory property <b>dataCategories</b> by index.
 *
 * @param index
 */
    public void removeDataCategories(int index) {
        this.dataCategories_.remove(index);
    }

    /**
 * Remove the DataCategory property <b>dataCategories</b> by object.
 *
 * @param dataCategories
 */
    public void removeDataCategories(DataCategory dataCategories) {
        this.dataCategories_.remove(dataCategories);
    }

    /**
 * Clear the DataCategory property <b>dataCategories</b>.
 *
 */
    public void clearDataCategories() {
        this.dataCategories_.clear();
    }

    /**
 * Makes an XML text representation.
 *
 * @return String
 */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);

        return (new String(buffer));
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<struct");

        if (type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.append("\"");
        }

        if (id_ != null) {
            buffer.append(" id=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.append("\"");
        }

        buffer.append(">");
        size = this.globalInformations_.size();

        for (int i = 0; i < size; i++) {
            GlobalInformation value = (GlobalInformation) this.globalInformations_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.dataCategories_.size();

        for (int i = 0; i < size; i++) {
            DataCategory value = (DataCategory) this.dataCategories_.get(i);
            value.makeTextElement(buffer);
        }

        buffer.append("</struct>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 * @exception IOException
 */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<struct");

        if (type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.write("\"");
        }

        if (id_ != null) {
            buffer.write(" id=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.write("\"");
        }

        buffer.write(">");
        size = this.globalInformations_.size();

        for (int i = 0; i < size; i++) {
            GlobalInformation value = (GlobalInformation) this.globalInformations_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.dataCategories_.size();

        for (int i = 0; i < size; i++) {
            DataCategory value = (DataCategory) this.dataCategories_.get(i);
            value.makeTextElement(buffer);
        }

        buffer.write("</struct>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<struct");

        if (type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.print("\"");
        }

        if (id_ != null) {
            buffer.print(" id=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.print("\"");
        }

        buffer.print(">");
        size = this.globalInformations_.size();

        for (int i = 0; i < size; i++) {
            GlobalInformation value = (GlobalInformation) this.globalInformations_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.dataCategories_.size();

        for (int i = 0; i < size; i++) {
            DataCategory value = (DataCategory) this.dataCategories_.get(i);
            value.makeTextElement(buffer);
        }

        buffer.print("</struct>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 * @exception IOException
 */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
 * Gets the property value as String.
 *
 * @return String
 */
    public String getTypeAsString() {
        return (URelaxer.getString(getType()));
    }

    /**
 * Gets the property value as String.
 *
 * @return String
 */
    public String getIdAsString() {
        return (URelaxer.getString(getId()));
    }

    /**
 * Sets the property value by String.
 *
 * @param string
 */
    public void setTypeByString(String string) {
        setType(string);
    }

    /**
 * Sets the property value by String.
 *
 * @param string
 */
    public void setIdByString(String string) {
        setId(string);
    }

    /**
 * Returns a String representation of this object.
 * While this method informs as XML format representaion, 
 *  it's purpose is just information, not making 
 * a rigid XML documentation.
 *
 * @return String
 */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
 * Tests if a Element <code>element</code> is valid
 * for the <code>DCR</code>.
 *
 * @param element
 * @return boolean
 */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "struct")) {
            return (false);
        }

        RStack target = new RStack(element);

        if (!URelaxer.hasAttributeHungry(target, "type")) {
            return (false);
        }

        if (!URelaxer.isMatchDataValuesAttr(element, "type", "token", "DCR")) {
            return (false);
        }

        while (true) {
            if (!GlobalInformation.isMatchHungry(target)) {
                break;
            }
        }

        while (true) {
            if (!DataCategory.isMatchHungry(target)) {
                break;
            }
        }

        if (!target.isEmptyElement()) {
            return (false);
        }

        return (true);
    }

    /**
 * Tests if elements contained in a Stack <code>stack</code>
 * is valid for the <code>DCR</code>.
 * This mehtod is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 * @return boolean
 */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();

        if (element == null) {
            return (false);
        }

        return (isMatch(element));
    }

    /**
 * Tests if elements contained in a Stack <code>stack</code>
 * is valid for the <code>DCR</code>.
 * This method consumes the stack contents during matching operation.
 * This mehtod is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 * @return boolean
 */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();

        if (element == null) {
            return (false);
        }

        if (isMatch(element)) {
            stack.popElement();

            return (true);
        } else {
            return (false);
        }
    }
}
