/*
 * File:     DataCategorySelection.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package mpi.dcr.ISO12620;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

import java.net.URL;

import javax.xml.parsers.ParserConfigurationException;


/**
 * <b>DataCategorySelection</b> is generated from DatCatsPerprofile.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element java:className="DataCategorySelection" name="STRUCT">
 *         <attribute name="type">
 *           <value>DCS</value> 
 *         </attribute>
 *         <zeroOrMore>
 *          <ref java:propertyName="DataCategorySummaries" name="struct_DC"/>
 *         </zeroOrMore>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element java:className="DataCategorySelection" name="STRUCT"&gt;
 *         &lt;attribute name="type"&gt;
 *           &lt;value&gt;DCS&lt;/value&gt; 
 *         &lt;/attribute&gt;
 *         &lt;zeroOrMore&gt;
 *          &lt;ref java:propertyName="DataCategorySummaries" name="struct_DC"/&gt;
 *         &lt;/zeroOrMore&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version DatCatsPerprofile.rng (Tue Sep 06 13:07:40 CEST 2005)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class DataCategorySelection implements java.io.Serializable, Cloneable {
    /**
 * serialVersionID(generated)
 */
    private static final long serialVersionUID = -5560404053175557241L;

    /** Holds value of property DOCUMENT ME! */
    public static final String TYPE_DCS = "DCS";
    private String type_;

    // List<DataCategorySummary>
    private java.util.List dataCategorySummaries_ = new java.util.ArrayList();

    /**
 * Creates a <code>DataCategorySelection</code>.
 *
 */
    public DataCategorySelection() {
        type_ = "";
    }

    /**
 * Creates a <code>DataCategorySelection</code>.
 *
 * @param source
 */
    public DataCategorySelection(DataCategorySelection source) {
        setup(source);
    }

    /**
 * Creates a <code>DataCategorySelection</code> by the Stack <code>stack</code>
 * that contains Elements.
 * This constructor is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 */
    public DataCategorySelection(RStack stack) {
        setup(stack);
    }

    /**
 * Creates a <code>DataCategorySelection</code> by the Document <code>doc</code>.
 *
 * @param doc
 */
    public DataCategorySelection(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
 * Creates a <code>DataCategorySelection</code> by the Element <code>element</code>.
 *
 * @param element
 */
    public DataCategorySelection(Element element) {
        setup(element);
    }

    /**
 * Creates a <code>DataCategorySelection</code> by the File <code>file</code>.
 *
 * @param file
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public DataCategorySelection(File file)
        throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
 * Creates a <code>DataCategorySelection</code>
 * by the String representation of URI <code>uri</code>.
 *
 * @param uri
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public DataCategorySelection(String uri)
        throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
 * Creates a <code>DataCategorySelection</code> by the URL <code>url</code>.
 *
 * @param url
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public DataCategorySelection(URL url)
        throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
 * Creates a <code>DataCategorySelection</code> by the InputStream <code>in</code>.
 *
 * @param in
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public DataCategorySelection(InputStream in)
        throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
 * Creates a <code>DataCategorySelection</code> by the InputSource <code>is</code>.
 *
 * @param is
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public DataCategorySelection(InputSource is)
        throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
 * Creates a <code>DataCategorySelection</code> by the Reader <code>reader</code>.
 *
 * @param reader
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public DataCategorySelection(Reader reader)
        throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
 * Initializes the <code>DataCategorySelection</code> by the DataCategorySelection <code>source</code>.
 *
 * @param source
 */
    public void setup(DataCategorySelection source) {
        int size;
        setType(source.getType());
        this.dataCategorySummaries_.clear();
        size = source.dataCategorySummaries_.size();

        for (int i = 0; i < size; i++) {
            addDataCategorySummaries((DataCategorySummary) source.getDataCategorySummaries(
                    i).clone());
        }
    }

    /**
 * Initializes the <code>DataCategorySelection</code> by the Document <code>doc</code>.
 *
 * @param doc
 */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
 * Initializes the <code>DataCategorySelection</code> by the Element <code>element</code>.
 *
 * @param element
 */
    public void setup(Element element) {
        init(element);
    }

    /**
 * Initializes the <code>DataCategorySelection</code> by the Stack <code>stack</code>
 * that contains Elements.
 * This constructor is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
 * @param element
 */
    private void init(Element element) {
        RStack stack = new RStack(element);
        type_ = URelaxer.getAttributePropertyAsString(element, "type");
        dataCategorySummaries_.clear();

        while (true) {
            if (DataCategorySummary.isMatch(stack)) {
                addDataCategorySummaries(new DataCategorySummary(stack));
            } else {
                break;
            }
        }
    }

    /**
 * @return Object
 */
    public Object clone() {
        return (new DataCategorySelection(this));
    }

    /**
 * Creates a DOM representation of the object.
 * Result is appended to the Node <code>parent</code>.
 *
 * @param parent
 */
    public void makeElement(Node parent) {
        Document doc;

        if (parent instanceof Document) {
            doc = (Document) parent;
        } else {
            doc = parent.getOwnerDocument();
        }

        Element element = doc.createElement("STRUCT");
        int size;

        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }

        size = this.dataCategorySummaries_.size();

        for (int i = 0; i < size; i++) {
            DataCategorySummary value = (DataCategorySummary) this.dataCategorySummaries_.get(i);
            value.makeElement(element);
        }

        parent.appendChild(element);
    }

    /**
 * Initializes the <code>DataCategorySelection</code> by the File <code>file</code>.
 *
 * @param file
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(File file)
        throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
 * Initializes the <code>DataCategorySelection</code>
 * by the String representation of URI <code>uri</code>.
 *
 * @param uri
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(String uri)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>DataCategorySelection</code> by the URL <code>url</code>.
 *
 * @param url
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(URL url)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>DataCategorySelection</code> by the InputStream <code>in</code>.
 *
 * @param in
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(InputStream in)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>DataCategorySelection</code> by the InputSource <code>is</code>.
 *
 * @param is
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(InputSource is)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>DataCategorySelection</code> by the Reader <code>reader</code>.
 *
 * @param reader
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(Reader reader)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
 * Creates a DOM document representation of the object.
 *
 * @exception ParserConfigurationException
 * @return Document
 */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);

        return (doc);
    }

    /**
 * Gets the String property <b>type</b>.
 *
 * @return String
 */
    public String getType() {
        return (type_);
    }

    /**
 * Sets the String property <b>type</b>.
 *
 * @param type
 */
    public void setType(String type) {
        this.type_ = type;
    }

    /**
 * Gets the DataCategorySummary property <b>DataCategorySummaries</b>.
 *
 * @return DataCategorySummary[]
 */
    public DataCategorySummary[] getDataCategorySummaries() {
        DataCategorySummary[] array = new DataCategorySummary[dataCategorySummaries_.size()];

        return ((DataCategorySummary[]) dataCategorySummaries_.toArray(array));
    }

    /**
 * Sets the DataCategorySummary property <b>DataCategorySummaries</b>.
 *
 * @param dataCategorySummaries
 */
    public void setDataCategorySummaries(
        DataCategorySummary[] dataCategorySummaries) {
        this.dataCategorySummaries_.clear();

        for (int i = 0; i < dataCategorySummaries.length; i++) {
            addDataCategorySummaries(dataCategorySummaries[i]);
        }
    }

    /**
 * Sets the DataCategorySummary property <b>DataCategorySummaries</b>.
 *
 * @param dataCategorySummaries
 */
    public void setDataCategorySummaries(
        DataCategorySummary dataCategorySummaries) {
        this.dataCategorySummaries_.clear();
        addDataCategorySummaries(dataCategorySummaries);
    }

    /**
 * Adds the DataCategorySummary property <b>DataCategorySummaries</b>.
 *
 * @param dataCategorySummaries
 */
    public void addDataCategorySummaries(
        DataCategorySummary dataCategorySummaries) {
        this.dataCategorySummaries_.add(dataCategorySummaries);
    }

    /**
 * Adds the DataCategorySummary property <b>DataCategorySummaries</b>.
 *
 * @param dataCategorySummaries
 */
    public void addDataCategorySummaries(
        DataCategorySummary[] dataCategorySummaries) {
        for (int i = 0; i < dataCategorySummaries.length; i++) {
            addDataCategorySummaries(dataCategorySummaries[i]);
        }
    }

    /**
 * Gets number of the DataCategorySummary property <b>DataCategorySummaries</b>.
 *
 * @return int
 */
    public int sizeDataCategorySummaries() {
        return (dataCategorySummaries_.size());
    }

    /**
 * Gets the DataCategorySummary property <b>DataCategorySummaries</b> by index.
 *
 * @param index
 * @return DataCategorySummary
 */
    public DataCategorySummary getDataCategorySummaries(int index) {
        return ((DataCategorySummary) dataCategorySummaries_.get(index));
    }

    /**
 * Sets the DataCategorySummary property <b>DataCategorySummaries</b> by index.
 *
 * @param index
 * @param dataCategorySummaries
 */
    public void setDataCategorySummaries(int index,
        DataCategorySummary dataCategorySummaries) {
        this.dataCategorySummaries_.set(index, dataCategorySummaries);
    }

    /**
 * Adds the DataCategorySummary property <b>DataCategorySummaries</b> by index.
 *
 * @param index
 * @param dataCategorySummaries
 */
    public void addDataCategorySummaries(int index,
        DataCategorySummary dataCategorySummaries) {
        this.dataCategorySummaries_.add(index, dataCategorySummaries);
    }

    /**
 * Remove the DataCategorySummary property <b>DataCategorySummaries</b> by index.
 *
 * @param index
 */
    public void removeDataCategorySummaries(int index) {
        this.dataCategorySummaries_.remove(index);
    }

    /**
 * Remove the DataCategorySummary property <b>DataCategorySummaries</b> by object.
 *
 * @param dataCategorySummaries
 */
    public void removeDataCategorySummaries(
        DataCategorySummary dataCategorySummaries) {
        this.dataCategorySummaries_.remove(dataCategorySummaries);
    }

    /**
 * Clear the DataCategorySummary property <b>DataCategorySummaries</b>.
 *
 */
    public void clearDataCategorySummaries() {
        this.dataCategorySummaries_.clear();
    }

    /**
 * Makes an XML text representation.
 *
 * @return String
 */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);

        return (new String(buffer));
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<STRUCT");

        if (type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.append("\"");
        }

        buffer.append(">");
        size = this.dataCategorySummaries_.size();

        for (int i = 0; i < size; i++) {
            DataCategorySummary value = (DataCategorySummary) this.dataCategorySummaries_.get(i);
            value.makeTextElement(buffer);
        }

        buffer.append("</STRUCT>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 * @exception IOException
 */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<STRUCT");

        if (type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.write("\"");
        }

        buffer.write(">");
        size = this.dataCategorySummaries_.size();

        for (int i = 0; i < size; i++) {
            DataCategorySummary value = (DataCategorySummary) this.dataCategorySummaries_.get(i);
            value.makeTextElement(buffer);
        }

        buffer.write("</STRUCT>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<STRUCT");

        if (type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.print("\"");
        }

        buffer.print(">");
        size = this.dataCategorySummaries_.size();

        for (int i = 0; i < size; i++) {
            DataCategorySummary value = (DataCategorySummary) this.dataCategorySummaries_.get(i);
            value.makeTextElement(buffer);
        }

        buffer.print("</STRUCT>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 * @exception IOException
 */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
 * Gets the property value as String.
 *
 * @return String
 */
    public String getTypeAsString() {
        return (URelaxer.getString(getType()));
    }

    /**
 * Sets the property value by String.
 *
 * @param string
 */
    public void setTypeByString(String string) {
        setType(string);
    }

    /**
 * Returns a String representation of this object.
 * While this method informs as XML format representaion, 
 *  it's purpose is just information, not making 
 * a rigid XML documentation.
 *
 * @return String
 */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
 * Tests if a Element <code>element</code> is valid
 * for the <code>DataCategorySelection</code>.
 *
 * @param element
 * @return boolean
 */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "STRUCT")) {
            return (false);
        }

        RStack target = new RStack(element);

        if (!URelaxer.hasAttributeHungry(target, "type")) {
            return (false);
        }

        if (!URelaxer.isMatchDataValuesAttr(element, "type", "token", "DCS")) {
            return (false);
        }

        while (true) {
            if (!DataCategorySummary.isMatchHungry(target)) {
                break;
            }
        }

        if (!target.isEmptyElement()) {
            return (false);
        }

        return (true);
    }

    /**
 * Tests if elements contained in a Stack <code>stack</code>
 * is valid for the <code>DataCategorySelection</code>.
 * This mehtod is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 * @return boolean
 */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();

        if (element == null) {
            return (false);
        }

        return (isMatch(element));
    }

    /**
 * Tests if elements contained in a Stack <code>stack</code>
 * is valid for the <code>DataCategorySelection</code>.
 * This method consumes the stack contents during matching operation.
 * This mehtod is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 * @return boolean
 */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();

        if (element == null) {
            return (false);
        }

        if (isMatch(element)) {
            stack.popElement();

            return (true);
        } else {
            return (false);
        }
    }
}
