/*
 * File:     DataCategorySummary.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package mpi.dcr.ISO12620;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

import java.net.URL;

import java.util.logging.Logger;

import javax.xml.parsers.ParserConfigurationException;


/**
 * <b>DataCategorySummary</b> is generated from DatCatsPerprofile.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element java:className="DataCategorySummary" name="STRUCT">
 *         <attribute name="type">
 *           <value>DCSummary</value> 
 *         </attribute>
 *         <attribute name="id">
 *             <text/> 
 *         </attribute>
 *         <element java:className="RegistrationStatus" java:propertyName="RegistrationStatus" name="feat">
 *             <attribute name="type">
 *                 <value>registrationStatus</value> 
 *             </attribute>
 *             <choice>
 *               <value>standard</value> 
 *               <value>qualified</value> 
 *               <value>candidate</value> 
 *               <value>deprecated</value> 
 *               <value>superceded</value> 
 *              </choice>
 *         </element>
 *         <element java:className="RegistrationAuthority" java:propertyName="RegistrationAuthority" name="feat">
 *             <attribute name="type">
 *                 <value>registrationAuthority</value> 
 *             </attribute>
 *             <text/> 
 *         </element>
 *         <element java:className="Identifier" java:propertyName="Identifier" name="feat">
 *             <attribute name="type">
 *                 <value>identifier</value> 
 *             </attribute>
 *             <text/> 
 *         </element>
 *         <element java:className="Version" java:propertyName="Version" name="feat">
 *             <attribute name="type">
 *                 <value>version</value> 
 *             </attribute>
 *             <text/> 
 *         </element>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element java:className="DataCategorySummary" name="STRUCT"&gt;
 *         &lt;attribute name="type"&gt;
 *           &lt;value&gt;DCSummary&lt;/value&gt; 
 *         &lt;/attribute&gt;
 *         &lt;attribute name="id"&gt;
 *             &lt;text/&gt; 
 *         &lt;/attribute&gt;
 *         &lt;element java:className="RegistrationStatus" java:propertyName="RegistrationStatus" name="feat"&gt;
 *             &lt;attribute name="type"&gt;
 *                 &lt;value&gt;registrationStatus&lt;/value&gt; 
 *             &lt;/attribute&gt;
 *             &lt;choice&gt;
 *               &lt;value&gt;standard&lt;/value&gt; 
 *               &lt;value&gt;qualified&lt;/value&gt; 
 *               &lt;value&gt;candidate&lt;/value&gt; 
 *               &lt;value&gt;deprecated&lt;/value&gt; 
 *               &lt;value&gt;superceded&lt;/value&gt; 
 *              &lt;/choice&gt;
 *         &lt;/element&gt;
 *         &lt;element java:className="RegistrationAuthority" java:propertyName="RegistrationAuthority" name="feat"&gt;
 *             &lt;attribute name="type"&gt;
 *                 &lt;value&gt;registrationAuthority&lt;/value&gt; 
 *             &lt;/attribute&gt;
 *             &lt;text/&gt; 
 *         &lt;/element&gt;
 *         &lt;element java:className="Identifier" java:propertyName="Identifier" name="feat"&gt;
 *             &lt;attribute name="type"&gt;
 *                 &lt;value&gt;identifier&lt;/value&gt; 
 *             &lt;/attribute&gt;
 *             &lt;text/&gt; 
 *         &lt;/element&gt;
 *         &lt;element java:className="Version" java:propertyName="Version" name="feat"&gt;
 *             &lt;attribute name="type"&gt;
 *                 &lt;value&gt;version&lt;/value&gt; 
 *             &lt;/attribute&gt;
 *             &lt;text/&gt; 
 *         &lt;/element&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version DatCatsPerprofile.rng (Tue Sep 06 13:23:17 CEST 2005)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class DataCategorySummary implements java.io.Serializable, Cloneable {
    /**
 * serialVersionID(generated)
 */
    private static final long serialVersionUID = -5977389266233016175L;

    /** Holds value of property DOCUMENT ME! */
    protected final static Logger logger = Logger.getLogger("DCR");

    /** Holds value of property DOCUMENT ME! */
    public static final String TYPE_DCSUMMARY = "DCSummary";
    private String type_;
    private String id_;
    private RegistrationStatus registrationStatus_;
    private RegistrationAuthority registrationAuthority_;
    private Identifier identifier_;
    private Version version_;

    /**
 * Creates a <code>DataCategorySummary</code>.
 *
 */
    public DataCategorySummary() {
        type_ = "";
        id_ = "";
    }

    /**
 * Creates a <code>DataCategorySummary</code>.
 *
 * @param source
 */
    public DataCategorySummary(DataCategorySummary source) {
        setup(source);
    }

    /**
 * Creates a <code>DataCategorySummary</code> by the Stack <code>stack</code>
 * that contains Elements.
 * This constructor is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 */
    public DataCategorySummary(RStack stack) {
        setup(stack);
    }

    /**
 * Creates a <code>DataCategorySummary</code> by the Document <code>doc</code>.
 *
 * @param doc
 */
    public DataCategorySummary(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
 * Creates a <code>DataCategorySummary</code> by the Element <code>element</code>.
 *
 * @param element
 */
    public DataCategorySummary(Element element) {
        setup(element);
    }

    /**
 * Creates a <code>DataCategorySummary</code> by the File <code>file</code>.
 *
 * @param file
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public DataCategorySummary(File file)
        throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
 * Creates a <code>DataCategorySummary</code>
 * by the String representation of URI <code>uri</code>.
 *
 * @param uri
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public DataCategorySummary(String uri)
        throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
 * Creates a <code>DataCategorySummary</code> by the URL <code>url</code>.
 *
 * @param url
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public DataCategorySummary(URL url)
        throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
 * Creates a <code>DataCategorySummary</code> by the InputStream <code>in</code>.
 *
 * @param in
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public DataCategorySummary(InputStream in)
        throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
 * Creates a <code>DataCategorySummary</code> by the InputSource <code>is</code>.
 *
 * @param is
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public DataCategorySummary(InputSource is)
        throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
 * Creates a <code>DataCategorySummary</code> by the Reader <code>reader</code>.
 *
 * @param reader
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public DataCategorySummary(Reader reader)
        throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
 * Initializes the <code>DataCategorySummary</code> by the DataCategorySummary <code>source</code>.
 *
 * @param source
 */
    public void setup(DataCategorySummary source) {
        setType(source.getType());
        setId(source.getId());

        if (source.registrationStatus_ != null) {
            setRegistrationStatus((RegistrationStatus) source.getRegistrationStatus()
                                                             .clone());
        }

        if (source.registrationAuthority_ != null) {
            setRegistrationAuthority((RegistrationAuthority) source.getRegistrationAuthority()
                                                                   .clone());
        }

        if (source.identifier_ != null) {
            setIdentifier((Identifier) source.getIdentifier().clone());
        }

        if (source.version_ != null) {
            setVersion((Version) source.getVersion().clone());
        }
    }

    /**
 * Initializes the <code>DataCategorySummary</code> by the Document <code>doc</code>.
 *
 * @param doc
 */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
 * Initializes the <code>DataCategorySummary</code> by the Element <code>element</code>.
 *
 * @param element
 */
    public void setup(Element element) {
        init(element);
    }

    /**
 * Initializes the <code>DataCategorySummary</code> by the Stack <code>stack</code>
 * that contains Elements.
 * This constructor is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
 * @param element
 */
    private void init(Element element) {
        RStack stack = new RStack(element);
        type_ = URelaxer.getAttributePropertyAsString(element, "type");
        id_ = URelaxer.getAttributePropertyAsString(element, "id");
        setRegistrationStatus(new RegistrationStatus(stack));
        setRegistrationAuthority(new RegistrationAuthority(stack));
        setIdentifier(new Identifier(stack));
        setVersion(new Version(stack));
    }

    /**
 * @return Object
 */
    public Object clone() {
        return (new DataCategorySummary(this));
    }

    /**
 * Creates a DOM representation of the object.
 * Result is appended to the Node <code>parent</code>.
 *
 * @param parent
 */
    public void makeElement(Node parent) {
        Document doc;

        if (parent instanceof Document) {
            doc = (Document) parent;
        } else {
            doc = parent.getOwnerDocument();
        }

        Element element = doc.createElement("STRUCT");

        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }

        if (this.id_ != null) {
            URelaxer.setAttributePropertyByString(element, "id", this.id_);
        }

        this.registrationStatus_.makeElement(element);
        this.registrationAuthority_.makeElement(element);
        this.identifier_.makeElement(element);
        this.version_.makeElement(element);
        parent.appendChild(element);
    }

    /**
 * Initializes the <code>DataCategorySummary</code> by the File <code>file</code>.
 *
 * @param file
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(File file)
        throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
 * Initializes the <code>DataCategorySummary</code>
 * by the String representation of URI <code>uri</code>.
 *
 * @param uri
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(String uri)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>DataCategorySummary</code> by the URL <code>url</code>.
 *
 * @param url
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(URL url)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>DataCategorySummary</code> by the InputStream <code>in</code>.
 *
 * @param in
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(InputStream in)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>DataCategorySummary</code> by the InputSource <code>is</code>.
 *
 * @param is
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(InputSource is)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>DataCategorySummary</code> by the Reader <code>reader</code>.
 *
 * @param reader
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(Reader reader)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
 * Creates a DOM document representation of the object.
 *
 * @exception ParserConfigurationException
 * @return Document
 */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);

        return (doc);
    }

    /**
 * Gets the String property <b>type</b>.
 *
 * @return String
 */
    public String getType() {
        return (type_);
    }

    /**
 * Sets the String property <b>type</b>.
 *
 * @param type
 */
    public void setType(String type) {
        this.type_ = type;
    }

    /**
 * Gets the String property <b>id</b>.
 *
 * @return String
 */
    public String getId() {
        return (id_);
    }

    /**
 * Sets the String property <b>id</b>.
 *
 * @param id
 */
    public void setId(String id) {
        this.id_ = id;
    }

    /**
 * Gets the RegistrationStatus property <b>RegistrationStatus</b>.
 *
 * @return RegistrationStatus
 */
    public RegistrationStatus getRegistrationStatus() {
        return (registrationStatus_);
    }

    /**
 * Sets the RegistrationStatus property <b>RegistrationStatus</b>.
 *
 * @param registrationStatus
 */
    public void setRegistrationStatus(RegistrationStatus registrationStatus) {
        this.registrationStatus_ = registrationStatus;
    }

    /**
 * Gets the RegistrationAuthority property <b>RegistrationAuthority</b>.
 *
 * @return RegistrationAuthority
 */
    public RegistrationAuthority getRegistrationAuthority() {
        return (registrationAuthority_);
    }

    /**
 * Sets the RegistrationAuthority property <b>RegistrationAuthority</b>.
 *
 * @param registrationAuthority
 */
    public void setRegistrationAuthority(
        RegistrationAuthority registrationAuthority) {
        this.registrationAuthority_ = registrationAuthority;
    }

    /**
 * Gets the Identifier property <b>Identifier</b>.
 *
 * @return Identifier
 */
    public Identifier getIdentifier() {
        return (identifier_);
    }

    /**
 * Sets the Identifier property <b>Identifier</b>.
 *
 * @param identifier
 */
    public void setIdentifier(Identifier identifier) {
        this.identifier_ = identifier;
    }

    /**
 * Gets the Version property <b>Version</b>.
 *
 * @return Version
 */
    public Version getVersion() {
        return (version_);
    }

    /**
 * Sets the Version property <b>Version</b>.
 *
 * @param version
 */
    public void setVersion(Version version) {
        this.version_ = version;
    }

    /**
 * Makes an XML text representation.
 *
 * @return String
 */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);

        return (new String(buffer));
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<STRUCT");

        if (type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.append("\"");
        }

        if (id_ != null) {
            buffer.append(" id=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.append("\"");
        }

        buffer.append(">");
        registrationStatus_.makeTextElement(buffer);
        registrationAuthority_.makeTextElement(buffer);
        identifier_.makeTextElement(buffer);
        version_.makeTextElement(buffer);
        buffer.append("</STRUCT>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 * @exception IOException
 */
    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<STRUCT");

        if (type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.write("\"");
        }

        if (id_ != null) {
            buffer.write(" id=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.write("\"");
        }

        buffer.write(">");
        registrationStatus_.makeTextElement(buffer);
        registrationAuthority_.makeTextElement(buffer);
        identifier_.makeTextElement(buffer);
        version_.makeTextElement(buffer);
        buffer.write("</STRUCT>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<STRUCT");

        if (type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.print("\"");
        }

        if (id_ != null) {
            buffer.print(" id=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.print("\"");
        }

        buffer.print(">");
        registrationStatus_.makeTextElement(buffer);
        registrationAuthority_.makeTextElement(buffer);
        identifier_.makeTextElement(buffer);
        version_.makeTextElement(buffer);
        buffer.print("</STRUCT>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 * @exception IOException
 */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
 * Gets the property value as String.
 *
 * @return String
 */
    public String getTypeAsString() {
        return (URelaxer.getString(getType()));
    }

    /**
 * Gets the property value as String.
 *
 * @return String
 */
    public String getIdAsString() {
        return (URelaxer.getString(getId()));
    }

    /**
 * Sets the property value by String.
 *
 * @param string
 */
    public void setTypeByString(String string) {
        setType(string);
    }

    /**
 * Sets the property value by String.
 *
 * @param string
 */
    public void setIdByString(String string) {
        setId(string);
    }

    /**
 * Returns a String representation of this object.
 * While this method informs as XML format representaion, 
 *  it's purpose is just information, not making 
 * a rigid XML documentation.
 *
 * @return String
 */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
 * Tests if a Element <code>element</code> is valid
 * for the <code>DataCategorySummary</code>.
 *
 * @param element
 * @return boolean
 */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "STRUCT")) {
            return (false);
        }

        RStack target = new RStack(element);

        if (!URelaxer.hasAttributeHungry(target, "type")) {
            //logger.info("no type");
            return (false);
        }

        if (!URelaxer.isMatchDataValuesAttr(element, "type", "token",
                    "DCSummary")) {
            //logger.info("");
            return (false);
        }

        if (!URelaxer.hasAttributeHungry(target, "id")) {
            return (false);
        }

        if (!RegistrationStatus.isMatchHungry(target)) {
            return (false);
        }

        if (!RegistrationAuthority.isMatchHungry(target)) {
            return (false);
        }

        if (!Identifier.isMatchHungry(target)) {
            return (false);
        }

        if (!Version.isMatchHungry(target)) {
            return (false);
        }

        if (!target.isEmptyElement()) {
            return (false);
        }

        return (true);
    }

    /**
 * Tests if elements contained in a Stack <code>stack</code>
 * is valid for the <code>DataCategorySummary</code>.
 * This mehtod is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 * @return boolean
 */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();

        if (element == null) {
            return (false);
        }

        return (isMatch(element));
    }

    /**
 * Tests if elements contained in a Stack <code>stack</code>
 * is valid for the <code>DataCategorySummary</code>.
 * This method consumes the stack contents during matching operation.
 * This mehtod is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 * @return boolean
 */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();

        if (element == null) {
            return (false);
        }

        if (isMatch(element)) {
            stack.popElement();

            return (true);
        } else {
            return (false);
        }
    }
}
