/*
 * File:     Description.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package mpi.dcr.ISO12620;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

import java.net.URL;

import java.util.logging.Logger;

import javax.xml.parsers.ParserConfigurationException;


/**
 * <b>Description</b> is generated from ISO12620_revised.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element java:className="Description" name="struct">
 *       <attribute name="type">
 *         <value>Desc</value>
 *       </attribute>
 *       <ref name="attId"/>
 *       <oneOrMore>
 *               <ref java:propertyName="definitions" name="definition_struct_Desc"/>
 *       </oneOrMore>
 *       <zeroOrMore>
 *               <ref java:propertyName="eplanations" name="explanation_struct_Desc"/>
 *       </zeroOrMore>
 *       <zeroOrMore>
 *               <ref java:propertyName="examples" name="example_struct_Desc"/>
 *       </zeroOrMore>
 *       <zeroOrMore>
 *               <ref java:propertyName="profiles" name="profile_struct_Desc"/>
 *       </zeroOrMore>
 *      <optional>
 *         <ref java:propertyName="broaderConceptGeneric" name="broaderConceptGeneric_struct_Desc"/>
 *       </optional>
 *          <zeroOrMore>
 *         <ref java:propertyName="conceptualDomains" name="conceptualDomain_struct_Desc"/>
 *       </zeroOrMore>
 *       <zeroOrMore>
 *         <ref java:propertyName="notes" name="note_struct_Desc"/>
 *       </zeroOrMore>
 *       <zeroOrMore>
 *         <ref java:propertyName="dataElements" name="struct_DE"/>
 *       </zeroOrMore>
 *       <zeroOrMore>
 *         <ref java:propertyName="languageSections" name="struct_LS"/>
 *       </zeroOrMore>
 *      
 *       
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element java:className="Description" name="struct"&gt;
 *       &lt;attribute name="type"&gt;
 *         &lt;value&gt;Desc&lt;/value&gt;
 *       &lt;/attribute&gt;
 *       &lt;ref name="attId"/&gt;
 *       &lt;oneOrMore&gt;
 *               &lt;ref java:propertyName="definitions" name="definition_struct_Desc"/&gt;
 *       &lt;/oneOrMore&gt;
 *       &lt;zeroOrMore&gt;
 *               &lt;ref java:propertyName="eplanations" name="explanation_struct_Desc"/&gt;
 *       &lt;/zeroOrMore&gt;
 *       &lt;zeroOrMore&gt;
 *               &lt;ref java:propertyName="examples" name="example_struct_Desc"/&gt;
 *       &lt;/zeroOrMore&gt;
 *       &lt;zeroOrMore&gt;
 *               &lt;ref java:propertyName="profiles" name="profile_struct_Desc"/&gt;
 *       &lt;/zeroOrMore&gt;
 *          &lt;optional&gt;
 *         &lt;ref java:propertyName="broaderConceptGeneric" name="broaderConceptGeneric_struct_Desc"/&gt;
 *       &lt;/optional&gt;
 *          &lt;zeroOrMore&gt;
 *         &lt;ref java:propertyName="conceptualDomains" name="conceptualDomain_struct_Desc"/&gt;
 *       &lt;/zeroOrMore&gt;      
 *          &lt;zeroOrMore&gt;
 *         &lt;ref java:propertyName="notes" name="note_struct_Desc"/&gt;
 *       &lt;/zeroOrMore&gt;

 *       &lt;zeroOrMore&gt;
 *         &lt;ref java:propertyName="dataElements" name="struct_DE"/&gt;
 *       &lt;/zeroOrMore&gt;
 *       &lt;zeroOrMore&gt;
 *         &lt;ref java:propertyName="languageSections" name="struct_LS"/&gt;
 *       &lt;/zeroOrMore&gt;
 *       
 *       
 *       
 *     &lt;/element&gt;</pre>
 *
 * @version ISO12620_revised.rng (Fri Sep 30 12:49:34 CEST 2005)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class Description implements java.io.Serializable, Cloneable {
    /**
 * serialVersionID(generated)
 */
    private static final long serialVersionUID = -557475951112761402L;

    /** Logger for this class and subclasses */
    protected final static Logger logger = Logger.getLogger("DCR");

    /** Holds value of property DOCUMENT ME! */
    public static final String TYPE_DESC = "Desc";
    private String type_;
    private String id_;

    // List<IDefinition>
    private java.util.List definitions_ = new java.util.ArrayList();

    // List<IExplanationStructDescChoice>
    private java.util.List explanations_ = new java.util.ArrayList();

    // List<IExample>
    private java.util.List examples_ = new java.util.ArrayList();

    // List<Profile>
    private java.util.List profiles_ = new java.util.ArrayList();

    // List<DataElement>
    private java.util.List dataElements_ = new java.util.ArrayList();

    // List<LanguageSection>
    private java.util.List languageSections_ = new java.util.ArrayList();
    private BroaderConceptGeneric broaderConceptGeneric_;

    // List<ConceptualDomain>
    private java.util.List conceptualDomains_ = new java.util.ArrayList();

    // List<INote>
    private java.util.List notes_ = new java.util.ArrayList();

    /**
 * Creates a <code>Description</code>.
 *
 */
    public Description() {
        type_ = "";
    }

    /**
 * Creates a <code>Description</code>.
 *
 * @param source
 */
    public Description(Description source) {
        setup(source);
    }

    /**
 * Creates a <code>Description</code> by the Stack <code>stack</code>
 * that contains Elements.
 * This constructor is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 */
    public Description(RStack stack) {
        setup(stack);
    }

    /**
 * Creates a <code>Description</code> by the Document <code>doc</code>.
 *
 * @param doc
 */
    public Description(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
 * Creates a <code>Description</code> by the Element <code>element</code>.
 *
 * @param element
 */
    public Description(Element element) {
        setup(element);
    }

    /**
 * Creates a <code>Description</code> by the File <code>file</code>.
 *
 * @param file
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public Description(File file)
        throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
 * Creates a <code>Description</code>
 * by the String representation of URI <code>uri</code>.
 *
 * @param uri
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public Description(String uri)
        throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
 * Creates a <code>Description</code> by the URL <code>url</code>.
 *
 * @param url
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public Description(URL url)
        throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
 * Creates a <code>Description</code> by the InputStream <code>in</code>.
 *
 * @param in
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public Description(InputStream in)
        throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
 * Creates a <code>Description</code> by the InputSource <code>is</code>.
 *
 * @param is
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public Description(InputSource is)
        throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
 * Creates a <code>Description</code> by the Reader <code>reader</code>.
 *
 * @param reader
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public Description(Reader reader)
        throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
 * Initializes the <code>Description</code> by the Description <code>source</code>.
 *
 * @param source
 */
    public void setup(Description source) {
        int size;
        setType(source.getType());
        setId(source.getId());
        this.definitions_.clear();
        size = source.definitions_.size();

        for (int i = 0; i < size; i++) {
            addDefinition((IDefinition) source.getDefinition(i).clone());
        }

        this.explanations_.clear();
        size = source.explanations_.size();

        for (int i = 0; i < size; i++) {
            addExplanation((IExplanation) source.getExplanation(i).clone());
        }

        this.examples_.clear();
        size = source.examples_.size();

        for (int i = 0; i < size; i++) {
            addExample((IExample) source.getExample(i).clone());
        }

        this.profiles_.clear();
        size = source.profiles_.size();

        for (int i = 0; i < size; i++) {
            addProfile((Profile) source.getProfiles(i).clone());
        }

        this.dataElements_.clear();
        size = source.dataElements_.size();

        for (int i = 0; i < size; i++) {
            addDataElement((DataElement) source.getDataElement(i).clone());
        }

        this.languageSections_.clear();
        size = source.languageSections_.size();

        for (int i = 0; i < size; i++) {
            addLanguageSection((LanguageSection) source.getLanguageSection(i)
                                                       .clone());
        }

        if (source.broaderConceptGeneric_ != null) {
            setBroaderConceptGeneric((BroaderConceptGeneric) source.getBroaderConceptGeneric()
                                                                   .clone());
        }

        this.conceptualDomains_.clear();
        size = source.conceptualDomains_.size();

        for (int i = 0; i < size; i++) {
            addConceptualDomains((ConceptualDomain) source.getConceptualDomain(
                    i).clone());
        }

        this.notes_.clear();
        size = source.notes_.size();

        for (int i = 0; i < size; i++) {
            addNote((INote) source.getNote(i).clone());
        }
    }

    /**
 * Initializes the <code>Description</code> by the Document <code>doc</code>.
 *
 * @param doc
 */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
 * Initializes the <code>Description</code> by the Element <code>element</code>.
 *
 * @param element
 */
    public void setup(Element element) {
        init(element);
    }

    /**
 * Initializes the <code>Description</code> by the Stack <code>stack</code>
 * that contains Elements.
 * This constructor is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
 * @param element
 */
    private void init(Element element) {
        RStack stack = new RStack(element);
        type_ = URelaxer.getAttributePropertyAsString(element, "type");
        id_ = URelaxer.getAttributePropertyAsString(element, "id");
        definitions_.clear();

        while (true) {
            if (DefinitionBrack.isMatch(stack)) {
                addDefinition(new DefinitionBrack(stack));
            } else if (Definition.isMatch(stack)) {
                addDefinition(new Definition(stack));
            } else {
                break;
            }
        }

        explanations_.clear();

        while (true) {
            if (ExplanationBrack.isMatch(stack)) {
                addExplanation(new ExplanationBrack(stack));
            } else if (Explanation.isMatch(stack)) {
                addExplanation(new Explanation(stack));
            } else {
                break;
            }
        }

        examples_.clear();

        while (true) {
            if (ExampleBrack.isMatch(stack)) {
                addExample(new ExampleBrack(stack));
            } else if (Example.isMatch(stack)) {
                addExample(new Example(stack));
            } else {
                break;
            }
        }

        profiles_.clear();

        while (true) {
            if (Profile.isMatch(stack)) {
                addProfile(new Profile(stack));
            } else {
                break;
            }
        }

        if (BroaderConceptGeneric.isMatch(stack)) {
            setBroaderConceptGeneric(new BroaderConceptGeneric(stack));
        }

        conceptualDomains_.clear();

        while (true) {
            if (ConceptualDomain.isMatch(stack)) {
                addConceptualDomains(new ConceptualDomain(stack));
            } else {
                break;
            }
        }

        notes_.clear();

        while (true) {
            if (Note.isMatch(stack)) {
                addNote(new Note(stack));
            } else if (NoteBrack.isMatch(stack)) {
                addNote(new NoteBrack(stack));
            } else {
                break;
            }
        }

        dataElements_.clear();

        while (true) {
            if (DataElement.isMatch(stack)) {
                addDataElement(new DataElement(stack));
            } else {
                break;
            }
        }

        languageSections_.clear();

        while (true) {
            if (LanguageSection.isMatch(stack)) {
                addLanguageSection(new LanguageSection(stack));
            } else {
                break;
            }
        }
    }

    /**
 * @return Object
 */
    public Object clone() {
        return (new Description(this));
    }

    /**
 * Creates a DOM representation of the object.
 * Result is appended to the Node <code>parent</code>.
 *
 * @param parent
 */
    public void makeElement(Node parent) {
        Document doc;

        if (parent instanceof Document) {
            doc = (Document) parent;
        } else {
            doc = parent.getOwnerDocument();
        }

        Element element = doc.createElement("struct");
        int size;

        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }

        if (this.id_ != null) {
            URelaxer.setAttributePropertyByString(element, "id", this.id_);
        }

        size = this.definitions_.size();

        for (int i = 0; i < size; i++) {
            IDefinition value = (IDefinition) this.definitions_.get(i);
            value.makeElement(element);
        }

        size = this.explanations_.size();

        for (int i = 0; i < size; i++) {
            IExplanation value = (IExplanation) this.explanations_.get(i);
            value.makeElement(element);
        }

        size = this.examples_.size();

        for (int i = 0; i < size; i++) {
            IExample value = (IExample) this.examples_.get(i);
            value.makeElement(element);
        }

        size = this.profiles_.size();

        for (int i = 0; i < size; i++) {
            Profile value = (Profile) this.profiles_.get(i);
            value.makeElement(element);
        }

        if (this.broaderConceptGeneric_ != null) {
            this.broaderConceptGeneric_.makeElement(element);
        }

        size = this.conceptualDomains_.size();

        for (int i = 0; i < size; i++) {
            ConceptualDomain value = (ConceptualDomain) this.conceptualDomains_.get(i);
            value.makeElement(element);
        }

        size = this.notes_.size();

        for (int i = 0; i < size; i++) {
            INote value = (INote) this.notes_.get(i);
            value.makeElement(element);
        }

        size = this.dataElements_.size();

        for (int i = 0; i < size; i++) {
            DataElement value = (DataElement) this.dataElements_.get(i);
            value.makeElement(element);
        }

        size = this.languageSections_.size();

        for (int i = 0; i < size; i++) {
            LanguageSection value = (LanguageSection) this.languageSections_.get(i);
            value.makeElement(element);
        }

        parent.appendChild(element);
    }

    /**
 * Initializes the <code>Description</code> by the File <code>file</code>.
 *
 * @param file
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(File file)
        throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
 * Initializes the <code>Description</code>
 * by the String representation of URI <code>uri</code>.
 *
 * @param uri
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(String uri)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>Description</code> by the URL <code>url</code>.
 *
 * @param url
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(URL url)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>Description</code> by the InputStream <code>in</code>.
 *
 * @param in
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(InputStream in)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>Description</code> by the InputSource <code>is</code>.
 *
 * @param is
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(InputSource is)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
 * Initializes the <code>Description</code> by the Reader <code>reader</code>.
 *
 * @param reader
 * @exception IOException
 * @exception SAXException
 * @exception ParserConfigurationException
 */
    public void setup(Reader reader)
        throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
 * Creates a DOM document representation of the object.
 *
 * @exception ParserConfigurationException
 * @return Document
 */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);

        return (doc);
    }

    /**
 * Gets the String property <b>type</b>.
 *
 * @return String
 */
    public String getType() {
        return (type_);
    }

    /**
 * Sets the String property <b>type</b>.
 *
 * @param type
 */
    public void setType(String type) {
        this.type_ = type;
    }

    /**
 * Gets the String property <b>id</b>.
 *
 * @return String
 */
    public String getId() {
        return (id_);
    }

    /**
 * Sets the String property <b>id</b>.
 *
 * @param id
 */
    public void setId(String id) {
        this.id_ = id;
    }

    /**
 * Gets the IDefinitionStructDescChoice property <b>definitionStructDesc</b>.
 *
 * @return IDefinitionStructDescChoice[]
 */
    public IDefinition[] getDefinitions() {
        IDefinition[] array = new IDefinition[definitions_.size()];

        return ((IDefinition[]) definitions_.toArray(array));
    }

    /**
 * Sets the IDefinitionStructDescChoice property <b>definitionStructDesc</b>.
 *
 * @param definitionStructDesc
 */
    public void setDefinitions(IDefinition[] definitionStructDesc) {
        this.definitions_.clear();

        for (int i = 0; i < definitionStructDesc.length; i++) {
            addDefinition(definitionStructDesc[i]);
        }
    }

    /**
 * Sets the IDefinitionStructDescChoice property <b>definitionStructDesc</b>.
 *
 * @param definitionStructDesc
 */
    public void setDefinitions(IDefinition definitionStructDesc) {
        this.definitions_.clear();
        addDefinition(definitionStructDesc);
    }

    /**
 * Adds the IDefinitionStructDescChoice property <b>definitionStructDesc</b>.
 *
 * @param definitionStructDesc
 */
    public void addDefinition(IDefinition definitionStructDesc) {
        this.definitions_.add(definitionStructDesc);
    }

    /**
 * Adds the IDefinitionStructDescChoice property <b>definitionStructDesc</b>.
 *
 * @param definitionStructDesc
 */
    public void addDefinitions(IDefinition[] definitionStructDesc) {
        for (int i = 0; i < definitionStructDesc.length; i++) {
            addDefinition(definitionStructDesc[i]);
        }
    }

    /**
 * Gets number of the IDefinitionStructDescChoice property <b>definitionStructDesc</b>.
 *
 * @return int
 */
    public int sizeDefinitions() {
        return (definitions_.size());
    }

    /**
 * Gets the IDefinitionStructDescChoice property <b>definitionStructDesc</b> by index.
 *
 * @param index
 * @return IDefinitionStructDescChoice
 */
    public IDefinition getDefinition(int index) {
        return ((IDefinition) definitions_.get(index));
    }

    /**
 * Sets the IDefinitionStructDescChoice property <b>definitionStructDesc</b> by index.
 *
 * @param index
 * @param definitionStructDesc
 */
    public void setDefinition(int index, IDefinition definitionStructDesc) {
        this.definitions_.set(index, definitionStructDesc);
    }

    /**
 * Adds the IDefinitionStructDescChoice property <b>definitionStructDesc</b> by index.
 *
 * @param index
 * @param definitionStructDesc
 */
    public void addDefinition(int index, IDefinition definitionStructDesc) {
        this.definitions_.add(index, definitionStructDesc);
    }

    /**
 * Remove the IDefinitionStructDescChoice property <b>definitionStructDesc</b> by index.
 *
 * @param index
 */
    public void removeDefinition(int index) {
        this.definitions_.remove(index);
    }

    /**
 * Remove the IDefinitionStructDescChoice property <b>definitionStructDesc</b> by object.
 *
 * @param definitionStructDesc
 */
    public void removeDefinition(IDefinition definitionStructDesc) {
        this.definitions_.remove(definitionStructDesc);
    }

    /**
 * Clear the IDefinitionStructDescChoice property <b>definitionStructDesc</b>.
 *
 */
    public void clearDefinitions() {
        this.definitions_.clear();
    }

    /**
 * Gets the IExplanationStructDescChoice property <b>explanationStructDesc</b>.
 *
 * @return IExplanationStructDescChoice[]
 */
    public IExplanation[] getExplanations() {
        IExplanation[] array = new IExplanation[explanations_.size()];

        return ((IExplanation[]) explanations_.toArray(array));
    }

    /**
 * Sets the IExplanationStructDescChoice property <b>explanationStructDesc</b>.
 *
 * @param explanationStructDesc
 */
    public void setExplanations(IExplanation[] explanationStructDesc) {
        this.explanations_.clear();

        for (int i = 0; i < explanationStructDesc.length; i++) {
            addExplanation(explanationStructDesc[i]);
        }
    }

    /**
 * Sets the IExplanationStructDescChoice property <b>explanationStructDesc</b>.
 *
 * @param explanationStructDesc
 */
    public void setExplanations(IExplanation explanationStructDesc) {
        this.explanations_.clear();
        addExplanation(explanationStructDesc);
    }

    /**
 * Adds the IExplanationStructDescChoice property <b>explanationStructDesc</b>.
 *
 * @param explanationStructDesc
 */
    public void addExplanation(IExplanation explanationStructDesc) {
        this.explanations_.add(explanationStructDesc);
    }

    /**
 * Adds the IExplanationStructDescChoice property <b>explanationStructDesc</b>.
 *
 * @param explanationStructDesc
 */
    public void addExplanations(IExplanation[] explanationStructDesc) {
        for (int i = 0; i < explanationStructDesc.length; i++) {
            addExplanation(explanationStructDesc[i]);
        }
    }

    /**
 * Gets number of the IExplanationStructDescChoice property <b>explanationStructDesc</b>.
 *
 * @return int
 */
    public int sizeExplanations() {
        return (explanations_.size());
    }

    /**
 * Gets the IExplanationStructDescChoice property <b>explanationStructDesc</b> by index.
 *
 * @param index
 * @return IExplanationStructDescChoice
 */
    public IExplanation getExplanation(int index) {
        return ((IExplanation) explanations_.get(index));
    }

    /**
 * Sets the IExplanationStructDescChoice property <b>explanationStructDesc</b> by index.
 *
 * @param index
 * @param explanationStructDesc
 */
    public void setExplanation(int index, IExplanation explanationStructDesc) {
        this.explanations_.set(index, explanationStructDesc);
    }

    /**
 * Adds the IExplanationStructDescChoice property <b>explanationStructDesc</b> by index.
 *
 * @param index
 * @param explanationStructDesc
 */
    public void addExplanation(int index, IExplanation explanationStructDesc) {
        this.explanations_.add(index, explanationStructDesc);
    }

    /**
 * Remove the IExplanationStructDescChoice property <b>explanationStructDesc</b> by index.
 *
 * @param index
 */
    public void removeExplanation(int index) {
        this.explanations_.remove(index);
    }

    /**
 * Remove the IExplanationStructDescChoice property <b>explanationStructDesc</b> by object.
 *
 * @param explanationStructDesc
 */
    public void removeExplanation(IExplanation explanationStructDesc) {
        this.explanations_.remove(explanationStructDesc);
    }

    /**
 * Clear the IExplanationStructDescChoice property <b>explanationStructDesc</b>.
 *
 */
    public void clearExplanations() {
        this.explanations_.clear();
    }

    /**
 * Gets the IExampleStructDescChoice property <b>exampleStructDesc</b>.
 *
 * @return IExampleStructDescChoice[]
 */
    public IExample[] getExamples() {
        IExample[] array = new IExample[examples_.size()];

        return ((IExample[]) examples_.toArray(array));
    }

    /**
 * Sets the IExampleStructDescChoice property <b>exampleStructDesc</b>.
 *
 * @param exampleStructDesc
 */
    public void setExamples(IExample[] exampleStructDesc) {
        this.examples_.clear();

        for (int i = 0; i < exampleStructDesc.length; i++) {
            addExample(exampleStructDesc[i]);
        }
    }

    /**
 * Sets the IExampleStructDescChoice property <b>exampleStructDesc</b>.
 *
 * @param exampleStructDesc
 */
    public void setExamples(IExample exampleStructDesc) {
        this.examples_.clear();
        addExample(exampleStructDesc);
    }

    /**
 * Adds the IExampleStructDescChoice property <b>exampleStructDesc</b>.
 *
 * @param exampleStructDesc
 */
    public void addExample(IExample exampleStructDesc) {
        this.examples_.add(exampleStructDesc);
    }

    /**
 * Adds the IExampleStructDescChoice property <b>exampleStructDesc</b>.
 *
 * @param exampleStructDesc
 */
    public void addExamples(IExample[] exampleStructDesc) {
        for (int i = 0; i < exampleStructDesc.length; i++) {
            addExample(exampleStructDesc[i]);
        }
    }

    /**
 * Gets number of the IExampleStructDescChoice property <b>exampleStructDesc</b>.
 *
 * @return int
 */
    public int sizeExamples() {
        return (examples_.size());
    }

    /**
 * Gets the IExampleStructDescChoice property <b>exampleStructDesc</b> by index.
 *
 * @param index
 * @return IExampleStructDescChoice
 */
    public IExample getExample(int index) {
        return ((IExample) examples_.get(index));
    }

    /**
 * Sets the IExampleStructDescChoice property <b>exampleStructDesc</b> by index.
 *
 * @param index
 * @param exampleStructDesc
 */
    public void setExample(int index, IExample exampleStructDesc) {
        this.examples_.set(index, exampleStructDesc);
    }

    /**
 * Adds the IExampleStructDescChoice property <b>exampleStructDesc</b> by index.
 *
 * @param index
 * @param exampleStructDesc
 */
    public void addExample(int index, IExample exampleStructDesc) {
        this.examples_.add(index, exampleStructDesc);
    }

    /**
 * Remove the IExampleStructDescChoice property <b>exampleStructDesc</b> by index.
 *
 * @param index
 */
    public void removeExample(int index) {
        this.examples_.remove(index);
    }

    /**
 * Remove the IExampleStructDescChoice property <b>exampleStructDesc</b> by object.
 *
 * @param exampleStructDesc
 */
    public void removeExample(IExample exampleStructDesc) {
        this.examples_.remove(exampleStructDesc);
    }

    /**
 * Clear the IExampleStructDescChoice property <b>exampleStructDesc</b>.
 *
 */
    public void clearExamples() {
        this.examples_.clear();
    }

    /**
 * Gets the Profile property <b>profiles</b>.
 *
 * @return Profile[]
 */
    public Profile[] getProfiles() {
        Profile[] array = new Profile[profiles_.size()];

        return ((Profile[]) profiles_.toArray(array));
    }

    /**
 * Sets the Profile property <b>profiles</b>.
 *
 * @param profiles
 */
    public void setProfiles(Profile[] profiles) {
        this.profiles_.clear();

        for (int i = 0; i < profiles.length; i++) {
            addProfile(profiles[i]);
        }
    }

    /**
 * Sets the Profile property <b>profiles</b>.
 *
 * @param profiles
 */
    public void setProfiles(Profile profiles) {
        this.profiles_.clear();
        addProfile(profiles);
    }

    /**
 * Adds the Profile property <b>profiles</b>.
 *
 * @param profiles
 */
    public void addProfile(Profile profiles) {
        this.profiles_.add(profiles);
    }

    /**
 * Adds the Profile property <b>profiles</b>.
 *
 * @param profiles
 */
    public void addProfiles(Profile[] profiles) {
        for (int i = 0; i < profiles.length; i++) {
            addProfile(profiles[i]);
        }
    }

    /**
 * Gets number of the Profile property <b>profiles</b>.
 *
 * @return int
 */
    public int sizeProfiles() {
        return (profiles_.size());
    }

    /**
 * Gets the Profile property <b>profiles</b> by index.
 *
 * @param index
 * @return Profile
 */
    public Profile getProfiles(int index) {
        return ((Profile) profiles_.get(index));
    }

    /**
 * Sets the Profile property <b>profiles</b> by index.
 *
 * @param index
 * @param profiles
 */
    public void setProfile(int index, Profile profiles) {
        this.profiles_.set(index, profiles);
    }

    /**
 * Adds the Profile property <b>profiles</b> by index.
 *
 * @param index
 * @param profiles
 */
    public void addProfile(int index, Profile profiles) {
        this.profiles_.add(index, profiles);
    }

    /**
 * Remove the Profile property <b>profiles</b> by index.
 *
 * @param index
 */
    public void removeProfile(int index) {
        this.profiles_.remove(index);
    }

    /**
 * Remove the Profile property <b>profiles</b> by object.
 *
 * @param profiles
 */
    public void removeProfile(Profile profiles) {
        this.profiles_.remove(profiles);
    }

    /**
 * Clear the Profile property <b>profiles</b>.
 *
 */
    public void clearProfiles() {
        this.profiles_.clear();
    }

    /**
 * Gets the DataElement property <b>dataElements</b>.
 *
 * @return DataElement[]
 */
    public DataElement[] getDataElements() {
        DataElement[] array = new DataElement[dataElements_.size()];

        return ((DataElement[]) dataElements_.toArray(array));
    }

    /**
 * Sets the DataElement property <b>dataElements</b>.
 *
 * @param dataElements
 */
    public void setDataElements(DataElement[] dataElements) {
        this.dataElements_.clear();

        for (int i = 0; i < dataElements.length; i++) {
            addDataElement(dataElements[i]);
        }
    }

    /**
 * Sets the DataElement property <b>dataElements</b>.
 *
 * @param dataElements
 */
    public void setDataElements(DataElement dataElements) {
        this.dataElements_.clear();
        addDataElement(dataElements);
    }

    /**
 * Adds the DataElement property <b>dataElements</b>.
 *
 * @param dataElements
 */
    public void addDataElement(DataElement dataElements) {
        this.dataElements_.add(dataElements);
    }

    /**
 * Adds the DataElement property <b>dataElements</b>.
 *
 * @param dataElements
 */
    public void addDataElements(DataElement[] dataElements) {
        for (int i = 0; i < dataElements.length; i++) {
            addDataElement(dataElements[i]);
        }
    }

    /**
 * Gets number of the DataElement property <b>dataElements</b>.
 *
 * @return int
 */
    public int sizeDataElements() {
        return (dataElements_.size());
    }

    /**
 * Gets the DataElement property <b>dataElements</b> by index.
 *
 * @param index
 * @return DataElement
 */
    public DataElement getDataElement(int index) {
        return ((DataElement) dataElements_.get(index));
    }

    /**
 * Sets the DataElement property <b>dataElements</b> by index.
 *
 * @param index
 * @param dataElements
 */
    public void setDataElements(int index, DataElement dataElements) {
        this.dataElements_.set(index, dataElements);
    }

    /**
 * Adds the DataElement property <b>dataElements</b> by index.
 *
 * @param index
 * @param dataElements
 */
    public void addDataElement(int index, DataElement dataElements) {
        this.dataElements_.add(index, dataElements);
    }

    /**
 * Remove the DataElement property <b>dataElements</b> by index.
 *
 * @param index
 */
    public void removeDataElement(int index) {
        this.dataElements_.remove(index);
    }

    /**
 * Remove the DataElement property <b>dataElements</b> by object.
 *
 * @param dataElements
 */
    public void removeDataElement(DataElement dataElements) {
        this.dataElements_.remove(dataElements);
    }

    /**
 * Clear the DataElement property <b>dataElements</b>.
 *
 */
    public void clearDataElements() {
        this.dataElements_.clear();
    }

    /**
 * Gets the LanguageSection property <b>languageSections</b>.
 *
 * @return LanguageSection[]
 */
    public LanguageSection[] getLanguageSections() {
        LanguageSection[] array = new LanguageSection[languageSections_.size()];

        return ((LanguageSection[]) languageSections_.toArray(array));
    }

    /**
 * Sets the LanguageSection property <b>languageSections</b>.
 *
 * @param languageSections
 */
    public void setLanguageSections(LanguageSection[] languageSections) {
        this.languageSections_.clear();

        for (int i = 0; i < languageSections.length; i++) {
            addLanguageSection(languageSections[i]);
        }
    }

    /**
 * Sets the LanguageSection property <b>languageSections</b>.
 *
 * @param languageSections
 */
    public void setLanguageSections(LanguageSection languageSections) {
        this.languageSections_.clear();
        addLanguageSection(languageSections);
    }

    /**
 * Adds the LanguageSection property <b>languageSections</b>.
 *
 * @param languageSections
 */
    public void addLanguageSection(LanguageSection languageSections) {
        this.languageSections_.add(languageSections);
    }

    /**
 * Adds the LanguageSection property <b>languageSections</b>.
 *
 * @param languageSections
 */
    public void addLanguageSections(LanguageSection[] languageSections) {
        for (int i = 0; i < languageSections.length; i++) {
            addLanguageSection(languageSections[i]);
        }
    }

    /**
 * Gets number of the LanguageSection property <b>languageSections</b>.
 *
 * @return int
 */
    public int sizeLanguageSections() {
        return (languageSections_.size());
    }

    /**
 * Gets the LanguageSection property <b>languageSections</b> by index.
 *
 * @param index
 * @return LanguageSection
 */
    public LanguageSection getLanguageSection(int index) {
        return ((LanguageSection) languageSections_.get(index));
    }

    /**
 * Sets the LanguageSection property <b>languageSections</b> by index.
 *
 * @param index
 * @param languageSections
 */
    public void setLanguageSection(int index, LanguageSection languageSections) {
        this.languageSections_.set(index, languageSections);
    }

    /**
 * Adds the LanguageSection property <b>languageSections</b> by index.
 *
 * @param index
 * @param languageSections
 */
    public void addLanguageSection(int index, LanguageSection languageSections) {
        this.languageSections_.add(index, languageSections);
    }

    /**
 * Remove the LanguageSection property <b>languageSections</b> by index.
 *
 * @param index
 */
    public void removeLanguageSection(int index) {
        this.languageSections_.remove(index);
    }

    /**
 * Remove the LanguageSection property <b>languageSections</b> by object.
 *
 * @param languageSections
 */
    public void removeLanguageSection(LanguageSection languageSections) {
        this.languageSections_.remove(languageSections);
    }

    /**
 * Clear the LanguageSection property <b>languageSections</b>.
 *
 */
    public void clearLanguageSections() {
        this.languageSections_.clear();
    }

    /**
 * Gets the BroaderConceptGeneric property <b>broaderConceptGeneric</b>.
 *
 * @return BroaderConceptGeneric
 */
    public BroaderConceptGeneric getBroaderConceptGeneric() {
        return (broaderConceptGeneric_);
    }

    /**
 * Sets the BroaderConceptGeneric property <b>broaderConceptGeneric</b>.
 *
 * @param broaderConceptGeneric
 */
    public void setBroaderConceptGeneric(
        BroaderConceptGeneric broaderConceptGeneric) {
        this.broaderConceptGeneric_ = broaderConceptGeneric;
    }

    /**
 * Gets the ConceptualDomain property <b>conceptualDomains</b>.
 *
 * @return ConceptualDomain[]
 */
    public ConceptualDomain[] getConceptualDomains() {
        ConceptualDomain[] array = new ConceptualDomain[conceptualDomains_.size()];

        return ((ConceptualDomain[]) conceptualDomains_.toArray(array));
    }

    /**
 * Sets the ConceptualDomain property <b>conceptualDomains</b>.
 *
 * @param conceptualDomains
 */
    public void setConceptualDomains(ConceptualDomain[] conceptualDomains) {
        this.conceptualDomains_.clear();

        for (int i = 0; i < conceptualDomains.length; i++) {
            addConceptualDomains(conceptualDomains[i]);
        }
    }

    /**
 * Sets the ConceptualDomain property <b>conceptualDomains</b>.
 *
 * @param conceptualDomains
 */
    public void setConceptualDomains(ConceptualDomain conceptualDomains) {
        this.conceptualDomains_.clear();
        addConceptualDomains(conceptualDomains);
    }

    /**
 * Adds the ConceptualDomain property <b>conceptualDomains</b>.
 *
 * @param conceptualDomains
 */
    public void addConceptualDomains(ConceptualDomain conceptualDomains) {
        this.conceptualDomains_.add(conceptualDomains);
    }

    /**
 * Adds the ConceptualDomain property <b>conceptualDomains</b>.
 *
 * @param conceptualDomains
 */
    public void addConceptualDomains(ConceptualDomain[] conceptualDomains) {
        for (int i = 0; i < conceptualDomains.length; i++) {
            addConceptualDomains(conceptualDomains[i]);
        }
    }

    /**
 * Gets number of the ConceptualDomain property <b>conceptualDomains</b>.
 *
 * @return int
 */
    public int sizeConceptualDomains() {
        return (conceptualDomains_.size());
    }

    /**
 * Gets the ConceptualDomain property <b>conceptualDomains</b> by index.
 *
 * @param index
 * @return ConceptualDomain
 */
    public ConceptualDomain getConceptualDomain(int index) {
        return ((ConceptualDomain) conceptualDomains_.get(index));
    }

    /**
 * Sets the ConceptualDomain property <b>conceptualDomains</b> by index.
 *
 * @param index
 * @param conceptualDomains
 */
    public void setConceptualDomains(int index,
        ConceptualDomain conceptualDomains) {
        this.conceptualDomains_.set(index, conceptualDomains);
    }

    /**
 * Adds the ConceptualDomain property <b>conceptualDomains</b> by index.
 *
 * @param index
 * @param conceptualDomains
 */
    public void addConceptualDomains(int index,
        ConceptualDomain conceptualDomains) {
        this.conceptualDomains_.add(index, conceptualDomains);
    }

    /**
 * Remove the ConceptualDomain property <b>conceptualDomains</b> by index.
 *
 * @param index
 */
    public void removeConceptualDomains(int index) {
        this.conceptualDomains_.remove(index);
    }

    /**
 * Remove the ConceptualDomain property <b>conceptualDomains</b> by object.
 *
 * @param conceptualDomains
 */
    public void removeConceptualDomains(ConceptualDomain conceptualDomains) {
        this.conceptualDomains_.remove(conceptualDomains);
    }

    /**
 * Clear the ConceptualDomain property <b>conceptualDomains</b>.
 *
 */
    public void clearConceptualDomains() {
        this.conceptualDomains_.clear();
    }

    /**
 * Gets the INoteStructDescChoice property <b>noteStructDesc</b>.
 *
 * @return INoteStructDescChoice[]
 */
    public INote[] getNotes() {
        INote[] array = new INote[notes_.size()];

        return ((INote[]) notes_.toArray(array));
    }

    /**
 * Sets the INoteStructDescChoice property <b>noteStructDesc</b>.
 *
 * @param noteStructDesc
 */
    public void setNotes(INote[] noteStructDesc) {
        this.notes_.clear();

        for (int i = 0; i < noteStructDesc.length; i++) {
            addNote(noteStructDesc[i]);
        }
    }

    /**
 * Sets the INoteStructDescChoice property <b>noteStructDesc</b>.
 *
 * @param noteStructDesc
 */
    public void setNotes(INote noteStructDesc) {
        this.notes_.clear();
        addNote(noteStructDesc);
    }

    /**
 * Adds the INoteStructDescChoice property <b>noteStructDesc</b>.
 *
 * @param noteStructDesc
 */
    public void addNote(INote noteStructDesc) {
        this.notes_.add(noteStructDesc);
    }

    /**
 * Adds the INoteStructDescChoice property <b>noteStructDesc</b>.
 *
 * @param noteStructDesc
 */
    public void addNotes(INote[] noteStructDesc) {
        for (int i = 0; i < noteStructDesc.length; i++) {
            addNote(noteStructDesc[i]);
        }
    }

    /**
 * Gets number of the INoteStructDescChoice property <b>noteStructDesc</b>.
 *
 * @return int
 */
    public int sizeNotes() {
        return (notes_.size());
    }

    /**
 * Gets the INoteStructDescChoice property <b>noteStructDesc</b> by index.
 *
 * @param index
 * @return INoteStructDescChoice
 */
    public INote getNote(int index) {
        return ((INote) notes_.get(index));
    }

    /**
 * Sets the INoteStructDescChoice property <b>noteStructDesc</b> by index.
 *
 * @param index
 * @param noteStructDesc
 */
    public void setNote(int index, INote noteStructDesc) {
        this.notes_.set(index, noteStructDesc);
    }

    /**
 * Adds the INoteStructDescChoice property <b>noteStructDesc</b> by index.
 *
 * @param index
 * @param noteStructDesc
 */
    public void addNote(int index, INote noteStructDesc) {
        this.notes_.add(index, noteStructDesc);
    }

    /**
 * Remove the INoteStructDescChoice property <b>noteStructDesc</b> by index.
 *
 * @param index
 */
    public void removeNote(int index) {
        this.notes_.remove(index);
    }

    /**
 * Remove the INoteStructDescChoice property <b>noteStructDesc</b> by object.
 *
 * @param noteStructDesc
 */
    public void removeNote(INote noteStructDesc) {
        this.notes_.remove(noteStructDesc);
    }

    /**
 * Clear the INoteStructDescChoice property <b>noteStructDesc</b>.
 *
 */
    public void clearNoteStructDesc() {
        this.notes_.clear();
    }

    /**
 * Makes an XML text representation.
 *
 * @return String
 */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);

        return (new String(buffer));
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<struct");

        if (type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.append("\"");
        }

        if (id_ != null) {
            buffer.append(" id=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.append("\"");
        }

        size = this.definitions_.size();

        for (int i = 0; i < size; i++) {
            IDefinition value = (IDefinition) this.definitions_.get(i);
            value.makeTextAttribute(buffer);
        }

        size = this.explanations_.size();

        for (int i = 0; i < size; i++) {
            IExplanation value = (IExplanation) this.explanations_.get(i);
            value.makeTextAttribute(buffer);
        }

        size = this.examples_.size();

        for (int i = 0; i < size; i++) {
            IExample value = (IExample) this.examples_.get(i);
            value.makeTextAttribute(buffer);
        }

        size = this.notes_.size();

        for (int i = 0; i < size; i++) {
            INote value = (INote) this.notes_.get(i);
            value.makeTextAttribute(buffer);
        }

        buffer.append(">");
        size = this.definitions_.size();

        for (int i = 0; i < size; i++) {
            IDefinition value = (IDefinition) this.definitions_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.explanations_.size();

        for (int i = 0; i < size; i++) {
            IExplanation value = (IExplanation) this.explanations_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.examples_.size();

        for (int i = 0; i < size; i++) {
            IExample value = (IExample) this.examples_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.profiles_.size();

        for (int i = 0; i < size; i++) {
            Profile value = (Profile) this.profiles_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.notes_.size();

        for (int i = 0; i < size; i++) {
            INote value = (INote) this.notes_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.dataElements_.size();

        for (int i = 0; i < size; i++) {
            DataElement value = (DataElement) this.dataElements_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.languageSections_.size();

        for (int i = 0; i < size; i++) {
            LanguageSection value = (LanguageSection) this.languageSections_.get(i);
            value.makeTextElement(buffer);
        }

        if (broaderConceptGeneric_ != null) {
            broaderConceptGeneric_.makeTextElement(buffer);
        }

        size = this.conceptualDomains_.size();

        for (int i = 0; i < size; i++) {
            ConceptualDomain value = (ConceptualDomain) this.conceptualDomains_.get(i);
            value.makeTextElement(buffer);
        }

        buffer.append("</struct>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 * @exception IOException
 */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<struct");

        if (type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.write("\"");
        }

        if (id_ != null) {
            buffer.write(" id=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.write("\"");
        }

        size = this.definitions_.size();

        for (int i = 0; i < size; i++) {
            IDefinition value = (IDefinition) this.definitions_.get(i);
            value.makeTextAttribute(buffer);
        }

        size = this.explanations_.size();

        for (int i = 0; i < size; i++) {
            IExplanation value = (IExplanation) this.explanations_.get(i);
            value.makeTextAttribute(buffer);
        }

        size = this.examples_.size();

        for (int i = 0; i < size; i++) {
            IExample value = (IExample) this.examples_.get(i);
            value.makeTextAttribute(buffer);
        }

        size = this.notes_.size();

        for (int i = 0; i < size; i++) {
            INote value = (INote) this.notes_.get(i);
            value.makeTextAttribute(buffer);
        }

        buffer.write(">");
        size = this.definitions_.size();

        for (int i = 0; i < size; i++) {
            IDefinition value = (IDefinition) this.definitions_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.explanations_.size();

        for (int i = 0; i < size; i++) {
            IExplanation value = (IExplanation) this.explanations_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.examples_.size();

        for (int i = 0; i < size; i++) {
            IExample value = (IExample) this.examples_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.profiles_.size();

        for (int i = 0; i < size; i++) {
            Profile value = (Profile) this.profiles_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.dataElements_.size();

        for (int i = 0; i < size; i++) {
            DataElement value = (DataElement) this.dataElements_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.languageSections_.size();

        for (int i = 0; i < size; i++) {
            LanguageSection value = (LanguageSection) this.languageSections_.get(i);
            value.makeTextElement(buffer);
        }

        if (broaderConceptGeneric_ != null) {
            broaderConceptGeneric_.makeTextElement(buffer);
        }

        size = this.conceptualDomains_.size();

        for (int i = 0; i < size; i++) {
            ConceptualDomain value = (ConceptualDomain) this.conceptualDomains_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.notes_.size();

        for (int i = 0; i < size; i++) {
            INote value = (INote) this.notes_.get(i);
            value.makeTextElement(buffer);
        }

        buffer.write("</struct>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<struct");

        if (type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.print("\"");
        }

        if (id_ != null) {
            buffer.print(" id=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.print("\"");
        }

        size = this.definitions_.size();

        for (int i = 0; i < size; i++) {
            IDefinition value = (IDefinition) this.definitions_.get(i);
            value.makeTextAttribute(buffer);
        }

        size = this.explanations_.size();

        for (int i = 0; i < size; i++) {
            IExplanation value = (IExplanation) this.explanations_.get(i);
            value.makeTextAttribute(buffer);
        }

        size = this.examples_.size();

        for (int i = 0; i < size; i++) {
            IExample value = (IExample) this.examples_.get(i);
            value.makeTextAttribute(buffer);
        }

        size = this.notes_.size();

        for (int i = 0; i < size; i++) {
            INote value = (INote) this.notes_.get(i);
            value.makeTextAttribute(buffer);
        }

        buffer.print(">");
        size = this.definitions_.size();

        for (int i = 0; i < size; i++) {
            IDefinition value = (IDefinition) this.definitions_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.explanations_.size();

        for (int i = 0; i < size; i++) {
            IExplanation value = (IExplanation) this.explanations_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.examples_.size();

        for (int i = 0; i < size; i++) {
            IExample value = (IExample) this.examples_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.profiles_.size();

        for (int i = 0; i < size; i++) {
            Profile value = (Profile) this.profiles_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.notes_.size();

        for (int i = 0; i < size; i++) {
            INote value = (INote) this.notes_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.dataElements_.size();

        for (int i = 0; i < size; i++) {
            DataElement value = (DataElement) this.dataElements_.get(i);
            value.makeTextElement(buffer);
        }

        size = this.languageSections_.size();

        for (int i = 0; i < size; i++) {
            LanguageSection value = (LanguageSection) this.languageSections_.get(i);
            value.makeTextElement(buffer);
        }

        if (broaderConceptGeneric_ != null) {
            broaderConceptGeneric_.makeTextElement(buffer);
        }

        size = this.conceptualDomains_.size();

        for (int i = 0; i < size; i++) {
            ConceptualDomain value = (ConceptualDomain) this.conceptualDomains_.get(i);
            value.makeTextElement(buffer);
        }

        buffer.print("</struct>");
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 * @exception IOException
 */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
 * Makes an XML text representation.
 *
 * @param buffer
 */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
 * Gets the property value as String.
 *
 * @return String
 */
    public String getTypeAsString() {
        return (URelaxer.getString(getType()));
    }

    /**
 * Gets the property value as String.
 *
 * @return String
 */
    public String getIdAsString() {
        return (URelaxer.getString(getId()));
    }

    /**
 * Sets the property value by String.
 *
 * @param string
 */
    public void setTypeByString(String string) {
        setType(string);
    }

    /**
 * Sets the property value by String.
 *
 * @param string
 */
    public void setIdByString(String string) {
        setId(string);
    }

    /**
 * Returns a String representation of this object.
 * While this method informs as XML format representaion, 
 *  it's purpose is just information, not making 
 * a rigid XML documentation.
 *
 * @return String
 */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
 * Tests if a Element <code>element</code> is valid
 * for the <code>Description</code>.
 *
 * @param element
 * @return boolean
 */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "struct")) {
            return (false);
        }

        RStack target = new RStack(element);

        if (!URelaxer.hasAttributeHungry(target, "type")) {
            return (false);
        }

        if (!URelaxer.isMatchDataValuesAttr(element, "type", "token", "Desc")) {
            return (false);
        }

        if (DefinitionBrack.isMatchHungry(target)) {
        } else if (Definition.isMatchHungry(target)) {
        } else {
            logger.info("NO definition");

            return (false);
        }

        while (true) {
            if (DefinitionBrack.isMatchHungry(target)) {
            } else if (Definition.isMatchHungry(target)) {
            } else {
                break;
            }
        }

        while (true) {
            if (ExplanationBrack.isMatchHungry(target)) {
            } else if (Explanation.isMatchHungry(target)) {
            } else {
                logger.info("NO EXPLANATION");

                break;
            }
        }

        while (true) {
            if (ExampleBrack.isMatchHungry(target)) {
            } else if (Example.isMatchHungry(target)) {
            } else {
                logger.info("NO EXAMPLE");

                break;
            }
        }

        while (true) {
            if (!Profile.isMatchHungry(target)) {
                break;
            }
        }

        if (BroaderConceptGeneric.isMatchHungry(target)) {
        }

        while (true) {
            if (!ConceptualDomain.isMatchHungry(target)) {
                logger.info("NO CONCEPTUALDOMAIN");

                break;
            }
        }

        while (true) {
            if (Note.isMatchHungry(target)) {
            } else if (NoteBrack.isMatchHungry(target)) {
            } else {
                logger.info("NO NOTE");

                break;
            }
        }

        while (true) {
            if (!DataElement.isMatchHungry(target)) {
                break;
            }

            logger.info("DATAELEMENT match");
        }

        while (true) {
            if (!LanguageSection.isMatchHungry(target)) {
                break;
            }

            logger.info("Language section match");
        }

        if (!target.isEmptyElement()) {
            logger.info("TARGET IS NOT EMPTY");

            return (false);
        }

        return (true);
    }

    /**
 * Tests if elements contained in a Stack <code>stack</code>
 * is valid for the <code>Description</code>.
 * This mehtod is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 * @return boolean
 */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();

        if (element == null) {
            return (false);
        }

        return (isMatch(element));
    }

    /**
 * Tests if elements contained in a Stack <code>stack</code>
 * is valid for the <code>Description</code>.
 * This method consumes the stack contents during matching operation.
 * This mehtod is supposed to be used internally
 * by the Relaxer system.
 *
 * @param stack
 * @return boolean
 */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();

        if (element == null) {
            return (false);
        }

        if (isMatch(element)) {
            stack.popElement();

            return (true);
        } else {
            return (false);
        }
    }
}
